/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.vocabulary;

import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

public class XSD {
    public static final String NS = "http://www.w3.org/2001/XMLSchema#";
    public static final Resource xfloat = XSD.resource("float");
    public static final Resource xdouble = XSD.resource("double");
    public static final Resource xint = XSD.resource("int");
    public static final Resource xlong = XSD.resource("long");
    public static final Resource xshort = XSD.resource("short");
    public static final Resource xbyte = XSD.resource("byte");
    public static final Resource xboolean = XSD.resource("boolean");
    public static final Resource xstring = XSD.resource("string");
    public static final Resource unsignedByte = XSD.resource("unsignedByte");
    public static final Resource unsignedShort = XSD.resource("unsignedShort");
    public static final Resource unsignedInt = XSD.resource("unsignedInt");
    public static final Resource unsignedLong = XSD.resource("unsignedLong");
    public static final Resource decimal = XSD.resource("decimal");
    public static final Resource integer = XSD.resource("integer");
    public static final Resource nonPositiveInteger = XSD.resource("nonPositiveInteger");
    public static final Resource nonNegativeInteger = XSD.resource("nonNegativeInteger");
    public static final Resource positiveInteger = XSD.resource("positiveInteger");
    public static final Resource negativeInteger = XSD.resource("negativeInteger");
    public static final Resource normalizedString = XSD.resource("normalizedString");
    public static final Resource anyURI = XSD.resource("anyURI");
    public static final Resource token = XSD.resource("token");
    public static final Resource Name = XSD.resource("Name");
    public static final Resource QName = XSD.resource("QName");
    public static final Resource language = XSD.resource("language");
    public static final Resource NMTOKEN = XSD.resource("NMTOKEN");
    public static final Resource ENTITIES = XSD.resource("ENTITIES");
    public static final Resource NMTOKENS = XSD.resource("NMTOKENS");
    public static final Resource ENTITY = XSD.resource("ENTITY");
    public static final Resource ID = XSD.resource("ID");
    public static final Resource NCName = XSD.resource("NCName");
    public static final Resource IDREF = XSD.resource("IDREF");
    public static final Resource IDREFS = XSD.resource("IDREFS");
    public static final Resource NOTATION = XSD.resource("NOTATION");
    public static final Resource hexBinary = XSD.resource("hexBinary");
    public static final Resource base64Binary = XSD.resource("base64Binary");
    public static final Resource date = XSD.resource("date");
    public static final Resource time = XSD.resource("time");
    public static final Resource dateTime = XSD.resource("dateTime");
    public static final Resource dateTimeStamp = XSD.resource("dateTimeStamp");
    public static final Resource duration = XSD.resource("duration");
    public static final Resource yearMonthDuration = XSD.resource("yearMonthDuration");
    public static final Resource dayTimeDuration = XSD.resource("dayTimeDuration");
    public static final Resource gDay = XSD.resource("gDay");
    public static final Resource gMonth = XSD.resource("gMonth");
    public static final Resource gYear = XSD.resource("gYear");
    public static final Resource gYearMonth = XSD.resource("gYearMonth");
    public static final Resource gMonthDay = XSD.resource("gMonthDay");
    public static final Property length = XSD.property("length");
    public static final Property minLength = XSD.property("minLength");
    public static final Property maxLength = XSD.property("maxLength");
    public static final Property pattern = XSD.property("pattern");
    public static final Property minInclusive = XSD.property("minInclusive");
    public static final Property minExclusive = XSD.property("minExclusive");
    public static final Property maxInclusive = XSD.property("maxInclusive");
    public static final Property maxExclusive = XSD.property("maxExclusive");
    public static final Property totalDigits = XSD.property("totalDigits");
    public static final Property fractionDigits = XSD.property("fractionDigits");

    public static String getURI() {
        return NS;
    }

    protected static Resource resource(String local) {
        return ResourceFactory.createResource(NS + local);
    }

    protected static Property property(String local) {
        return ResourceFactory.createProperty(NS, local);
    }
}

