/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.matchhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.matchhighlight.MatchRegionRetriever;
import org.apache.lucene.search.matchhighlight.OffsetRange;
import org.apache.lucene.search.matchhighlight.OffsetsRetrievalStrategy;

public final class OffsetsFromValues
implements OffsetsRetrievalStrategy {
    private final String field;
    private final Analyzer analyzer;

    public OffsetsFromValues(String field, Analyzer analyzer) {
        this.field = field;
        this.analyzer = analyzer;
    }

    @Override
    public List<OffsetRange> get(MatchesIterator matchesIterator, MatchRegionRetriever.FieldValueProvider doc) throws IOException {
        List<CharSequence> values = doc.getValues(this.field);
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
        int valueOffset = 0;
        for (CharSequence charSequence : values) {
            String value = charSequence.toString();
            TokenStream ts = this.analyzer.tokenStream(this.field, value);
            OffsetAttribute offsetAttr = ts.getAttribute(OffsetAttribute.class);
            ts.reset();
            int startOffset = valueOffset;
            while (ts.incrementToken()) {
            }
            ts.end();
            ranges.add(new OffsetRange(startOffset, valueOffset += offsetAttr.endOffset()));
            valueOffset += this.analyzer.getOffsetGap(this.field);
            ts.close();
        }
        return ranges;
    }
}

