/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.subject.support;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.web.subject.WebSubject;
import org.apache.shiro.web.subject.WebSubjectContext;

public class DefaultWebSubjectContext
extends DefaultSubjectContext
implements WebSubjectContext {
    private static final long serialVersionUID = 8188555355305827739L;
    private static final String SERVLET_REQUEST = DefaultWebSubjectContext.class.getName() + ".SERVLET_REQUEST";
    private static final String SERVLET_RESPONSE = DefaultWebSubjectContext.class.getName() + ".SERVLET_RESPONSE";

    public DefaultWebSubjectContext() {
    }

    public DefaultWebSubjectContext(WebSubjectContext context2) {
        super(context2);
    }

    @Override
    public String resolveHost() {
        ServletRequest request;
        String host = super.resolveHost();
        if (host == null && (request = this.resolveServletRequest()) != null) {
            host = request.getRemoteHost();
        }
        return host;
    }

    @Override
    public ServletRequest getServletRequest() {
        return this.getTypedValue(SERVLET_REQUEST, ServletRequest.class);
    }

    @Override
    public void setServletRequest(ServletRequest request) {
        if (request != null) {
            this.put(SERVLET_REQUEST, (Object)request);
        }
    }

    @Override
    public ServletRequest resolveServletRequest() {
        Subject existing;
        ServletRequest request = this.getServletRequest();
        if (request == null && (existing = this.getSubject()) instanceof WebSubject) {
            request = ((WebSubject)existing).getServletRequest();
        }
        return request;
    }

    @Override
    public ServletResponse getServletResponse() {
        return this.getTypedValue(SERVLET_RESPONSE, ServletResponse.class);
    }

    @Override
    public void setServletResponse(ServletResponse response) {
        if (response != null) {
            this.put(SERVLET_RESPONSE, (Object)response);
        }
    }

    @Override
    public ServletResponse resolveServletResponse() {
        Subject existing;
        ServletResponse response = this.getServletResponse();
        if (response == null && (existing = this.getSubject()) instanceof WebSubject) {
            response = ((WebSubject)existing).getServletResponse();
        }
        return response;
    }
}

