/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.geometry.ArrayEnvelope;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Range;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.util.TemporalAccessor;
import org.apache.sis.referencing.util.WKTUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

@XmlTransient
public abstract class AbstractEnvelope
extends FormattableObject
implements Envelope,
Emptiable {
    private static final Envelope[] EMPTY = new Envelope[0];

    protected AbstractEnvelope() {
    }

    public static AbstractEnvelope castOrCopy(Envelope envelope) {
        if (envelope == null || envelope instanceof AbstractEnvelope) {
            return (AbstractEnvelope)envelope;
        }
        return new GeneralEnvelope(envelope);
    }

    static boolean assertEquals(CoordinateReferenceSystem expected, CoordinateReferenceSystem actual) {
        if (AbstractEnvelope.equals(expected, actual, ComparisonMode.DEBUG)) {
            return true;
        }
        String title = IdentifiedObjects.getDisplayName(actual, null);
        if (title != null && !title.equalsIgnoreCase(IdentifiedObjects.getDisplayName(expected, null))) {
            throw new AssertionError((Object)Errors.format((short)51, title));
        }
        return false;
    }

    private static boolean equals(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2, ComparisonMode mode) {
        return crs1 == null || crs2 == null || Utilities.deepEquals(crs1, crs2, mode);
    }

    static CoordinateReferenceSystem getCommonCRS(DirectPosition lowerCorner, DirectPosition upperCorner) throws MismatchedReferenceSystemException {
        ArgumentChecks.ensureNonNull("lowerCorner", lowerCorner);
        ArgumentChecks.ensureNonNull("upperCorner", upperCorner);
        CoordinateReferenceSystem crs1 = lowerCorner.getCoordinateReferenceSystem();
        CoordinateReferenceSystem crs2 = upperCorner.getCoordinateReferenceSystem();
        if (crs1 == null) {
            return crs2;
        }
        if (crs2 != null && !crs1.equals(crs2)) {
            throw new MismatchedReferenceSystemException(Errors.format((short)78));
        }
        return crs1;
    }

    static CoordinateSystemAxis getAxis(CoordinateReferenceSystem crs, int dimension) {
        CoordinateSystem cs;
        if (crs != null && (cs = crs.getCoordinateSystem()) != null) {
            return cs.getAxis(dimension);
        }
        return null;
    }

    static boolean isWrapAround(CoordinateReferenceSystem crs, int dimension) {
        return AbstractEnvelope.isWrapAround(AbstractEnvelope.getAxis(crs, dimension));
    }

    static boolean isWrapAround(CoordinateSystemAxis axis) {
        return axis != null && RangeMeaning.WRAPAROUND.equals(axis.getRangeMeaning());
    }

    static double getCycle(CoordinateSystemAxis axis) {
        if (AbstractEnvelope.isWrapAround(axis)) {
            return axis.getMaximumValue() - axis.getMinimumValue();
        }
        return Double.NaN;
    }

    static boolean isNegativeUnsafe(double value) {
        return (Double.doubleToRawLongBits(value) & Long.MIN_VALUE) != 0L;
    }

    @Override
    public DirectPosition getLowerCorner() {
        return new LowerCorner();
    }

    @Override
    public DirectPosition getUpperCorner() {
        return new UpperCorner();
    }

    public DirectPosition getMedian() {
        return new Median();
    }

    public abstract double getLower(int var1) throws IndexOutOfBoundsException;

    public abstract double getUpper(int var1) throws IndexOutOfBoundsException;

    @Override
    public double getMinimum(int dimension) throws IndexOutOfBoundsException {
        double lower = this.getLower(dimension);
        if (MathFunctions.isNegative(this.getUpper(dimension) - lower)) {
            CoordinateSystemAxis axis = AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), dimension);
            lower = AbstractEnvelope.isWrapAround(axis) ? axis.getMinimumValue() : Double.NaN;
        }
        return lower;
    }

    @Override
    public double getMaximum(int dimension) throws IndexOutOfBoundsException {
        double upper = this.getUpper(dimension);
        if (MathFunctions.isNegative(upper - this.getLower(dimension))) {
            CoordinateSystemAxis axis = AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), dimension);
            upper = AbstractEnvelope.isWrapAround(axis) ? axis.getMaximumValue() : Double.NaN;
        }
        return upper;
    }

    @Override
    public double getMedian(int dimension) throws IndexOutOfBoundsException {
        double lower = this.getLower(dimension);
        double upper = this.getUpper(dimension);
        double median = 0.5 * (lower + upper);
        if (MathFunctions.isNegative(upper - lower)) {
            median = AbstractEnvelope.fixMedian(AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), dimension), median);
        }
        return median;
    }

    static double fixMedian(CoordinateSystemAxis axis, double median) {
        if (AbstractEnvelope.isWrapAround(axis)) {
            double minimum = axis.getMinimumValue();
            double maximum = axis.getMaximumValue();
            double cycle = maximum - minimum;
            if (cycle > 0.0 && cycle != Double.POSITIVE_INFINITY) {
                return median + 0.5 * Math.copySign(cycle, 0.5 * (minimum + maximum) - median);
            }
        }
        return Double.NaN;
    }

    @Override
    public double getSpan(int dimension) {
        double span = this.getUpper(dimension) - this.getLower(dimension);
        if (MathFunctions.isNegative(span)) {
            span = AbstractEnvelope.fixSpan(AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), dimension), span);
        }
        return span;
    }

    static double fixSpan(CoordinateSystemAxis axis, double span) {
        double cycle;
        if (AbstractEnvelope.isWrapAround(axis) && (cycle = axis.getMaximumValue() - axis.getMinimumValue()) > 0.0 && cycle != Double.POSITIVE_INFINITY && (span += cycle) >= 0.0) {
            return span;
        }
        return Double.NaN;
    }

    public double getSpan(int dimension, Unit<?> unit) throws IndexOutOfBoundsException, IncommensurableException {
        Unit<?> source;
        double value = this.getSpan(dimension);
        CoordinateSystemAxis axis = AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), dimension);
        if (axis != null && (source = axis.getUnit()) != null) {
            value = source.getConverterToAny(unit).convert(value);
        }
        return value;
    }

    public Optional<Range<Instant>> getTimeRange() {
        TemporalAccessor t = TemporalAccessor.of(this.getCoordinateReferenceSystem(), 0);
        return t != null ? Optional.of(t.getTimeRange(this)) : Optional.empty();
    }

    public Envelope[] toSimpleEnvelopes() {
        long isWrapAround = 0L;
        CoordinateReferenceSystem crs = null;
        int dimension = this.getDimension();
        for (int i = 0; i != dimension; ++i) {
            double span = this.getUpper(i) - this.getLower(i);
            if (span > 0.0) continue;
            if (!MathFunctions.isNegative(span)) {
                return EMPTY;
            }
            if (crs == null) {
                crs = this.getCoordinateReferenceSystem();
            }
            if (!AbstractEnvelope.isWrapAround(crs, i)) {
                return EMPTY;
            }
            if (i >= 64) {
                throw new IllegalStateException(Errors.format((short)36, "axis", dimension));
            }
            isWrapAround |= 1L << i;
        }
        int bitCount = Long.bitCount(isWrapAround);
        if (bitCount >= 31) {
            throw new IllegalStateException(Errors.format((short)36, "wraparound", bitCount));
        }
        Envelope[] envelopes = new Envelope[1 << bitCount];
        if (envelopes.length == 1) {
            envelopes[0] = this;
        } else {
            int i;
            double[] c = new double[dimension * 2];
            for (int i2 = 0; i2 < dimension; ++i2) {
                c[i2] = this.getLower(i2);
                c[i2 + dimension] = this.getUpper(i2);
            }
            double[][] coordinates = new double[envelopes.length][];
            for (int i3 = 0; i3 < envelopes.length; ++i3) {
                GeneralEnvelope envelope = new GeneralEnvelope(i3 == 0 ? c : (double[])c.clone());
                envelope.crs = crs;
                envelopes[i3] = envelope;
                coordinates[i3] = envelope.coordinates;
            }
            int mask = 1;
            CoordinateSystem cs = crs.getCoordinateSystem();
            while ((i = Long.numberOfTrailingZeros(isWrapAround)) != 64) {
                CoordinateSystemAxis axis = cs.getAxis(i);
                double min2 = axis.getMinimumValue();
                double max2 = axis.getMaximumValue();
                for (int j = 0; j < coordinates.length; ++j) {
                    c = coordinates[j];
                    if ((j & mask) == 0) {
                        c[i + dimension] = max2;
                        continue;
                    }
                    c[i] = min2;
                }
                mask <<= 1;
                isWrapAround &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        return envelopes;
    }

    public boolean isFinite() {
        int i = this.getDimension();
        while (--i >= 0) {
            if (Double.isFinite(this.getLower(i)) && Double.isFinite(this.getUpper(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        int dimension = this.getDimension();
        if (dimension == 0) {
            return true;
        }
        for (int i = 0; i < dimension; ++i) {
            if (this.getSpan(i) > 0.0) continue;
            return true;
        }
        assert (!this.isAllNaN()) : this;
        return false;
    }

    public boolean isAllNaN() {
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (Double.isNaN(this.getLower(i)) && Double.isNaN(this.getUpper(i))) continue;
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    public boolean contains(DirectPosition position) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("position", position);
        int dimension = this.getDimension();
        ArgumentChecks.ensureDimensionMatches("point", dimension, position);
        assert (AbstractEnvelope.assertEquals(this.getCoordinateReferenceSystem(), position.getCoordinateReferenceSystem())) : position;
        for (int i = 0; i < dimension; ++i) {
            boolean c2;
            double value = position.getOrdinate(i);
            double lower = this.getLower(i);
            double upper = this.getUpper(i);
            boolean c1 = value >= lower;
            boolean bl = c2 = value <= upper;
            if (c1 & c2 || c1 | c2 && MathFunctions.isNegative(upper - lower)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Envelope envelope) throws MismatchedDimensionException {
        return this.contains(envelope, true);
    }

    public boolean contains(Envelope envelope, boolean edgesInclusive) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("envelope", envelope);
        int dimension = this.getDimension();
        ArgumentChecks.ensureDimensionMatches("envelope", dimension, envelope);
        assert (AbstractEnvelope.assertEquals(this.getCoordinateReferenceSystem(), envelope.getCoordinateReferenceSystem())) : envelope;
        DirectPosition lowerCorner = envelope.getLowerCorner();
        DirectPosition upperCorner = envelope.getUpperCorner();
        for (int i = 0; i < dimension; ++i) {
            boolean upperCondition;
            boolean lowerCondition;
            double lower0 = this.getLower(i);
            double upper0 = this.getUpper(i);
            double lower1 = lowerCorner.getOrdinate(i);
            double upper1 = upperCorner.getOrdinate(i);
            if (edgesInclusive) {
                lowerCondition = lower1 >= lower0;
                upperCondition = upper1 <= upper0;
            } else {
                lowerCondition = lower1 > lower0;
                boolean bl = upperCondition = upper1 < upper0;
            }
            if (lowerCondition & upperCondition ? !AbstractEnvelope.isNegativeUnsafe(upper1 - lower1) || AbstractEnvelope.isNegativeUnsafe(upper0 - lower0) || lower0 == Double.NEGATIVE_INFINITY && upper0 == Double.POSITIVE_INFINITY || upper0 - lower0 >= AbstractEnvelope.getCycle(AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), i)) : (lowerCondition != upperCondition ? MathFunctions.isNegative(upper0 - lower0) && (MathFunctions.isPositive(upper1 - lower1) || edgesInclusive && Double.doubleToRawLongBits(lower0) == 0L && Double.doubleToRawLongBits(upper0) == Long.MIN_VALUE) : MathFunctions.isNegativeZero(upper0 - lower0))) continue;
            return false;
        }
        assert (envelope.getClass() == ArrayEnvelope.class || this.intersects(new ArrayEnvelope(envelope), edgesInclusive)) : envelope;
        return true;
    }

    public boolean intersects(Envelope envelope) throws MismatchedDimensionException {
        return this.intersects(envelope, false);
    }

    public boolean intersects(Envelope envelope, boolean touch) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("envelope", envelope);
        int dimension = this.getDimension();
        ArgumentChecks.ensureDimensionMatches("envelope", dimension, envelope);
        assert (AbstractEnvelope.assertEquals(this.getCoordinateReferenceSystem(), envelope.getCoordinateReferenceSystem())) : envelope;
        DirectPosition lowerCorner = envelope.getLowerCorner();
        DirectPosition upperCorner = envelope.getUpperCorner();
        for (int i = 0; i < dimension; ++i) {
            boolean sp1;
            boolean sp0;
            boolean upperCondition;
            boolean lowerCondition;
            double lower0 = this.getLower(i);
            double upper0 = this.getUpper(i);
            double lower1 = lowerCorner.getOrdinate(i);
            double upper1 = upperCorner.getOrdinate(i);
            if (touch) {
                lowerCondition = lower1 <= upper0;
                upperCondition = upper1 >= lower0;
            } else {
                lowerCondition = lower1 < upper0;
                boolean bl = upperCondition = upper1 > lower0;
            }
            if (upperCondition & lowerCondition || (sp0 = MathFunctions.isNegative(upper0 - lower0)) | (sp1 = MathFunctions.isNegative(upper1 - lower1)) && sp0 & sp1 | (upperCondition | lowerCondition)) continue;
            assert (envelope.getClass() == ArrayEnvelope.class || AbstractEnvelope.hasNaN(envelope) || !this.contains(new ArrayEnvelope(envelope), touch)) : envelope;
            return false;
        }
        return true;
    }

    static boolean hasNaN(Envelope envelope) {
        return AbstractEnvelope.hasNaN(envelope.getLowerCorner()) || AbstractEnvelope.hasNaN(envelope.getUpperCorner());
    }

    static boolean hasNaN(DirectPosition position) {
        int i = position.getDimension();
        while (--i >= 0) {
            if (!Double.isNaN(position.getOrdinate(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Envelope other, double eps, boolean epsIsRelative) {
        ArgumentChecks.ensureNonNull("other", other);
        int dimension = this.getDimension();
        if (other.getDimension() != dimension || !AbstractEnvelope.equals(this.getCoordinateReferenceSystem(), other.getCoordinateReferenceSystem(), eps == 0.0 ? ComparisonMode.IGNORE_METADATA : ComparisonMode.APPROXIMATE)) {
            return false;
        }
        DirectPosition lowerCorner = other.getLowerCorner();
        DirectPosition upperCorner = other.getUpperCorner();
        for (int i = 0; i < dimension; ++i) {
            double span;
            double \u03b5 = eps;
            if (epsIsRelative && (span = Math.max(this.getSpan(i), other.getSpan(i))) > 0.0 && span < Double.POSITIVE_INFINITY) {
                \u03b5 *= span;
            }
            if (MathFunctions.epsilonEqual(this.getLower(i), lowerCorner.getOrdinate(i), \u03b5) && MathFunctions.epsilonEqual(this.getUpper(i), upperCorner.getOrdinate(i), \u03b5)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            AbstractEnvelope that = (AbstractEnvelope)object;
            int dimension = this.getDimension();
            if (dimension == that.getDimension()) {
                for (int i = 0; i < dimension; ++i) {
                    if (Double.doubleToLongBits(this.getLower(i)) == Double.doubleToLongBits(that.getLower(i)) && Double.doubleToLongBits(this.getUpper(i)) == Double.doubleToLongBits(that.getUpper(i))) continue;
                    assert (!this.equals(that, 0.0, false)) : this;
                    return false;
                }
                if (Objects.equals(this.getCoordinateReferenceSystem(), that.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == that.hashCode()) : this;
                    assert (this.equals(that, 0.0, false)) : this;
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int dimension = this.getDimension();
        int code = 1;
        boolean p = true;
        do {
            for (int i = 0; i < dimension; ++i) {
                code = code * 31 + Double.hashCode(p ? this.getLower(i) : this.getUpper(i));
            }
        } while (!(p = !p));
        return code + Objects.hashCode(this.getCoordinateReferenceSystem());
    }

    @Override
    public String toString() {
        return AbstractEnvelope.toString(this, false);
    }

    static String toString(Envelope envelope, boolean isSinglePrecision) {
        int dimension = envelope.getDimension();
        StringBuilder buffer = new StringBuilder(64).append("BOX");
        if (dimension != 2) {
            buffer.append(dimension).append('D');
        }
        if (dimension == 0) {
            buffer.append("()");
        } else {
            DirectPosition lowerCorner = envelope.getLowerCorner();
            DirectPosition upperCorner = envelope.getUpperCorner();
            boolean isUpper = false;
            do {
                for (int i = 0; i < dimension; ++i) {
                    buffer.append((char)(i == 0 && !isUpper ? 40 : 32));
                    double coordinate = (isUpper ? upperCorner : lowerCorner).getOrdinate(i);
                    if (isSinglePrecision) {
                        buffer.append((float)coordinate);
                    } else {
                        buffer.append(coordinate);
                    }
                    StringBuilders.trimFractionalPart(buffer);
                }
                buffer.append(isUpper ? (char)')' : ',');
            } while (isUpper = !isUpper);
        }
        return buffer.toString();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        Vector[] points = new Vector[]{Vector.create(this.getLowerCorner().getCoordinate()), Vector.create(this.getUpperCorner().getCoordinate())};
        formatter.append(points, WKTUtilities.suggestFractionDigits(this.getCoordinateReferenceSystem(), points));
        int dimension = this.getDimension();
        String keyword = "Box";
        if (dimension != 2) {
            keyword = keyword + dimension + 'D';
        }
        formatter.setInvalidWKT(Envelope.class, null);
        return keyword;
    }

    void setRange(int dimension, double lower, double upper) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException(Errors.format((short)153, this.getClass()));
    }

    private final class LowerCorner
    extends Point {
        private static final long serialVersionUID = 1310741484466506178L;

        private LowerCorner() {
        }

        @Override
        public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
            return AbstractEnvelope.this.getLower(dimension);
        }

        @Override
        public void setOrdinate(int dimension, double value) {
            AbstractEnvelope.this.setRange(dimension, value, AbstractEnvelope.this.getUpper(dimension));
        }
    }

    private final class UpperCorner
    extends Point {
        private static final long serialVersionUID = -6458663549974061472L;

        private UpperCorner() {
        }

        @Override
        public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
            return AbstractEnvelope.this.getUpper(dimension);
        }

        @Override
        public void setOrdinate(int dimension, double value) {
            AbstractEnvelope.this.setRange(dimension, AbstractEnvelope.this.getLower(dimension), value);
        }
    }

    private final class Median
    extends Point {
        private static final long serialVersionUID = -5826011018957321729L;

        private Median() {
        }

        @Override
        public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
            return AbstractEnvelope.this.getMedian(dimension);
        }
    }

    private abstract class Point
    extends AbstractDirectPosition
    implements Serializable {
        private static final long serialVersionUID = -4868610696294317932L;

        private Point() {
        }

        @Override
        public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return AbstractEnvelope.this.getCoordinateReferenceSystem();
        }

        @Override
        public final int getDimension() {
            return AbstractEnvelope.this.getDimension();
        }
    }
}

