/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.vocabulary;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFDirLangString;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.datatypes.xsd.impl.RDFhtml;
import org.apache.jena.datatypes.xsd.impl.RDFjson;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

public class RDF {
    public static final String uri = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final Resource Alt = RDF.resource("Alt");
    public static final Resource Bag = RDF.resource("Bag");
    public static final Resource Property = RDF.resource("Property");
    public static final Resource Seq = RDF.resource("Seq");
    public static final Resource Statement = RDF.resource("Statement");
    public static final Resource List = RDF.resource("List");
    public static final Resource nil = RDF.resource("nil");
    public static final Resource CompoundLiteral = RDF.resource("CompoundLiteral");
    public static final Property first = RDF.property("first");
    public static final Property rest = RDF.property("rest");
    public static final Property subject = RDF.property("subject");
    public static final Property predicate = RDF.property("predicate");
    public static final Property object = RDF.property("object");
    public static final Property type = RDF.property("type");
    public static final Property value = RDF.property("value");
    public static final Property reifies = RDF.property("reifies");
    public static final Resource langString = RDF.resource("langString");
    public static final Resource dirLangString = RDF.resource("dirLangString");
    public static final Resource xmlLiteral = RDF.resource("XMLLiteral");
    public static final Resource JSON = RDF.resource("JSON");
    public static final Resource HTML = RDF.resource("HTML");
    public static final Resource PlainLiteral = RDF.resource("PlainLiteral");
    public static final Property langRange = RDF.property("langRange");
    public static final Property language = RDF.property("language");
    public static final Property direction = RDF.property("direction");
    public static final String dirLTR = TextDirection.LTR.direction();
    public static final String dirRTL = TextDirection.RTL.direction();
    public static final RDFDatatype dtLangString = RDFLangString.rdfLangString;
    public static final RDFDatatype dtDirLangString = RDFDirLangString.rdfDirLangString;
    public static final RDFDatatype dtXMLLiteral = XMLLiteralType.rdfXMLLiteral;
    public static final RDFDatatype dtRDFJSON = RDFjson.rdfJSON;
    public static final RDFDatatype dtRDFHTML = RDFhtml.rdfHTML;

    public static String getURI() {
        return uri;
    }

    protected static Resource resource(String local) {
        return ResourceFactory.createResource(uri + local);
    }

    protected static Property property(String local) {
        return ResourceFactory.createProperty(uri, local);
    }

    public static Property li(int i) {
        return RDF.property("_" + i);
    }

    public static final class Nodes {
        public static final Node Alt = Alt.asNode();
        public static final Node Bag = Bag.asNode();
        public static final Node Property = Property.asNode();
        public static final Node Seq = Seq.asNode();
        public static final Node Statement = Statement.asNode();
        public static final Node List = List.asNode();
        public static final Node nil = nil.asNode();
        public static final Node CompoundLiteral = CompoundLiteral.asNode();
        public static final Node first = first.asNode();
        public static final Node rest = rest.asNode();
        public static final Node subject = subject.asNode();
        public static final Node predicate = predicate.asNode();
        public static final Node object = object.asNode();
        public static final Node type = type.asNode();
        public static final Node value = value.asNode();
        public static final Node langString = langString.asNode();
        public static final Node dirLangString = dirLangString.asNode();
        public static final Node xmlLiteral = xmlLiteral.asNode();
        public static final Node HTML = HTML.asNode();
        public static final Node JSON = JSON.asNode();
        public static final Node langRange = langRange.asNode();
        public static final Node language = language.asNode();
        public static final Node direction = direction.asNode();
        public static final Node PlainLiteral = PlainLiteral.asNode();
        public static final Node reifies = reifies.asNode();

        public static Node li(int i) {
            return RDF.li(i).asNode();
        }
    }
}

