/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.sys;

import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.jena.graph.Node;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.http.Params;
import org.apache.jena.sparql.exec.http.UpdateSendMode;
import org.apache.jena.sparql.syntax.syntaxtransform.UpdateTransformOps;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ContextAccumulator;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateException;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public abstract class ExecUpdateHTTPBuilder<X, Y> {
    protected String serviceURL;
    protected boolean parseCheck = true;
    private UpdateEltAcc updateEltAcc = new UpdateEltAcc(this);
    protected Params params = Params.create();
    protected boolean allowCompression;
    protected Map<String, String> httpHeaders = new HashMap<String, String>();
    protected HttpClient httpClient;
    protected UpdateSendMode sendMode = UpdateSendMode.systemDefault;
    protected List<String> usingGraphURIs = null;
    protected List<String> usingNamedGraphURIs = null;
    private ContextAccumulator contextAcc = ContextAccumulator.newBuilder(() -> ARQ.getContext());
    protected Map<Var, Node> substitutionMap = new HashMap<Var, Node>();
    protected long timeout = -1L;
    protected TimeUnit timeoutUnit = null;

    protected ExecUpdateHTTPBuilder() {
    }

    protected abstract Y thisBuilder();

    public Y endpoint(String serviceURL) {
        this.serviceURL = serviceURL;
        return this.thisBuilder();
    }

    public Y update(UpdateRequest updateRequest) {
        Objects.requireNonNull(updateRequest);
        this.updateEltAcc.add(updateRequest);
        return this.thisBuilder();
    }

    public Y update(String updateRequestString) {
        Objects.requireNonNull(updateRequestString);
        if (this.parseCheck) {
            this.updateEltAcc.add(updateRequestString);
        } else {
            this.updateEltAcc.addString(updateRequestString);
        }
        return this.thisBuilder();
    }

    public Y update(Update update2) {
        Objects.requireNonNull(update2);
        this.updateEltAcc.add(update2);
        return this.thisBuilder();
    }

    public Y updateString(String updateString) {
        Objects.requireNonNull(updateString);
        this.updateEltAcc.clear();
        this.updateEltAcc.addString(updateString);
        return this.thisBuilder();
    }

    public Y parseCheck(boolean parseCheck) {
        this.parseCheck = parseCheck;
        return this.thisBuilder();
    }

    public Y substitution(Binding binding) {
        binding.forEach(this.substitutionMap::put);
        return this.thisBuilder();
    }

    public Y substitution(String var, Node value) {
        return this.substitution(Var.alloc(var), value);
    }

    public Y substitution(Var var, Node value) {
        this.substitutionMap.put(var, value);
        return this.thisBuilder();
    }

    public Y timeout(long timeout, TimeUnit timeoutUnit) {
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        return this.thisBuilder();
    }

    public Y httpClient(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient);
        return this.thisBuilder();
    }

    public Y sendMode(UpdateSendMode mode) {
        this.sendMode = mode;
        return this.thisBuilder();
    }

    public Y addUsingGraphURI(String uri) {
        if (this.usingGraphURIs == null) {
            this.usingGraphURIs = new ArrayList<String>();
        }
        this.usingGraphURIs.add(uri);
        return this.thisBuilder();
    }

    public Y addUsingNamedGraphURI(String uri) {
        if (this.usingNamedGraphURIs == null) {
            this.usingNamedGraphURIs = new ArrayList<String>();
        }
        this.usingNamedGraphURIs.add(uri);
        return this.thisBuilder();
    }

    public Y param(String name) {
        Objects.requireNonNull(name);
        this.params.add(name);
        return this.thisBuilder();
    }

    public Y param(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        this.params.add(name, value);
        return this.thisBuilder();
    }

    public Y httpHeader(String headerName, String headerValue) {
        Objects.requireNonNull(headerName);
        Objects.requireNonNull(headerValue);
        this.httpHeaders.put(headerName, headerValue);
        return this.thisBuilder();
    }

    public Y httpHeaders(Map<String, String> headers) {
        Objects.requireNonNull(headers);
        this.httpHeaders.putAll(headers);
        return this.thisBuilder();
    }

    public Y context(Context context2) {
        if (context2 == null) {
            return this.thisBuilder();
        }
        this.contextAcc.context(context2);
        return this.thisBuilder();
    }

    public Y set(Symbol symbol, Object value) {
        this.contextAcc.set(symbol, value);
        return this.thisBuilder();
    }

    public Y set(Symbol symbol, boolean value) {
        this.contextAcc.set(symbol, value);
        return this.thisBuilder();
    }

    public X build() {
        UpdateRequest updateActual;
        Objects.requireNonNull(this.serviceURL, "No service URL");
        if (this.updateEltAcc.isEmpty()) {
            throw new UpdateException("No update for UpdateExecutionHTTP");
        }
        HttpClient hClient = HttpEnv.getHttpClient(this.serviceURL, this.httpClient);
        UpdateRequest updateRequest = updateActual = this.updateEltAcc.isParsed() ? this.updateEltAcc.buildUpdateRequest() : null;
        if (this.substitutionMap != null && !this.substitutionMap.isEmpty()) {
            if (updateActual == null) {
                try {
                    updateActual = this.updateEltAcc.buildUpdateRequest();
                }
                catch (Exception e2) {
                    throw new UpdateException("Substitution only supported for UpdateRequest objects. Failed to parse a given string as an UpdateRequest object.", e2);
                }
            }
            updateActual = UpdateTransformOps.transform(updateActual, this.substitutionMap);
        }
        String updateStringActual = updateActual == null ? this.updateEltAcc.buildString() : null;
        Context cxt = this.contextAcc.context();
        return this.buildX(hClient, updateActual, updateStringActual, cxt);
    }

    protected abstract X buildX(HttpClient var1, UpdateRequest var2, String var3, Context var4);

    static {
        JenaSystem.init();
    }

    private class UpdateEltAcc
    implements Iterable<UpdateElt> {
        public static final String DELIMITER = "\n;\n";
        private List<UpdateElt> updateOperations = new ArrayList<UpdateElt>();
        private List<UpdateElt> updateOperationsView = Collections.unmodifiableList(this.updateOperations);
        private boolean isParsed = true;

        private UpdateEltAcc(ExecUpdateHTTPBuilder execUpdateHTTPBuilder) {
        }

        public boolean isParsed() {
            return this.isParsed;
        }

        public void add(UpdateElt updateElt) {
            this.isParsed = this.isParsed && updateElt.isParsed();
            this.updateOperations.add(updateElt);
        }

        public void add(Update update2) {
            this.add(new UpdateElt(update2));
        }

        public void add(String updateRequestString) {
            UpdateRequest updateRequest = UpdateFactory.create(updateRequestString);
            this.add(updateRequest);
        }

        public void add(UpdateRequest updateRequest) {
            updateRequest.getOperations().forEach(this::add);
        }

        public void addString(String updateRequestString) {
            this.add(new UpdateElt(updateRequestString));
        }

        public UpdateRequest buildUpdateRequest() {
            return this.addToUpdateRequest(new UpdateRequest());
        }

        public UpdateRequest addToUpdateRequest(UpdateRequest updateRequest) {
            for (UpdateElt elt : this.updateOperations) {
                if (elt.isParsed()) {
                    updateRequest.add(elt.update());
                    continue;
                }
                try {
                    updateRequest.add(elt.updateString());
                }
                catch (Exception e2) {
                    e2.addSuppressed(new RuntimeException("Failed to parse: " + elt.updateString()));
                    throw e2;
                }
            }
            return updateRequest;
        }

        public void clear() {
            this.updateOperations.clear();
            this.isParsed = true;
        }

        public boolean isEmpty() {
            return this.updateOperations.isEmpty();
        }

        @Override
        public Iterator<UpdateElt> iterator() {
            return this.updateOperationsView.iterator();
        }

        public String buildString() {
            return this.updateOperations.stream().map(UpdateElt::toString).collect(Collectors.joining(DELIMITER));
        }
    }

    private record UpdateElt(Update update, String updateString) {
        UpdateElt(Update update2) {
            this(Objects.requireNonNull(update2), null);
        }

        UpdateElt(String updateString) {
            this(null, Objects.requireNonNull(updateString));
        }

        boolean isParsed() {
            return this.update != null;
        }

        @Override
        public String toString() {
            return this.isParsed() ? new UpdateRequest(this.update()).toString() : this.updateString();
        }
    }
}

