/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem.collection;

import java.util.ConcurrentModificationException;
import java.util.Spliterator;
import java.util.function.Predicate;
import org.apache.jena.mem.collection.JenaMapSetCommon;
import org.apache.jena.mem.iterator.SparseArrayIterator;
import org.apache.jena.mem.spliterator.SparseArraySpliterator;
import org.apache.jena.util.iterator.ExtendedIterator;

public abstract class FastHashBase<K>
implements JenaMapSetCommon<K> {
    protected static final int MINIMUM_HASHES_SIZE = 16;
    protected static final int MINIMUM_ELEMENTS_SIZE = 8;
    protected int keysPos = 0;
    protected K[] keys;
    protected int[] hashCodesOrDeletedIndices;
    protected int lastDeletedIndex = -1;
    protected int removedKeysCount = 0;
    protected int[] positions;

    protected FastHashBase(int initialSize) {
        int positionsSize = Integer.highestOneBit(initialSize << 1);
        if (positionsSize < initialSize << 1) {
            positionsSize <<= 1;
        }
        this.positions = new int[positionsSize];
        this.keys = this.newKeysArray(initialSize);
        this.hashCodesOrDeletedIndices = new int[initialSize];
    }

    protected FastHashBase() {
        this.positions = new int[16];
        this.keys = this.newKeysArray(8);
        this.hashCodesOrDeletedIndices = new int[8];
    }

    protected <T extends FastHashBase<?>> FastHashBase(T baseToCopy) {
        this.positions = new int[baseToCopy.positions.length];
        System.arraycopy(baseToCopy.positions, 0, this.positions, 0, baseToCopy.positions.length);
        this.hashCodesOrDeletedIndices = new int[baseToCopy.hashCodesOrDeletedIndices.length];
        System.arraycopy(baseToCopy.hashCodesOrDeletedIndices, 0, this.hashCodesOrDeletedIndices, 0, baseToCopy.hashCodesOrDeletedIndices.length);
        this.keys = this.newKeysArray(baseToCopy.keys.length);
        System.arraycopy(baseToCopy.keys, 0, this.keys, 0, baseToCopy.keys.length);
        this.keysPos = baseToCopy.keysPos;
        this.lastDeletedIndex = baseToCopy.lastDeletedIndex;
        this.removedKeysCount = baseToCopy.removedKeysCount;
    }

    protected abstract K[] newKeysArray(int var1);

    protected final int calcStartIndexByHashCode(int hashCode) {
        return hashCode & this.positions.length - 1;
    }

    private int calcNewPositionsSize() {
        if (this.keysPos << 1 > this.positions.length) {
            int newLength = this.positions.length << 1;
            return newLength < 0 ? Integer.MAX_VALUE : newLength;
        }
        return -1;
    }

    protected final void growPositionsArrayIfNeeded() {
        int newSize = this.calcNewPositionsSize();
        if (newSize < 0) {
            return;
        }
        int[] oldPositions = this.positions;
        this.positions = new int[newSize];
        for (int oldPosition : oldPositions) {
            if (0 == oldPosition) continue;
            this.positions[this.findEmptySlotWithoutEqualityCheck((int)this.hashCodesOrDeletedIndices[oldPosition ^ 0xFFFFFFFF])] = oldPosition;
        }
    }

    protected final boolean tryGrowPositionsArrayIfNeeded() {
        int newSize = this.calcNewPositionsSize();
        if (newSize < 0) {
            return false;
        }
        int[] oldPositions = this.positions;
        this.positions = new int[newSize];
        for (int oldPosition : oldPositions) {
            if (0 == oldPosition) continue;
            this.positions[this.findEmptySlotWithoutEqualityCheck((int)this.hashCodesOrDeletedIndices[oldPosition ^ 0xFFFFFFFF])] = oldPosition;
        }
        return true;
    }

    @Override
    public int size() {
        return this.keysPos - this.removedKeysCount;
    }

    protected final int getFreeKeyIndex() {
        int index;
        if (this.lastDeletedIndex == -1) {
            if ((index = this.keysPos++) == this.keys.length) {
                this.growKeysAndHashCodeArrays();
            }
        } else {
            index = this.lastDeletedIndex;
            this.lastDeletedIndex = this.hashCodesOrDeletedIndices[this.lastDeletedIndex];
            --this.removedKeysCount;
        }
        return index;
    }

    protected void growKeysAndHashCodeArrays() {
        int newSize = (this.keys.length >> 1) + this.keys.length;
        if (newSize < 0) {
            newSize = Integer.MAX_VALUE;
        }
        K[] oldKeys = this.keys;
        this.keys = this.newKeysArray(newSize);
        System.arraycopy(oldKeys, 0, this.keys, 0, oldKeys.length);
        int[] oldHashCodes = this.hashCodesOrDeletedIndices;
        this.hashCodesOrDeletedIndices = new int[newSize];
        System.arraycopy(oldHashCodes, 0, this.hashCodesOrDeletedIndices, 0, oldHashCodes.length);
    }

    @Override
    public final boolean tryRemove(K o) {
        return this.tryRemove(o, o.hashCode());
    }

    public final boolean tryRemove(K e2, int hashCode) {
        int index = this.findPosition(e2, hashCode);
        if (index < 0) {
            return false;
        }
        this.removeFrom(index);
        return true;
    }

    public final int removeAndGetIndex(K e2) {
        return this.removeAndGetIndex(e2, e2.hashCode());
    }

    public final int removeAndGetIndex(K e2, int hashCode) {
        int pIndex = this.findPosition(e2, hashCode);
        if (pIndex < 0) {
            return -1;
        }
        int eIndex = ~this.positions[pIndex];
        this.removeFrom(pIndex);
        return eIndex;
    }

    @Override
    public final void removeUnchecked(K e2) {
        this.removeUnchecked(e2, e2.hashCode());
    }

    public final void removeUnchecked(K e2, int hashCode) {
        this.removeFrom(this.findPosition(e2, hashCode));
    }

    protected void removeFrom(int here) {
        int pIndex = ~this.positions[here];
        this.hashCodesOrDeletedIndices[pIndex] = this.lastDeletedIndex;
        this.lastDeletedIndex = pIndex;
        ++this.removedKeysCount;
        this.keys[pIndex] = null;
        while (true) {
            int r;
            this.positions[here] = 0;
            int scan = here;
            do {
                if (--scan < 0) {
                    scan += this.positions.length;
                }
                if (this.positions[scan] != 0) continue;
                return;
            } while (scan <= (r = this.calcStartIndexByHashCode(this.hashCodesOrDeletedIndices[~this.positions[scan]])) && r < here || r < here && here < scan || here < scan && scan <= r);
            this.positions[here] = this.positions[scan];
            here = scan;
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean containsKey(K o) {
        int hashCode = o.hashCode();
        int pIndex = this.calcStartIndexByHashCode(hashCode);
        while (0 != this.positions[pIndex]) {
            int eIndex = ~this.positions[pIndex];
            if (hashCode == this.hashCodesOrDeletedIndices[eIndex] && o.equals(this.keys[eIndex])) {
                return true;
            }
            if (--pIndex >= 0) continue;
            pIndex += this.positions.length;
        }
        return false;
    }

    @Override
    public final boolean anyMatch(Predicate<K> predicate) {
        for (int pos = this.keysPos - 1; -1 < pos; --pos) {
            if (null == this.keys[pos] || !predicate.test(this.keys[pos])) continue;
            return true;
        }
        return false;
    }

    public final boolean anyMatchRandomOrder(Predicate<K> predicate) {
        for (int pIndex = this.positions.length - 1; -1 < pIndex; --pIndex) {
            if (0 == this.positions[pIndex] || !predicate.test(this.keys[~this.positions[pIndex]])) continue;
            return true;
        }
        return false;
    }

    @Override
    public final ExtendedIterator<K> keyIterator() {
        int initialSize = this.size();
        Runnable checkForConcurrentModification = () -> {
            if (this.size() != initialSize) {
                throw new ConcurrentModificationException();
            }
        };
        return new SparseArrayIterator<K>(this.keys, this.keysPos, checkForConcurrentModification);
    }

    protected final int findPosition(K e2, int hashCode) {
        int pIndex = this.calcStartIndexByHashCode(hashCode);
        while (0 != this.positions[pIndex]) {
            int pos = ~this.positions[pIndex];
            if (hashCode == this.hashCodesOrDeletedIndices[pos] && e2.equals(this.keys[pos])) {
                return pIndex;
            }
            if (--pIndex >= 0) continue;
            pIndex += this.positions.length;
        }
        return ~pIndex;
    }

    protected final int findEmptySlotWithoutEqualityCheck(int hashCode) {
        int pIndex = this.calcStartIndexByHashCode(hashCode);
        while (0 != this.positions[pIndex]) {
            if (--pIndex >= 0) continue;
            pIndex += this.positions.length;
        }
        return pIndex;
    }

    @Override
    public void clear() {
        this.positions = new int[16];
        this.keys = this.newKeysArray(8);
        this.hashCodesOrDeletedIndices = new int[8];
        this.keysPos = 0;
        this.lastDeletedIndex = -1;
        this.removedKeysCount = 0;
    }

    @Override
    public final Spliterator<K> keySpliterator() {
        int initialSize = this.size();
        Runnable checkForConcurrentModification = () -> {
            if (this.size() != initialSize) {
                throw new ConcurrentModificationException();
            }
        };
        return new SparseArraySpliterator<K>(this.keys, this.keysPos, checkForConcurrentModification);
    }
}

