/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.jena.atlas.data.BagFactory;
import org.apache.jena.atlas.data.SerializationFactory;
import org.apache.jena.atlas.data.SortedDataBag;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyFactory;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.cdt.CDTFactory;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.library.cdt.CDTLiteralFunctionUtils;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.WriterExpr;
import org.apache.jena.sparql.system.SerializationFactoryFinder;
import org.apache.jena.sparql.util.ExprUtils;

public class AggFoldList
extends AggregatorBase {
    protected final List<SortCondition> orderBy;
    protected final ThresholdPolicy<Binding> policy;
    protected final Comparator<Binding> comparator;

    public AggFoldList(boolean isDistinct, Expr expr1) {
        this(isDistinct, expr1, null);
    }

    public AggFoldList(boolean isDistinct, Expr expr1, List<SortCondition> orderBy) {
        super("FOLD", isDistinct, AggFoldList.collectExprs(expr1, orderBy));
        this.orderBy = orderBy;
        if (orderBy != null && !orderBy.isEmpty()) {
            this.policy = ThresholdPolicyFactory.policyFromContext(ARQ.getContext());
            this.comparator = new BindingComparator(orderBy);
        } else {
            this.policy = null;
            this.comparator = null;
        }
    }

    protected static ExprList collectExprs(Expr expr1, List<SortCondition> orderBy) {
        ExprList l = new ExprList(expr1);
        if (orderBy != null) {
            for (SortCondition c : orderBy) {
                l.add(c.getExpression());
            }
        }
        return l;
    }

    @Override
    public Aggregator copy(ExprList exprs) {
        ArrayList<SortCondition> _orderBy;
        Expr _expr1;
        if (this.orderBy == null) {
            if (exprs.size() != 1) {
                throw new IllegalArgumentException();
            }
            _expr1 = exprs.get(0);
            _orderBy = null;
        } else {
            if (exprs.size() != this.orderBy.size() + 1) {
                throw new IllegalArgumentException();
            }
            Iterator<SortCondition> cit = this.orderBy.iterator();
            Iterator<Expr> eit = exprs.iterator();
            _expr1 = eit.next();
            _orderBy = new ArrayList<SortCondition>(this.orderBy.size());
            while (eit.hasNext()) {
                SortCondition c = new SortCondition(eit.next(), cit.next().getDirection());
                _orderBy.add(c);
            }
        }
        return new AggFoldList(this.isDistinct, _expr1, _orderBy);
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggFoldList)) {
            return false;
        }
        AggFoldList fold = (AggFoldList)other;
        return this.isDistinct == fold.isDistinct && this.getExprList().get(0).equals(fold.getExprList().get(0), bySyntax) && Objects.equals(this.orderBy, fold.orderBy);
    }

    @Override
    public Accumulator createAccumulator() {
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            return new SortingListAccumulator();
        }
        return new BasicListAccumulator(this.getExprList().get(0), this.isDistinct);
    }

    @Override
    public Node getValueEmpty() {
        ArrayList<CDTValue> emptyList = new ArrayList<CDTValue>();
        return CDTLiteralFunctionUtils.createNode(emptyList);
    }

    @Override
    public int hashCode() {
        return 0x186 ^ this.getExpr().hashCode();
    }

    @Override
    public String asSparqlExpr(SerializationContext sCxt) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.append(this.getName(), new Object[0]);
        out.append("(", new Object[0]);
        if (this.isDistinct) {
            out.append("DISTINCT ", new Object[0]);
        }
        ExprUtils.fmtSPARQL((IndentedWriter)out, this.getExprList().get(0), sCxt);
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            out.append(" ORDER BY ", new Object[0]);
            Iterator<SortCondition> it = this.orderBy.iterator();
            while (it.hasNext()) {
                it.next().output(out, sCxt);
                if (!it.hasNext()) continue;
                out.append(", ", new Object[0]);
            }
        }
        out.append(")", new Object[0]);
        return out.asString();
    }

    @Override
    public String toPrefixString() {
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.append("(", new Object[0]);
        out.append(this.getName().toLowerCase(Locale.ROOT), new Object[0]);
        out.incIndent();
        if (this.isDistinct) {
            out.append(" distinct", new Object[0]);
        }
        WriterExpr.output((IndentedWriter)out, this.getExprList().get(0), null);
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            out.append(" order by ", new Object[0]);
            out.incIndent();
            for (SortCondition c : this.orderBy) {
                c.output(out);
            }
            out.decIndent();
        }
        out.decIndent();
        out.append(")", new Object[0]);
        return out.asString();
    }

    protected class SortingListAccumulator
    implements Accumulator {
        protected final SortedDataBag<Binding> sbag;
        protected FunctionEnv functionEnv = null;

        public SortingListAccumulator() {
            SerializationFactory<Binding> sf = SerializationFactoryFinder.bindingSerializationFactory();
            this.sbag = BagFactory.newSortedBag(AggFoldList.this.policy, sf, AggFoldList.this.comparator);
        }

        @Override
        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            this.sbag.add(binding);
            if (this.functionEnv == null) {
                this.functionEnv = functionEnv;
            }
        }

        @Override
        public NodeValue getValue() {
            Iterator<Binding> it = this.sbag.iterator();
            BasicListAccumulator acc = new BasicListAccumulator(AggFoldList.this.getExprList().get(0), AggFoldList.this.isDistinct);
            while (it.hasNext()) {
                acc.accumulate(it.next(), this.functionEnv);
            }
            this.sbag.close();
            return acc.getValue();
        }
    }

    protected static class BasicListAccumulator
    extends AccumulatorExpr {
        protected final List<CDTValue> list = new ArrayList<CDTValue>();
        protected boolean nullValueAdded = false;

        protected BasicListAccumulator(Expr expr, boolean makeDistinct) {
            super(expr, makeDistinct);
        }

        @Override
        protected void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            CDTValue v = CDTFactory.createValue(nv.asNode());
            this.list.add(v);
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
            if (this.makeDistinct && this.nullValueAdded) {
                return;
            }
            this.nullValueAdded = true;
            CDTValue v = CDTFactory.getNullValue();
            this.list.add(v);
        }

        @Override
        protected NodeValue getAccValue() {
            return CDTLiteralFunctionUtils.createNodeValue(this.list);
        }

        @Override
        public NodeValue getValue() {
            return this.getAccValue();
        }
    }
}

