/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util.iterator;

import java.util.function.Consumer;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;

public class SingletonIterator<T>
extends NiceIterator<T>
implements ExtendedIterator<T> {
    private T item;
    private boolean delivered = false;

    public SingletonIterator(T element) {
        this.item = element;
    }

    @Override
    public boolean hasNext() {
        return !this.delivered;
    }

    @Override
    public T next() {
        if (this.delivered) {
            return this.noElements("no objects in this iterator");
        }
        this.delivered = true;
        return this.item;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (!this.delivered) {
            action.accept(this.item);
            this.delivered = true;
        }
    }
}

