/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DocAndFloatFeatureBuffer;
import org.apache.lucene.search.DocAndScoreAccBuffer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerUtil;
import org.apache.lucene.search.SimpleScorable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.MathUtil;

final class MaxScoreBulkScorer
extends BulkScorer {
    static final int INNER_WINDOW_SIZE = 4096;
    private final int maxDoc;
    final DisiWrapper[] allScorers;
    private final DisiWrapper[] scratch;
    private final DisiPriorityQueue essentialQueue;
    int firstEssentialScorer;
    int firstRequiredScorer;
    float nextMinCompetitiveScore;
    private final long cost;
    final SimpleScorable scorable = new SimpleScorable();
    final double[] maxScoreSums;
    private final DisiWrapper filter;
    private final FixedBitSet windowMatches = new FixedBitSet(4096);
    private final double[] windowScores = new double[4096];
    private final DocAndFloatFeatureBuffer docAndScoreBuffer = new DocAndFloatFeatureBuffer();
    private final DocAndScoreAccBuffer docAndScoreAccBuffer = new DocAndScoreAccBuffer();
    private int numOuterWindows;
    private int numCandidates;
    private int minWindowSize = 1;

    MaxScoreBulkScorer(int maxDoc, List<Scorer> scorers, Scorer filter) throws IOException {
        this.maxDoc = maxDoc;
        this.filter = filter == null ? null : new DisiWrapper(filter, false);
        this.allScorers = new DisiWrapper[scorers.size()];
        this.scratch = new DisiWrapper[this.allScorers.length];
        int i = 0;
        long cost = 0L;
        for (Scorer scorer : scorers) {
            DisiWrapper w = new DisiWrapper(scorer, true);
            cost += w.cost;
            this.allScorers[i++] = w;
        }
        this.cost = cost;
        this.essentialQueue = DisiPriorityQueue.ofMaxSize(this.allScorers.length);
        this.maxScoreSums = new double[this.allScorers.length];
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
        collector.setScorer(this.scorable);
        int outerWindowMin = min2;
        block0: while (outerWindowMin < max2) {
            int outerWindowMax = this.computeOuterWindowMax(outerWindowMin);
            outerWindowMax = Math.min(outerWindowMax, max2);
            while (true) {
                this.updateMaxWindowScores(outerWindowMin, outerWindowMax);
                if (!this.partitionScorers()) {
                    outerWindowMin = outerWindowMax;
                    continue block0;
                }
                int newOuterWindowMax = this.computeOuterWindowMax(outerWindowMin);
                if (newOuterWindowMax >= outerWindowMax) break;
                outerWindowMax = newOuterWindowMax;
            }
            DisiWrapper top = this.essentialQueue.top();
            while (top.doc < outerWindowMin) {
                top.doc = top.iterator.advance(outerWindowMin);
                top = this.essentialQueue.updateTop();
            }
            while (top.doc < outerWindowMax) {
                this.scoreInnerWindow(collector, acceptDocs, outerWindowMax, this.filter);
                top = this.essentialQueue.top();
                if (!(this.scorable.minCompetitiveScore >= this.nextMinCompetitiveScore)) continue;
            }
            outerWindowMin = Math.min(top.doc, outerWindowMax);
            ++this.numOuterWindows;
        }
        return this.nextCandidate(max2);
    }

    private void scoreInnerWindow(LeafCollector collector, Bits acceptDocs, int max2, DisiWrapper filter) throws IOException {
        if (filter != null) {
            this.scoreInnerWindowWithFilter(collector, acceptDocs, max2, filter);
        } else if (this.allScorers.length - this.firstRequiredScorer >= 2) {
            this.scoreInnerWindowAsConjunction(collector, acceptDocs, max2);
        } else {
            DisiWrapper top = this.essentialQueue.top();
            DisiWrapper top2 = this.essentialQueue.top2();
            if (top2 == null) {
                this.scoreInnerWindowSingleEssentialClause(collector, acceptDocs, max2);
            } else if (top2.doc - 2048 >= top.doc) {
                this.scoreInnerWindowSingleEssentialClause(collector, acceptDocs, Math.min(max2, top2.doc));
            } else {
                this.scoreInnerWindowMultipleEssentialClauses(collector, acceptDocs, max2);
            }
        }
    }

    private void scoreInnerWindowWithFilter(LeafCollector collector, Bits acceptDocs, int max2, DisiWrapper filter) throws IOException {
        DisiWrapper top = this.essentialQueue.top();
        assert (top.doc < max2);
        while (top.doc < filter.doc) {
            top.doc = top.approximation.advance(filter.doc);
            top = this.essentialQueue.updateTop();
        }
        int innerWindowMin = top.doc;
        int innerWindowMax = MathUtil.unsignedMin(max2, innerWindowMin + 4096);
        this.docAndScoreAccBuffer.size = 0;
        while (top.doc < innerWindowMax) {
            assert (filter.doc <= top.doc);
            if (filter.doc < top.doc) {
                filter.doc = filter.approximation.advance(top.doc);
            }
            if (filter.doc != top.doc) {
                do {
                    top.doc = top.iterator.advance(filter.doc);
                    top = this.essentialQueue.updateTop();
                } while (top.doc < filter.doc);
                continue;
            }
            int doc = top.doc;
            boolean match = !(acceptDocs != null && !acceptDocs.get(doc) || filter.twoPhaseView != null && !filter.twoPhaseView.matches());
            double score = 0.0;
            do {
                if (match) {
                    score += (double)top.scorer.score();
                }
                top.doc = top.iterator.nextDoc();
                top = this.essentialQueue.updateTop();
            } while (top.doc == doc);
            if (!match) continue;
            this.docAndScoreAccBuffer.grow(this.docAndScoreAccBuffer.size + 1);
            this.docAndScoreAccBuffer.docs[this.docAndScoreAccBuffer.size] = doc;
            this.docAndScoreAccBuffer.scores[this.docAndScoreAccBuffer.size] = score;
            ++this.docAndScoreAccBuffer.size;
        }
        this.scoreNonEssentialClauses(collector, this.docAndScoreAccBuffer, this.firstEssentialScorer);
    }

    private void scoreInnerWindowSingleEssentialClause(LeafCollector collector, Bits acceptDocs, int upTo) throws IOException {
        DisiWrapper top = this.essentialQueue.top();
        top.scorer.nextDocsAndScores(upTo, acceptDocs, this.docAndScoreBuffer);
        while (this.docAndScoreBuffer.size > 0) {
            this.docAndScoreAccBuffer.copyFrom(this.docAndScoreBuffer);
            this.scoreNonEssentialClauses(collector, this.docAndScoreAccBuffer, this.firstEssentialScorer);
            top.scorer.nextDocsAndScores(upTo, acceptDocs, this.docAndScoreBuffer);
        }
        top.doc = top.iterator.docID();
        this.essentialQueue.updateTop();
    }

    private void scoreInnerWindowAsConjunction(LeafCollector collector, Bits acceptDocs, int max2) throws IOException {
        int i;
        assert (this.firstEssentialScorer == this.allScorers.length - 1);
        assert (this.firstRequiredScorer <= this.allScorers.length - 2);
        DisiWrapper lead1 = this.allScorers[this.allScorers.length - 1];
        assert (this.essentialQueue.size() == 1);
        assert (lead1 == this.essentialQueue.top());
        lead1.scorer.nextDocsAndScores(max2, acceptDocs, this.docAndScoreBuffer);
        while (this.docAndScoreBuffer.size > 0) {
            this.docAndScoreAccBuffer.copyFrom(this.docAndScoreBuffer);
            for (i = this.allScorers.length - 2; i >= this.firstRequiredScorer; --i) {
                if (this.scorable.minCompetitiveScore > 0.0f) {
                    ScorerUtil.filterCompetitiveHits(this.docAndScoreAccBuffer, this.maxScoreSums[i], this.scorable.minCompetitiveScore, this.allScorers.length);
                }
                DisiWrapper scorer = this.allScorers[i];
                ScorerUtil.applyRequiredClause(this.docAndScoreAccBuffer, scorer.iterator, scorer.scorable);
            }
            this.scoreNonEssentialClauses(collector, this.docAndScoreAccBuffer, this.firstRequiredScorer);
            lead1.scorer.nextDocsAndScores(max2, acceptDocs, this.docAndScoreBuffer);
        }
        for (i = this.allScorers.length - 1; i >= this.firstRequiredScorer; --i) {
            this.allScorers[i].doc = this.allScorers[i].iterator.docID();
        }
    }

    private void scoreInnerWindowMultipleEssentialClauses(LeafCollector collector, Bits acceptDocs, int max2) throws IOException {
        DisiWrapper top = this.essentialQueue.top();
        int innerWindowMin = top.doc;
        int innerWindowMax = MathUtil.unsignedMin(max2, innerWindowMin + 4096);
        int innerWindowSize = innerWindowMax - innerWindowMin;
        do {
            top.scorer.nextDocsAndScores(innerWindowMax, acceptDocs, this.docAndScoreBuffer);
            while (this.docAndScoreBuffer.size > 0) {
                for (int index2 = 0; index2 < this.docAndScoreBuffer.size; ++index2) {
                    int doc = this.docAndScoreBuffer.docs[index2];
                    float score = this.docAndScoreBuffer.features[index2];
                    int i = doc - innerWindowMin;
                    this.windowMatches.set(i);
                    int n = i;
                    this.windowScores[n] = this.windowScores[n] + (double)score;
                }
                top.scorer.nextDocsAndScores(innerWindowMax, acceptDocs, this.docAndScoreBuffer);
            }
            top.doc = top.iterator.docID();
            top = this.essentialQueue.updateTop();
        } while (top.doc < innerWindowMax);
        this.docAndScoreAccBuffer.growNoCopy(this.windowMatches.cardinality(0, innerWindowSize));
        this.docAndScoreAccBuffer.size = 0;
        this.windowMatches.forEach(0, innerWindowSize, 0, index -> {
            this.docAndScoreAccBuffer.docs[this.docAndScoreAccBuffer.size] = innerWindowMin + index;
            this.docAndScoreAccBuffer.scores[this.docAndScoreAccBuffer.size] = this.windowScores[index];
            ++this.docAndScoreAccBuffer.size;
            this.windowScores[index] = 0.0;
        });
        this.windowMatches.clear(0, innerWindowSize);
        this.scoreNonEssentialClauses(collector, this.docAndScoreAccBuffer, this.firstEssentialScorer);
    }

    private int computeOuterWindowMax(int windowMin) throws IOException {
        int firstWindowLead = Math.min(this.firstEssentialScorer, this.allScorers.length - 1);
        int windowMax = Integer.MAX_VALUE;
        for (int i = firstWindowLead; i < this.allScorers.length; ++i) {
            DisiWrapper scorer = this.allScorers[i];
            if (this.filter != null && scorer.cost < this.filter.cost) continue;
            int upTo = scorer.scorer.advanceShallow(Math.max(scorer.doc, windowMin));
            windowMax = MathUtil.unsignedMin(windowMax, upTo + 1);
        }
        if (this.allScorers.length - firstWindowLead > 1) {
            long threshold = (long)this.numOuterWindows * 32L * (long)this.allScorers.length;
            this.minWindowSize = (long)this.numCandidates < threshold ? Math.min(this.minWindowSize << 1, 4096) : 1;
            int minWindowMax = MathUtil.unsignedMin(Integer.MAX_VALUE, windowMin + this.minWindowSize);
            windowMax = Math.max(windowMax, minWindowMax);
        }
        return windowMax;
    }

    void updateMaxWindowScores(int windowMin, int windowMax) throws IOException {
        for (DisiWrapper scorer : this.allScorers) {
            if (scorer.doc < windowMax) {
                if (scorer.doc < windowMin) {
                    scorer.scorer.advanceShallow(windowMin);
                }
                scorer.maxWindowScore = scorer.scorer.getMaxScore(windowMax - 1);
                continue;
            }
            scorer.maxWindowScore = 0.0f;
        }
    }

    private void scoreNonEssentialClauses(LeafCollector collector, DocAndScoreAccBuffer buffer, int numNonEssentialClauses) throws IOException {
        int i;
        this.numCandidates += buffer.size;
        for (i = numNonEssentialClauses - 1; i >= 0; --i) {
            DisiWrapper scorer = this.allScorers[i];
            assert (this.scorable.minCompetitiveScore > 0.0f) : "All clauses are essential if minCompetitiveScore is equal to zero";
            ScorerUtil.filterCompetitiveHits(buffer, this.maxScoreSums[i], this.scorable.minCompetitiveScore, this.allScorers.length);
            ScorerUtil.applyOptionalClause(buffer, scorer.iterator, scorer.scorable);
            scorer.doc = scorer.iterator.docID();
        }
        for (i = 0; i < buffer.size; ++i) {
            this.scorable.score = (float)buffer.scores[i];
            collector.collect(buffer.docs[i]);
        }
    }

    boolean partitionScorers() {
        int i;
        System.arraycopy(this.allScorers, 0, this.scratch, 0, this.allScorers.length);
        Arrays.sort(this.scratch, (scorer1, scorer2) -> Double.compare((double)scorer1.maxWindowScore / (double)Math.max(1L, scorer1.cost), (double)scorer2.maxWindowScore / (double)Math.max(1L, scorer2.cost)));
        double maxScoreSum = 0.0;
        this.firstEssentialScorer = 0;
        this.nextMinCompetitiveScore = Float.POSITIVE_INFINITY;
        for (i = 0; i < this.allScorers.length; ++i) {
            DisiWrapper w = this.scratch[i];
            double newMaxScoreSum = maxScoreSum + (double)w.maxWindowScore;
            float maxScoreSumFloat = (float)MathUtil.sumUpperBound(newMaxScoreSum, this.firstEssentialScorer + 1);
            if (maxScoreSumFloat < this.scorable.minCompetitiveScore) {
                maxScoreSum = newMaxScoreSum;
                this.allScorers[this.firstEssentialScorer] = w;
                this.maxScoreSums[this.firstEssentialScorer] = maxScoreSum;
                ++this.firstEssentialScorer;
                continue;
            }
            this.allScorers[this.allScorers.length - 1 - (i - this.firstEssentialScorer)] = w;
            this.nextMinCompetitiveScore = Math.min(maxScoreSumFloat, this.nextMinCompetitiveScore);
        }
        this.firstRequiredScorer = this.allScorers.length;
        if (this.firstEssentialScorer == this.allScorers.length) {
            return false;
        }
        this.essentialQueue.clear();
        for (i = this.firstEssentialScorer; i < this.allScorers.length; ++i) {
            this.essentialQueue.add(this.allScorers[i]);
        }
        if (this.firstEssentialScorer == this.allScorers.length - 1) {
            this.firstRequiredScorer = this.allScorers.length - 1;
            double maxRequiredScore = this.allScorers[this.firstEssentialScorer].maxWindowScore;
            while (this.firstRequiredScorer > 0) {
                double maxPossibleScoreWithoutPreviousClause = maxRequiredScore;
                if (this.firstRequiredScorer > 1) {
                    maxPossibleScoreWithoutPreviousClause += this.maxScoreSums[this.firstRequiredScorer - 2];
                }
                if ((float)maxPossibleScoreWithoutPreviousClause >= this.scorable.minCompetitiveScore) break;
                --this.firstRequiredScorer;
                maxRequiredScore += (double)this.allScorers[this.firstRequiredScorer].maxWindowScore;
            }
        }
        return true;
    }

    private int nextCandidate(int rangeEnd) {
        if (rangeEnd >= this.maxDoc) {
            return Integer.MAX_VALUE;
        }
        int next = Integer.MAX_VALUE;
        for (DisiWrapper scorer : this.allScorers) {
            if (scorer.doc < rangeEnd) {
                return rangeEnd;
            }
            next = Math.min(next, scorer.doc);
        }
        return next;
    }

    @Override
    public long cost() {
        return this.cost;
    }
}

