/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.common.KRaftVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class MetadataCache$ {
    public static final MetadataCache$ MODULE$ = new MetadataCache$();

    public KRaftMetadataCache kRaftMetadataCache(int brokerId, Supplier<KRaftVersion> kraftVersionSupplier) {
        return new KRaftMetadataCache(brokerId, kraftVersionSupplier);
    }

    public Cluster toCluster(String clusterId, MetadataImage image) {
        int getNodes$1_id;
        java.util.List list;
        HashMap brokerToNodes = new HashMap();
        image.cluster().brokers().values().stream().filter(broker -> !broker.fenced()).forEach(broker -> brokerToNodes.put(Predef$.MODULE$.int2Integer(broker.id()), broker.nodes()));
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        Collection topicImages = image.topics().topicsByName().values();
        if (topicImages != null) {
            topicImages.forEach(topic -> topic.partitions().forEach((key, value) -> {
                int getNodes$1_id = value.leader;
                java.util.List nodes = (java.util.List)brokerToNodes.get(BoxesRunTime.boxToInteger((int)getNodes$1_id));
                if (nodes != null) {
                    nodes.forEach(node -> partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(key), node, MetadataCache$.toArray$1(partition$1.replicas, brokerToNodes), MetadataCache$.toArray$1(partition$1.isr, brokerToNodes), (Node[])MODULE$.getOfflineReplicas(image, (PartitionRegistration)value, null).stream().map(replica -> MetadataCache$.getNodes$1(Predef$.MODULE$.Integer2int(replica), brokerToNodes)).flatMap(replica -> replica.stream()).toArray(Node[]::new))));
                    if (Topic.isInternal((String)topic.name())) {
                        internalTopics.add(topic.name());
                        return;
                    }
                    return;
                }
            }));
        }
        Node controllerNode = (list = (java.util.List)brokerToNodes.get(BoxesRunTime.boxToInteger((int)(getNodes$1_id = BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)))))) == null ? Node.noNode() : (Node)list.get(0);
        return new Cluster(clusterId, (Collection)brokerToNodes.values().stream().flatMap(n -> n.stream()).collect(Collectors.toList()), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)brokerId -> MetadataCache$.$anonfun$getOfflineReplicas$1(image, offlineReplicas, listenerName, partition, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private ListenerName getOfflineReplicas$default$3() {
        return null;
    }

    private boolean isReplicaOffline(PartitionRegistration partition, ListenerName listenerName, BrokerRegistration broker) {
        return broker.fenced() || !broker.listeners().containsKey(listenerName.value()) || this.isReplicaInOfflineDir(broker, partition);
    }

    private boolean isReplicaInOfflineDir(BrokerRegistration broker, PartitionRegistration partition) {
        return !broker.hasOnlineDir(partition.directory(broker.id()));
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply((int)ThreadLocalRandom.current().nextInt((int)aliveBrokers.size()))).id));
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(image.cluster().brokers().values()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.fenced()))).map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), b.rack()));
    }

    private static final java.util.List getNodes$1(int id, HashMap brokerToNodes$1) {
        return (java.util.List)brokerToNodes$1.get(BoxesRunTime.boxToInteger((int)id));
    }

    private static final Node[] toArray$1(int[] replicas, HashMap brokerToNodes$1) {
        return (Node[])Arrays.stream(replicas).mapToObj(replica -> MetadataCache$.getNodes$1(replica, brokerToNodes$1)).flatMap(replica -> replica.stream()).toArray(Node[]::new);
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(MetadataImage image$2, ArrayList offlineReplicas$1, ListenerName listenerName$1, PartitionRegistration partition$2, int brokerId) {
        Option option = Option$.MODULE$.apply((Object)image$2.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            if (listenerName$1 == null || MODULE$.isReplicaOffline(partition$2, listenerName$1, broker)) {
                return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    private MetadataCache$() {
    }
}

