/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.image.node.FeaturesImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.server.common.EligibleLeaderReplicasVersion;
import org.apache.kafka.server.common.MetadataVersion;

public final class FeaturesImage {
    public static final FeaturesImage EMPTY = new FeaturesImage(Map.of(), Optional.empty());
    private final Map<String, Short> finalizedVersions;
    private final Optional<MetadataVersion> metadataVersion;

    public FeaturesImage(Map<String, Short> finalizedVersions, MetadataVersion metadataVersion) {
        this(finalizedVersions, Optional.of(metadataVersion));
    }

    FeaturesImage(Map<String, Short> finalizedVersions, Optional<MetadataVersion> metadataVersion) {
        this.finalizedVersions = Collections.unmodifiableMap(finalizedVersions);
        this.metadataVersion = metadataVersion;
    }

    public boolean isEmpty() {
        return this.finalizedVersions.isEmpty() && this.metadataVersion.isEmpty();
    }

    public Optional<MetadataVersion> metadataVersion() {
        return this.metadataVersion;
    }

    public MetadataVersion metadataVersionOrThrow() {
        return this.metadataVersion.orElseThrow(() -> new IllegalStateException("Unknown metadata version for FeaturesImage: " + String.valueOf(this)));
    }

    public Map<String, Short> finalizedVersions() {
        return this.finalizedVersions;
    }

    public boolean isElrEnabled() {
        return this.finalizedVersions.getOrDefault("eligible.leader.replicas.version", EligibleLeaderReplicasVersion.ELRV_0.featureLevel()) >= EligibleLeaderReplicasVersion.ELRV_1.featureLevel();
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        this.writeFeatureLevels(writer, options);
    }

    private void writeFeatureLevels(ImageWriter writer, ImageWriterOptions options) {
        writer.write(0, new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(options.metadataVersion().featureLevel()));
        for (Map.Entry<String, Short> entry : this.finalizedVersions.entrySet()) {
            if (entry.getKey().equals("metadata.version")) continue;
            writer.write(0, new FeatureLevelRecord().setName(entry.getKey()).setFeatureLevel(entry.getValue()));
        }
    }

    public int hashCode() {
        return Objects.hash(this.finalizedVersions, this.metadataVersion);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FeaturesImage)) {
            return false;
        }
        FeaturesImage other = (FeaturesImage)o;
        return this.finalizedVersions.equals(other.finalizedVersions) && this.metadataVersion.equals(other.metadataVersion);
    }

    public String toString() {
        return new FeaturesImageNode(this).stringify();
    }
}

