/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.connector.impl;

import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.ops4j.pax.transx.tm.NamedResource;

public class WrapperNamedXAResource
implements NamedResource {
    protected static final Logger LOG = Logger.getLogger(WrapperNamedXAResource.class.getName());
    private final XAResource xaResource;
    private final String name;

    public WrapperNamedXAResource(XAResource xaResource, String name) {
        if (xaResource == null) {
            throw new NullPointerException("No XAResource supplied.  XA support may not be configured properly");
        }
        if (name == null) {
            throw new NullPointerException("No name supplied. Resource adapter not properly configured");
        }
        this.xaResource = xaResource;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        LOG.finest(() -> "Commit called on XAResource " + this.getName() + "\n Xid: " + xid + "\n onePhase:" + onePhase);
        this.xaResource.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        LOG.finest(() -> "End called on XAResource " + this.getName() + "\n Xid: " + xid + "\n flags:" + this.decodeFlags(flags));
        this.xaResource.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        LOG.finest(() -> "Forget called on XAResource " + this.getName() + "\n Xid: " + xid);
        this.xaResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource other) throws XAException {
        if (other instanceof WrapperNamedXAResource) {
            return this.xaResource.isSameRM(((WrapperNamedXAResource)((Object)other)).xaResource);
        }
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        LOG.finest(() -> "Prepare called on XAResource " + this.getName() + "\n Xid: " + xid);
        return this.xaResource.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        LOG.finest(() -> "Recover called on XAResource " + this.getName() + "\n flags: " + this.decodeFlags(flag));
        return this.xaResource.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        LOG.finest(() -> "Rollback called on XAResource " + this.getName() + "\n Xid: " + xid);
        this.xaResource.rollback(xid);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaResource.setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        LOG.finest(() -> "Start called on XAResource " + this.getName() + "\n Xid: " + xid + "\n flags:" + this.decodeFlags(flags));
        this.xaResource.start(xid, flags);
    }

    private String decodeFlags(int flags) {
        if (flags == 0) {
            return " TMNOFLAGS";
        }
        StringBuilder b = new StringBuilder();
        flags = this.decodeFlag(flags, b, 0x800000, " TMENDRSCAN");
        flags = this.decodeFlag(flags, b, 0x20000000, " TMFAIL");
        flags = this.decodeFlag(flags, b, 0x200000, " TMJOIN");
        flags = this.decodeFlag(flags, b, 0x40000000, " TMONEPHASE");
        flags = this.decodeFlag(flags, b, 0x8000000, " TMRESUME");
        flags = this.decodeFlag(flags, b, 0x1000000, " TMSTARTRSCAN");
        flags = this.decodeFlag(flags, b, 0x4000000, " TMSUCCESS");
        if ((flags = this.decodeFlag(flags, b, 0x2000000, " TMSUSPEND")) != 0) {
            b.append(" remaining: ").append(flags);
        }
        return b.toString();
    }

    private int decodeFlag(int flags, StringBuilder b, int flag, String flagName) {
        if ((flags & flag) == flag) {
            b.append(flagName);
            flags ^= flag;
        }
        return flags;
    }
}

