/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.UriFactoryResolver;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUriFactoryResolver
implements CamelContextAware,
UriFactoryResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/urifactory/";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUriFactoryResolver.class);
    private CamelContext camelContext;
    private FactoryFinder factoryFinder;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public EndpointUriFactory resolveFactory(String name, CamelContext context) {
        Class<?> type;
        if (ObjectHelper.isEmpty((Object)name)) {
            return null;
        }
        Set assemblers = context.getRegistry().findByType(EndpointUriFactory.class);
        EndpointUriFactory answer = assemblers.stream().filter(a -> a.isEnabled(name)).findFirst().orElse(null);
        if (answer != null) {
            answer.setCamelContext(context);
            return answer;
        }
        try {
            type = this.findAssembler(name + "-endpoint", context);
        }
        catch (NoFactoryAvailableException e) {
            type = null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no EndpointUriFactory registered for scheme: " + name, e);
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found EndpointUriFactory: {} via type: {} via: {}{}", new Object[]{name, type.getName(), this.factoryFinder.getResourcePath(), name});
            }
            if (EndpointUriFactory.class.isAssignableFrom(type)) {
                answer = (EndpointUriFactory)context.getInjector().newInstance(type, false);
                answer.setCamelContext(context);
                return answer;
            }
            throw new IllegalArgumentException("Type is not a EndpointUriFactory implementation. Found: " + type.getName());
        }
        return answer;
    }

    private Class<?> findAssembler(String name, CamelContext context) throws IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name).orElse(null);
    }
}

