/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import org.apache.kyuubi.jdbc.hive.auth.KerberosUtils;
import org.apache.kyuubi.jdbc.hive.auth.TSubjectTransport;
import org.apache.kyuubi.shaded.thrift.transport.TSaslClientTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KerberosSaslHelper {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosSaslHelper.class);

    public static TTransport createSubjectAssumedTransport(Subject subject, String serverPrincipal, String host, TTransport underlyingTransport, Map<String, String> saslProps) throws SaslException, TTransportException {
        String resolvedPrincipal = KerberosUtils.canonicalPrincipal(serverPrincipal, host);
        String[] names = KerberosUtils.splitPrincipal(resolvedPrincipal);
        TSaslClientTransport saslTransport = new TSaslClientTransport("GSSAPI", null, names[0], names[1], saslProps, null, underlyingTransport);
        return new TSubjectTransport((TTransport)saslTransport, subject);
    }

    private KerberosSaslHelper() {
        throw new UnsupportedOperationException("Can't initialize class");
    }
}

