﻿// Lucene version compatibility level 4.8.1
/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

namespace Lucene.Net.Tartarus.Snowball.Ext
{
    /// <summary>
    /// This class was automatically generated by a Snowball to Java compiler
    /// It implements the stemming algorithm defined by a snowball script.
    /// </summary>
    public class BasqueStemmer : SnowballProgram
    {
        // LUCENENET specific: Factored out methodObject by using Func<bool> instead of Reflection

        private readonly static Among[] a_0 = {
                    new Among ( "idea", -1, 1 ),
                    new Among ( "bidea", 0, 1 ),
                    new Among ( "kidea", 0, 1 ),
                    new Among ( "pidea", 0, 1 ),
                    new Among ( "kundea", -1, 1 ),
                    new Among ( "galea", -1, 1 ),
                    new Among ( "tailea", -1, 1 ),
                    new Among ( "tzailea", -1, 1 ),
                    new Among ( "gunea", -1, 1 ),
                    new Among ( "kunea", -1, 1 ),
                    new Among ( "tzaga", -1, 1 ),
                    new Among ( "gaia", -1, 1 ),
                    new Among ( "aldia", -1, 1 ),
                    new Among ( "taldia", 12, 1 ),
                    new Among ( "karia", -1, 1 ),
                    new Among ( "garria", -1, 2 ),
                    new Among ( "karria", -1, 1 ),
                    new Among ( "ka", -1, 1 ),
                    new Among ( "tzaka", 17, 1 ),
                    new Among ( "la", -1, 1 ),
                    new Among ( "mena", -1, 1 ),
                    new Among ( "pena", -1, 1 ),
                    new Among ( "kina", -1, 1 ),
                    new Among ( "ezina", -1, 1 ),
                    new Among ( "tezina", 23, 1 ),
                    new Among ( "kuna", -1, 1 ),
                    new Among ( "tuna", -1, 1 ),
                    new Among ( "kizuna", -1, 1 ),
                    new Among ( "era", -1, 1 ),
                    new Among ( "bera", 28, 1 ),
                    new Among ( "arabera", 29, 4 ),
                    new Among ( "kera", 28, 1 ),
                    new Among ( "pera", 28, 1 ),
                    new Among ( "orra", -1, 1 ),
                    new Among ( "korra", 33, 1 ),
                    new Among ( "dura", -1, 1 ),
                    new Among ( "gura", -1, 1 ),
                    new Among ( "kura", -1, 1 ),
                    new Among ( "tura", -1, 1 ),
                    new Among ( "eta", -1, 1 ),
                    new Among ( "keta", 39, 1 ),
                    new Among ( "gailua", -1, 1 ),
                    new Among ( "eza", -1, 1 ),
                    new Among ( "erreza", 42, 1 ),
                    new Among ( "tza", -1, 2 ),
                    new Among ( "gaitza", 44, 1 ),
                    new Among ( "kaitza", 44, 1 ),
                    new Among ( "kuntza", 44, 1 ),
                    new Among ( "ide", -1, 1 ),
                    new Among ( "bide", 48, 1 ),
                    new Among ( "kide", 48, 1 ),
                    new Among ( "pide", 48, 1 ),
                    new Among ( "kunde", -1, 1 ),
                    new Among ( "tzake", -1, 1 ),
                    new Among ( "tzeke", -1, 1 ),
                    new Among ( "le", -1, 1 ),
                    new Among ( "gale", 55, 1 ),
                    new Among ( "taile", 55, 1 ),
                    new Among ( "tzaile", 55, 1 ),
                    new Among ( "gune", -1, 1 ),
                    new Among ( "kune", -1, 1 ),
                    new Among ( "tze", -1, 1 ),
                    new Among ( "atze", 61, 1 ),
                    new Among ( "gai", -1, 1 ),
                    new Among ( "aldi", -1, 1 ),
                    new Among ( "taldi", 64, 1 ),
                    new Among ( "ki", -1, 1 ),
                    new Among ( "ari", -1, 1 ),
                    new Among ( "kari", 67, 1 ),
                    new Among ( "lari", 67, 1 ),
                    new Among ( "tari", 67, 1 ),
                    new Among ( "etari", 70, 1 ),
                    new Among ( "garri", -1, 2 ),
                    new Among ( "karri", -1, 1 ),
                    new Among ( "arazi", -1, 1 ),
                    new Among ( "tarazi", 74, 1 ),
                    new Among ( "an", -1, 1 ),
                    new Among ( "ean", 76, 1 ),
                    new Among ( "rean", 77, 1 ),
                    new Among ( "kan", 76, 1 ),
                    new Among ( "etan", 76, 1 ),
                    new Among ( "atseden", -1, 3 ),
                    new Among ( "men", -1, 1 ),
                    new Among ( "pen", -1, 1 ),
                    new Among ( "kin", -1, 1 ),
                    new Among ( "rekin", 84, 1 ),
                    new Among ( "ezin", -1, 1 ),
                    new Among ( "tezin", 86, 1 ),
                    new Among ( "tun", -1, 1 ),
                    new Among ( "kizun", -1, 1 ),
                    new Among ( "go", -1, 1 ),
                    new Among ( "ago", 90, 1 ),
                    new Among ( "tio", -1, 1 ),
                    new Among ( "dako", -1, 1 ),
                    new Among ( "or", -1, 1 ),
                    new Among ( "kor", 94, 1 ),
                    new Among ( "tzat", -1, 1 ),
                    new Among ( "du", -1, 1 ),
                    new Among ( "gailu", -1, 1 ),
                    new Among ( "tu", -1, 1 ),
                    new Among ( "atu", 99, 1 ),
                    new Among ( "aldatu", 100, 1 ),
                    new Among ( "tatu", 100, 1 ),
                    new Among ( "baditu", 99, 5 ),
                    new Among ( "ez", -1, 1 ),
                    new Among ( "errez", 104, 1 ),
                    new Among ( "tzez", 104, 1 ),
                    new Among ( "gaitz", -1, 1 ),
                    new Among ( "kaitz", -1, 1 )
                };

        private readonly static Among[] a_1 = {
                    new Among ( "ada", -1, 1 ),
                    new Among ( "kada", 0, 1 ),
                    new Among ( "anda", -1, 1 ),
                    new Among ( "denda", -1, 1 ),
                    new Among ( "gabea", -1, 1 ),
                    new Among ( "kabea", -1, 1 ),
                    new Among ( "aldea", -1, 1 ),
                    new Among ( "kaldea", 6, 1 ),
                    new Among ( "taldea", 6, 1 ),
                    new Among ( "ordea", -1, 1 ),
                    new Among ( "zalea", -1, 1 ),
                    new Among ( "tzalea", 10, 1 ),
                    new Among ( "gilea", -1, 1 ),
                    new Among ( "emea", -1, 1 ),
                    new Among ( "kumea", -1, 1 ),
                    new Among ( "nea", -1, 1 ),
                    new Among ( "enea", 15, 1 ),
                    new Among ( "zionea", 15, 1 ),
                    new Among ( "unea", 15, 1 ),
                    new Among ( "gunea", 18, 1 ),
                    new Among ( "pea", -1, 1 ),
                    new Among ( "aurrea", -1, 1 ),
                    new Among ( "tea", -1, 1 ),
                    new Among ( "kotea", 22, 1 ),
                    new Among ( "artea", 22, 1 ),
                    new Among ( "ostea", 22, 1 ),
                    new Among ( "etxea", -1, 1 ),
                    new Among ( "ga", -1, 1 ),
                    new Among ( "anga", 27, 1 ),
                    new Among ( "gaia", -1, 1 ),
                    new Among ( "aldia", -1, 1 ),
                    new Among ( "taldia", 30, 1 ),
                    new Among ( "handia", -1, 1 ),
                    new Among ( "mendia", -1, 1 ),
                    new Among ( "geia", -1, 1 ),
                    new Among ( "egia", -1, 1 ),
                    new Among ( "degia", 35, 1 ),
                    new Among ( "tegia", 35, 1 ),
                    new Among ( "nahia", -1, 1 ),
                    new Among ( "ohia", -1, 1 ),
                    new Among ( "kia", -1, 1 ),
                    new Among ( "tokia", 40, 1 ),
                    new Among ( "oia", -1, 1 ),
                    new Among ( "koia", 42, 1 ),
                    new Among ( "aria", -1, 1 ),
                    new Among ( "karia", 44, 1 ),
                    new Among ( "laria", 44, 1 ),
                    new Among ( "taria", 44, 1 ),
                    new Among ( "eria", -1, 1 ),
                    new Among ( "keria", 48, 1 ),
                    new Among ( "teria", 48, 1 ),
                    new Among ( "garria", -1, 2 ),
                    new Among ( "larria", -1, 1 ),
                    new Among ( "kirria", -1, 1 ),
                    new Among ( "duria", -1, 1 ),
                    new Among ( "asia", -1, 1 ),
                    new Among ( "tia", -1, 1 ),
                    new Among ( "ezia", -1, 1 ),
                    new Among ( "bizia", -1, 1 ),
                    new Among ( "ontzia", -1, 1 ),
                    new Among ( "ka", -1, 1 ),
                    new Among ( "joka", 60, 3 ),
                    new Among ( "aurka", 60, 10 ),
                    new Among ( "ska", 60, 1 ),
                    new Among ( "xka", 60, 1 ),
                    new Among ( "zka", 60, 1 ),
                    new Among ( "gibela", -1, 1 ),
                    new Among ( "gela", -1, 1 ),
                    new Among ( "kaila", -1, 1 ),
                    new Among ( "skila", -1, 1 ),
                    new Among ( "tila", -1, 1 ),
                    new Among ( "ola", -1, 1 ),
                    new Among ( "na", -1, 1 ),
                    new Among ( "kana", 72, 1 ),
                    new Among ( "ena", 72, 1 ),
                    new Among ( "garrena", 74, 1 ),
                    new Among ( "gerrena", 74, 1 ),
                    new Among ( "urrena", 74, 1 ),
                    new Among ( "zaina", 72, 1 ),
                    new Among ( "tzaina", 78, 1 ),
                    new Among ( "kina", 72, 1 ),
                    new Among ( "mina", 72, 1 ),
                    new Among ( "garna", 72, 1 ),
                    new Among ( "una", 72, 1 ),
                    new Among ( "duna", 83, 1 ),
                    new Among ( "asuna", 83, 1 ),
                    new Among ( "tasuna", 85, 1 ),
                    new Among ( "ondoa", -1, 1 ),
                    new Among ( "kondoa", 87, 1 ),
                    new Among ( "ngoa", -1, 1 ),
                    new Among ( "zioa", -1, 1 ),
                    new Among ( "koa", -1, 1 ),
                    new Among ( "takoa", 91, 1 ),
                    new Among ( "zkoa", 91, 1 ),
                    new Among ( "noa", -1, 1 ),
                    new Among ( "zinoa", 94, 1 ),
                    new Among ( "aroa", -1, 1 ),
                    new Among ( "taroa", 96, 1 ),
                    new Among ( "zaroa", 96, 1 ),
                    new Among ( "eroa", -1, 1 ),
                    new Among ( "oroa", -1, 1 ),
                    new Among ( "osoa", -1, 1 ),
                    new Among ( "toa", -1, 1 ),
                    new Among ( "ttoa", 102, 1 ),
                    new Among ( "ztoa", 102, 1 ),
                    new Among ( "txoa", -1, 1 ),
                    new Among ( "tzoa", -1, 1 ),
                    new Among ( "\u00F1oa", -1, 1 ),
                    new Among ( "ra", -1, 1 ),
                    new Among ( "ara", 108, 1 ),
                    new Among ( "dara", 109, 1 ),
                    new Among ( "liara", 109, 1 ),
                    new Among ( "tiara", 109, 1 ),
                    new Among ( "tara", 109, 1 ),
                    new Among ( "etara", 113, 1 ),
                    new Among ( "tzara", 109, 1 ),
                    new Among ( "bera", 108, 1 ),
                    new Among ( "kera", 108, 1 ),
                    new Among ( "pera", 108, 1 ),
                    new Among ( "ora", 108, 2 ),
                    new Among ( "tzarra", 108, 1 ),
                    new Among ( "korra", 108, 1 ),
                    new Among ( "tra", 108, 1 ),
                    new Among ( "sa", -1, 1 ),
                    new Among ( "osa", 123, 1 ),
                    new Among ( "ta", -1, 1 ),
                    new Among ( "eta", 125, 1 ),
                    new Among ( "keta", 126, 1 ),
                    new Among ( "sta", 125, 1 ),
                    new Among ( "dua", -1, 1 ),
                    new Among ( "mendua", 129, 1 ),
                    new Among ( "ordua", 129, 1 ),
                    new Among ( "lekua", -1, 1 ),
                    new Among ( "burua", -1, 1 ),
                    new Among ( "durua", -1, 1 ),
                    new Among ( "tsua", -1, 1 ),
                    new Among ( "tua", -1, 1 ),
                    new Among ( "mentua", 136, 1 ),
                    new Among ( "estua", 136, 1 ),
                    new Among ( "txua", -1, 1 ),
                    new Among ( "zua", -1, 1 ),
                    new Among ( "tzua", 140, 1 ),
                    new Among ( "za", -1, 1 ),
                    new Among ( "eza", 142, 1 ),
                    new Among ( "eroza", 142, 1 ),
                    new Among ( "tza", 142, 2 ),
                    new Among ( "koitza", 145, 1 ),
                    new Among ( "antza", 145, 1 ),
                    new Among ( "gintza", 145, 1 ),
                    new Among ( "kintza", 145, 1 ),
                    new Among ( "kuntza", 145, 1 ),
                    new Among ( "gabe", -1, 1 ),
                    new Among ( "kabe", -1, 1 ),
                    new Among ( "kide", -1, 1 ),
                    new Among ( "alde", -1, 1 ),
                    new Among ( "kalde", 154, 1 ),
                    new Among ( "talde", 154, 1 ),
                    new Among ( "orde", -1, 1 ),
                    new Among ( "ge", -1, 1 ),
                    new Among ( "zale", -1, 1 ),
                    new Among ( "tzale", 159, 1 ),
                    new Among ( "gile", -1, 1 ),
                    new Among ( "eme", -1, 1 ),
                    new Among ( "kume", -1, 1 ),
                    new Among ( "ne", -1, 1 ),
                    new Among ( "zione", 164, 1 ),
                    new Among ( "une", 164, 1 ),
                    new Among ( "gune", 166, 1 ),
                    new Among ( "pe", -1, 1 ),
                    new Among ( "aurre", -1, 1 ),
                    new Among ( "te", -1, 1 ),
                    new Among ( "kote", 170, 1 ),
                    new Among ( "arte", 170, 1 ),
                    new Among ( "oste", 170, 1 ),
                    new Among ( "etxe", -1, 1 ),
                    new Among ( "gai", -1, 1 ),
                    new Among ( "di", -1, 1 ),
                    new Among ( "aldi", 176, 1 ),
                    new Among ( "taldi", 177, 1 ),
                    new Among ( "geldi", 176, 8 ),
                    new Among ( "handi", 176, 1 ),
                    new Among ( "mendi", 176, 1 ),
                    new Among ( "gei", -1, 1 ),
                    new Among ( "egi", -1, 1 ),
                    new Among ( "degi", 183, 1 ),
                    new Among ( "tegi", 183, 1 ),
                    new Among ( "nahi", -1, 1 ),
                    new Among ( "ohi", -1, 1 ),
                    new Among ( "ki", -1, 1 ),
                    new Among ( "toki", 188, 1 ),
                    new Among ( "oi", -1, 1 ),
                    new Among ( "goi", 190, 1 ),
                    new Among ( "koi", 190, 1 ),
                    new Among ( "ari", -1, 1 ),
                    new Among ( "kari", 193, 1 ),
                    new Among ( "lari", 193, 1 ),
                    new Among ( "tari", 193, 1 ),
                    new Among ( "garri", -1, 2 ),
                    new Among ( "larri", -1, 1 ),
                    new Among ( "kirri", -1, 1 ),
                    new Among ( "duri", -1, 1 ),
                    new Among ( "asi", -1, 1 ),
                    new Among ( "ti", -1, 1 ),
                    new Among ( "ontzi", -1, 1 ),
                    new Among ( "\u00F1i", -1, 1 ),
                    new Among ( "ak", -1, 1 ),
                    new Among ( "ek", -1, 1 ),
                    new Among ( "tarik", -1, 1 ),
                    new Among ( "gibel", -1, 1 ),
                    new Among ( "ail", -1, 1 ),
                    new Among ( "kail", 209, 1 ),
                    new Among ( "kan", -1, 1 ),
                    new Among ( "tan", -1, 1 ),
                    new Among ( "etan", 212, 1 ),
                    new Among ( "en", -1, 4 ),
                    new Among ( "ren", 214, 2 ),
                    new Among ( "garren", 215, 1 ),
                    new Among ( "gerren", 215, 1 ),
                    new Among ( "urren", 215, 1 ),
                    new Among ( "ten", 214, 4 ),
                    new Among ( "tzen", 214, 4 ),
                    new Among ( "zain", -1, 1 ),
                    new Among ( "tzain", 221, 1 ),
                    new Among ( "kin", -1, 1 ),
                    new Among ( "min", -1, 1 ),
                    new Among ( "dun", -1, 1 ),
                    new Among ( "asun", -1, 1 ),
                    new Among ( "tasun", 226, 1 ),
                    new Among ( "aizun", -1, 1 ),
                    new Among ( "ondo", -1, 1 ),
                    new Among ( "kondo", 229, 1 ),
                    new Among ( "go", -1, 1 ),
                    new Among ( "ngo", 231, 1 ),
                    new Among ( "zio", -1, 1 ),
                    new Among ( "ko", -1, 1 ),
                    new Among ( "trako", 234, 5 ),
                    new Among ( "tako", 234, 1 ),
                    new Among ( "etako", 236, 1 ),
                    new Among ( "eko", 234, 1 ),
                    new Among ( "tariko", 234, 1 ),
                    new Among ( "sko", 234, 1 ),
                    new Among ( "tuko", 234, 1 ),
                    new Among ( "minutuko", 241, 6 ),
                    new Among ( "zko", 234, 1 ),
                    new Among ( "no", -1, 1 ),
                    new Among ( "zino", 244, 1 ),
                    new Among ( "ro", -1, 1 ),
                    new Among ( "aro", 246, 1 ),
                    new Among ( "igaro", 247, 9 ),
                    new Among ( "taro", 247, 1 ),
                    new Among ( "zaro", 247, 1 ),
                    new Among ( "ero", 246, 1 ),
                    new Among ( "giro", 246, 1 ),
                    new Among ( "oro", 246, 1 ),
                    new Among ( "oso", -1, 1 ),
                    new Among ( "to", -1, 1 ),
                    new Among ( "tto", 255, 1 ),
                    new Among ( "zto", 255, 1 ),
                    new Among ( "txo", -1, 1 ),
                    new Among ( "tzo", -1, 1 ),
                    new Among ( "gintzo", 259, 1 ),
                    new Among ( "\u00F1o", -1, 1 ),
                    new Among ( "zp", -1, 1 ),
                    new Among ( "ar", -1, 1 ),
                    new Among ( "dar", 263, 1 ),
                    new Among ( "behar", 263, 1 ),
                    new Among ( "zehar", 263, 7 ),
                    new Among ( "liar", 263, 1 ),
                    new Among ( "tiar", 263, 1 ),
                    new Among ( "tar", 263, 1 ),
                    new Among ( "tzar", 263, 1 ),
                    new Among ( "or", -1, 2 ),
                    new Among ( "kor", 271, 1 ),
                    new Among ( "os", -1, 1 ),
                    new Among ( "ket", -1, 1 ),
                    new Among ( "du", -1, 1 ),
                    new Among ( "mendu", 275, 1 ),
                    new Among ( "ordu", 275, 1 ),
                    new Among ( "leku", -1, 1 ),
                    new Among ( "buru", -1, 2 ),
                    new Among ( "duru", -1, 1 ),
                    new Among ( "tsu", -1, 1 ),
                    new Among ( "tu", -1, 1 ),
                    new Among ( "tatu", 282, 4 ),
                    new Among ( "mentu", 282, 1 ),
                    new Among ( "estu", 282, 1 ),
                    new Among ( "txu", -1, 1 ),
                    new Among ( "zu", -1, 1 ),
                    new Among ( "tzu", 287, 1 ),
                    new Among ( "gintzu", 288, 1 ),
                    new Among ( "z", -1, 1 ),
                    new Among ( "ez", 290, 1 ),
                    new Among ( "eroz", 290, 1 ),
                    new Among ( "tz", 290, 1 ),
                    new Among ( "koitz", 293, 1 )
                };

        private readonly static Among[] a_2 = {
                    new Among ( "zlea", -1, 2 ),
                    new Among ( "keria", -1, 1 ),
                    new Among ( "la", -1, 1 ),
                    new Among ( "era", -1, 1 ),
                    new Among ( "dade", -1, 1 ),
                    new Among ( "tade", -1, 1 ),
                    new Among ( "date", -1, 1 ),
                    new Among ( "tate", -1, 1 ),
                    new Among ( "gi", -1, 1 ),
                    new Among ( "ki", -1, 1 ),
                    new Among ( "ik", -1, 1 ),
                    new Among ( "lanik", 10, 1 ),
                    new Among ( "rik", 10, 1 ),
                    new Among ( "larik", 12, 1 ),
                    new Among ( "ztik", 10, 1 ),
                    new Among ( "go", -1, 1 ),
                    new Among ( "ro", -1, 1 ),
                    new Among ( "ero", 16, 1 ),
                    new Among ( "to", -1, 1 )
                };

        private static readonly char[] g_v = { (char)17, (char)65, (char)16 };

        private int I_p2;
        private int I_p1;
        private int I_pV;

        private void copy_from(BasqueStemmer other)
        {
            I_p2 = other.I_p2;
            I_p1 = other.I_p1;
            I_pV = other.I_pV;
            base.CopyFrom(other);
        }

        private bool r_mark_regions()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_6;
            int v_8;
            // (, line 25
            I_pV = m_limit;
            I_p1 = m_limit;
            I_p2 = m_limit;
            // do, line 31
            v_1 = m_cursor;

            do
            {
                // (, line 31
                // or, line 33

                do
                {
                    v_2 = m_cursor;

                    do
                    {
                        // (, line 32
                        if (!(InGrouping(g_v, 97, 117)))
                        {
                            goto lab2;
                        }
                        // or, line 32

                        do
                        {
                            v_3 = m_cursor;

                            do
                            {
                                // (, line 32
                                if (!(OutGrouping(g_v, 97, 117)))
                                {
                                    goto lab4;
                                }
                                // gopast, line 32

                                while (true)
                                {

                                    do
                                    {
                                        if (!(InGrouping(g_v, 97, 117)))
                                        {
                                            goto lab6;
                                        }
                                        goto golab5;
                                    } while (false);
                                    lab6:
                                    if (m_cursor >= m_limit)
                                    {
                                        goto lab4;
                                    }
                                    m_cursor++;
                                }
                                golab5:
                                goto lab3;
                            } while (false);
                            lab4:
                            m_cursor = v_3;
                            // (, line 32
                            if (!(InGrouping(g_v, 97, 117)))
                            {
                                goto lab2;
                            }
                            // gopast, line 32

                            while (true)
                            {

                                do
                                {
                                    if (!(OutGrouping(g_v, 97, 117)))
                                    {
                                        goto lab8;
                                    }
                                    goto golab7;
                                } while (false);
                                lab8:
                                if (m_cursor >= m_limit)
                                {
                                    goto lab2;
                                }
                                m_cursor++;
                            }
                            golab7: {/* LUCENENET: intentionally blank */}
                        } while (false);
                        lab3:
                        goto lab1;
                    } while (false);
                    lab2:
                    m_cursor = v_2;
                    // (, line 34
                    if (!(OutGrouping(g_v, 97, 117)))
                    {
                        goto lab0;
                    }
                    // or, line 34

                    do
                    {
                        v_6 = m_cursor;

                        do
                        {
                            // (, line 34
                            if (!(OutGrouping(g_v, 97, 117)))
                            {
                                goto lab10;
                            }
                            // gopast, line 34

                            while (true)
                            {

                                do
                                {
                                    if (!(InGrouping(g_v, 97, 117)))
                                    {
                                        goto lab12;
                                    }
                                    goto golab11;
                                } while (false);
                                lab12:
                                if (m_cursor >= m_limit)
                                {
                                    goto lab10;
                                }
                                m_cursor++;
                            }
                            golab11:
                            goto lab9;
                        } while (false);
                        lab10:
                        m_cursor = v_6;
                        // (, line 34
                        if (!(InGrouping(g_v, 97, 117)))
                        {
                            goto lab0;
                        }
                        // next, line 34
                        if (m_cursor >= m_limit)
                        {
                            goto lab0;
                        }
                        m_cursor++;
                    } while (false);
                    lab9: {/* LUCENENET: intentionally blank */}
                } while (false);
                lab1:
                // setmark pV, line 35
                I_pV = m_cursor;
            } while (false);
            lab0:
            m_cursor = v_1;
            // do, line 37
            v_8 = m_cursor;

            do
            {
                // (, line 37
                // gopast, line 38

                while (true)
                {

                    do
                    {
                        if (!(InGrouping(g_v, 97, 117)))
                        {
                            goto lab15;
                        }
                        goto golab14;
                    } while (false);
                    lab15:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab14:
                // gopast, line 38

                while (true)
                {

                    do
                    {
                        if (!(OutGrouping(g_v, 97, 117)))
                        {
                            goto lab17;
                        }
                        goto golab16;
                    } while (false);
                    lab17:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab16:
                // setmark p1, line 38
                I_p1 = m_cursor;
                // gopast, line 39

                while (true)
                {

                    do
                    {
                        if (!(InGrouping(g_v, 97, 117)))
                        {
                            goto lab19;
                        }
                        goto golab18;
                    } while (false);
                    lab19:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab18:
                // gopast, line 39

                while (true)
                {

                    do
                    {
                        if (!(OutGrouping(g_v, 97, 117)))
                        {
                            goto lab21;
                        }
                        goto golab20;
                    } while (false);
                    lab21:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab20:
                // setmark p2, line 39
                I_p2 = m_cursor;
            } while (false);
            lab13:
            m_cursor = v_8;
            return true;
        }

        private bool r_RV()
        {
            if (!(I_pV <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R2()
        {
            if (!(I_p2 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R1()
        {
            if (!(I_p1 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_aditzak()
        {
            int among_var;
            // (, line 49
            // [, line 50
            m_ket = m_cursor;
            // substring, line 50
            among_var = FindAmongB(a_0, 109);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 50
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 61
                    // call RV, line 61
                    if (!r_RV())
                    {
                        return false;
                    }
                    // delete, line 61
                    SliceDel();
                    break;
                case 2:
                    // (, line 63
                    // call R2, line 63
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 63
                    SliceDel();
                    break;
                case 3:
                    // (, line 65
                    // <-, line 65
                    SliceFrom("atseden");
                    break;
                case 4:
                    // (, line 67
                    // <-, line 67
                    SliceFrom("arabera");
                    break;
                case 5:
                    // (, line 69
                    // <-, line 69
                    SliceFrom("baditu");
                    break;
            }
            return true;
        }

        private bool r_izenak()
        {
            int among_var;
            // (, line 74
            // [, line 75
            m_ket = m_cursor;
            // substring, line 75
            among_var = FindAmongB(a_1, 295);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 75
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 105
                    // call RV, line 105
                    if (!r_RV())
                    {
                        return false;
                    }
                    // delete, line 105
                    SliceDel();
                    break;
                case 2:
                    // (, line 107
                    // call R2, line 107
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 107
                    SliceDel();
                    break;
                case 3:
                    // (, line 109
                    // <-, line 109
                    SliceFrom("jok");
                    break;
                case 4:
                    // (, line 111
                    // call R1, line 111
                    if (!r_R1())
                    {
                        return false;
                    }
                    // delete, line 111
                    SliceDel();
                    break;
                case 5:
                    // (, line 113
                    // <-, line 113
                    SliceFrom("tra");
                    break;
                case 6:
                    // (, line 115
                    // <-, line 115
                    SliceFrom("minutu");
                    break;
                case 7:
                    // (, line 117
                    // <-, line 117
                    SliceFrom("zehar");
                    break;
                case 8:
                    // (, line 119
                    // <-, line 119
                    SliceFrom("geldi");
                    break;
                case 9:
                    // (, line 121
                    // <-, line 121
                    SliceFrom("igaro");
                    break;
                case 10:
                    // (, line 123
                    // <-, line 123
                    SliceFrom("aurka");
                    break;
            }
            return true;
        }

        private bool r_adjetiboak()
        {
            int among_var;
            // (, line 127
            // [, line 128
            m_ket = m_cursor;
            // substring, line 128
            among_var = FindAmongB(a_2, 19);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 128
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 131
                    // call RV, line 131
                    if (!r_RV())
                    {
                        return false;
                    }
                    // delete, line 131
                    SliceDel();
                    break;
                case 2:
                    // (, line 133
                    // <-, line 133
                    SliceFrom("z");
                    break;
            }
            return true;
        }


        public override bool Stem()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            // (, line 139
            // do, line 140
            v_1 = m_cursor;

            do
            {
                // call mark_regions, line 140
                if (!r_mark_regions())
                {
                    goto lab0;
                }
            } while (false);
            lab0:
            m_cursor = v_1;
            // backwards, line 141
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // (, line 141
            // repeat, line 142

            while (true)
            {
                v_2 = m_limit - m_cursor;

                do
                {
                    // call aditzak, line 142
                    if (!r_aditzak())
                    {
                        goto lab2;
                    }
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab1;

                    goto end_of_outer_loop;

                } while (false);
                lab2:
                m_cursor = m_limit - v_2;
                goto replab1;
                end_of_outer_loop: { }
            }
            replab1:
            // repeat, line 143

            while (true)
            {
                v_3 = m_limit - m_cursor;

                do
                {
                    // call izenak, line 143
                    if (!r_izenak())
                    {
                        goto lab4;
                    }
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab3;

                    goto end_of_outer_loop_2;

                } while (false);
                lab4:
                m_cursor = m_limit - v_3;
                goto replab3;
                end_of_outer_loop_2: { }
            }
            replab3:
            // do, line 144
            v_4 = m_limit - m_cursor;

            do
            {
                // call adjetiboak, line 144
                if (!r_adjetiboak())
                {
                    goto lab5;
                }
            } while (false);
            lab5:
            m_cursor = m_limit - v_4;
            m_cursor = m_limit_backward; return true;
        }


        public override bool Equals(object o)
        {
            return o is BasqueStemmer;
        }

        public override int GetHashCode()
        {
            return this.GetType().FullName.GetHashCode();
        }
    }
}