// ---------- Attention: Generated code, please do not modify! -----------

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.component;

import jakarta.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUILink;
import org.apache.myfaces.tobago.renderkit.css.CustomClass;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.component.Tags;
import jakarta.annotation.Generated;
import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;

/**
 Renders a link element, i. e. an anchor &lt;a&gt; tag.
  For a &lt;link&gt; tag, please use &lt;tc:metaLink&gt; tag.
  * UIComponent class, generated from template {@code component.stg} with class
  * {@link org.apache.myfaces.tobago.internal.taglib.component.LinkTagDeclaration}.
 */
@Generated("component.stg")
public class UILink
    extends AbstractUILink implements SupportsAccessKey {

  private static final Tags TAG = Tags.link;

  public static final String COMPONENT_TYPE = TAG.componentType();

  public static final String COMPONENT_FAMILY = "jakarta.faces.Command";

  private static final Collection<String> EVENT_NAMES = Arrays.asList("click", "dblclick", "focus", "blur");

  @Override
  public Collection<String> getEventNames() {
    return EVENT_NAMES;
  }

  @Override
  public String getDefaultEventName() {
    return "click";
  }


  enum PropertyKeys {
    image,
    markup,
    link,
    tabIndex,
    confirmation,
    label,
    transition,
    target,
    fragment,
    autoSpacing,
    accessKey,
    customClass,
    tip,
    omit,
    outcome,
  }

  public String getFamily() {
    return COMPONENT_FAMILY;
  }


  /**
  Url to an image to display.

  */
  public java.lang.String getImage() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.image);
  }

  public void setImage(java.lang.String image) {
    getStateHelper().put(PropertyKeys.image, image);
  }

  public org.apache.myfaces.tobago.context.Markup getMarkup() {
    Object object = getStateHelper().eval(PropertyKeys.markup);
    if (object != null) {
      return Markup.valueOf(object);
    }
    return null;
  }

  public void setMarkup(org.apache.myfaces.tobago.context.Markup markup) {
    getStateHelper().put(PropertyKeys.markup, markup);
  }

  /**
  <p>
   Link to an arbitrary URL, either an internal link or an external link. For internal URLs, a session id will be
   added, if needed (when cookies disabled). The context path needs to be added manually e.g. #{request.contextPath}.
   For JSF navigation to a viewId use the outcome attribute!
   </p>

   <p>
   The semantic of this attributes has been changed from Tobago 3 to 4!
   </p>

  */
  public java.lang.String getLink() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.link);
  }

  public void setLink(java.lang.String link) {
    getStateHelper().put(PropertyKeys.link, link);
  }

  /**
  Controls the navigation of the focus through the
   input controls on a page with the Tab-Key.
   The navigation starts from the element with
   the lowest tabIndex value to the element with the highest value.
   Elements that have identical tabIndex values should be navigated
   in the order they appear in the character stream
   Elements that are disabled or with a negative tabIndex
   do not participate in the tabbing order.

  */
  public java.lang.Integer getTabIndex() {
    Number value  = (Number) getStateHelper().eval(PropertyKeys.tabIndex);
    if (value != null) {
      return value.intValue();
    }
    return null;
  }

  public void setTabIndex(java.lang.Integer tabIndex) {
    getStateHelper().put(PropertyKeys.tabIndex, tabIndex);
  }

  /**
  Text to use as confirmation message.

  */
  public java.lang.String getConfirmation() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.confirmation);
  }

  public void setConfirmation(java.lang.String confirmation) {
    getStateHelper().put(PropertyKeys.confirmation, confirmation);
  }

  /**
  A localized user presentable label for this component.

  */
  public java.lang.String getLabel() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.label);
  }

  public void setLabel(java.lang.String label) {
    getStateHelper().put(PropertyKeys.label, label);
  }

  /**
  Specify, if the command calls an JSF-Action.
   Useful to switch off the Double-Submit-Check and Waiting-Behavior.
  <br>Default: <code>true</code>
  */
  public boolean isTransition() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.transition);
    if (bool != null) {
      return bool;
    }
    return true;
  }

  public void setTransition(boolean transition) {
    getStateHelper().put(PropertyKeys.transition, transition);
  }

  /**
  Name of a frame where the resource retrieved via this hyperlink is to be
   displayed.

  */
  public java.lang.String getTarget() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.target);
  }

  public void setTarget(java.lang.String target) {
    getStateHelper().put(PropertyKeys.target, target);
  }

  /**
  The identifier of the page fragment which should
   be brought into focus when the target page is
   rendered. The value of this attribute is appended
   to the end of target URL following a hash (#) mark.
   This notation is part of the standard URL syntax.

  */
  public java.lang.String getFragment() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.fragment);
  }

  public void setFragment(java.lang.String fragment) {
    getStateHelper().put(PropertyKeys.fragment, fragment);
  }

  /**
  Automatically add spacing (margins/paddings) to the component for better positioning.
   Default is 'true' except the component is inside a:
   - header
   - footer
   - bar
   - sheet
   - tree
   - link group
   - button group
   - before facet
   - after facet
   - label facet
   - bar facet

  */
  public Boolean getAutoSpacing() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.autoSpacing);
    if (bool != null) {
      return bool;
    }
    return null;
  }

  public void setAutoSpacing(Boolean autoSpacing) {
    getStateHelper().put(PropertyKeys.autoSpacing, autoSpacing);
  }

  /**
  The access key of this control.

  */
  public java.lang.Character getAccessKey() {
    return (java.lang.Character) getStateHelper().eval(PropertyKeys.accessKey);
  }

  public void setAccessKey(java.lang.Character accessKey) {
    getStateHelper().put(PropertyKeys.accessKey, accessKey);
  }

  /**
  Sets a CSS class in its parent, if the parent supports it.

   Which this feature it is possible to put a CSS class name into a component with the &lt;tc:style&gt; tag. Example:

   <pre>
   &lt;tc:in&gt;
     &lt;tc:style customClass="my-emphasized"/&gt;
   &lt;/tc:in&gt;
   </pre>

   One capability is, to used external CSS libs.
   <br>
   This feature should not be used imprudent.
   Because it might be unstable against changes in the renderered HTML code.

  */
  public org.apache.myfaces.tobago.renderkit.css.CustomClass getCustomClass() {
    return (org.apache.myfaces.tobago.renderkit.css.CustomClass) getStateHelper().eval(PropertyKeys.customClass);
  }

  public void setCustomClass(org.apache.myfaces.tobago.renderkit.css.CustomClass customClass) {
    getStateHelper().put(PropertyKeys.customClass, customClass);
  }

  /**
  Text value to display as tooltip.

  */
  public java.lang.String getTip() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.tip);
  }

  public void setTip(java.lang.String tip) {
    getStateHelper().put(PropertyKeys.tip, tip);
  }

  /**
  Flag indicating that the action of this element, will not be executed from client side
   (e.g. when the user clicks a button.
   When setting this value to true, the action will not be executed by the Tobago, but it can executed
   by JavaScript.
   This attribute is useful, when you want to add JavaScript event handlers to commands manually.
   In this case you usually don't want a submit with a full reload of the page.
  <br>Default: <code>false</code>
  */
  public boolean isOmit() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.omit);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setOmit(boolean omit) {
    getStateHelper().put(PropertyKeys.omit, omit);
  }

  /**
  Link to an internal facelet page, like the outcome of an action.
   The context path will be added.
   A session id will be added, if needed.

  */
  public java.lang.String getOutcome() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.outcome);
  }

  public void setOutcome(java.lang.String outcome) {
    getStateHelper().put(PropertyKeys.outcome, outcome);
  }


  @Override
  public void restoreState(FacesContext context, Object state) {
    // FIXME HACK for mojarra SystemEventListener state restoring bug
    pushComponentToEL(context, this);
    super.restoreState(context, state);
    popComponentFromEL(context);
  }

}