/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.xml;

import com.github.caldav4j.exceptions.DOMValidationException;
import com.github.caldav4j.xml.OutputsDOM;
import java.util.Collection;
import java.util.Map;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class OutputsDOMBase
implements OutputsDOM {
    private static final Logger log = LoggerFactory.getLogger(OutputsDOMBase.class);

    protected abstract String getElementName();

    protected abstract Namespace getNamespace();

    protected String getNamespaceURI() {
        return this.getNamespace().getURI();
    }

    protected String getNamespaceQualifier() {
        return this.getNamespace().getPrefix();
    }

    protected abstract Collection<? extends XmlSerializable> getChildren();

    protected abstract Map<String, String> getAttributes();

    protected abstract String getTextContent();

    @Override
    public void validate() throws DOMValidationException {
    }

    public String getQualifiedName() {
        return this.getNamespaceQualifier() + ":" + this.getElementName();
    }

    @Override
    public Document createNewDocument() throws DOMValidationException {
        try {
            this.validate();
            Document d = DomUtil.createDocument();
            Element root = this.toXml(d);
            d.appendChild(root);
            return d;
        }
        catch (Exception e) {
            log.error("Error creating Document.");
            throw new DOMValidationException("Error creating Document.");
        }
    }

    public Element toXml(Document document) {
        Element root = null;
        try {
            this.validate();
            root = DomUtil.createElement((Document)document, (String)this.getElementName(), (Namespace)this.getNamespace());
            this.fillElement(root, document);
        }
        catch (DOMValidationException e) {
            log.error("Error creating element. Validation failed.");
            e.printStackTrace();
        }
        return root;
    }

    protected void fillElement(Element e, Document document) {
        Map<String, String> attributes;
        Collection<? extends XmlSerializable> children = this.getChildren();
        if (children != null && !children.isEmpty()) {
            for (XmlSerializable xmlSerializable : children) {
                Element childNode = xmlSerializable.toXml(document);
                e.appendChild(childNode);
            }
        }
        if (this.getTextContent() != null) {
            e.setTextContent(this.getTextContent());
        }
        if ((attributes = this.getAttributes()) != null && !attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                e.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void validate(Collection<? extends OutputsDOM> c) throws DOMValidationException {
        for (OutputsDOM outputsDOM : c) {
            outputsDOM.validate();
        }
    }

    protected void throwValidationException(String m) throws DOMValidationException {
        String message = this.getQualifiedName() + " - " + m;
        throw new DOMValidationException(message);
    }
}

