/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util.crypt;

import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.crypt.ICrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptProvider {
    private static final Logger log = LoggerFactory.getLogger(CryptProvider.class);
    private static ICrypt crypt;

    private CryptProvider() {
    }

    public static synchronized ICrypt get() {
        if (crypt == null) {
            String clazz = OpenmeetingsVariables.getCryptClassName();
            try {
                log.debug("get:: configKeyCryptClassName: {}", (Object)clazz);
                crypt = clazz == null ? null : (ICrypt)Class.forName(clazz).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception err) {
                log.error("[get]", (Throwable)err);
            }
        }
        return crypt;
    }

    public static synchronized void reset() {
        crypt = null;
    }
}

