/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.client.impl.protocol.util.PropertiesUtil;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.Beta;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Beta
public class DataConnectionConfig
implements IdentifiedDataSerializable,
NamedConfig {
    private String name;
    private String type;
    private boolean shared = true;
    private Properties properties;

    public DataConnectionConfig() {
        this.properties = new Properties();
    }

    public DataConnectionConfig(DataConnectionConfig config) {
        this.name = config.name;
        this.type = config.type;
        this.shared = config.shared;
        this.properties = PropertiesUtil.clone(config.getProperties());
    }

    public DataConnectionConfig(String name) {
        this();
        this.name = Preconditions.checkNotNull(name, "Name must not be null");
    }

    @Override
    public DataConnectionConfig setName(String name) {
        this.name = Preconditions.checkHasText(name, "Data connection name must contain text");
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public DataConnectionConfig setType(@Nonnull String type) {
        this.type = Preconditions.checkHasText(type, "Data connection type must contain text");
        return this;
    }

    public boolean isShared() {
        return this.shared;
    }

    public DataConnectionConfig setShared(boolean shared) {
        this.shared = shared;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Nullable
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Nullable
    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public DataConnectionConfig setProperty(String key, String value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public DataConnectionConfig setProperties(Properties properties) {
        this.properties = Preconditions.checkNotNull(properties, "Data connection properties cannot be null, they can be empty");
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataConnectionConfig that = (DataConnectionConfig)o;
        return this.shared == that.shared && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.shared, this.properties);
    }

    public String toString() {
        return "DataConnectionConfig{name='" + this.name + "', type='" + this.type + "', shared=" + this.shared + ", properties=" + this.properties + "}";
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeBoolean(this.shared);
        out.writeInt(this.properties.size());
        for (String key : this.properties.stringPropertyNames()) {
            out.writeString(key);
            out.writeString(this.properties.getProperty(key));
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.type = in.readString();
        this.shared = in.readBoolean();
        int propertiesSize = in.readInt();
        for (int i = 0; i < propertiesSize; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.properties.setProperty(key, value);
        }
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 68;
    }
}

