/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.iteration;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

public class IterationResult<T> {
    private final List<T> page;
    private final UUID cursorId;
    private final UUID cursorIdToForget;

    public IterationResult(List<T> page, UUID cursorId, @Nullable UUID cursorIdToForget) {
        this.page = page;
        this.cursorId = cursorId;
        this.cursorIdToForget = cursorIdToForget;
    }

    public List<T> getPage() {
        return this.page;
    }

    public UUID getCursorId() {
        return this.cursorId;
    }

    public UUID getCursorIdToForget() {
        return this.cursorIdToForget;
    }

    public boolean isEmpty() {
        return this.page.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IterationResult that = (IterationResult)o;
        return Objects.equals(this.page, that.page) && Objects.equals(this.cursorId, that.cursorId);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.cursorId);
    }
}

