/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.metricsets;

import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.util.Preconditions;
import java.io.File;

public final class FileMetricSet {
    private FileMetricSet() {
    }

    public static void register(MetricsRegistry metricsRegistry) {
        Preconditions.checkNotNull(metricsRegistry, "metricsRegistry");
        File file = new File(System.getProperty("user.home"));
        MetricDescriptor descriptor = metricsRegistry.newMetricDescriptor().withPrefix("file.partition").withDiscriminator("dir", "user.home");
        metricsRegistry.registerStaticProbe(file, descriptor, "freeSpace", ProbeLevel.MANDATORY, ProbeUnit.BYTES, File::getFreeSpace);
        metricsRegistry.registerStaticProbe(file, descriptor, "totalSpace", ProbeLevel.MANDATORY, ProbeUnit.BYTES, File::getTotalSpace);
        metricsRegistry.registerStaticProbe(file, descriptor, "usableSpace", ProbeLevel.MANDATORY, ProbeUnit.BYTES, File::getUsableSpace);
    }
}

