/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.internal.tpcengine.Option;
import com.hazelcast.internal.tpcengine.net.AsyncSocket;
import com.hazelcast.internal.tpcengine.net.AsyncSocketBuilder;
import com.hazelcast.internal.tpcengine.net.AsyncSocketOptions;
import com.hazelcast.internal.tpcengine.net.AsyncSocketReader;
import com.hazelcast.internal.tpcengine.net.AsyncSocketWriter;
import com.hazelcast.internal.tpcengine.nio.NioAcceptRequest;
import com.hazelcast.internal.tpcengine.nio.NioAsyncSocket;
import com.hazelcast.internal.tpcengine.nio.NioAsyncSocketOptions;
import com.hazelcast.internal.tpcengine.nio.NioReactor;
import com.hazelcast.internal.tpcengine.util.ExceptionUtil;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;

public class NioAsyncSocketBuilder
implements AsyncSocketBuilder {
    static final int DEFAULT_WRITE_QUEUE_CAPACITY = 131072;
    private static final Constructor<AsyncSocket> TLS_NIO_ASYNC_SOCKET_CONSTRUCTOR;
    private static final String TLS_NIO_ASYNC_SOCKET_CLASS_NAME = "com.hazelcast.internal.tpcengine.nio.TlsNioAsyncSocket";
    final NioReactor reactor;
    final SocketChannel socketChannel;
    final NioAcceptRequest acceptRequest;
    final boolean clientSide;
    boolean directBuffers = true;
    int writeQueueCapacity = 131072;
    AsyncSocketReader reader;
    AsyncSocketWriter writer;
    NioAsyncSocketOptions options;
    private boolean built;

    NioAsyncSocketBuilder(NioReactor reactor, NioAcceptRequest acceptRequest) {
        try {
            this.reactor = reactor;
            this.acceptRequest = acceptRequest;
            if (acceptRequest == null) {
                this.socketChannel = SocketChannel.open();
                this.clientSide = true;
            } else {
                this.socketChannel = acceptRequest.socketChannel;
                this.clientSide = false;
            }
            this.socketChannel.configureBlocking(false);
            this.options = new NioAsyncSocketOptions(this.socketChannel);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public <T> NioAsyncSocketBuilder set(Option<T> option, T value) {
        this.verifyNotBuilt();
        this.options.set(option, value);
        return this;
    }

    @Override
    public <T> boolean setIfSupported(Option<T> option, T value) {
        this.verifyNotBuilt();
        return this.options.set(option, value);
    }

    public NioAsyncSocketBuilder setDirectBuffers(boolean directBuffers) {
        this.verifyNotBuilt();
        this.directBuffers = directBuffers;
        return this;
    }

    public NioAsyncSocketBuilder setWriteQueueCapacity(int writeQueueCapacity) {
        this.verifyNotBuilt();
        this.writeQueueCapacity = Preconditions.checkPositive(writeQueueCapacity, "writeQueueCapacity");
        return this;
    }

    @Override
    public final NioAsyncSocketBuilder setReader(AsyncSocketReader reader) {
        this.verifyNotBuilt();
        this.reader = Preconditions.checkNotNull(reader);
        return this;
    }

    @Override
    public AsyncSocketBuilder setWriter(AsyncSocketWriter writer) {
        this.verifyNotBuilt();
        this.writer = Preconditions.checkNotNull(writer);
        return this;
    }

    @Override
    public AsyncSocket build() {
        this.verifyNotBuilt();
        this.built = true;
        if (this.reader == null) {
            throw new IllegalStateException("reader is not configured.");
        }
        if (Thread.currentThread() == this.reactor.eventloopThread()) {
            return this.options.get(AsyncSocketOptions.SSL_ENGINE_FACTORY) == null ? new NioAsyncSocket(this) : this.newTlsNioAsyncSocket(this);
        }
        CompletableFuture future = new CompletableFuture();
        this.reactor.execute(() -> {
            try {
                AsyncSocket asyncSocket = this.options.get(AsyncSocketOptions.SSL_ENGINE_FACTORY) == null ? new NioAsyncSocket(this) : this.newTlsNioAsyncSocket(this);
                future.complete(asyncSocket);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
                throw ExceptionUtil.sneakyThrow(e);
            }
        });
        return (AsyncSocket)future.join();
    }

    private AsyncSocket newTlsNioAsyncSocket(NioAsyncSocketBuilder nioAsyncSocketBuilder) {
        if (TLS_NIO_ASYNC_SOCKET_CONSTRUCTOR == null) {
            throw new IllegalStateException("class com.hazelcast.internal.tpcengine.nio.TlsNioAsyncSocket is not found");
        }
        try {
            return TLS_NIO_ASYNC_SOCKET_CONSTRUCTOR.newInstance(nioAsyncSocketBuilder);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void verifyNotBuilt() {
        if (this.built) {
            throw new IllegalStateException("Can't call build twice on the same AsyncSocketBuilder");
        }
    }

    static {
        Constructor<?> tlsNioAsyncSocketConstructor = null;
        try {
            Class<?> clazz = NioAsyncSocketBuilder.class.getClassLoader().loadClass(TLS_NIO_ASYNC_SOCKET_CLASS_NAME);
            tlsNioAsyncSocketConstructor = clazz.getDeclaredConstructor(NioAsyncSocketBuilder.class);
            tlsNioAsyncSocketConstructor.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            tlsNioAsyncSocketConstructor = null;
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        finally {
            TLS_NIO_ASYNC_SOCKET_CONSTRUCTOR = tlsNioAsyncSocketConstructor;
        }
    }
}

