/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.cluster.Address;
import com.hazelcast.collection.IList;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BinaryOperatorEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.AbstractHazelcastConnectorSupplier;
import com.hazelcast.jet.impl.connector.MapSinkConfiguration;
import com.hazelcast.jet.impl.connector.MapSinkEntryProcessorConfiguration;
import com.hazelcast.jet.impl.connector.ProcessorFunctionConnectorSupplier;
import com.hazelcast.jet.impl.connector.WriteBufferedP;
import com.hazelcast.jet.impl.connector.WriteMapP;
import com.hazelcast.jet.impl.connector.WriteObservableP;
import com.hazelcast.jet.impl.observer.ObservableImpl;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.security.PermissionsUtil;
import com.hazelcast.security.impl.function.SecuredFunctions;
import com.hazelcast.security.permission.RingBufferPermission;
import java.security.Permission;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class HazelcastWriters {
    private HazelcastWriters() {
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier writeMapSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn) {
        MapSinkConfiguration<Object, ? extends K, ? extends V> params = new MapSinkConfiguration<Object, K, V>(name);
        params.setClientXml(ImdgUtil.asXmlString(clientConfig));
        params.setToKeyFn(toKeyFn);
        params.setToValueFn(toValueFn);
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        params.setClientXml(clientXml);
        return HazelcastWriters.writeMapSupplier(params);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier writeMapSupplier(MapSinkConfiguration<T, K, V> sinkConfig) {
        WriteMapP.Supplier<T, K, V> supplier = WriteMapP.Supplier.createNew(sinkConfig);
        if (sinkConfig.isRemote()) {
            return ProcessorMetaSupplier.preferLocalParallelismOne(supplier);
        }
        Permission processorMetaSupplierPermission = PermissionsUtil.mapPutPermission(sinkConfig.getMapName());
        return ProcessorMetaSupplier.preferLocalParallelismOne(processorMetaSupplierPermission, supplier);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier mergeMapSupplier(MapSinkConfiguration<T, K, V> sinkConfig) {
        FunctionEx<T, K> toKeyFn = sinkConfig.getToKeyFn();
        FunctionEx toValueFn = sinkConfig.getToValueFn();
        BinaryOperatorEx mergeFn = sinkConfig.getMergeFn();
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(toValueFn, "toValueFn");
        Util.checkSerializable(mergeFn, "mergeFn");
        boolean isRemote = sinkConfig.isRemote();
        FunctionEx<HazelcastInstance, Processor> processorFunction = SecuredFunctions.updateMapProcessorFn(sinkConfig.getMapName(), isRemote, toKeyFn, (oldValue, item) -> {
            Object newValue = toValueFn.apply(item);
            if (oldValue == null) {
                return newValue;
            }
            return mergeFn.apply((Object)oldValue, (Object)newValue);
        });
        ProcessorFunctionConnectorSupplier processorSupplier = new ProcessorFunctionConnectorSupplier(sinkConfig.getDataConnectionName(), sinkConfig.getClientXml(), processorFunction);
        if (isRemote) {
            return ProcessorMetaSupplier.of(processorSupplier);
        }
        Permission processorMetaSupplierPermission = PermissionsUtil.mapUpdatePermission(sinkConfig.getMapName());
        return ProcessorMetaSupplier.of(processorMetaSupplierPermission, (ProcessorSupplier)processorSupplier);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier updateMapSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(updateFn, "updateFn");
        MapSinkConfiguration<Object, ? extends K, ? extends V> sinkConfig = new MapSinkConfiguration<Object, K, V>(name);
        sinkConfig.setClientXml(ImdgUtil.asXmlString(clientConfig));
        sinkConfig.setToKeyFn(toKeyFn);
        sinkConfig.setUpdateFn(updateFn);
        return HazelcastWriters.updateMapSupplier(sinkConfig);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier updateMapSupplier(MapSinkConfiguration<T, K, V> sinkConfig) {
        Util.checkSerializable(sinkConfig.getToKeyFn(), "toKeyFn");
        Util.checkSerializable(sinkConfig.getUpdateFn(), "updateFn");
        boolean isRemote = sinkConfig.isRemote();
        FunctionEx<HazelcastInstance, Processor> processorFunction = SecuredFunctions.updateMapProcessorFn(sinkConfig.getMapName(), isRemote, sinkConfig.getToKeyFn(), sinkConfig.getUpdateFn());
        ProcessorFunctionConnectorSupplier processorSupplier = new ProcessorFunctionConnectorSupplier(sinkConfig.getDataConnectionName(), sinkConfig.getClientXml(), processorFunction);
        if (isRemote) {
            return ProcessorMetaSupplier.of(processorSupplier);
        }
        Permission processorMetaSupplierPermission = PermissionsUtil.mapUpdatePermission(sinkConfig.getMapName());
        return ProcessorMetaSupplier.of(processorMetaSupplierPermission, (ProcessorSupplier)processorSupplier);
    }

    @Nonnull
    public static <T, K, V, R> ProcessorMetaSupplier updateMapSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        MapSinkEntryProcessorConfiguration sinkConfig = new MapSinkEntryProcessorConfiguration(name);
        sinkConfig.setClientXml(ImdgUtil.asXmlString(clientConfig));
        sinkConfig.setMaxParallelAsyncOps(1000);
        sinkConfig.setToKeyFn(toKeyFn);
        sinkConfig.setToEntryProcessorFn(toEntryProcessorFn);
        return HazelcastWriters.updateMapSupplier(sinkConfig);
    }

    @Nonnull
    public static <T, K, V, R> ProcessorMetaSupplier updateMapSupplier(MapSinkEntryProcessorConfiguration<T, K, V, R> sinkConfig) {
        Util.checkSerializable(sinkConfig.getToKeyFn(), "toKeyFn");
        Util.checkSerializable(sinkConfig.getToEntryProcessorFn(), "toEntryProcessorFn");
        boolean isRemote = sinkConfig.isRemote();
        FunctionEx<HazelcastInstance, Processor> processorFunction = SecuredFunctions.updateWithEntryProcessorFn(sinkConfig.getMaxParallelAsyncOps(), sinkConfig.getMapName(), isRemote, sinkConfig.getToKeyFn(), sinkConfig.getToEntryProcessorFn());
        ProcessorFunctionConnectorSupplier processorSupplier = new ProcessorFunctionConnectorSupplier(sinkConfig.getDataConnectionName(), sinkConfig.getClientXml(), processorFunction);
        if (isRemote) {
            return ProcessorMetaSupplier.of(processorSupplier);
        }
        Permission processorMetaSupplierPermission = PermissionsUtil.mapUpdatePermission(sinkConfig.getMapName());
        return ProcessorMetaSupplier.of(processorMetaSupplierPermission, (ProcessorSupplier)processorSupplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier writeCacheSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return ProcessorMetaSupplier.preferLocalParallelismOne(PermissionsUtil.cachePutPermission(clientXml, name), new WriteCachePSupplier(clientXml, name));
    }

    @Nonnull
    public static ProcessorMetaSupplier writeListSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return ProcessorMetaSupplier.preferLocalParallelismOne(PermissionsUtil.listAddPermission(clientXml, name), new WriteListPSupplier(clientXml, name));
    }

    public static ProcessorMetaSupplier writeObservableSupplier(final @Nonnull String name) {
        return new ProcessorMetaSupplier(){
            private static final long serialVersionUID = 1L;

            @Override
            @Nonnull
            public Map<String, String> getTags() {
                return Collections.singletonMap(ObservableImpl.OWNED_OBSERVABLE, name);
            }

            @Override
            public int preferredLocalParallelism() {
                return 1;
            }

            @Override
            @Nonnull
            public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
                return address -> new WriteObservableP.Supplier(name);
            }

            @Override
            public Permission getRequiredPermission() {
                return new RingBufferPermission(name, "create", "put");
            }

            @Override
            public boolean isReusable() {
                return true;
            }

            @Override
            public boolean initIsCooperative() {
                return true;
            }

            @Override
            public boolean closeIsCooperative() {
                return true;
            }
        };
    }

    static RuntimeException handleInstanceNotActive(HazelcastInstanceNotActiveException e, boolean isLocal) {
        return isLocal ? new RestartableException(e) : e;
    }

    private static class WriteCachePSupplier<K, V>
    extends AbstractHazelcastConnectorSupplier {
        private static final long serialVersionUID = 1L;
        private final String name;

        WriteCachePSupplier(@Nullable String clientXml, @Nonnull String name) {
            super(null, clientXml);
            this.name = name;
        }

        @Override
        protected Processor createProcessor(HazelcastInstance instance, SerializationService serializationService) {
            ICache cache = instance.getCacheManager().getCache(this.name);
            FunctionEx<ProcessorSupplier.Context, ArrayMap> bufferCreator = context -> new ArrayMap();
            BiConsumerEx<ArrayMap, Map.Entry> entryReceiver = (buffer, entry) -> {
                Object key = serializationService.toData(entry.getKey());
                Object value = serializationService.toData(entry.getValue());
                buffer.add(new AbstractMap.SimpleEntry(key, value));
            };
            ConsumerEx<ArrayMap> bufferFlusher = buffer -> {
                try {
                    cache.putAll((Map)buffer);
                }
                catch (HazelcastInstanceNotActiveException e) {
                    throw HazelcastWriters.handleInstanceNotActive(e, this.isLocal());
                }
                buffer.clear();
            };
            return new WriteBufferedP<ArrayMap, Map.Entry>(bufferCreator, entryReceiver, bufferFlusher, ConsumerEx.noop());
        }

        @Override
        public List<Permission> permissions() {
            return Collections.singletonList(PermissionsUtil.cachePutPermission(this.clientXml, this.name));
        }
    }

    private static class WriteListPSupplier<T>
    extends AbstractHazelcastConnectorSupplier {
        private static final long serialVersionUID = 1L;
        private final String name;

        WriteListPSupplier(@Nullable String clientXml, @Nonnull String name) {
            super(null, clientXml);
            this.name = name;
        }

        @Override
        protected Processor createProcessor(HazelcastInstance instance, SerializationService serializationService) {
            IList list = instance.getList(this.name);
            FunctionEx<ProcessorSupplier.Context, List> bufferCreator = context -> new ArrayList();
            BiConsumerEx<List, Object> itemReceiver = (buffer, item) -> buffer.add(serializationService.toData(item));
            ConsumerEx<List> bufferFlusher = buffer -> {
                try {
                    list.addAll(buffer);
                }
                catch (HazelcastInstanceNotActiveException e) {
                    throw HazelcastWriters.handleInstanceNotActive(e, this.isLocal());
                }
                buffer.clear();
            };
            return new WriteBufferedP<List, Object>(bufferCreator, itemReceiver, bufferFlusher, ConsumerEx.noop());
        }

        @Override
        public List<Permission> permissions() {
            return Collections.singletonList(PermissionsUtil.listAddPermission(this.clientXml, this.name));
        }
    }

    public static final class ArrayMap<K, V>
    extends AbstractMap<K, V> {
        private final List<Map.Entry<K, V>> entries;
        private final ArraySet set = new ArraySet();

        ArrayMap() {
            this.entries = new ArrayList<Map.Entry<K, V>>();
        }

        public ArrayMap(int size) {
            this.entries = new ArrayList<Map.Entry<K, V>>(size);
        }

        @Override
        @Nonnull
        public Set<Map.Entry<K, V>> entrySet() {
            return this.set;
        }

        public void add(Map.Entry<K, V> entry) {
            this.entries.add(entry);
        }

        @Override
        public V get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this.entries.toString();
        }

        private class ArraySet
        extends AbstractSet<Map.Entry<K, V>> {
            private ArraySet() {
            }

            @Override
            @Nonnull
            public Iterator<Map.Entry<K, V>> iterator() {
                return ArrayMap.this.entries.iterator();
            }

            @Override
            public int size() {
                return ArrayMap.this.entries.size();
            }

            @Override
            public void clear() {
                ArrayMap.this.entries.clear();
            }
        }
    }
}

