/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.map.impl.EntryEventFilter;
import com.hazelcast.map.impl.querycache.QueryCacheConfigurator;
import com.hazelcast.map.impl.querycache.QueryCacheEventService;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import java.util.EventListener;

public abstract class AbstractQueryCacheConfigurator
implements QueryCacheConfigurator {
    private final QueryCacheEventService eventService;

    public AbstractQueryCacheConfigurator(QueryCacheEventService eventService) {
        this.eventService = eventService;
    }

    protected void setEntryListener(String mapName, String cacheId, QueryCacheConfig config, ClassLoader loader) {
        for (EntryListenerConfig listenerConfig : config.getEntryListenerConfigs()) {
            MapListener listener = (MapListener)this.getListener(listenerConfig, loader);
            if (listener == null) continue;
            EntryEventFilter filter = new EntryEventFilter(null, listenerConfig.isIncludeValue());
            this.eventService.addListener(mapName, cacheId, listener, filter);
        }
    }

    protected void setPredicateImpl(QueryCacheConfig config, ClassLoader loader) {
        PredicateConfig predicateConfig = config.getPredicateConfig();
        if (predicateConfig.getImplementation() != null) {
            return;
        }
        Predicate predicate = this.getPredicate(predicateConfig, loader);
        if (predicate == null) {
            return;
        }
        predicateConfig.setImplementation(predicate);
    }

    private Predicate getPredicate(PredicateConfig predicateConfig, ClassLoader loader) {
        if (!StringUtil.isNullOrEmpty(predicateConfig.getClassName())) {
            try {
                return (Predicate)ClassLoaderUtil.newInstance(loader, predicateConfig.getClassName());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (!StringUtil.isNullOrEmpty(predicateConfig.getSql())) {
            String sql = predicateConfig.getSql();
            return Predicates.sql(sql);
        }
        return null;
    }

    private <T extends EventListener> T getListener(ListenerConfig listenerConfig, ClassLoader loader) {
        EventListener listener = null;
        if (listenerConfig.getImplementation() != null) {
            listener = listenerConfig.getImplementation();
        } else if (listenerConfig.getClassName() != null) {
            try {
                return (T)((EventListener)ClassLoaderUtil.newInstance(loader, listenerConfig.getClassName()));
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        return (T)listener;
    }
}

