/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.Closeable;
import java.io.IOException;
import org.apache.avro.file.SeekableInput;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class AvroStorageInputStream
implements Closeable,
SeekableInput {
    private final FSDataInputStream stream;
    private final long len;

    public AvroStorageInputStream(Path path, TaskAttemptContext context) throws IOException {
        this.stream = path.getFileSystem(context.getConfiguration()).open(path);
        this.len = path.getFileSystem(context.getConfiguration()).getFileStatus(path).getLen();
    }

    public long length() {
        return this.len;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    public void seek(long p) throws IOException {
        this.stream.seek(p);
    }

    public long tell() throws IOException {
        return this.stream.getPos();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

