/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class CoprocessorWhitelistMasterObserver
implements MasterCoprocessor,
MasterObserver {
    public static final String CP_COPROCESSOR_WHITELIST_PATHS_KEY = "hbase.coprocessor.region.whitelist.paths";
    private static final Logger LOG = LoggerFactory.getLogger(CoprocessorWhitelistMasterObserver.class);

    @Override
    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }

    @Override
    public TableDescriptor preModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, TableDescriptor currentDesc, TableDescriptor newDesc) throws IOException {
        CoprocessorWhitelistMasterObserver.verifyCoprocessors(ctx, newDesc);
        return newDesc;
    }

    @Override
    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor htd, RegionInfo[] regions) throws IOException {
        CoprocessorWhitelistMasterObserver.verifyCoprocessors(ctx, htd);
    }

    private static boolean validatePath(Path coprocPath, Path wlPath) {
        if (wlPath.toString().equals("*")) {
            return true;
        }
        if (!wlPath.isAbsoluteAndSchemeAuthorityNull()) {
            String wlPathScheme = wlPath.toUri().getScheme();
            String coprocPathScheme = coprocPath.toUri().getScheme();
            String wlPathHost = wlPath.toUri().getHost();
            String coprocPathHost = coprocPath.toUri().getHost();
            wlPathScheme = wlPathScheme != null ? wlPathScheme.toString().toLowerCase() : "";
            wlPathHost = wlPathHost != null ? wlPathHost.toString().toLowerCase() : "";
            coprocPathScheme = coprocPathScheme != null ? coprocPathScheme.toString().toLowerCase() : "";
            coprocPathHost = coprocPathHost != null ? coprocPathHost.toString().toLowerCase() : "";
            if (!wlPathScheme.equals(coprocPathScheme) || !wlPathHost.equals(coprocPathHost)) {
                return false;
            }
        }
        if (wlPath.isRoot()) {
            return true;
        }
        return FilenameUtils.wildcardMatch((String)Path.getPathWithoutSchemeAndAuthority((Path)coprocPath).toString(), (String)Path.getPathWithoutSchemeAndAuthority((Path)wlPath).toString());
    }

    private static void verifyCoprocessors(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor htd) throws IOException {
        Collection paths = ctx.getEnvironment().getConfiguration().getStringCollection(CP_COPROCESSOR_WHITELIST_PATHS_KEY);
        for (CoprocessorDescriptor cp : htd.getCoprocessorDescriptors()) {
            if (!cp.getJarPath().isPresent() || !paths.stream().noneMatch(p -> {
                Path wlPath = new Path(p);
                if (CoprocessorWhitelistMasterObserver.validatePath(new Path((String)cp.getJarPath().get()), wlPath)) {
                    LOG.debug(String.format("Coprocessor %s found in directory %s", cp.getClassName(), p));
                    return true;
                }
                return false;
            })) continue;
            throw new IOException(String.format("Loading %s DENIED in %s", cp.getClassName(), CP_COPROCESSOR_WHITELIST_PATHS_KEY));
        }
    }
}

