/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.util;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.jruby.ast.AliasNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FileNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.XStrNode;
import org.jruby.util.ConvertBytes;

public class SexpMaker {
    public static String create(Node node) {
        StringBuilder sb = new StringBuilder(100);
        SexpMaker.process(sb, node);
        return sb.toString();
    }

    public static String create(String methodName, Node argsNode, Node body) {
        StringBuilder sb = new StringBuilder(100);
        SexpMaker.processMethod(sb, methodName, argsNode, body);
        return sb.toString();
    }

    public static String sha1(String methodName, Node argsNode, Node body) {
        MessageDigest sha1;
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
        DigestBuilder db = new DigestBuilder(sha1);
        SexpMaker.processMethod(db, methodName, argsNode, body);
        byte[] digest2 = db.d.digest();
        return new String(ConvertBytes.twosComplementToHexBytes(digest2, false));
    }

    private static void processMethod(Builder sb, String methodName, Node argsNode, Node body) {
        sb.append("(method ").append(methodName).append(' ');
        sb.append("(file ").append(new File(body.getPosition().getFile()).getName()).append(") ");
        sb.append("(line ").append(body.getPosition().getStartLine()).append(") ");
        SexpMaker.process(sb, argsNode);
        sb.append(' ');
        SexpMaker.process(sb, body);
        sb.append(')');
    }

    private static void process(Builder sb, Node node) {
        if (node == null) {
            sb.append("null");
            return;
        }
        sb.append('(');
        SexpMaker.shortName(sb, node);
        SexpMaker.leafInfo(sb, node);
        List<Node> nodes = node.childNodes();
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            Node child = nodes.get(i2);
            sb.append(' ');
            SexpMaker.process(sb, child);
        }
        sb.append(')');
    }

    private static void shortName(Builder sb, Node node) {
        sb.append(node.getNodeType().simpleName());
    }

    private static void leafInfo(Builder sb, Node node) {
        switch (node.getNodeType()) {
            case ALIASNODE: {
                SexpMaker.aliasNode(sb, (AliasNode)node);
                break;
            }
            case ARGUMENTNODE: {
                SexpMaker.argumentNode(sb, (ArgumentNode)node);
                break;
            }
            case ATTRASSIGNNODE: {
                SexpMaker.attrAssignNode(sb, (AttrAssignNode)node);
                break;
            }
            case BACKREFNODE: {
                SexpMaker.backRefNode(sb, (BackRefNode)node);
                break;
            }
            case BIGNUMNODE: {
                SexpMaker.bignumNode(sb, (BignumNode)node);
                break;
            }
            case BLOCKARGNODE: {
                SexpMaker.blockArgNode(sb, (BlockArgNode)node);
                break;
            }
            case CALLNODE: {
                SexpMaker.callNode(sb, (CallNode)node);
                break;
            }
            case CLASSVARASGNNODE: {
                SexpMaker.classVarAsgnNode(sb, (ClassVarAsgnNode)node);
                break;
            }
            case CLASSVARDECLNODE: {
                SexpMaker.classVarDeclNode(sb, (ClassVarDeclNode)node);
                break;
            }
            case CLASSVARNODE: {
                SexpMaker.classVarNode(sb, (ClassVarNode)node);
                break;
            }
            case COLON2NODE: {
                SexpMaker.colon2Node(sb, (Colon2Node)node);
                break;
            }
            case COLON3NODE: {
                SexpMaker.colon3Node(sb, (Colon3Node)node);
                break;
            }
            case CONSTDECLNODE: {
                SexpMaker.constDeclNode(sb, (ConstDeclNode)node);
                break;
            }
            case CONSTNODE: {
                SexpMaker.constNode(sb, (ConstNode)node);
                break;
            }
            case DASGNNODE: {
                SexpMaker.dAsgnNode(sb, (DAsgnNode)node);
                break;
            }
            case DOTNODE: {
                SexpMaker.dotNode(sb, (DotNode)node);
                break;
            }
            case DREGEXPNODE: {
                SexpMaker.dRegexpNode(sb, (DRegexpNode)node);
                break;
            }
            case DVARNODE: {
                SexpMaker.dVarNode(sb, (DVarNode)node);
                break;
            }
            case FCALLNODE: {
                SexpMaker.fCallNode(sb, (FCallNode)node);
                break;
            }
            case FIXNUMNODE: {
                SexpMaker.fixnumNode(sb, (FixnumNode)node);
                break;
            }
            case FLIPNODE: {
                SexpMaker.flipNode(sb, (FlipNode)node);
                break;
            }
            case FLOATNODE: {
                SexpMaker.floatNode(sb, (FloatNode)node);
                break;
            }
            case GLOBALASGNNODE: {
                SexpMaker.globalAsgnNode(sb, (GlobalAsgnNode)node);
                break;
            }
            case GLOBALVARNODE: {
                SexpMaker.globalVarNode(sb, (GlobalVarNode)node);
                break;
            }
            case INSTASGNNODE: {
                SexpMaker.instAsgnNode(sb, (InstAsgnNode)node);
                break;
            }
            case INSTVARNODE: {
                SexpMaker.instVarNode(sb, (InstVarNode)node);
                break;
            }
            case LOCALASGNNODE: {
                SexpMaker.localAsgnNode(sb, (LocalAsgnNode)node);
                break;
            }
            case LOCALVARNODE: {
                SexpMaker.localVarNode(sb, (LocalVarNode)node);
                break;
            }
            case NTHREFNODE: {
                SexpMaker.nthRefNode(sb, (NthRefNode)node);
                break;
            }
            case OPASGNNODE: {
                SexpMaker.opAsgnNode(sb, (OpAsgnNode)node);
                break;
            }
            case OPELEMENTASGNNODE: {
                SexpMaker.opElementAsgnNode(sb, (OpElementAsgnNode)node);
                break;
            }
            case REGEXPNODE: {
                SexpMaker.regexpNode(sb, (RegexpNode)node);
                break;
            }
            case STRNODE: {
                SexpMaker.strNode(sb, (StrNode)node);
                break;
            }
            case SYMBOLNODE: {
                SexpMaker.symbolNode(sb, (SymbolNode)node);
                break;
            }
            case UNDEFNODE: {
                SexpMaker.undefNode(sb, (UndefNode)node);
                break;
            }
            case VALIASNODE: {
                SexpMaker.valiasNode(sb, (VAliasNode)node);
                break;
            }
            case VCALLNODE: {
                SexpMaker.vcallNode(sb, (VCallNode)node);
                break;
            }
            case XSTRNODE: {
                SexpMaker.xStrNode(sb, (XStrNode)node);
                break;
            }
        }
    }

    private static void xStrNode(Builder sb, XStrNode node) {
        sb.append(" '").append(node.getValue()).append('\'');
    }

    private static void vcallNode(Builder sb, VCallNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void valiasNode(Builder sb, VAliasNode node) {
        sb.append(' ').append(node.getOldName()).append(node.getNewName());
    }

    private static void undefNode(Builder sb, UndefNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void strNode(Builder sb, StrNode node) {
        if (node instanceof FileNode) {
            sb.append(" __FILE__");
        } else {
            sb.append(" '").append(node.getValue()).append('\'');
        }
    }

    private static void regexpNode(Builder sb, RegexpNode node) {
        sb.append(' ').append(node.getValue()).append(' ').append(node.getOptions());
    }

    private static void opElementAsgnNode(Builder sb, OpElementAsgnNode node) {
        sb.append(' ').append(node.getOperatorName());
    }

    private static void nthRefNode(Builder sb, NthRefNode node) {
        sb.append(' ').append(node.getMatchNumber());
    }

    private static void localAsgnNode(Builder sb, LocalAsgnNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void instVarNode(Builder sb, InstVarNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void instAsgnNode(Builder sb, InstAsgnNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void globalVarNode(Builder sb, GlobalVarNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void globalAsgnNode(Builder sb, GlobalAsgnNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void floatNode(Builder sb, FloatNode node) {
        sb.append(' ').append(node.getValue());
    }

    private static void flipNode(Builder sb, FlipNode node) {
        sb.append(' ').append(node.isExclusive());
    }

    private static void fixnumNode(Builder sb, FixnumNode node) {
        sb.append(' ').append(node.getValue());
    }

    private static void fCallNode(Builder sb, FCallNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void dVarNode(Builder sb, DVarNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void blockArgNode(Builder sb, BlockArgNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void backRefNode(Builder sb, BackRefNode node) {
        sb.append(' ').append(node.getType());
    }

    private static void symbolNode(Builder sb, SymbolNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void localVarNode(Builder sb, LocalVarNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void argumentNode(Builder sb, ArgumentNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void dRegexpNode(Builder sb, DRegexpNode node) {
        sb.append(' ').append(node.getOnce()).append(' ').append(node.getOptions());
    }

    private static void dotNode(Builder sb, DotNode node) {
        sb.append(' ').append(node.isExclusive()).append(' ').append(node.isLiteral());
    }

    private static void dAsgnNode(Builder sb, DAsgnNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void constNode(Builder sb, ConstNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void constDeclNode(Builder sb, ConstDeclNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void colon3Node(Builder sb, Colon3Node node) {
        sb.append(' ').append(node.getName());
    }

    private static void colon2Node(Builder sb, Colon2Node node) {
        sb.append(' ').append(node.getName());
    }

    private static void classVarNode(Builder sb, ClassVarNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void classVarDeclNode(Builder sb, ClassVarDeclNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void classVarAsgnNode(Builder sb, ClassVarAsgnNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void callNode(Builder sb, CallNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void bignumNode(Builder sb, BignumNode node) {
        sb.append(' ').append(node.getValue());
    }

    private static void attrAssignNode(Builder sb, AttrAssignNode node) {
        sb.append(' ').append(node.getName());
    }

    private static void aliasNode(Builder sb, AliasNode node) {
        sb.append(' ').append(node.getOldName()).append(node.getNewName());
    }

    private static void opAsgnNode(Builder sb, OpAsgnNode node) {
        sb.append(" '").append(node.getOperatorName()).append('\'');
    }

    private static class DigestBuilder
    implements Builder {
        MessageDigest d;

        DigestBuilder(MessageDigest digest2) {
            this.d = digest2;
        }

        @Override
        public Builder append(Object o) {
            this.append(o.toString());
            return this;
        }

        @Override
        public Builder append(String str) {
            this.d.update(str.getBytes());
            return this;
        }

        @Override
        public Builder append(boolean b2) {
            this.append((byte)(b2 ? 1 : 0));
            return this;
        }

        @Override
        public Builder append(char ch) {
            this.d.update((byte)(ch >> 8));
            this.d.update((byte)ch);
            return this;
        }

        @Override
        public Builder append(int i2) {
            this.append((char)(i2 >> 16));
            this.append((char)i2);
            return this;
        }

        @Override
        public Builder append(long l) {
            this.append((int)(l >> 32));
            this.append((int)l);
            return this;
        }

        @Override
        public Builder append(double d) {
            this.append(Double.doubleToLongBits(d));
            return this;
        }
    }

    private static class StringBuilder
    implements Builder {
        final java.lang.StringBuilder b;

        StringBuilder(int size2) {
            this.b = new java.lang.StringBuilder(size2);
        }

        @Override
        public Builder append(Object o) {
            this.append(o.toString());
            return this;
        }

        @Override
        public Builder append(String str) {
            this.b.append(str);
            return this;
        }

        @Override
        public Builder append(boolean bool2) {
            this.b.append(bool2);
            return this;
        }

        @Override
        public Builder append(char ch) {
            this.b.append(ch);
            return this;
        }

        @Override
        public Builder append(int i2) {
            this.b.append(i2);
            return this;
        }

        @Override
        public Builder append(long l) {
            this.b.append(l);
            return this;
        }

        @Override
        public Builder append(double d) {
            this.b.append(d);
            return this;
        }
    }

    private static interface Builder {
        public Builder append(String var1);

        public Builder append(char var1);

        public Builder append(int var1);

        public Builder append(Object var1);

        public Builder append(boolean var1);

        public Builder append(long var1);

        public Builder append(double var1);
    }
}

