/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.HostRestrictingAuthorizationFilter;
import org.apache.hadoop.hdfs.server.datanode.web.HostRestrictingAuthorizationFilterHandler;
import org.junit.Assert;
import org.junit.Test;

public class TestHostRestrictingAuthorizationFilterHandler {
    static final String CONFNAME = "dfs.web.authentication.host.allow.rules";

    @Test
    public void testRejectAll() throws Exception {
        CustomEmbeddedChannel channel = new CustomEmbeddedChannel("127.0.0.1", 1006, new ChannelHandler[]{new HostRestrictingAuthorizationFilterHandler()});
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/user/myName/fooFile?op=OPEN");
        Assert.assertFalse((String)"Should get error back from handler for rejected request", (boolean)channel.writeInbound(new Object[]{httpRequest}));
        DefaultHttpResponse channelResponse = (DefaultHttpResponse)channel.outboundMessages().poll();
        Assert.assertNotNull((String)"Expected response to exist.", (Object)channelResponse);
        Assert.assertEquals((Object)HttpResponseStatus.FORBIDDEN, (Object)channelResponse.getStatus());
        Assert.assertFalse((boolean)channel.isOpen());
    }

    @Test
    public void testMultipleAcceptedGETsOneChannel() throws Exception {
        Configuration conf = new Configuration();
        conf.set(CONFNAME, "*,*,/allowed");
        HostRestrictingAuthorizationFilter filter = HostRestrictingAuthorizationFilterHandler.initializeState((Configuration)conf);
        CustomEmbeddedChannel channel = new CustomEmbeddedChannel("127.0.0.1", 1006, new ChannelHandler[]{new HostRestrictingAuthorizationFilterHandler(filter)});
        DefaultFullHttpRequest allowedHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/allowed/file_one?op=OPEN");
        DefaultFullHttpRequest allowedHttpRequest2 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/allowed/file_two?op=OPEN");
        DefaultFullHttpRequest allowedHttpRequest3 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/allowed/file_three?op=OPEN");
        Assert.assertTrue((String)"Should successfully accept request", (boolean)channel.writeInbound(new Object[]{allowedHttpRequest}));
        Assert.assertTrue((String)"Should successfully accept request, second time", (boolean)channel.writeInbound(new Object[]{allowedHttpRequest2}));
        Assert.assertTrue((String)"Should successfully accept request, third time", (boolean)channel.writeInbound(new Object[]{allowedHttpRequest3}));
    }

    @Test
    public void testMultipleChannels() throws Exception {
        Configuration conf = new Configuration();
        conf.set(CONFNAME, "*,*,/allowed");
        HostRestrictingAuthorizationFilter filter = HostRestrictingAuthorizationFilterHandler.initializeState((Configuration)conf);
        CustomEmbeddedChannel channel1 = new CustomEmbeddedChannel("127.0.0.1", 1006, new ChannelHandler[]{new HostRestrictingAuthorizationFilterHandler(filter)});
        CustomEmbeddedChannel channel2 = new CustomEmbeddedChannel("127.0.0.2", 1006, new ChannelHandler[]{new HostRestrictingAuthorizationFilterHandler(filter)});
        CustomEmbeddedChannel channel3 = new CustomEmbeddedChannel("127.0.0.3", 1006, new ChannelHandler[]{new HostRestrictingAuthorizationFilterHandler(filter)});
        DefaultFullHttpRequest allowedHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/allowed/file_one?op=OPEN");
        DefaultFullHttpRequest allowedHttpRequest2 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/allowed/file_two?op=OPEN");
        DefaultFullHttpRequest allowedHttpRequest3 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/allowed/file_three?op=OPEN");
        Assert.assertTrue((String)"Should successfully accept request", (boolean)channel1.writeInbound(new Object[]{allowedHttpRequest}));
        Assert.assertTrue((String)"Should successfully accept request, second time", (boolean)channel2.writeInbound(new Object[]{allowedHttpRequest2}));
        channel1.close();
        Assert.assertTrue((String)"Should successfully accept request, third time", (boolean)channel3.writeInbound(new Object[]{allowedHttpRequest3}));
    }

    @Test
    public void testAcceptGETFILECHECKSUM() throws Exception {
        CustomEmbeddedChannel channel = new CustomEmbeddedChannel("127.0.0.1", 1006, new ChannelHandler[]{new HostRestrictingAuthorizationFilterHandler()});
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/user/myName/fooFile?op=GETFILECHECKSUM");
        Assert.assertTrue((String)"Should successfully accept request", (boolean)channel.writeInbound(new Object[]{httpRequest}));
    }

    protected static class CustomEmbeddedChannel
    extends EmbeddedChannel {
        private InetSocketAddress socketAddress;

        public CustomEmbeddedChannel(String host, int port, ChannelHandler ... handlers) {
            super(handlers);
            this.socketAddress = new InetSocketAddress(host, port);
        }

        protected SocketAddress remoteAddress0() {
            return this.socketAddress;
        }
    }
}

