/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.FSDirAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFSDirAttrOp {
    public static final Logger LOG = LoggerFactory.getLogger(TestFSDirAttrOp.class);

    private boolean unprotectedSetTimes(long atime, long atime0, long precision, long mtime, boolean force) throws QuotaExceededException {
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        SnapshotManager ssMgr = (SnapshotManager)Mockito.mock(SnapshotManager.class);
        FSDirectory fsd = (FSDirectory)Mockito.mock(FSDirectory.class);
        INodesInPath iip = (INodesInPath)Mockito.mock(INodesInPath.class);
        INode inode = (INode)Mockito.mock(INode.class);
        Mockito.when((Object)fsd.getFSNamesystem()).thenReturn((Object)fsn);
        Mockito.when((Object)fsn.getSnapshotManager()).thenReturn((Object)ssMgr);
        Mockito.when((Object)ssMgr.getSkipCaptureAccessTimeOnlyChange()).thenReturn((Object)false);
        Mockito.when((Object)fsd.getAccessTimePrecision()).thenReturn((Object)precision);
        Mockito.when((Object)fsd.hasWriteLock()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)iip.getLastINode()).thenReturn((Object)inode);
        Mockito.when((Object)iip.getLatestSnapshotId()).thenReturn((Object)Mockito.anyInt());
        Mockito.when((Object)inode.getAccessTime()).thenReturn((Object)atime0);
        return FSDirAttrOp.unprotectedSetTimes((FSDirectory)fsd, (INodesInPath)iip, (long)mtime, (long)atime, (boolean)force);
    }

    private boolean unprotectedSetAttributes(short currPerm, short newPerm) throws Exception {
        return this.unprotectedSetAttributes(currPerm, newPerm, "user1", "user1", false);
    }

    private boolean unprotectedSetAttributes(short currPerm, short newPerm, String currUser, String newUser, boolean testChangeOwner) throws Exception {
        String groupName = "testGroup";
        FsPermission originalPerm = new FsPermission(currPerm);
        FsPermission updatedPerm = new FsPermission(newPerm);
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        SnapshotManager ssMgr = (SnapshotManager)Mockito.mock(SnapshotManager.class);
        FSDirectory fsd = (FSDirectory)Mockito.mock(FSDirectory.class);
        INodesInPath iip = (INodesInPath)Mockito.mock(INodesInPath.class);
        Mockito.when((Object)fsd.getFSNamesystem()).thenReturn((Object)fsn);
        Mockito.when((Object)fsn.getSnapshotManager()).thenReturn((Object)ssMgr);
        Mockito.when((Object)ssMgr.getSkipCaptureAccessTimeOnlyChange()).thenReturn((Object)false);
        Mockito.when((Object)fsd.getAccessTimePrecision()).thenReturn((Object)1000L);
        Mockito.when((Object)fsd.hasWriteLock()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)iip.getLatestSnapshotId()).thenReturn((Object)0);
        INodeDirectory inode = new INodeDirectory(1000L, DFSUtil.string2Bytes((String)""), new PermissionStatus(currUser, "testGroup", originalPerm), 0L);
        Mockito.when((Object)iip.getLastINode()).thenReturn((Object)inode);
        return testChangeOwner ? FSDirAttrOp.unprotectedSetOwner((FSDirectory)fsd, (INodesInPath)iip, (String)newUser, (String)groupName) : FSDirAttrOp.unprotectedSetPermission((FSDirectory)fsd, (INodesInPath)iip, (FsPermission)updatedPerm);
    }

    @Test
    public void testUnprotectedSetPermissions() throws Exception {
        Assert.assertTrue((String)"setPermissions return true for updated permissions", (boolean)this.unprotectedSetAttributes((short)511, (short)0));
        Assert.assertFalse((String)"setPermissions should return false for same permissions", (boolean)this.unprotectedSetAttributes((short)511, (short)511));
    }

    @Test
    public void testUnprotectedSetOwner() throws Exception {
        Assert.assertTrue((String)"SetOwner should return true for a new user", (boolean)this.unprotectedSetAttributes((short)511, (short)511, "user1", "user2", true));
        Assert.assertFalse((String)"SetOwner should return false for same user", (boolean)this.unprotectedSetAttributes((short)511, (short)511, "user1", "user1", true));
    }

    @Test
    public void testUnprotectedSetTimes() throws Exception {
        Assert.assertFalse((String)"SetTimes should not update access time because it's within the last precision interval", (boolean)this.unprotectedSetTimes(100L, 0L, 1000L, -1L, false));
        Assert.assertFalse((String)"SetTimes should not update access time because it's within the last precision interval", (boolean)this.unprotectedSetTimes(1000L, 0L, 1000L, -1L, false));
        Assert.assertTrue((String)"SetTimes should update access time", (boolean)this.unprotectedSetTimes(1011L, 10L, 1000L, -1L, false));
        Assert.assertTrue((String)"SetTimes should update access time", (boolean)this.unprotectedSetTimes(100L, 0L, 1000L, -1L, true));
        Assert.assertTrue((String)"SetTimes should update access time", (boolean)this.unprotectedSetTimes(100L, 0L, 1000L, 1L, false));
    }
}

