/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyState;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.ErasureCodingPolicyManager;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.TestINodeFile;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestFSImage {
    private static final String HADOOP_2_7_ZER0_BLOCK_SIZE_TGZ = "image-with-zero-block-size.tar.gz";
    private static final ErasureCodingPolicy testECPolicy = SystemErasureCodingPolicies.getByID((byte)5);

    @Test
    public void testPersist() throws IOException {
        Configuration conf = new Configuration();
        this.testPersistHelper(conf);
    }

    @Test
    public void testCompression() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.image.compress", true);
        this.setCompressCodec(conf, "org.apache.hadoop.io.compress.DefaultCodec");
        this.setCompressCodec(conf, "org.apache.hadoop.io.compress.GzipCodec");
        this.setCompressCodec(conf, "org.apache.hadoop.io.compress.BZip2Codec");
    }

    @Test
    public void testNativeCompression() throws IOException {
        Assume.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.image.compress", true);
        this.setCompressCodec(conf, "org.apache.hadoop.io.compress.Lz4Codec");
    }

    private void setCompressCodec(Configuration conf, String compressCodec) throws IOException {
        conf.set("dfs.image.compression.codec", compressCodec);
        this.testPersistHelper(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPersistHelper(Configuration conf) throws IOException {
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path dir = new Path("/abc/def");
            Path file1 = new Path(dir, "f1");
            Path file2 = new Path(dir, "f2");
            fs.create(file1).close();
            FSDataOutputStream out = fs.create(file2);
            out.writeBytes("hello");
            ((DFSOutputStream)out.getWrappedStream()).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
            fs.setSafeMode(SafeModeAction.ENTER);
            fs.saveNamespace();
            fs.setSafeMode(SafeModeAction.LEAVE);
            cluster.restartNameNode(new String[0]);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Assert.assertTrue((boolean)fs.isDirectory(dir));
            Assert.assertTrue((boolean)fs.exists(file1));
            Assert.assertTrue((boolean)fs.exists(file2));
            INodeFile file2Node = fsn.dir.getINode4Write(file2.toString()).asFile();
            Assert.assertEquals((long)"hello".length(), (long)file2Node.computeFileSize());
            Assert.assertTrue((boolean)file2Node.isUnderConstruction());
            BlockInfo[] blks = file2Node.getBlocks();
            Assert.assertEquals((long)1L, (long)blks.length);
            Assert.assertEquals((Object)HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, (Object)blks[0].getBlockUCState());
            LeaseManager.Lease lease = fsn.leaseManager.getLease(file2Node);
            Assert.assertNotNull((Object)lease);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void testSaveAndLoadStripedINodeFile(FSNamesystem fsn, Configuration conf, boolean isUC) throws IOException {
        fsn.setErasureCodingPolicy("/", testECPolicy.getName(), false);
        long id = 123456789L;
        byte[] name = "testSaveAndLoadInodeFile_testfile".getBytes();
        PermissionStatus permissionStatus = new PermissionStatus("testuser_a", "testuser_groups", new FsPermission(1877));
        long mtime = 1426219316L;
        long atime = 1426222916L;
        BlockInfoContiguous[] blocks = new BlockInfoContiguous[]{};
        byte erasureCodingPolicyID = testECPolicy.getId();
        long preferredBlockSize = 0x8000000L;
        INodeFile file = new INodeFile(id, name, permissionStatus, mtime, atime, (BlockInfo[])blocks, null, Byte.valueOf(erasureCodingPolicyID), preferredBlockSize, 0, BlockType.STRIPED);
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        BlockInfoStriped[] stripedBlocks = new BlockInfoStriped[3];
        long stripedBlkId = 10000001L;
        long timestamp = mtime + 3600L;
        for (int i = 0; i < stripedBlocks.length; ++i) {
            stripedBlocks[i] = new BlockInfoStriped(new Block(stripedBlkId + (long)i, preferredBlockSize, timestamp), testECPolicy);
            file.addBlock((BlockInfo)stripedBlocks[i]);
        }
        String client = "testClient";
        String clientMachine = "testClientMachine";
        String path = "testUnderConstructionPath";
        DataOutputStream out = new DataOutputStream(bs);
        if (isUC) {
            file.toUnderConstruction("testClient", "testClientMachine");
            FSImageSerialization.writeINodeUnderConstruction((DataOutputStream)out, (INodeFile)file, (String)"testUnderConstructionPath");
        } else {
            FSImageSerialization.writeINodeFile((INodeFile)file, (DataOutput)out, (boolean)false);
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bs.toByteArray()));
        INodeFile fileByLoaded = isUC ? FSImageSerialization.readINodeUnderConstruction((DataInput)in, (FSNamesystem)fsn, (int)fsn.getFSImage().getLayoutVersion()) : (INodeFile)new FSImageFormat.Loader(conf, fsn).loadINodeWithLocalName(false, (DataInput)in, false);
        Assert.assertEquals((long)id, (long)fileByLoaded.getId());
        Assert.assertArrayEquals((byte[])(isUC ? "testUnderConstructionPath".getBytes() : name), (byte[])fileByLoaded.getLocalName().getBytes());
        Assert.assertEquals((Object)permissionStatus.getUserName(), (Object)fileByLoaded.getPermissionStatus().getUserName());
        Assert.assertEquals((Object)permissionStatus.getGroupName(), (Object)fileByLoaded.getPermissionStatus().getGroupName());
        Assert.assertEquals((Object)permissionStatus.getPermission(), (Object)fileByLoaded.getPermissionStatus().getPermission());
        Assert.assertEquals((long)mtime, (long)fileByLoaded.getModificationTime());
        Assert.assertEquals((long)(isUC ? mtime : atime), (long)fileByLoaded.getAccessTime());
        Assert.assertEquals((long)3L, (long)fileByLoaded.getBlocks().length);
        Assert.assertEquals((long)preferredBlockSize, (long)fileByLoaded.getPreferredBlockSize());
        Assert.assertEquals((long)file.getFileReplication(), (long)fileByLoaded.getFileReplication());
        if (isUC) {
            Assert.assertEquals((Object)"testClient", (Object)fileByLoaded.getFileUnderConstructionFeature().getClientName());
            Assert.assertEquals((Object)"testClientMachine", (Object)fileByLoaded.getFileUnderConstructionFeature().getClientMachine());
        }
    }

    @Test
    public void testSaveAndLoadStripedINodeFile() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            DFSTestUtil.enableAllECPolicies(cluster.getFileSystem());
            this.testSaveAndLoadStripedINodeFile(cluster.getNamesystem(), conf, false);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testSaveAndLoadStripedINodeFileUC() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            DFSTestUtil.enableAllECPolicies(cluster.getFileSystem());
            this.testSaveAndLoadStripedINodeFile(cluster.getNamesystem(), conf, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemovalStaleFsimageCkpt() throws IOException {
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
            conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
            secondary = new SecondaryNameNode((Configuration)conf);
            secondary.doCheckpoint();
            NNStorage storage = secondary.getFSImage().storage;
            File currentDir = FSImageTestUtil.getCurrentDirs(storage, NNStorage.NameNodeDirType.IMAGE).get(0);
            File staleCkptFile = new File(currentDir.getPath() + "/fsimage.ckpt_0000000000000000002");
            staleCkptFile.createNewFile();
            Assert.assertTrue((boolean)staleCkptFile.exists());
            secondary.doCheckpoint();
            Assert.assertFalse((boolean)staleCkptFile.exists());
        }
        finally {
            if (secondary != null) {
                secondary.shutdown();
                secondary = null;
            }
            if (cluster != null) {
                cluster.shutdown();
                cluster = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDigest() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.setSafeMode(SafeModeAction.ENTER);
            fs.saveNamespace();
            fs.setSafeMode(SafeModeAction.LEAVE);
            File currentDir = FSImageTestUtil.getNameNodeCurrentDirs(cluster, 0).get(0);
            File fsimage = FSImageTestUtil.findNewestImageFile(currentDir.getAbsolutePath());
            Assert.assertEquals((Object)MD5FileUtils.readStoredMd5ForFile((File)fsimage), (Object)MD5FileUtils.computeMd5ForFile((File)fsimage));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testLoadMtimeAtime() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            String userDir = hdfs.getHomeDirectory().toUri().getPath().toString();
            Path file = new Path(userDir, "file");
            Path dir = new Path(userDir, "/dir");
            Path link = new Path(userDir, "/link");
            hdfs.createNewFile(file);
            hdfs.mkdirs(dir);
            hdfs.createSymlink(file, link, false);
            long mtimeFile = hdfs.getFileStatus(file).getModificationTime();
            long atimeFile = hdfs.getFileStatus(file).getAccessTime();
            long mtimeDir = hdfs.getFileStatus(dir).getModificationTime();
            long mtimeLink = hdfs.getFileLinkStatus(link).getModificationTime();
            long atimeLink = hdfs.getFileLinkStatus(link).getAccessTime();
            hdfs.setSafeMode(SafeModeAction.ENTER);
            hdfs.saveNamespace();
            hdfs.setSafeMode(SafeModeAction.LEAVE);
            cluster.shutdown();
            cluster = new MiniDFSCluster.Builder(conf).format(false).numDataNodes(1).build();
            cluster.waitActive();
            hdfs = cluster.getFileSystem();
            Assert.assertEquals((long)mtimeFile, (long)hdfs.getFileStatus(file).getModificationTime());
            Assert.assertEquals((long)atimeFile, (long)hdfs.getFileStatus(file).getAccessTime());
            Assert.assertEquals((long)mtimeDir, (long)hdfs.getFileStatus(dir).getModificationTime());
            Assert.assertEquals((long)mtimeLink, (long)hdfs.getFileLinkStatus(link).getModificationTime());
            Assert.assertEquals((long)atimeLink, (long)hdfs.getFileLinkStatus(link).getAccessTime());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCtime() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            long pre = Time.now();
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            long post = Time.now();
            long ctime = cluster.getNamesystem().getCTime();
            Assert.assertTrue((pre <= ctime ? 1 : 0) != 0);
            Assert.assertTrue((ctime <= post ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZeroBlockSize() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String tarFile = System.getProperty("test.cache.data", "build/test/cache") + "/" + HADOOP_2_7_ZER0_BLOCK_SIZE_TGZ;
        String testDir = PathUtils.getTestDirName(this.getClass());
        File dfsDir = new File(testDir, "image-with-zero-block-size");
        if (dfsDir.exists() && !FileUtil.fullyDelete((File)dfsDir)) {
            throw new IOException("Could not delete dfs directory '" + dfsDir + "'");
        }
        FileUtil.unTar((File)new File(tarFile), (File)new File(testDir));
        File nameDir = new File(dfsDir, "name");
        GenericTestUtils.assertExists((File)nameDir);
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).waitSafeMode(false).startupOption(HdfsServerConstants.StartupOption.UPGRADE).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testPath = new Path("/tmp/zeroBlockFile");
            Assert.assertTrue((String)"File /tmp/zeroBlockFile doesn't exist ", (boolean)fs.exists(testPath));
            Assert.assertTrue((String)"Name node didn't come up", (boolean)cluster.isNameNodeUp(0));
        }
        finally {
            cluster.shutdown();
            FileUtil.fullyDelete((File)dfsDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSupportBlockGroup() throws Exception {
        short GROUP_SIZE = (short)(testECPolicy.getNumDataUnits() + testECPolicy.getNumParityUnits());
        int BLOCK_SIZE = 0x800000;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 0x800000L);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(GROUP_SIZE).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.enableAllECPolicies(fs);
            Path parentDir = new Path("/ec-10-4");
            Path childDir = new Path(parentDir, "ec-3-2");
            ErasureCodingPolicy ec32Policy = SystemErasureCodingPolicies.getByID((byte)2);
            fs.mkdirs(parentDir);
            fs.mkdirs(childDir);
            fs.setErasureCodingPolicy(parentDir, testECPolicy.getName());
            fs.setErasureCodingPolicy(childDir, ec32Policy.getName());
            Path file_10_4 = new Path(parentDir, "striped_file_10_4");
            Path file_3_2 = new Path(childDir, "striped_file_3_2");
            byte[] bytes = StripedFileTestUtil.generateBytes(0x800000);
            DFSTestUtil.writeFile((FileSystem)fs, file_10_4, new String(bytes));
            DFSTestUtil.writeFile((FileSystem)fs, file_3_2, new String(bytes));
            fs.setSafeMode(SafeModeAction.ENTER);
            fs.saveNamespace();
            fs.setSafeMode(SafeModeAction.LEAVE);
            cluster.restartNameNodes();
            fs = cluster.getFileSystem();
            Assert.assertTrue((boolean)fs.exists(file_10_4));
            Assert.assertTrue((boolean)fs.exists(file_3_2));
            FSNamesystem fsn = cluster.getNamesystem();
            INodeFile inode = fsn.dir.getINode(file_10_4.toString()).asFile();
            Assert.assertTrue((boolean)inode.isStriped());
            Assert.assertEquals((long)testECPolicy.getId(), (long)inode.getErasureCodingPolicyID());
            BlockInfo[] blks = inode.getBlocks();
            Assert.assertEquals((long)1L, (long)blks.length);
            Assert.assertTrue((boolean)blks[0].isStriped());
            Assert.assertEquals((long)testECPolicy.getId(), (long)fs.getErasureCodingPolicy(file_10_4).getId());
            Assert.assertEquals((long)testECPolicy.getId(), (long)((BlockInfoStriped)blks[0]).getErasureCodingPolicy().getId());
            Assert.assertEquals((long)testECPolicy.getNumDataUnits(), (long)((BlockInfoStriped)blks[0]).getDataBlockNum());
            Assert.assertEquals((long)testECPolicy.getNumParityUnits(), (long)((BlockInfoStriped)blks[0]).getParityBlockNum());
            byte[] content = DFSTestUtil.readFileAsBytes((FileSystem)fs, file_10_4);
            Assert.assertArrayEquals((byte[])bytes, (byte[])content);
            inode = fsn.dir.getINode(file_3_2.toString()).asFile();
            Assert.assertTrue((boolean)inode.isStriped());
            Assert.assertEquals((long)SystemErasureCodingPolicies.getByID((byte)2).getId(), (long)inode.getErasureCodingPolicyID());
            blks = inode.getBlocks();
            Assert.assertEquals((long)1L, (long)blks.length);
            Assert.assertTrue((boolean)blks[0].isStriped());
            Assert.assertEquals((long)ec32Policy.getId(), (long)fs.getErasureCodingPolicy(file_3_2).getId());
            Assert.assertEquals((long)ec32Policy.getNumDataUnits(), (long)((BlockInfoStriped)blks[0]).getDataBlockNum());
            Assert.assertEquals((long)ec32Policy.getNumParityUnits(), (long)((BlockInfoStriped)blks[0]).getParityBlockNum());
            content = DFSTestUtil.readFileAsBytes((FileSystem)fs, file_3_2);
            Assert.assertArrayEquals((byte[])bytes, (byte[])content);
            ErasureCodingPolicy ecPolicy = fsn.getErasureCodingPolicy(parentDir.toString());
            Assert.assertNotNull((Object)ecPolicy);
            Assert.assertEquals((long)testECPolicy.getId(), (long)ecPolicy.getId());
            ecPolicy = fsn.getErasureCodingPolicy(childDir.toString());
            Assert.assertNotNull((Object)ecPolicy);
            Assert.assertEquals((long)ec32Policy.getId(), (long)ecPolicy.getId());
            ecPolicy = fsn.getErasureCodingPolicy("/");
            Assert.assertNull((Object)ecPolicy);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHasNonEcBlockUsingStripedIDForLoadFile() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(9).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            FSNamesystem fns = cluster.getNamesystem();
            String testDir = "/test_block_manager";
            String testFile = "testfile_loadfile";
            String testFilePath = testDir + "/" + testFile;
            String clientName = "testUser_loadfile";
            String clientMachine = "testMachine_loadfile";
            long blkId = -1L;
            long blkNumBytes = 1024L;
            long timestamp = 1426222918L;
            fs.mkdir(new Path(testDir), new FsPermission("755"));
            Path p = new Path(testFilePath);
            DFSTestUtil.createFile((FileSystem)fs, p, 0L, (short)1, 1L);
            BlockInfoContiguous cBlk = new BlockInfoContiguous(new Block(blkId, blkNumBytes, timestamp), 3);
            INodeFile file = (INodeFile)fns.getFSDirectory().getINode(testFilePath);
            file.toUnderConstruction(clientName, clientMachine);
            file.addBlock((BlockInfo)cBlk);
            TestINodeFile.toCompleteFile(file);
            fns.enterSafeMode(false);
            fns.saveNamespace(0L, 0L);
            cluster.restartNameNodes();
            cluster.waitActive();
            fns = cluster.getNamesystem();
            Assert.assertTrue((boolean)fns.getBlockManager().hasNonEcBlockUsingStripedID());
            fs = cluster.getFileSystem();
            fs.delete(p, false);
            fns.enterSafeMode(false);
            fns.saveNamespace(0L, 0L);
            cluster.restartNameNodes();
            cluster.waitActive();
            fns = cluster.getNamesystem();
            Assert.assertFalse((boolean)fns.getBlockManager().hasNonEcBlockUsingStripedID());
            cluster.shutdown();
            cluster = null;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHasNonEcBlockUsingStripedIDForLoadUCFile() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(9).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            FSNamesystem fns = cluster.getNamesystem();
            String testDir = "/test_block_manager";
            String testFile = "testfile_loaducfile";
            String testFilePath = testDir + "/" + testFile;
            String clientName = "testUser_loaducfile";
            String clientMachine = "testMachine_loaducfile";
            long blkId = -1L;
            long blkNumBytes = 1024L;
            long timestamp = 1426222918L;
            fs.mkdir(new Path(testDir), new FsPermission("755"));
            Path p = new Path(testFilePath);
            DFSTestUtil.createFile((FileSystem)fs, p, 0L, (short)1, 1L);
            BlockInfoContiguous cBlk = new BlockInfoContiguous(new Block(blkId, blkNumBytes, timestamp), 3);
            INodeFile file = (INodeFile)fns.getFSDirectory().getINode(testFilePath);
            file.toUnderConstruction(clientName, clientMachine);
            file.addBlock((BlockInfo)cBlk);
            fns.enterSafeMode(false);
            fns.saveNamespace(0L, 0L);
            cluster.restartNameNodes();
            cluster.waitActive();
            fns = cluster.getNamesystem();
            Assert.assertTrue((boolean)fns.getBlockManager().hasNonEcBlockUsingStripedID());
            cluster.shutdown();
            cluster = null;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHasNonEcBlockUsingStripedIDForLoadSnapshot() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(9).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            FSNamesystem fns = cluster.getNamesystem();
            String testDir = "/test_block_manager";
            String testFile = "testfile_loadSnapshot";
            String testFilePath = testDir + "/" + testFile;
            String clientName = "testUser_loadSnapshot";
            String clientMachine = "testMachine_loadSnapshot";
            long blkId = -1L;
            long blkNumBytes = 1024L;
            long timestamp = 1426222918L;
            Path d = new Path(testDir);
            fs.mkdir(d, new FsPermission("755"));
            fs.allowSnapshot(d);
            Path p = new Path(testFilePath);
            DFSTestUtil.createFile((FileSystem)fs, p, 0L, (short)1, 1L);
            BlockInfoContiguous cBlk = new BlockInfoContiguous(new Block(blkId, blkNumBytes, timestamp), 3);
            INodeFile file = (INodeFile)fns.getFSDirectory().getINode(testFilePath);
            file.toUnderConstruction(clientName, clientMachine);
            file.addBlock((BlockInfo)cBlk);
            TestINodeFile.toCompleteFile(file);
            fs.createSnapshot(d, "testHasNonEcBlockUsingStripeID");
            fs.truncate(p, 0L);
            fns.enterSafeMode(false);
            fns.saveNamespace(0L, 0L);
            cluster.restartNameNodes();
            cluster.waitActive();
            fns = cluster.getNamesystem();
            Assert.assertTrue((boolean)fns.getBlockManager().hasNonEcBlockUsingStripedID());
            cluster.shutdown();
            cluster = null;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testBlockTypeProtoDefaultsToContiguous() throws Exception {
        FsImageProto.INodeSection.INodeFile.Builder builder = FsImageProto.INodeSection.INodeFile.newBuilder();
        FsImageProto.INodeSection.INodeFile inodeFile = builder.build();
        BlockType defaultBlockType = PBHelperClient.convert((HdfsProtos.BlockTypeProto)inodeFile.getBlockType());
        Assert.assertEquals((Object)defaultBlockType, (Object)BlockType.CONTIGUOUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveAndLoadFileUnderReplicationPolicyDir() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.enableAllECPolicies(fs);
            ErasureCodingPolicy replicaPolicy = SystemErasureCodingPolicies.getReplicationPolicy();
            ErasureCodingPolicy defaultEcPolicy = StripedFileTestUtil.getDefaultECPolicy();
            Path ecDir = new Path("/ec");
            Path replicaDir = new Path(ecDir, "replica");
            Path replicaFile1 = new Path(replicaDir, "f1");
            Path replicaFile2 = new Path(replicaDir, "f2");
            fs.mkdir(ecDir, null);
            fs.setErasureCodingPolicy(ecDir, defaultEcPolicy.getName());
            fs.mkdir(replicaDir, null);
            fs.setErasureCodingPolicy(replicaDir, replicaPolicy.getName());
            fs.create(replicaFile1).close();
            FSDataOutputStream out = fs.create(replicaFile2, (short)2);
            out.writeBytes("hello");
            ((DFSOutputStream)out.getWrappedStream()).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
            fs.setSafeMode(SafeModeAction.ENTER);
            fs.saveNamespace();
            fs.setSafeMode(SafeModeAction.LEAVE);
            cluster.restartNameNode(new String[0]);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Assert.assertTrue((boolean)fs.getFileStatus(ecDir).isDirectory());
            Assert.assertTrue((boolean)fs.getFileStatus(replicaDir).isDirectory());
            Assert.assertTrue((boolean)fs.exists(replicaFile1));
            Assert.assertTrue((boolean)fs.exists(replicaFile2));
            Assert.assertEquals((String)"Directory should have default EC policy.", (Object)defaultEcPolicy, (Object)fs.getErasureCodingPolicy(ecDir));
            Assert.assertEquals((String)"Directory should hide replication EC policy.", null, (Object)fs.getErasureCodingPolicy(replicaDir));
            Assert.assertEquals((String)"File should not have EC policy.", null, (Object)fs.getErasureCodingPolicy(replicaFile1));
            INodeFile file2Node = fsn.dir.getINode4Write(replicaFile2.toString()).asFile();
            Assert.assertEquals((long)"hello".length(), (long)file2Node.computeFileSize());
            Assert.assertTrue((boolean)file2Node.isUnderConstruction());
            BlockInfo[] blks = file2Node.getBlocks();
            Assert.assertEquals((long)1L, (long)blks.length);
            Assert.assertEquals((Object)HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, (Object)blks[0].getBlockUCState());
            Assert.assertEquals((String)"File should return expected replication factor.", (long)2L, (long)blks[0].getReplication());
            Assert.assertEquals((String)"File should not have EC policy.", null, (Object)fs.getErasureCodingPolicy(replicaFile2));
            LeaseManager.Lease lease = fsn.leaseManager.getLease(file2Node);
            Assert.assertNotNull((Object)lease);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testSaveAndLoadErasureCodingPolicies() throws IOException {
        Configuration conf = new Configuration();
        int blockSize = 0x1000000;
        conf.setLong("dfs.blocksize", 0x1000000L);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(10).build();){
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.enableAllECPolicies(fs);
            fs.setSafeMode(SafeModeAction.ENTER);
            fs.saveNamespace();
            fs.setSafeMode(SafeModeAction.LEAVE);
            cluster.restartNameNodes();
            cluster.waitActive();
            Assert.assertEquals((String)"Erasure coding policy number should match", (long)SystemErasureCodingPolicies.getPolicies().size(), (long)ErasureCodingPolicyManager.getInstance().getPolicies().length);
            ECSchema newSchema = new ECSchema("rs", 5, 4);
            ErasureCodingPolicy newPolicy = new ErasureCodingPolicy(newSchema, 2048, -2);
            ErasureCodingPolicy[] policies = new ErasureCodingPolicy[]{newPolicy};
            AddErasureCodingPolicyResponse[] ret = fs.addErasureCodingPolicies(policies);
            Assert.assertEquals((long)1L, (long)ret.length);
            Assert.assertEquals((Object)true, (Object)ret[0].isSucceed());
            newPolicy = ret[0].getPolicy();
            fs.setSafeMode(SafeModeAction.ENTER);
            fs.saveNamespace();
            fs.setSafeMode(SafeModeAction.LEAVE);
            cluster.restartNameNodes();
            cluster.waitActive();
            Assert.assertEquals((String)"Erasure coding policy number should match", (long)(SystemErasureCodingPolicies.getPolicies().size() + 1), (long)ErasureCodingPolicyManager.getInstance().getPolicies().length);
            ErasureCodingPolicy ecPolicy = ErasureCodingPolicyManager.getInstance().getByID(newPolicy.getId());
            Assert.assertEquals((String)"Newly added erasure coding policy is not found", (Object)newPolicy, (Object)ecPolicy);
            Assert.assertEquals((String)"Newly added erasure coding policy should be of disabled state", (Object)ErasureCodingPolicyState.DISABLED, (Object)DFSTestUtil.getECPolicyState(ecPolicy));
            this.testChangeErasureCodingPolicyState(cluster, 0x1000000, newPolicy, false);
            this.testChangeErasureCodingPolicyState(cluster, 0x1000000, SystemErasureCodingPolicies.getByID((byte)1), true);
            this.testChangeErasureCodingPolicyState(cluster, 0x1000000, SystemErasureCodingPolicies.getByID((byte)2), false);
        }
    }

    private void testChangeErasureCodingPolicyState(MiniDFSCluster cluster, int blockSize, ErasureCodingPolicy targetPolicy, boolean isDefault) throws IOException {
        DistributedFileSystem fs = cluster.getFileSystem();
        fs.enableErasureCodingPolicy(targetPolicy.getName());
        Path dirPath = new Path("/striped");
        Path filePath = new Path(dirPath, "file");
        int fileLength = blockSize * targetPolicy.getNumDataUnits();
        fs.mkdirs(dirPath);
        fs.setErasureCodingPolicy(dirPath, targetPolicy.getName());
        byte[] bytes = StripedFileTestUtil.generateBytes(fileLength);
        DFSTestUtil.writeFile((FileSystem)fs, filePath, bytes);
        fs.setSafeMode(SafeModeAction.ENTER);
        fs.saveNamespace();
        fs.setSafeMode(SafeModeAction.LEAVE);
        cluster.restartNameNodes();
        cluster.waitActive();
        ErasureCodingPolicy ecPolicy = ErasureCodingPolicyManager.getInstance().getByID(targetPolicy.getId());
        Assert.assertEquals((String)"The erasure coding policy is not found", (Object)targetPolicy, (Object)ecPolicy);
        Assert.assertEquals((String)"The erasure coding policy should be of enabled state", (Object)ErasureCodingPolicyState.ENABLED, (Object)DFSTestUtil.getECPolicyState(ecPolicy));
        Assert.assertTrue((String)"Policy should be in disabled state in FSImage!", (boolean)this.isPolicyEnabledInFsImage(targetPolicy));
        DFSTestUtil.readFileAsBytes((FileSystem)fs, filePath);
        fs.disableErasureCodingPolicy(ecPolicy.getName());
        fs.setSafeMode(SafeModeAction.ENTER);
        fs.saveNamespace();
        fs.setSafeMode(SafeModeAction.LEAVE);
        cluster.restartNameNodes();
        cluster.waitActive();
        ecPolicy = ErasureCodingPolicyManager.getInstance().getByID(targetPolicy.getId());
        Assert.assertEquals((String)"The erasure coding policy is not found", (Object)targetPolicy, (Object)ecPolicy);
        ErasureCodingPolicyState ecPolicyState = DFSTestUtil.getECPolicyState(ecPolicy);
        if (isDefault) {
            Assert.assertEquals((String)"The erasure coding policy should be of enabled state", (Object)ErasureCodingPolicyState.ENABLED, (Object)ecPolicyState);
        } else {
            Assert.assertEquals((String)"The erasure coding policy should be of disabled state", (Object)ErasureCodingPolicyState.DISABLED, (Object)ecPolicyState);
        }
        Assert.assertFalse((String)"Policy should be in disabled state in FSImage!", (boolean)this.isPolicyEnabledInFsImage(targetPolicy));
        DFSTestUtil.readFileAsBytes((FileSystem)fs, filePath);
        try {
            fs.removeErasureCodingPolicy(ecPolicy.getName());
        }
        catch (RemoteException e) {
            Assert.assertTrue((String)"Built-in policy cannot be removed", (boolean)ecPolicy.isSystemPolicy());
            GenericTestUtils.assertExceptionContains((String)"System erasure coding policy", (Throwable)e);
            return;
        }
        fs.removeErasureCodingPolicy(ecPolicy.getName());
        fs.setSafeMode(SafeModeAction.ENTER);
        fs.saveNamespace();
        fs.setSafeMode(SafeModeAction.LEAVE);
        cluster.restartNameNodes();
        cluster.waitActive();
        ecPolicy = ErasureCodingPolicyManager.getInstance().getByID(targetPolicy.getId());
        Assert.assertEquals((String)"The erasure coding policy saved into and loaded from fsImage is bad", (Object)targetPolicy, (Object)ecPolicy);
        Assert.assertEquals((String)"The erasure coding policy should be of removed state", (Object)ErasureCodingPolicyState.REMOVED, (Object)DFSTestUtil.getECPolicyState(ecPolicy));
        DFSTestUtil.readFileAsBytes((FileSystem)fs, filePath);
        fs.delete(dirPath, true);
    }

    private boolean isPolicyEnabledInFsImage(ErasureCodingPolicy testPolicy) {
        ErasureCodingPolicyInfo[] persistedPolicies;
        for (ErasureCodingPolicyInfo p : persistedPolicies = ErasureCodingPolicyManager.getInstance().getPersistedPolicies()) {
            if (!p.getPolicy().getName().equals(testPolicy.getName())) continue;
            return p.isEnabled();
        }
        throw new AssertionError((Object)"Policy is not found!");
    }

    private ArrayList<FsImageProto.FileSummary.Section> getSubSectionsOfName(ArrayList<FsImageProto.FileSummary.Section> sections, FSImageFormatProtobuf.SectionName name) {
        ArrayList<FsImageProto.FileSummary.Section> subSec = new ArrayList<FsImageProto.FileSummary.Section>();
        for (FsImageProto.FileSummary.Section s : sections) {
            if (!s.getName().equals(name.toString())) continue;
            subSec.add(s);
        }
        return subSec;
    }

    private MiniDFSCluster createAndLoadParallelFSImage(Configuration conf) throws IOException {
        Path f;
        int j;
        Path dir;
        int i;
        conf.set("dfs.image.parallel.load", "true");
        conf.set("dfs.image.parallel.inode.threshold", "1");
        conf.set("dfs.image.parallel.target.sections", "4");
        conf.set("dfs.image.parallel.threads", "4");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        String baseDir = "/abc/def";
        for (i = 0; i < 10; ++i) {
            dir = new Path(baseDir + "/" + i);
            for (j = 0; j < 5; ++j) {
                f = new Path(dir, Integer.toString(j));
                FSDataOutputStream os = fs.create(f);
                os.write(1);
                os.close();
            }
        }
        fs.setSafeMode(SafeModeAction.ENTER);
        fs.saveNamespace();
        fs.setSafeMode(SafeModeAction.LEAVE);
        cluster.restartNameNode(new String[0]);
        cluster.waitActive();
        fs = cluster.getFileSystem();
        for (i = 0; i < 10; ++i) {
            dir = new Path(baseDir + "/" + i);
            Assert.assertTrue((boolean)fs.getFileStatus(dir).isDirectory());
            for (j = 0; j < 5; ++j) {
                f = new Path(dir, Integer.toString(j));
                Assert.assertTrue((boolean)fs.exists(f));
            }
        }
        return cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelSaveAndLoad() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = this.createAndLoadParallelFSImage(conf);
            FsImageProto.FileSummary summary = FSImageTestUtil.getLatestImageSummary(cluster);
            ArrayList sections = Lists.newArrayList((Iterable)summary.getSectionsList());
            ArrayList<FsImageProto.FileSummary.Section> inodeSubSections = this.getSubSectionsOfName(sections, FSImageFormatProtobuf.SectionName.INODE_SUB);
            ArrayList<FsImageProto.FileSummary.Section> dirSubSections = this.getSubSectionsOfName(sections, FSImageFormatProtobuf.SectionName.INODE_DIR_SUB);
            FsImageProto.FileSummary.Section inodeSection = this.getSubSectionsOfName(sections, FSImageFormatProtobuf.SectionName.INODE).get(0);
            FsImageProto.FileSummary.Section dirSection = this.getSubSectionsOfName(sections, FSImageFormatProtobuf.SectionName.INODE_DIR).get(0);
            Assert.assertEquals((long)4L, (long)inodeSubSections.size());
            Assert.assertEquals((long)4L, (long)dirSubSections.size());
            this.ensureSubSectionsAlignWithParent(inodeSubSections, inodeSection);
            this.ensureSubSectionsAlignWithParent(dirSubSections, dirSection);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoParallelSectionsWithCompressionEnabled() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.image.compress", true);
        conf.set("dfs.image.compression.codec", "org.apache.hadoop.io.compress.GzipCodec");
        MiniDFSCluster cluster = null;
        try {
            cluster = this.createAndLoadParallelFSImage(conf);
            FsImageProto.FileSummary summary = FSImageTestUtil.getLatestImageSummary(cluster);
            ArrayList sections = Lists.newArrayList((Iterable)summary.getSectionsList());
            ArrayList<FsImageProto.FileSummary.Section> inodeSubSections = this.getSubSectionsOfName(sections, FSImageFormatProtobuf.SectionName.INODE_SUB);
            ArrayList<FsImageProto.FileSummary.Section> dirSubSections = this.getSubSectionsOfName(sections, FSImageFormatProtobuf.SectionName.INODE_DIR_SUB);
            Assert.assertEquals((long)0L, (long)inodeSubSections.size());
            Assert.assertEquals((long)0L, (long)dirSubSections.size());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void ensureSubSectionsAlignWithParent(ArrayList<FsImageProto.FileSummary.Section> subSec, FsImageProto.FileSummary.Section parent) {
        for (int i = 0; i < subSec.size() - 1; ++i) {
            FsImageProto.FileSummary.Section s = subSec.get(i);
            long endOffset = s.getOffset() + s.getLength();
            Assert.assertEquals((long)subSec.get(i + 1).getOffset(), (long)endOffset);
        }
        FsImageProto.FileSummary.Section lastSubSection = subSec.get(subSec.size() - 1);
        Assert.assertEquals((long)(parent.getLength() + parent.getOffset()), (long)(lastSubSection.getLength() + lastSubSection.getOffset()));
        Assert.assertEquals((long)parent.getOffset(), (long)subSec.get(0).getOffset());
    }

    @Test
    public void testUpdateBlocksMapAndNameCacheAsync() throws IOException {
        Path file;
        int j;
        Path dir;
        int i;
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        FSDirectory fsdir = cluster.getNameNode().namesystem.getFSDirectory();
        File workingDir = GenericTestUtils.getTestDir();
        File preRestartTree = new File(workingDir, "preRestartTree");
        File postRestartTree = new File(workingDir, "postRestartTree");
        Path baseDir = new Path("/user/foo");
        fs.mkdirs(baseDir);
        fs.allowSnapshot(baseDir);
        for (i = 0; i < 5; ++i) {
            dir = new Path(baseDir, Integer.toString(i));
            fs.mkdirs(dir);
            for (j = 0; j < 5; ++j) {
                file = new Path(dir, Integer.toString(j));
                FSDataOutputStream os = fs.create(file);
                os.write((int)((byte)j));
                os.close();
            }
            fs.createSnapshot(baseDir, "snap_" + i);
            fs.rename(new Path(dir, "0"), new Path(dir, "renamed"));
        }
        SnapshotTestHelper.dumpTree2File(fsdir, preRestartTree);
        fs.setSafeMode(SafeModeAction.ENTER);
        fs.saveNamespace();
        fs.setSafeMode(SafeModeAction.LEAVE);
        cluster.restartNameNode(new String[0]);
        cluster.waitActive();
        fs = cluster.getFileSystem();
        fsdir = cluster.getNameNode().namesystem.getFSDirectory();
        for (i = 0; i < 5; ++i) {
            dir = new Path(baseDir, Integer.toString(i));
            Assert.assertTrue((boolean)fs.getFileStatus(dir).isDirectory());
            for (j = 0; j < 5; ++j) {
                file = new Path(dir, Integer.toString(j));
                if (j == 0) {
                    file = new Path(dir, "renamed");
                }
                FSDataInputStream in = fs.open(file);
                byte n = in.readByte();
                Assert.assertEquals((long)j, (long)n);
                in.close();
            }
        }
        SnapshotTestHelper.dumpTree2File(fsdir, postRestartTree);
        SnapshotTestHelper.compareDumpedTreeInFile(preRestartTree, postRestartTree, true);
    }
}

