/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.Statistic;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatistic;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatisticGroup;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatistics;
import org.apache.hive.spark.counter.SparkCounter;
import org.apache.hive.spark.counter.SparkCounterGroup;
import org.apache.hive.spark.counter.SparkCounters;

public class SparkStatisticsBuilder {
    private Map<String, List<SparkStatistic>> statisticMap = new LinkedHashMap<String, List<SparkStatistic>>();

    public SparkStatistics build() {
        LinkedList<SparkStatisticGroup> statisticGroups = new LinkedList<SparkStatisticGroup>();
        for (Map.Entry<String, List<SparkStatistic>> entry : this.statisticMap.entrySet()) {
            String groupName = entry.getKey();
            List<SparkStatistic> statisticList = entry.getValue();
            statisticGroups.add(new SparkStatisticGroup(groupName, statisticList));
        }
        return new SparkStatistics(statisticGroups);
    }

    public SparkStatisticsBuilder add(SparkCounters sparkCounters) {
        for (SparkCounterGroup counterGroup : sparkCounters.getSparkCounterGroups().values()) {
            String groupDisplayName = counterGroup.getGroupDisplayName();
            List<SparkStatistic> statisticList = this.statisticMap.get(groupDisplayName);
            if (statisticList == null) {
                statisticList = new LinkedList<SparkStatistic>();
                this.statisticMap.put(groupDisplayName, statisticList);
            }
            for (SparkCounter counter : counterGroup.getSparkCounters().values()) {
                String displayName = counter.getDisplayName();
                statisticList.add(new SparkStatistic(displayName, Long.toString(counter.getValue())));
            }
        }
        return this;
    }

    public SparkStatisticsBuilder add(String groupName, String name, String value) {
        List<SparkStatistic> statisticList = this.statisticMap.get(groupName);
        if (statisticList == null) {
            statisticList = new LinkedList<SparkStatistic>();
            this.statisticMap.put(groupName, statisticList);
        }
        statisticList.add(new SparkStatistic(name, value));
        return this;
    }
}

