/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.antlr.runtime.ClassicToken;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeVisitor;
import org.antlr.runtime.tree.TreeVisitorAction;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcRel;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.adapter.jdbc.JdbcTable;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.FilterMergeRule;
import org.apache.calcite.rel.rules.JoinToMultiJoinRule;
import org.apache.calcite.rel.rules.LoptOptimizeJoinRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDialectFactory;
import org.apache.calcite.sql.SqlDialectFactoryImpl;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.CompositeList;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSubquerySemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteViewSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveConfPlannerContext;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveDefaultRelMetadataProvider;
import org.apache.hadoop.hive.ql.optimizer.calcite.HivePlannerContext;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOpMaterializationValidator;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRexExecutorImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTypeSystemImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveAlgorithmsConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveVolcanoPlanner;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveExcept;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveGroupingID;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIntersect;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableFunctionScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.JdbcHiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregateJoinTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregateProjectMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregatePullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregateReduceFunctionsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveAggregateReduceRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveDruidRules;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveExceptRewriteRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveExpandDistinctAggregatesRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterAggregateTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterProjectTSTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterProjectTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterSetOpTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveFilterSortTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveInsertExchange4JoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveIntersectMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveIntersectRewriteRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinAddNotNullRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinCommuteRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinProjectTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinPushTransitivePredicatesRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveJoinToMultiJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePartitionPruneRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePointLookupOptimizerRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePreFilteringRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectFilterPullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectOverIntersectRemoveRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectSortTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveReduceExpressionsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveReduceExpressionsWithStatsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRelDecorrelator;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRelFieldTrimmer;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRemoveGBYSemiJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRemoveSqCountCheck;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRulesRegistry;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSemiJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortJoinReduceRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortLimitPullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortProjectTransposeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortRemoveRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortUnionReduceRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSubQueryRemoveRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveUnionMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveUnionPullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveWindowingFixRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCAbstractSplitFilterRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCAggregationPushDownRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCExtractJoinFilterRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCFilterJoinRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCFilterPushDownRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCJoinPushDownRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCProjectPushDownRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCSortPushDownRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCUnionPushDownRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveAggregateIncrementalRewritingRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveNoAggregateIncrementalRewritingRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.MaterializedViewRewritingRelVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.HiveOpConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.JoinCondTypeCheckProcFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.JoinTypeCheckCtx;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.PlanModifierForReturnPath;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.RexNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ColumnStatsList;
import org.apache.hadoop.hive.ql.parse.DruidSqlOperatorConverter;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.NamedJoinInfo;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBExpr;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.QBSubQuery;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SubQueryUtils;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArray;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFInline;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.joda.time.Interval;

public class CalcitePlanner
extends SemanticAnalyzer {
    private final AtomicInteger noColsMissingStats = new AtomicInteger(0);
    private SemanticException semanticException;
    private boolean runCBO = true;
    private boolean disableSemJoinReordering = true;
    private EnumSet<ExtendedCBOProfile> profilesCBO;

    public CalcitePlanner(QueryState queryState) throws SemanticException {
        super(queryState);
        if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED)) {
            this.runCBO = false;
            this.disableSemJoinReordering = false;
        }
    }

    public void resetCalciteConfiguration() {
        if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED)) {
            this.runCBO = true;
            this.disableSemJoinReordering = true;
        }
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (this.runCBO) {
            super.analyzeInternal(ast, new SemanticAnalyzer.PlannerContextFactory(){

                @Override
                public SemanticAnalyzer.PlannerContext create() {
                    return new PreCboCtx();
                }
            });
        } else {
            super.analyzeInternal(ast);
        }
    }

    public RelNode genLogicalPlan(ASTNode ast) throws SemanticException {
        this.LOG.info("Starting generating logical plan");
        PreCboCtx cboCtx = new PreCboCtx();
        this.processPositionAlias(ast);
        if (!this.genResolvedParseTree(ast, cboCtx)) {
            return null;
        }
        ASTNode queryForCbo = ast;
        if (cboCtx.type == PreCboCtx.Type.CTAS || cboCtx.type == PreCboCtx.Type.VIEW) {
            queryForCbo = cboCtx.nodeOfInterest;
        }
        this.runCBO = this.canCBOHandleAst(queryForCbo, this.getQB(), cboCtx);
        if (!this.runCBO) {
            return null;
        }
        this.profilesCBO = CalcitePlanner.obtainCBOProfiles(this.queryProperties);
        this.disableJoinMerge = true;
        RelNode resPlan = this.logicalPlan();
        this.LOG.info("Finished generating logical plan");
        return resPlan;
    }

    public static RelOptPlanner createPlanner(HiveConf conf) {
        return CalcitePlanner.createPlanner(conf, new HashSet<RelNode>(), new HashSet<RelNode>());
    }

    private static RelOptPlanner createPlanner(HiveConf conf, Set<RelNode> corrScalarRexSQWithAgg, Set<RelNode> scalarAggNoGbyNoWin) {
        Double maxSplitSize = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE);
        Double maxMemory = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
        HiveAlgorithmsConf algorithmsConf = new HiveAlgorithmsConf(maxSplitSize, maxMemory);
        HiveRulesRegistry registry = new HiveRulesRegistry();
        Properties calciteConfigProperties = new Properties();
        calciteConfigProperties.setProperty(CalciteConnectionProperty.TIME_ZONE.camelName(), conf.getLocalTimeZone().getId());
        calciteConfigProperties.setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), Boolean.FALSE.toString());
        CalciteConnectionConfigImpl calciteConfig = new CalciteConnectionConfigImpl(calciteConfigProperties);
        boolean isCorrelatedColumns = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_CORRELATED_MULTI_KEY_JOINS);
        boolean heuristicMaterializationStrategy = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_SELECTION_STRATEGY).equals("heuristic");
        HivePlannerContext confContext = new HivePlannerContext(algorithmsConf, registry, (CalciteConnectionConfig)calciteConfig, corrScalarRexSQWithAgg, scalarAggNoGbyNoWin, new HiveConfPlannerContext(isCorrelatedColumns, heuristicMaterializationStrategy));
        return HiveVolcanoPlanner.createPlanner(confContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    Operator genOPTree(ASTNode ast, SemanticAnalyzer.PlannerContext plannerCtx) throws SemanticException {
        sinkOp = null;
        skipCalcitePlan = false;
        if (!this.runCBO) {
            skipCalcitePlan = true;
        } else {
            cboCtx = (PreCboCtx)plannerCtx;
            oldHints = new ArrayList<ASTNode>();
            this.getHintsFromQB(this.getQB(), oldHints);
            queryForCbo = ast;
            if (PreCboCtx.access$000(cboCtx) == PreCboCtx.Type.CTAS || PreCboCtx.access$000(cboCtx) == PreCboCtx.Type.VIEW) {
                queryForCbo = PreCboCtx.access$100(cboCtx);
            }
            this.runCBO = this.canCBOHandleAst(queryForCbo, this.getQB(), cboCtx);
            if (this.queryProperties.hasMultiDestQuery()) {
                this.handleMultiDestQuery(ast, cboCtx);
            }
            if (this.runCBO) {
                this.profilesCBO = CalcitePlanner.obtainCBOProfiles(this.queryProperties);
                this.disableJoinMerge = true;
                reAnalyzeAST = false;
                materializedView = this.getQB().isMaterializedView();
                try {
                    if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP)) {
                        if (PreCboCtx.access$000(cboCtx) == PreCboCtx.Type.VIEW && !materializedView) {
                            throw new SemanticException("Create view is not supported in cbo return path.");
                        }
                        sinkOp = this.getOptimizedHiveOPDag();
                        if (oldHints.size() > 0) {
                            this.LOG.debug("Propagating hints to QB: " + oldHints);
                            this.getQB().getParseInfo().setHintList(oldHints);
                        }
                        this.LOG.info("CBO Succeeded; optimized logical plan.");
                        this.ctx.setCboInfo("Plan optimized by CBO.");
                        this.ctx.setCboSucceeded(true);
                    }
                    newAST = this.getOptimizedAST();
                    newAST = this.fixUpAfterCbo(ast, newAST, cboCtx);
                    if (this.mvRebuildMode == SemanticAnalyzer.MaterializationRebuildMode.AGGREGATE_REBUILD) {
                        this.fixUpASTAggregateIncrementalRebuild(newAST);
                    } else if (this.mvRebuildMode == SemanticAnalyzer.MaterializationRebuildMode.NO_AGGREGATE_REBUILD) {
                        this.fixUpASTNoAggregateIncrementalRebuild(newAST);
                    }
                    if (PreCboCtx.access$000(cboCtx) == PreCboCtx.Type.VIEW && !materializedView) {
                        try {
                            this.handleCreateViewDDL(newAST);
                        }
                        catch (SemanticException e) {
                            throw new CalciteViewSemanticException(e.getMessage());
                        }
                    } else if (PreCboCtx.access$000(cboCtx) == PreCboCtx.Type.VIEW && materializedView) {
                        originalText = this.ctx.getTokenRewriteStream().toString(PreCboCtx.access$100(cboCtx).getTokenStartIndex(), PreCboCtx.access$100(cboCtx).getTokenStopIndex());
                        this.unparseTranslator.applyTranslations(this.ctx.getTokenRewriteStream());
                        expandedText = this.ctx.getTokenRewriteStream().toString(PreCboCtx.access$100(cboCtx).getTokenStartIndex(), PreCboCtx.access$100(cboCtx).getTokenStopIndex());
                        this.init(false);
                        this.setAST(newAST);
                        newAST = this.reAnalyzeViewAfterCbo(newAST);
                        this.createVwDesc.setViewOriginalText(originalText);
                        this.createVwDesc.setViewExpandedText(expandedText);
                        this.viewSelect = newAST;
                        this.viewsExpanded = new ArrayList<E>();
                        this.viewsExpanded.add(this.createVwDesc.getViewName());
                    } else if (PreCboCtx.access$000(cboCtx) == PreCboCtx.Type.CTAS) {
                        this.init(false);
                        this.setAST(newAST);
                        newAST = this.reAnalyzeCTASAfterCbo(newAST);
                    } else {
                        this.init(false);
                    }
                    if (oldHints.size() > 0) {
                        if (this.getQB().getParseInfo().getHints() != null) {
                            this.LOG.warn("Hints are not null in the optimized tree; after CBO " + this.getQB().getParseInfo().getHints().dump());
                        } else {
                            this.LOG.debug("Propagating hints to QB: " + oldHints);
                            this.getQB().getParseInfo().setHintList(oldHints);
                        }
                    }
                    ctx_1 = this.initPhase1Ctx();
                    if (!this.doPhase1(newAST, this.getQB(), ctx_1, null)) {
                        throw new RuntimeException("Couldn't do phase1 on CBO optimized query plan");
                    }
                    this.getMetaData(this.getQB());
                    this.disableJoinMerge = this.defaultJoinMerge;
                    sinkOp = this.genPlan(this.getQB());
                    this.LOG.info("CBO Succeeded; optimized logical plan.");
                    this.ctx.setCboInfo("Plan optimized by CBO.");
                    this.ctx.setCboSucceeded(true);
                    if (!this.LOG.isTraceEnabled()) ** GOTO lbl127
                    this.LOG.trace(newAST.dump());
                }
                catch (Exception e) {
                    v0 = isMissingStats = this.noColsMissingStats.get() > 0;
                    if (isMissingStats) {
                        this.LOG.error("CBO failed due to missing column stats (see previous errors), skipping CBO");
                        this.ctx.setCboInfo("Plan not optimized by CBO due to missing statistics. Please check log for more details.");
                    } else {
                        this.LOG.error("CBO failed, skipping CBO. ", (Throwable)e);
                        if (e instanceof CalciteSemanticException) {
                            calciteSemanticException = (CalciteSemanticException)e;
                            unsupportedFeature = calciteSemanticException.getUnsupportedFeature();
                            if (unsupportedFeature != null) {
                                this.ctx.setCboInfo("Plan not optimized by CBO due to missing feature [" + (Object)unsupportedFeature + "].");
                            } else {
                                this.ctx.setCboInfo("Plan not optimized by CBO.");
                            }
                        } else {
                            this.ctx.setCboInfo("Plan not optimized by CBO.");
                        }
                    }
                    if (e instanceof CalciteSubquerySemanticException) {
                        throw new SemanticException(e);
                    }
                    if (e instanceof CalciteViewSemanticException) {
                        throw new SemanticException(e);
                    }
                    if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) || isMissingStats || e instanceof CalciteSemanticException) {
                        reAnalyzeAST = true;
                    }
                    if (e instanceof SemanticException && !this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
                        reAnalyzeAST = true;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof SemanticException) {
                        throw e;
                    }
                    throw new SemanticException(e);
                }
                finally {
                    this.runCBO = false;
                    this.disableJoinMerge = this.defaultJoinMerge;
                    this.disableSemJoinReordering = false;
                    if (reAnalyzeAST) {
                        this.init(true);
                        this.prunedPartitions.clear();
                        super.genResolvedParseTree(ast, new SemanticAnalyzer.PlannerContext());
                        skipCalcitePlan = true;
                    }
                }
            } else {
                this.ctx.setCboInfo("Plan not optimized by CBO.");
                skipCalcitePlan = true;
            }
        }
lbl127:
        // 7 sources

        if (skipCalcitePlan) {
            sinkOp = super.genOPTree(ast, plannerCtx);
        }
        return sinkOp;
    }

    private void handleCreateViewDDL(ASTNode newAST) throws SemanticException {
        this.saveViewDefinition();
        String originalText = this.createVwDesc.getViewOriginalText();
        String expandedText = this.createVwDesc.getViewExpandedText();
        List<FieldSchema> schema = this.createVwDesc.getSchema();
        List<FieldSchema> partitionColumns = this.createVwDesc.getPartCols();
        this.init(false);
        this.setAST(newAST);
        newAST = this.reAnalyzeViewAfterCbo(newAST);
        this.createVwDesc.setViewOriginalText(originalText);
        this.createVwDesc.setViewExpandedText(expandedText);
        this.createVwDesc.setSchema(schema);
        this.createVwDesc.setPartCols(partitionColumns);
    }

    private void handleMultiDestQuery(ASTNode ast, PreCboCtx cboCtx) throws SemanticException {
        if (!this.runCBO) {
            return;
        }
        if (CalcitePlanner.isJoinToken(cboCtx.nodeOfInterest)) {
            ASTNode subq = this.rewriteASTForMultiInsert(ast, cboCtx.nodeOfInterest);
            if (subq != null) {
                cboCtx.nodeOfInterest = (ASTNode)subq.getChild(0);
                QB newQB = new QB(null, "", false);
                SemanticAnalyzer.Phase1Ctx ctx_1 = this.initPhase1Ctx();
                this.doPhase1(cboCtx.nodeOfInterest, newQB, ctx_1, null);
                this.setQB(newQB);
                this.getMetaData(this.getQB());
            } else {
                this.runCBO = false;
            }
        } else if (cboCtx.nodeOfInterest.getToken().getType() == 1026) {
            ASTNode subq = cboCtx.nodeOfInterest;
            cboCtx.nodeOfInterest = (ASTNode)subq.getChild(0);
            String subQAlias = CalcitePlanner.unescapeIdentifier(subq.getChild(1).getText());
            QB newQB = this.getQB().getSubqForAlias(subQAlias).getQB();
            newQB.getParseInfo().setAlias("");
            newQB.getParseInfo().setIsSubQ(false);
            this.setQB(newQB);
        } else {
            this.runCBO = false;
        }
    }

    private ASTNode rewriteASTForMultiInsert(ASTNode query, ASTNode nodeOfInterest) {
        ArrayListMultimap aliasNodes = ArrayListMultimap.create();
        final AtomicBoolean notSupported = new AtomicBoolean(false);
        TreeVisitorAction action = new TreeVisitorAction((Multimap)aliasNodes){
            final /* synthetic */ Multimap val$aliasNodes;
            {
                this.val$aliasNodes = multimap;
            }

            public Object pre(Object t) {
                if (!notSupported.get()) {
                    Object p;
                    if (ParseDriver.adaptor.getType(t) == 713) {
                        notSupported.set(true);
                    } else if (ParseDriver.adaptor.getType(t) == 16) {
                        Object c = ParseDriver.adaptor.getChild(t, 0);
                        if (c != null && ParseDriver.adaptor.getType(c) == 1058) {
                            this.val$aliasNodes.put((Object)((ASTNode)t).toStringTree(), t);
                        }
                    } else if (ParseDriver.adaptor.getType(t) == 1058 && ((p = ParseDriver.adaptor.getParent(t)) == null || ParseDriver.adaptor.getType(p) != 16)) {
                        this.val$aliasNodes.put((Object)((ASTNode)t).toStringTree(), t);
                    }
                }
                return t;
            }

            public Object post(Object t) {
                return t;
            }
        };
        TreeVisitor tv = new TreeVisitor(ParseDriver.adaptor);
        for (int i = 0; i < query.getChildCount(); ++i) {
            ASTNode child = (ASTNode)query.getChild(i);
            if (ParseDriver.adaptor.getType((Object)child) != 859) continue;
            tv.visit((Object)child, action);
        }
        if (notSupported.get()) {
            return null;
        }
        ASTNode from = new ASTNode((Token)new CommonToken(840, "TOK_FROM"));
        from.addChild((Tree)((ASTNode)ParseDriver.adaptor.dupTree((Object)nodeOfInterest)));
        ASTNode destination = new ASTNode((Token)new CommonToken(810, "TOK_DESTINATION"));
        ASTNode dir = new ASTNode((Token)new CommonToken(812, "TOK_DIR"));
        ASTNode tmpFile = new ASTNode((Token)new CommonToken(1073, "TOK_TMP_FILE"));
        dir.addChild((Tree)tmpFile);
        destination.addChild((Tree)dir);
        ASTNode select = new ASTNode((Token)new CommonToken(983, "TOK_SELECT"));
        int num = 0;
        for (Collection selectIdentifier : aliasNodes.asMap().values()) {
            Iterator it = selectIdentifier.iterator();
            ASTNode node = (ASTNode)it.next();
            ASTNode selectExpr = new ASTNode((Token)new CommonToken(985, "TOK_SELEXPR"));
            selectExpr.addChild((Tree)((ASTNode)ParseDriver.adaptor.dupTree((Object)node)));
            String colAlias = "col" + num;
            selectExpr.addChild((Tree)new ASTNode((Token)new CommonToken(24, colAlias)));
            select.addChild((Tree)selectExpr);
            ASTNode colExpr = new ASTNode((Token)new CommonToken(1058, "TOK_TABLE_OR_COL"));
            colExpr.addChild((Tree)new ASTNode((Token)new CommonToken(24, colAlias)));
            CalcitePlanner.replaceASTChild(node, colExpr);
            while (it.hasNext()) {
                node = (ASTNode)it.next();
                colExpr = new ASTNode((Token)new CommonToken(1058, "TOK_TABLE_OR_COL"));
                colExpr.addChild((Tree)new ASTNode((Token)new CommonToken(24, colAlias)));
                CalcitePlanner.replaceASTChild(node, colExpr);
            }
            ++num;
        }
        ASTNode insert = new ASTNode((Token)new CommonToken(859, "TOK_INSERT"));
        insert.addChild((Tree)destination);
        insert.addChild((Tree)select);
        ASTNode newQuery = new ASTNode((Token)new CommonToken(954, "TOK_QUERY"));
        newQuery.addChild((Tree)from);
        newQuery.addChild((Tree)insert);
        ASTNode subq = new ASTNode((Token)new CommonToken(1026, "TOK_SUBQUERY"));
        subq.addChild((Tree)newQuery);
        subq.addChild((Tree)new ASTNode((Token)new CommonToken(24, "subq")));
        CalcitePlanner.replaceASTChild(nodeOfInterest, subq);
        return subq;
    }

    boolean canCBOHandleAst(ASTNode ast, QB qb, PreCboCtx cboCtx) {
        boolean result;
        int root = ast.getToken().getType();
        boolean needToLogMessage = STATIC_LOG.isInfoEnabled();
        boolean isSupportedRoot = root == 954 || root == 830 || qb.isCTAS() || qb.isMaterializedView();
        boolean isSupportedType = qb.getIsQuery() || qb.isCTAS() || qb.isMaterializedView() || cboCtx.type == PreCboCtx.Type.INSERT || cboCtx.type == PreCboCtx.Type.MULTI_INSERT;
        boolean noBadTokens = HiveCalciteUtil.validateASTForUnsupportedTokens(ast);
        boolean bl = result = isSupportedRoot && isSupportedType && noBadTokens;
        if (!result) {
            if (needToLogMessage) {
                String msg = "";
                if (!isSupportedRoot) {
                    msg = msg + "doesn't have QUERY or EXPLAIN as root and not a CTAS; ";
                }
                if (!isSupportedType) {
                    msg = msg + "is not a query with at least one source table  or there is a subquery without a source table, or CTAS, or insert; ";
                }
                if (!noBadTokens) {
                    msg = msg + "has unsupported tokens; ";
                }
                if (msg.isEmpty()) {
                    msg = msg + "has some unspecified limitations; ";
                }
                STATIC_LOG.info("Not invoking CBO because the statement " + msg.substring(0, msg.length() - 2));
            }
            return false;
        }
        String msg = CalcitePlanner.canHandleQbForCbo(this.queryProperties, this.conf, true, needToLogMessage, qb);
        if (msg == null) {
            return true;
        }
        if (needToLogMessage) {
            STATIC_LOG.info("Not invoking CBO because the statement " + msg.substring(0, msg.length() - 2));
        }
        return false;
    }

    static String canHandleQbForCbo(QueryProperties queryProperties, HiveConf conf, boolean topLevelQB, boolean verbose, QB qb) {
        if (!(queryProperties.hasClusterBy() || queryProperties.hasDistributeBy() || queryProperties.hasSortBy() || queryProperties.hasPTF() || queryProperties.usesScript() || !queryProperties.isCBOSupportedLateralViews())) {
            return null;
        }
        String msg = "";
        if (verbose) {
            if (queryProperties.hasClusterBy()) {
                msg = msg + "has cluster by; ";
            }
            if (queryProperties.hasDistributeBy()) {
                msg = msg + "has distribute by; ";
            }
            if (queryProperties.hasSortBy()) {
                msg = msg + "has sort by; ";
            }
            if (queryProperties.hasPTF()) {
                msg = msg + "has PTF; ";
            }
            if (queryProperties.usesScript()) {
                msg = msg + "uses scripts; ";
            }
            if (queryProperties.hasLateralViews()) {
                msg = msg + "has lateral views; ";
            }
            if (msg.isEmpty()) {
                msg = msg + "has some unspecified limitations; ";
            }
        }
        return msg;
    }

    private static EnumSet<ExtendedCBOProfile> obtainCBOProfiles(QueryProperties queryProperties) {
        EnumSet<ExtendedCBOProfile> profilesCBO = EnumSet.noneOf(ExtendedCBOProfile.class);
        if (queryProperties.getJoinCount() > 1) {
            profilesCBO.add(ExtendedCBOProfile.JOIN_REORDERING);
        }
        if (queryProperties.hasWindowing()) {
            profilesCBO.add(ExtendedCBOProfile.WINDOWING_POSTPROCESSING);
        }
        return profilesCBO;
    }

    @Override
    boolean isCBOExecuted() {
        return this.runCBO;
    }

    @Override
    boolean isCBOSupportedLateralView(ASTNode lateralView) {
        if (lateralView.getToken().getType() == 880) {
            return false;
        }
        ASTNode lvFunc = (ASTNode)lateralView.getChild(0).getChild(0).getChild(0);
        String lvFuncName = lvFunc.getChild(0).getText();
        if (lvFuncName.compareToIgnoreCase(GenericUDTFInline.class.getAnnotation(Description.class).name()) != 0) {
            return false;
        }
        if (lvFunc.getChildCount() != 2) {
            return false;
        }
        ASTNode innerFunc = (ASTNode)lvFunc.getChild(1);
        return innerFunc.getToken().getType() == 842 && innerFunc.getChild(0).getText().compareToIgnoreCase(GenericUDFArray.class.getAnnotation(Description.class).name()) == 0;
    }

    @Override
    boolean continueJoinMerge() {
        return !this.runCBO || !this.disableSemJoinReordering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Table materializeCTE(String cteName, SemanticAnalyzer.CTEClause cte) throws HiveException {
        ASTNode createTable = new ASTNode((Token)new ClassicToken(783));
        ASTNode tableName = new ASTNode((Token)new ClassicToken(1061));
        tableName.addChild((Tree)new ASTNode((Token)new ClassicToken(24, cteName)));
        ASTNode temporary = new ASTNode((Token)new ClassicToken(305, "$MATERIALIZATION"));
        createTable.addChild((Tree)tableName);
        createTable.addChild((Tree)temporary);
        createTable.addChild((Tree)cte.cteNode);
        CalcitePlanner analyzer = new CalcitePlanner(this.queryState);
        analyzer.initCtx(this.ctx);
        analyzer.init(false);
        analyzer.aliasToCTEs.putAll(this.aliasToCTEs);
        HiveOperation operation = this.queryState.getHiveOperation();
        try {
            analyzer.analyzeInternal(createTable);
        }
        finally {
            this.queryState.setCommandType(operation);
        }
        Table table = analyzer.tableDesc.toTable(this.conf);
        Path location = table.getDataLocation();
        try {
            location.getFileSystem((Configuration)this.conf).mkdirs(location);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        table.setMaterializedTable(true);
        this.LOG.info(cteName + " will be materialized into " + location);
        cte.table = table;
        cte.source = analyzer;
        this.ctx.addMaterializedTable(cteName, table);
        this.ctx.addMaterializedTable(table.getFullyQualifiedName(), table);
        return table;
    }

    private void fixUpASTAggregateIncrementalRebuild(ASTNode newAST) throws SemanticException {
        ASTNode updateNode = new ASTSearcher().simpleBreadthFirstSearch(newAST, 954, 859);
        ASTNode destinationNode = (ASTNode)updateNode.getChild(0);
        ASTNode newInsertInto = (ASTNode)ParseDriver.adaptor.create(860, "TOK_INSERT_INTO");
        newInsertInto.addChildren(destinationNode.getChildren());
        ASTNode destinationParentNode = (ASTNode)destinationNode.getParent();
        int childIndex = destinationNode.childIndex;
        destinationParentNode.deleteChild(childIndex);
        destinationParentNode.insertChild(childIndex, newInsertInto);
        ASTNode materializationNode = new ASTSearcher().simpleBreadthFirstSearch(newInsertInto, 860, 1033, 1061);
        ASTNode updateParent = (ASTNode)updateNode.getParent();
        ASTNode insertNode = (ASTNode)ParseDriver.adaptor.dupTree((Object)updateNode);
        insertNode.setParent((Tree)updateParent);
        updateParent.addChild((Tree)insertNode);
        ASTNode subqueryNodeInputROJ = new ASTSearcher().simpleBreadthFirstSearch(newAST, 954, 840, 977, 1026);
        ASTNode selectNodeInputROJ = new ASTSearcher().simpleBreadthFirstSearch(subqueryNodeInputROJ, 1026, 954, 859, 983);
        ASTNode selectExprNodeInputROJ = (ASTNode)ParseDriver.adaptor.create(985, "TOK_SELEXPR");
        ASTNode dotNodeInputROJ = (ASTNode)ParseDriver.adaptor.create(16, ".");
        ASTNode columnTokNodeInputROJ = (ASTNode)ParseDriver.adaptor.create(1058, "TOK_TABLE_OR_COL");
        ASTNode tableNameNodeInputROJ = (ASTNode)ParseDriver.adaptor.create(24, Warehouse.getQualifiedName((String)materializationNode.getChild(0).getText(), (String)materializationNode.getChild(1).getText()));
        ASTNode rowIdNodeInputROJ = (ASTNode)ParseDriver.adaptor.create(24, VirtualColumn.ROWID.getName());
        ParseDriver.adaptor.addChild((Object)selectNodeInputROJ, (Object)selectExprNodeInputROJ);
        ParseDriver.adaptor.addChild((Object)selectExprNodeInputROJ, (Object)dotNodeInputROJ);
        ParseDriver.adaptor.addChild((Object)dotNodeInputROJ, (Object)columnTokNodeInputROJ);
        ParseDriver.adaptor.addChild((Object)dotNodeInputROJ, (Object)rowIdNodeInputROJ);
        ParseDriver.adaptor.addChild((Object)columnTokNodeInputROJ, (Object)tableNameNodeInputROJ);
        ASTNode selectNodeInUpdate = (ASTNode)updateNode.getChild(1);
        if (selectNodeInUpdate.getType() != 983) {
            throw new SemanticException("TOK_SELECT expected in incremental rewriting");
        }
        ASTNode selectExprNodeInUpdate = (ASTNode)ParseDriver.adaptor.dupNode((Object)selectExprNodeInputROJ);
        ASTNode dotNodeInUpdate = (ASTNode)ParseDriver.adaptor.dupNode((Object)dotNodeInputROJ);
        ASTNode columnTokNodeInUpdate = (ASTNode)ParseDriver.adaptor.dupNode((Object)columnTokNodeInputROJ);
        ASTNode tableNameNodeInUpdate = (ASTNode)ParseDriver.adaptor.dupNode((Object)subqueryNodeInputROJ.getChild(1));
        ASTNode rowIdNodeInUpdate = (ASTNode)ParseDriver.adaptor.dupNode((Object)rowIdNodeInputROJ);
        ParseDriver.adaptor.addChild((Object)selectExprNodeInUpdate, (Object)dotNodeInUpdate);
        ParseDriver.adaptor.addChild((Object)dotNodeInUpdate, (Object)columnTokNodeInUpdate);
        ParseDriver.adaptor.addChild((Object)dotNodeInUpdate, (Object)rowIdNodeInUpdate);
        ParseDriver.adaptor.addChild((Object)columnTokNodeInUpdate, (Object)tableNameNodeInUpdate);
        selectNodeInUpdate.insertChild(0, ParseDriver.adaptor.dupTree((Object)selectExprNodeInUpdate));
        ASTNode whereClauseInUpdate = null;
        for (int i = 0; i < ((ArrayList)updateNode.getChildren()).size(); ++i) {
            if (updateNode.getChild(i).getType() != 1099) continue;
            whereClauseInUpdate = (ASTNode)updateNode.getChild(i);
            break;
        }
        if (whereClauseInUpdate == null) {
            throw new SemanticException("TOK_WHERE expected in incremental rewriting");
        }
        if (whereClauseInUpdate.getChild(0).getType() != 215) {
            throw new SemanticException("OR clause expected below TOK_WHERE in incremental rewriting");
        }
        ASTNode newCondInUpdate = (ASTNode)whereClauseInUpdate.getChild(0).getChild(0);
        ParseDriver.adaptor.setChild((Object)whereClauseInUpdate, 0, (Object)newCondInUpdate);
        ASTNode sortExprNode = (ASTNode)ParseDriver.adaptor.create(1019, "TOK_SORTBY");
        ASTNode orderExprNode = (ASTNode)ParseDriver.adaptor.create(1063, "TOK_TABSORTCOLNAMEASC");
        ASTNode nullsOrderExprNode = (ASTNode)ParseDriver.adaptor.create(904, "TOK_NULLS_FIRST");
        ASTNode dotNodeInSort = (ASTNode)ParseDriver.adaptor.dupTree((Object)dotNodeInUpdate);
        ParseDriver.adaptor.addChild((Object)updateNode, (Object)sortExprNode);
        ParseDriver.adaptor.addChild((Object)sortExprNode, (Object)orderExprNode);
        ParseDriver.adaptor.addChild((Object)orderExprNode, (Object)nullsOrderExprNode);
        ParseDriver.adaptor.addChild((Object)nullsOrderExprNode, (Object)dotNodeInSort);
        ASTNode whereClauseInInsert = null;
        for (int i = 0; i < ((ArrayList)insertNode.getChildren()).size(); ++i) {
            if (insertNode.getChild(i).getType() != 1099) continue;
            whereClauseInInsert = (ASTNode)insertNode.getChild(i);
            break;
        }
        if (whereClauseInInsert == null) {
            throw new SemanticException("TOK_WHERE expected in incremental rewriting");
        }
        if (whereClauseInInsert.getChild(0).getType() != 215) {
            throw new SemanticException("OR clause expected below TOK_WHERE in incremental rewriting");
        }
        ASTNode newCondInInsert = (ASTNode)whereClauseInInsert.getChild(0).getChild(1);
        ParseDriver.adaptor.setChild((Object)whereClauseInInsert, 0, (Object)newCondInInsert);
        this.ctx.setOperation(Context.Operation.MERGE);
        this.ctx.addDestNamePrefix(1, Context.DestClausePrefix.UPDATE);
        this.ctx.addDestNamePrefix(2, Context.DestClausePrefix.INSERT);
    }

    private void fixUpASTNoAggregateIncrementalRebuild(ASTNode newAST) throws SemanticException {
        ASTNode dest = new ASTSearcher().simpleBreadthFirstSearch(newAST, 954, 859, 810);
        ASTNode newChild = (ASTNode)ParseDriver.adaptor.create(860, "TOK_INSERT_INTO");
        newChild.addChildren(dest.getChildren());
        ASTNode destParent = (ASTNode)dest.getParent();
        int childIndex = dest.childIndex;
        destParent.deleteChild(childIndex);
        destParent.insertChild(childIndex, newChild);
    }

    @Override
    String fixCtasColumnName(String colName) {
        if (this.runCBO) {
            int lastDot = colName.lastIndexOf(46);
            if (lastDot < 0) {
                return colName;
            }
            String nqColumnName = colName.substring(lastDot + 1);
            STATIC_LOG.debug("Replacing " + colName + " (produced by CBO) by " + nqColumnName);
            return nqColumnName;
        }
        return super.fixCtasColumnName(colName);
    }

    ASTNode fixUpAfterCbo(ASTNode originalAst, ASTNode newAst, PreCboCtx cboCtx) throws SemanticException {
        switch (cboCtx.type) {
            case NONE: {
                return newAst;
            }
            case CTAS: 
            case VIEW: {
                CalcitePlanner.replaceASTChild(cboCtx.nodeOfInterest, newAst);
                return originalAst;
            }
            case INSERT: {
                ASTNode newDest = new ASTSearcher().simpleBreadthFirstSearch(newAst, 954, 859, 810);
                if (newDest == null) {
                    this.LOG.error("Cannot find destination after CBO; new ast is " + newAst.dump());
                    throw new SemanticException("Cannot find destination after CBO");
                }
                CalcitePlanner.replaceASTChild(newDest, cboCtx.nodeOfInterest);
                return newAst;
            }
            case MULTI_INSERT: {
                CalcitePlanner.replaceASTChild(cboCtx.nodeOfInterest, newAst);
                return originalAst;
            }
        }
        throw new AssertionError((Object)("Unexpected type " + (Object)((Object)cboCtx.type)));
    }

    ASTNode reAnalyzeCTASAfterCbo(ASTNode newAst) throws SemanticException {
        if ((newAst = this.analyzeCreateTable(newAst, this.getQB(), null)) == null) {
            this.LOG.error("analyzeCreateTable failed to initialize CTAS after CBO; new ast is " + this.getAST().dump());
            throw new SemanticException("analyzeCreateTable failed to initialize CTAS after CBO");
        }
        return newAst;
    }

    ASTNode reAnalyzeViewAfterCbo(ASTNode newAst) throws SemanticException {
        if ((newAst = this.analyzeCreateView(newAst, this.getQB(), null)) == null) {
            this.LOG.error("analyzeCreateTable failed to initialize materialized view after CBO; new ast is " + this.getAST().dump());
            throw new SemanticException("analyzeCreateTable failed to initialize materialized view after CBO");
        }
        return newAst;
    }

    private static void replaceASTChild(ASTNode child, ASTNode newChild) {
        ASTNode parent = (ASTNode)child.parent;
        int childIndex = child.childIndex;
        parent.deleteChild(childIndex);
        parent.insertChild(childIndex, newChild);
    }

    RelNode logicalPlan() throws SemanticException {
        RelNode optimizedOptiqPlan = null;
        CalcitePlannerAction calcitePlannerAction = null;
        if (this.columnAccessInfo == null) {
            this.columnAccessInfo = new ColumnAccessInfo();
        }
        calcitePlannerAction = new CalcitePlannerAction(this.prunedPartitions, this.ctx.getOpContext().getColStatsCache(), this.columnAccessInfo);
        try {
            optimizedOptiqPlan = (RelNode)Frameworks.withPlanner((Frameworks.PlannerAction)calcitePlannerAction, (FrameworkConfig)Frameworks.newConfigBuilder().typeSystem((RelDataTypeSystem)new HiveTypeSystemImpl()).build());
        }
        catch (Exception e) {
            this.rethrowCalciteException(e);
            throw new AssertionError((Object)("rethrowCalciteException didn't throw for " + e.getMessage()));
        }
        return optimizedOptiqPlan;
    }

    ASTNode getOptimizedAST() throws SemanticException {
        RelNode optimizedOptiqPlan = this.logicalPlan();
        ASTNode optiqOptimizedAST = ASTConverter.convert(optimizedOptiqPlan, this.resultSchema, HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COLUMN_ALIGNMENT));
        return optiqOptimizedAST;
    }

    Operator getOptimizedHiveOPDag() throws SemanticException {
        RelNode optimizedOptiqPlan = null;
        CalcitePlannerAction calcitePlannerAction = null;
        if (this.columnAccessInfo == null) {
            this.columnAccessInfo = new ColumnAccessInfo();
        }
        calcitePlannerAction = new CalcitePlannerAction(this.prunedPartitions, this.ctx.getOpContext().getColStatsCache(), this.columnAccessInfo);
        try {
            optimizedOptiqPlan = (RelNode)Frameworks.withPlanner((Frameworks.PlannerAction)calcitePlannerAction, (FrameworkConfig)Frameworks.newConfigBuilder().typeSystem((RelDataTypeSystem)new HiveTypeSystemImpl()).build());
        }
        catch (Exception e) {
            this.rethrowCalciteException(e);
            throw new AssertionError((Object)("rethrowCalciteException didn't throw for " + e.getMessage()));
        }
        RelNode modifiedOptimizedOptiqPlan = PlanModifierForReturnPath.convertOpTree(optimizedOptiqPlan, this.resultSchema, this.getQB().getTableDesc() != null);
        this.LOG.debug("Translating the following plan:\n" + RelOptUtil.toString((RelNode)modifiedOptimizedOptiqPlan));
        Operator hiveRoot = new HiveOpConverter(this, this.conf, this.unparseTranslator, this.topOps).convert(modifiedOptimizedOptiqPlan);
        RowResolver hiveRootRR = this.genRowResolver(hiveRoot, this.getQB());
        this.opParseCtx.put(hiveRoot, new OpParseContext(hiveRootRR));
        String dest = this.getQB().getParseInfo().getClauseNames().iterator().next();
        if (this.getQB().getParseInfo().getDestSchemaForClause(dest) != null && this.getQB().getTableDesc() == null) {
            Operator<?> selOp = this.handleInsertStatement(dest, hiveRoot, hiveRootRR, this.getQB());
            return this.genFileSinkPlan(dest, this.getQB(), selOp);
        }
        return this.genFileSinkPlan(dest, this.getQB(), hiveRoot);
    }

    Operator<?> handleInsertStatement(String dest, Operator<?> input, RowResolver inputRR, QB qb) throws SemanticException {
        ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
        ArrayList<ColumnInfo> columns = inputRR.getColumnInfos();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo col = columns.get(i);
            colList.add(new ExprNodeColumnDesc(col));
        }
        ASTNode selExprList = qb.getParseInfo().getSelForClause(dest);
        RowResolver out_rwsch = this.handleInsertStatementSpec(colList, dest, inputRR, inputRR, qb, selExprList);
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < colList.size(); ++i) {
            String outputCol = CalcitePlanner.getColumnInternalName(i);
            colExprMap.put(outputCol, colList.get(i));
            columnNames.add(outputCol);
        }
        Operator<SelectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(colList, columnNames), new RowSchema(out_rwsch.getColumnInfos()), input, new Operator[0]), out_rwsch);
        output.setColumnExprMap(colExprMap);
        return output;
    }

    private void rethrowCalciteException(Exception e) throws SemanticException {
        Throwable first = this.semanticException != null ? this.semanticException : e;
        Throwable current = first;
        Throwable cause = current.getCause();
        while (cause != null) {
            Throwable causeOfCause = cause.getCause();
            if (current == first && causeOfCause == null && this.isUselessCause(first)) {
                first = cause;
                break;
            }
            if (causeOfCause != null && this.isUselessCause(cause) && ExceptionHelper.resetCause(current, causeOfCause)) {
                cause = causeOfCause;
                continue;
            }
            current = cause;
            cause = current.getCause();
        }
        if (first instanceof RuntimeException) {
            throw (RuntimeException)first;
        }
        if (first instanceof SemanticException) {
            throw (SemanticException)first;
        }
        throw new RuntimeException(first);
    }

    private boolean isUselessCause(Throwable t) {
        return t instanceof RuntimeException || t instanceof InvocationTargetException || t instanceof UndeclaredThrowableException;
    }

    private RowResolver genRowResolver(Operator op, QB qb) {
        RowResolver rr = new RowResolver();
        String subqAlias = qb.getAliases().size() == 1 && qb.getSubqAliases().size() == 1 ? qb.getAliases().get(0) : null;
        for (ColumnInfo ci : op.getSchema().getSignature()) {
            try {
                rr.putWithCheck(subqAlias != null ? subqAlias : ci.getTabAlias(), ci.getAlias() != null ? ci.getAlias() : ci.getInternalName(), ci.getInternalName(), new ColumnInfo(ci));
            }
            catch (SemanticException e) {
                throw new RuntimeException(e);
            }
        }
        return rr;
    }

    private static enum TableType {
        DRUID,
        NATIVE,
        JDBC;

    }

    private class CalcitePlannerAction
    implements Frameworks.PlannerAction<RelNode> {
        private RelOptCluster cluster;
        private RelOptSchema relOptSchema;
        private final Map<String, PrunedPartitionList> partitionCache;
        private final Map<String, ColumnStatsList> colStatsCache;
        private final ColumnAccessInfo columnAccessInfo;
        private Map<HiveProject, Table> viewProjectToTableSchema;
        private int subqueryId;
        Set<RelNode> corrScalarRexSQWithAgg = new HashSet<RelNode>();
        Set<RelNode> scalarAggNoGbyNoWin = new HashSet<RelNode>();
        LinkedHashMap<RelNode, RowResolver> relToHiveRR = new LinkedHashMap();
        LinkedHashMap<RelNode, ImmutableMap<String, Integer>> relToHiveColNameCalcitePosMap = new LinkedHashMap();

        CalcitePlannerAction(Map<String, PrunedPartitionList> partitionCache, Map<String, ColumnStatsList> colStatsCache, ColumnAccessInfo columnAccessInfo) {
            this.partitionCache = partitionCache;
            this.colStatsCache = colStatsCache;
            this.columnAccessInfo = columnAccessInfo;
        }

        public RelNode apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
            RelOptCluster optCluster;
            RelNode calciteGenPlan = null;
            RelNode calcitePreCboPlan = null;
            RelNode calciteOptimizedPlan = null;
            this.subqueryId = -1;
            RelOptPlanner planner = CalcitePlanner.createPlanner(CalcitePlanner.this.conf, this.corrScalarRexSQWithAgg, this.scalarAggNoGbyNoWin);
            RexBuilder rexBuilder = cluster.getRexBuilder();
            this.cluster = optCluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)rexBuilder);
            this.relOptSchema = relOptSchema;
            PerfLogger perfLogger = SessionState.getPerfLogger();
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            try {
                calciteGenPlan = this.genLogicalPlan(CalcitePlanner.this.getQB(), true, null, null);
                CalcitePlanner.this.resultSchema = SemanticAnalyzer.convertRowSchemaToResultSetSchema(this.relToHiveRR.get(calciteGenPlan), CalcitePlanner.this.getQB().isView() ? false : HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_RESULTSET_USE_UNIQUE_COLUMN_NAMES));
            }
            catch (SemanticException e) {
                CalcitePlanner.this.semanticException = e;
                throw new RuntimeException(e);
            }
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Plan generation");
            HiveRelOpMaterializationValidator matValidator = new HiveRelOpMaterializationValidator();
            matValidator.validateQueryMaterialization(calciteGenPlan);
            if (!matValidator.isValidMaterialization()) {
                String reason = matValidator.getInvalidMaterializationReason();
                CalcitePlanner.this.setInvalidQueryMaterializationReason(reason);
            }
            HiveRexExecutorImpl executorProvider = new HiveRexExecutorImpl(optCluster);
            calciteGenPlan.getCluster().getPlanner().setExecutor((RexExecutor)executorProvider);
            HiveRelFieldTrimmer fieldTrimmer = new HiveRelFieldTrimmer(null, HiveRelFactories.HIVE_BUILDER.create(optCluster, null), this.columnAccessInfo, this.viewProjectToTableSchema);
            fieldTrimmer.trim(calciteGenPlan);
            HiveDefaultRelMetadataProvider mdProvider = new HiveDefaultRelMetadataProvider(CalcitePlanner.this.conf);
            RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)mdProvider.getMetadataProvider()));
            CalcitePlanner.this.LOG.debug("Plan before removing subquery:\n" + RelOptUtil.toString((RelNode)calciteGenPlan));
            calciteGenPlan = this.hepPlan(calciteGenPlan, false, mdProvider.getMetadataProvider(), null, new HiveSubQueryRemoveRule(CalcitePlanner.this.conf));
            CalcitePlanner.this.LOG.debug("Plan just after removing subquery:\n" + RelOptUtil.toString((RelNode)calciteGenPlan));
            calciteGenPlan = HiveRelDecorrelator.decorrelateQuery(calciteGenPlan);
            CalcitePlanner.this.LOG.debug("Plan after decorrelation:\n" + RelOptUtil.toString((RelNode)calciteGenPlan));
            calcitePreCboPlan = this.applyPreJoinOrderingTransforms(calciteGenPlan, mdProvider.getMetadataProvider(), (RexExecutor)executorProvider);
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_ENABLE_AUTO_REWRITING) && !CalcitePlanner.this.getQB().isMaterializedView() && !CalcitePlanner.this.ctx.isLoadingMaterializedView() && !CalcitePlanner.this.getQB().isCTAS()) {
                calcitePreCboPlan = this.applyMaterializedViewRewriting(planner, calcitePreCboPlan, mdProvider.getMetadataProvider(), (RexExecutor)executorProvider);
            }
            if (CalcitePlanner.this.profilesCBO.contains((Object)ExtendedCBOProfile.JOIN_REORDERING)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                try {
                    ArrayList list = Lists.newArrayList();
                    list.add(mdProvider.getMetadataProvider());
                    RelTraitSet desiredTraits = optCluster.traitSetOf(new RelTrait[]{HiveRelNode.CONVENTION, RelCollations.EMPTY});
                    HepProgramBuilder hepPgmBldr = new HepProgramBuilder().addMatchOrder(HepMatchOrder.BOTTOM_UP);
                    hepPgmBldr.addRuleInstance((RelOptRule)new JoinToMultiJoinRule(HiveJoin.class));
                    hepPgmBldr.addRuleInstance((RelOptRule)new LoptOptimizeJoinRule(HiveRelFactories.HIVE_BUILDER));
                    HepProgram hepPgm = hepPgmBldr.build();
                    HepPlanner hepPlanner = new HepPlanner(hepPgm);
                    hepPlanner.registerMetadataProviders((List)list);
                    RelMetadataProvider chainedProvider = ChainedRelMetadataProvider.of((List)list);
                    optCluster.setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(chainedProvider, (RelOptPlanner)hepPlanner));
                    RelNode rootRel = calcitePreCboPlan;
                    hepPlanner.setRoot(rootRel);
                    if (!calcitePreCboPlan.getTraitSet().equals((Object)desiredTraits)) {
                        rootRel = hepPlanner.changeTraits(calcitePreCboPlan, desiredTraits);
                    }
                    hepPlanner.setRoot(rootRel);
                    calciteOptimizedPlan = hepPlanner.findBestExp();
                }
                catch (Exception e) {
                    boolean isMissingStats;
                    boolean bl = isMissingStats = CalcitePlanner.this.noColsMissingStats.get() > 0;
                    if (isMissingStats) {
                        CalcitePlanner.this.LOG.warn("Missing column stats (see previous messages), skipping join reordering in CBO");
                        CalcitePlanner.this.noColsMissingStats.set(0);
                        calciteOptimizedPlan = calcitePreCboPlan;
                        CalcitePlanner.this.disableSemJoinReordering = false;
                    }
                    throw e;
                }
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Join Reordering");
            } else {
                calciteOptimizedPlan = calcitePreCboPlan;
                CalcitePlanner.this.disableSemJoinReordering = false;
            }
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, new RelOptRule[]{ProjectRemoveRule.INSTANCE, HiveUnionMergeRule.INSTANCE, HiveAggregateProjectMergeRule.INSTANCE, HiveProjectMergeRule.INSTANCE_NO_FORCE, HiveJoinCommuteRule.INSTANCE});
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Optimizations without stats 1");
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.AGGR_JOIN_TRANSPOSE)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                try {
                    calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, new RelOptRule[]{HiveAggregateJoinTransposeRule.INSTANCE});
                }
                catch (Exception e) {
                    boolean isMissingStats;
                    boolean bl = isMissingStats = CalcitePlanner.this.noColsMissingStats.get() > 0;
                    if (isMissingStats) {
                        CalcitePlanner.this.LOG.warn("Missing column stats (see previous messages), skipping aggregate-join transpose in CBO");
                        CalcitePlanner.this.noColsMissingStats.set(0);
                    }
                    throw e;
                }
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Aggregate join transpose");
            }
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.SEMIJOIN_CONVERSION)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HiveSemiJoinRule.INSTANCE_PROJECT, HiveSemiJoinRule.INSTANCE_AGGREGATE);
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Semijoin conversion");
            }
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HiveRemoveGBYSemiJoinRule.INSTANCE);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Removal of gby from semijoin");
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_REMOVE_SQ_COUNT_CHECK)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HiveRemoveSqCountCheck.INSTANCE);
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Removing sq_count_check UDF ");
            }
            if (CalcitePlanner.this.profilesCBO.contains((Object)ExtendedCBOProfile.WINDOWING_POSTPROCESSING)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, HiveWindowingFixRule.INSTANCE);
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Window fixing rule");
            }
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, new RelOptRule[]{HiveDruidRules.FILTER, HiveDruidRules.PROJECT_FILTER_TRANSPOSE, HiveDruidRules.AGGREGATE_FILTER_TRANSPOSE, HiveDruidRules.AGGREGATE_PROJECT, HiveDruidRules.PROJECT, HiveDruidRules.EXPAND_SINGLE_DISTINCT_AGGREGATES_DRUID_RULE, HiveDruidRules.AGGREGATE, HiveDruidRules.POST_AGGREGATION_PROJECT, HiveDruidRules.FILTER_AGGREGATE_TRANSPOSE, HiveDruidRules.FILTER_PROJECT_TRANSPOSE, HiveDruidRules.HAVING_FILTER_RULE, HiveDruidRules.SORT_PROJECT_TRANSPOSE, HiveDruidRules.SORT, HiveDruidRules.PROJECT_SORT_TRANSPOSE});
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Druid transformation rules");
            calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, true, mdProvider.getMetadataProvider(), null, HepMatchOrder.TOP_DOWN, new RelOptRule[]{JDBCExtractJoinFilterRule.INSTANCE, JDBCAbstractSplitFilterRule.SPLIT_FILTER_ABOVE_JOIN, JDBCAbstractSplitFilterRule.SPLIT_FILTER_ABOVE_CONVERTER, JDBCFilterJoinRule.INSTANCE, JDBCJoinPushDownRule.INSTANCE, JDBCUnionPushDownRule.INSTANCE, JDBCFilterPushDownRule.INSTANCE, JDBCProjectPushDownRule.INSTANCE, JDBCAggregationPushDownRule.INSTANCE, JDBCSortPushDownRule.INSTANCE});
            if (HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, true, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, new RelOptRule[]{HiveJoinProjectTransposeRule.BOTH_PROJECT_INCLUDE_OUTER, HiveJoinProjectTransposeRule.LEFT_PROJECT_INCLUDE_OUTER, HiveJoinProjectTransposeRule.RIGHT_PROJECT_INCLUDE_OUTER, HiveJoinToMultiJoinRule.INSTANCE, HiveProjectMergeRule.INSTANCE});
                fieldTrimmer = new HiveRelFieldTrimmer(null, HiveRelFactories.HIVE_BUILDER.create(optCluster, null));
                calciteOptimizedPlan = fieldTrimmer.trim(calciteOptimizedPlan);
                calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, new RelOptRule[]{ProjectRemoveRule.INSTANCE, new ProjectMergeRule(false, HiveRelFactories.HIVE_BUILDER)});
                calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, true, mdProvider.getMetadataProvider(), null, HiveFilterProjectTSTransposeRule.INSTANCE, HiveFilterProjectTSTransposeRule.INSTANCE_DRUID, HiveProjectFilterPullUpConstantsRule.INSTANCE);
                calciteOptimizedPlan = this.hepPlan(calciteOptimizedPlan, false, mdProvider.getMetadataProvider(), null, HepMatchOrder.BOTTOM_UP, HiveInsertExchange4JoinRule.EXCHANGE_BELOW_JOIN, HiveInsertExchange4JoinRule.EXCHANGE_BELOW_MULTIJOIN);
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Translation from Calcite tree to Hive tree");
            }
            if (CalcitePlanner.this.LOG.isDebugEnabled() && !CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
                CalcitePlanner.this.LOG.debug("CBO Planning details:\n");
                CalcitePlanner.this.LOG.debug("Original Plan:\n" + RelOptUtil.toString((RelNode)calciteGenPlan));
                CalcitePlanner.this.LOG.debug("Plan After PPD, PartPruning, ColumnPruning:\n" + RelOptUtil.toString((RelNode)calcitePreCboPlan));
                CalcitePlanner.this.LOG.debug("Plan After Join Reordering:\n" + RelOptUtil.toString((RelNode)calciteOptimizedPlan, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES));
            }
            return calciteOptimizedPlan;
        }

        private RelNode applyPreJoinOrderingTransforms(RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider) {
            PerfLogger perfLogger = SessionState.getPerfLogger();
            int maxCNFNodeCount = CalcitePlanner.this.conf.getIntVar(HiveConf.ConfVars.HIVE_CBO_CNF_NODES_LIMIT);
            int minNumORClauses = CalcitePlanner.this.conf.getIntVar(HiveConf.ConfVars.HIVEPOINTLOOKUPOPTIMIZERMIN);
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, true, mdProvider, null, HepMatchOrder.BOTTOM_UP, HiveProjectOverIntersectRemoveRule.INSTANCE, HiveIntersectMergeRule.INSTANCE, HiveUnionMergeRule.INSTANCE);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: HiveProjectOverIntersectRemoveRule, HiveIntersectMerge and HiveUnionMergeRule rules");
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, false, mdProvider, executorProvider, HepMatchOrder.BOTTOM_UP, HiveIntersectRewriteRule.INSTANCE);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: HiveIntersectRewrite rule");
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, false, mdProvider, executorProvider, HepMatchOrder.BOTTOM_UP, HiveExceptRewriteRule.INSTANCE);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: HiveExceptRewrite rule");
            if (!CalcitePlanner.this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("mr") && CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVEOPTIMIZEDISTINCTREWRITE)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                basePlan = this.hepPlan(basePlan, true, mdProvider, executorProvider, HiveExpandDistinctAggregatesRule.INSTANCE);
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, Distinct aggregate rewrite");
            }
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, false, mdProvider, executorProvider, HepMatchOrder.ARBITRARY, new HivePreFilteringRule(maxCNFNodeCount));
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, factor out common filter elements and separating deterministic vs non-deterministic UDF");
            ArrayList rules = Lists.newArrayList();
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVEOPTPPD_WINDOWING)) {
                rules.add(HiveFilterProjectTransposeRule.INSTANCE_DETERMINISTIC_WINDOWING);
            } else {
                rules.add(HiveFilterProjectTransposeRule.INSTANCE_DETERMINISTIC);
            }
            rules.add(HiveFilterSetOpTransposeRule.INSTANCE);
            rules.add(HiveFilterSortTransposeRule.INSTANCE);
            rules.add(HiveFilterJoinRule.JOIN);
            rules.add(HiveFilterJoinRule.FILTER_ON_JOIN);
            rules.add(new HiveFilterAggregateTransposeRule(Filter.class, HiveRelFactories.HIVE_BUILDER, Aggregate.class));
            rules.add(new FilterMergeRule(HiveRelFactories.HIVE_BUILDER));
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_REDUCE_WITH_STATS)) {
                rules.add(HiveReduceExpressionsWithStatsRule.INSTANCE);
            }
            rules.add(HiveProjectFilterPullUpConstantsRule.INSTANCE);
            rules.add(HiveReduceExpressionsRule.PROJECT_INSTANCE);
            rules.add(HiveReduceExpressionsRule.FILTER_INSTANCE);
            rules.add(HiveReduceExpressionsRule.JOIN_INSTANCE);
            rules.add(HiveAggregateReduceFunctionsRule.INSTANCE);
            rules.add(HiveAggregateReduceRule.INSTANCE);
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVEPOINTLOOKUPOPTIMIZER)) {
                rules.add(new HivePointLookupOptimizerRule.FilterCondition(minNumORClauses));
                rules.add(new HivePointLookupOptimizerRule.JoinCondition(minNumORClauses));
            }
            rules.add(HiveJoinAddNotNullRule.INSTANCE_JOIN);
            rules.add(HiveJoinAddNotNullRule.INSTANCE_SEMIJOIN);
            rules.add(HiveJoinPushTransitivePredicatesRule.INSTANCE_JOIN);
            rules.add(HiveJoinPushTransitivePredicatesRule.INSTANCE_SEMIJOIN);
            rules.add(HiveSortMergeRule.INSTANCE);
            rules.add(HiveSortLimitPullUpConstantsRule.INSTANCE);
            rules.add(HiveUnionPullUpConstantsRule.INSTANCE);
            rules.add(HiveAggregatePullUpConstantsRule.INSTANCE);
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, true, mdProvider, executorProvider, HepMatchOrder.BOTTOM_UP, rules.toArray(new RelOptRule[rules.size()]));
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, PPD, not null predicates, transitive inference, constant folding");
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_LIMIT_TRANSPOSE)) {
                perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
                float reductionProportion = HiveConf.getFloatVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_LIMIT_TRANSPOSE_REDUCTION_PERCENTAGE);
                long reductionTuples = HiveConf.getLongVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_LIMIT_TRANSPOSE_REDUCTION_TUPLES);
                basePlan = this.hepPlan(basePlan, true, mdProvider, executorProvider, new RelOptRule[]{HiveSortMergeRule.INSTANCE, HiveSortProjectTransposeRule.INSTANCE, HiveSortJoinReduceRule.INSTANCE, HiveSortUnionReduceRule.INSTANCE});
                basePlan = this.hepPlan(basePlan, true, mdProvider, executorProvider, HepMatchOrder.BOTTOM_UP, new HiveSortRemoveRule(reductionProportion, reductionTuples), HiveProjectSortTransposeRule.INSTANCE);
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, Push down limit through outer join");
            }
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, false, mdProvider, executorProvider, new HivePartitionPruneRule(CalcitePlanner.this.conf));
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, Partition Pruning");
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            HiveRelFieldTrimmer fieldTrimmer = new HiveRelFieldTrimmer(null, HiveRelFactories.HIVE_BUILDER.create(this.cluster, null), CalcitePlanner.this.profilesCBO.contains((Object)ExtendedCBOProfile.JOIN_REORDERING));
            basePlan = fieldTrimmer.trim(basePlan);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, Projection Pruning");
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, false, mdProvider, executorProvider, new RelOptRule[]{HiveProjectMergeRule.INSTANCE, ProjectRemoveRule.INSTANCE, HiveSortMergeRule.INSTANCE});
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, Merge Project-Project, Merge Sort-Sort");
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            basePlan = this.hepPlan(basePlan, true, mdProvider, executorProvider, HiveFilterProjectTSTransposeRule.INSTANCE, HiveFilterProjectTSTransposeRule.INSTANCE_DRUID, HiveProjectFilterPullUpConstantsRule.INSTANCE);
            perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: Prejoin ordering transformation, Rerun PPD");
            return basePlan;
        }

        private RelNode applyMaterializedViewRewriting(RelOptPlanner planner, RelNode basePlan, RelMetadataProvider mdProvider, RexExecutor executorProvider) {
            final RelOptCluster optCluster = basePlan.getCluster();
            PerfLogger perfLogger = SessionState.getPerfLogger();
            perfLogger.PerfLogBegin(this.getClass().getName(), "optimizer");
            RelNode calcitePreMVRewritingPlan = basePlan;
            List<Object> materializations = new ArrayList();
            try {
                materializations = CalcitePlanner.this.mvRebuildMode != SemanticAnalyzer.MaterializationRebuildMode.NONE ? Hive.get().getValidMaterializedView(CalcitePlanner.this.mvRebuildDbName, CalcitePlanner.this.mvRebuildName, this.getTablesUsed(basePlan), true) : Hive.get().getAllValidMaterializedViews(this.getTablesUsed(basePlan), false);
                materializations = Lists.transform(materializations, (Function)new Function<RelOptMaterialization, RelOptMaterialization>(){

                    public RelOptMaterialization apply(RelOptMaterialization materialization) {
                        RelNode newViewScan;
                        RelNode viewScan = materialization.tableRel;
                        if (viewScan instanceof Project) {
                            Project pq = (Project)viewScan;
                            newViewScan = HiveProject.create(optCluster, this.copyNodeScan(pq.getInput()), pq.getChildExps(), pq.getRowType(), Collections.emptyList());
                        } else {
                            newViewScan = this.copyNodeScan(viewScan);
                        }
                        return new RelOptMaterialization(newViewScan, materialization.queryRel, null, materialization.qualifiedTableName);
                    }

                    private RelNode copyNodeScan(RelNode scan) {
                        Object newScan;
                        if (scan instanceof DruidQuery) {
                            DruidQuery dq = (DruidQuery)scan;
                            newScan = DruidQuery.create((RelOptCluster)optCluster, (RelTraitSet)optCluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), (RelOptTable)scan.getTable(), (DruidTable)dq.getDruidTable(), (List)ImmutableList.of((Object)dq.getTableScan()));
                        } else {
                            newScan = new HiveTableScan(optCluster, optCluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), (RelOptHiveTable)scan.getTable(), (String)scan.getTable().getQualifiedName().get(0), null, false, false);
                        }
                        return newScan;
                    }
                });
            }
            catch (HiveException e) {
                CalcitePlanner.this.LOG.warn("Exception loading materialized views", (Throwable)e);
            }
            if (!materializations.isEmpty()) {
                optCluster.invalidateMetadataQuery();
                RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE));
                for (RelOptMaterialization relOptMaterialization : materializations) {
                    planner.addMaterialization(relOptMaterialization);
                }
                planner.addRule((RelOptRule)HiveMaterializedViewRule.INSTANCE_PROJECT_FILTER);
                planner.addRule((RelOptRule)HiveMaterializedViewRule.INSTANCE_FILTER);
                planner.addRule((RelOptRule)HiveMaterializedViewRule.INSTANCE_PROJECT_JOIN);
                planner.addRule((RelOptRule)HiveMaterializedViewRule.INSTANCE_JOIN);
                planner.addRule((RelOptRule)HiveMaterializedViewRule.INSTANCE_PROJECT_AGGREGATE);
                planner.addRule((RelOptRule)HiveMaterializedViewRule.INSTANCE_AGGREGATE);
                planner.setRoot(basePlan);
                basePlan = planner.findBestExp();
                planner.clear();
                optCluster.invalidateMetadataQuery();
                RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)mdProvider));
                perfLogger.PerfLogEnd(this.getClass().getName(), "optimizer", "Calcite: View-based rewriting");
                if (calcitePreMVRewritingPlan != basePlan) {
                    if (CalcitePlanner.this.mvRebuildMode == SemanticAnalyzer.MaterializationRebuildMode.INSERT_OVERWRITE_REBUILD && HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REBUILD_INCREMENTAL)) {
                        MaterializedViewRewritingRelVisitor visitor = new MaterializedViewRewritingRelVisitor();
                        visitor.go(basePlan);
                        if (visitor.isRewritingAllowed()) {
                            if (visitor.isContainsAggregate()) {
                                basePlan = this.hepPlan(basePlan, false, mdProvider, null, HepMatchOrder.TOP_DOWN, HiveAggregateIncrementalRewritingRule.INSTANCE);
                                CalcitePlanner.this.mvRebuildMode = SemanticAnalyzer.MaterializationRebuildMode.AGGREGATE_REBUILD;
                            } else {
                                basePlan = this.hepPlan(basePlan, false, mdProvider, null, HepMatchOrder.TOP_DOWN, HiveNoAggregateIncrementalRewritingRule.INSTANCE);
                                CalcitePlanner.this.mvRebuildMode = SemanticAnalyzer.MaterializationRebuildMode.NO_AGGREGATE_REBUILD;
                            }
                        }
                    }
                    basePlan = this.applyPreJoinOrderingTransforms(basePlan, mdProvider, executorProvider);
                }
            }
            return basePlan;
        }

        private List<String> getTablesUsed(RelNode plan) {
            final ArrayList<String> tablesUsed = new ArrayList<String>();
            new RelVisitor(){

                public void visit(RelNode node, int ordinal, RelNode parent) {
                    if (node instanceof TableScan) {
                        TableScan ts = (TableScan)node;
                        tablesUsed.add(((RelOptHiveTable)ts.getTable()).getHiveTableMD().getFullyQualifiedName());
                    }
                    super.visit(node, ordinal, parent);
                }
            }.go(plan);
            return tablesUsed;
        }

        private RelNode hepPlan(RelNode basePlan, boolean followPlanChanges, RelMetadataProvider mdProvider, RexExecutor executorProvider, RelOptRule ... rules) {
            return this.hepPlan(basePlan, followPlanChanges, mdProvider, executorProvider, HepMatchOrder.TOP_DOWN, rules);
        }

        private RelNode hepPlan(RelNode basePlan, boolean followPlanChanges, RelMetadataProvider mdProvider, RexExecutor executorProvider, HepMatchOrder order, RelOptRule ... rules) {
            RelNode optimizedRelNode = basePlan;
            HepProgramBuilder programBuilder = new HepProgramBuilder();
            if (followPlanChanges) {
                programBuilder.addMatchOrder(order);
                programBuilder = programBuilder.addRuleCollection((Collection)ImmutableList.copyOf((Object[])rules));
            } else {
                for (RelOptRule r : rules) {
                    programBuilder.addRuleInstance(r);
                }
            }
            HepPlanner planner = new HepPlanner(programBuilder.build(), basePlan.getCluster().getPlanner().getContext());
            ArrayList list = Lists.newArrayList();
            list.add(mdProvider);
            planner.registerMetadataProviders((List)list);
            RelMetadataProvider chainedProvider = ChainedRelMetadataProvider.of((List)list);
            basePlan.getCluster().setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(chainedProvider, (RelOptPlanner)planner));
            if (executorProvider != null) {
                basePlan.getCluster().getPlanner().setExecutor(executorProvider);
                planner.setExecutor(executorProvider);
            }
            planner.setRoot(basePlan);
            optimizedRelNode = planner.findBestExp();
            return optimizedRelNode;
        }

        private RelNode genSetOpLogicalPlan(QBExpr.Opcode opcode, String alias, String leftalias, RelNode leftRel, String rightalias, RelNode rightRel) throws SemanticException {
            RowResolver leftRR = this.relToHiveRR.get(leftRel);
            RowResolver rightRR = this.relToHiveRR.get(rightRel);
            LinkedHashMap<String, ColumnInfo> leftmap = leftRR.getFieldMap(leftalias);
            LinkedHashMap<String, ColumnInfo> rightmap = rightRR.getFieldMap(rightalias);
            if (leftmap.size() != rightmap.size()) {
                throw new SemanticException("Schema of both sides of union should match.");
            }
            ASTNode tabref = CalcitePlanner.this.getQB().getAliases().isEmpty() ? null : CalcitePlanner.this.getQB().getParseInfo().getSrcForAlias(CalcitePlanner.this.getQB().getAliases().get(0));
            RowResolver setOpOutRR = new RowResolver();
            Iterator lIter = ((HashMap)leftmap).entrySet().iterator();
            Iterator rIter = ((HashMap)rightmap).entrySet().iterator();
            while (lIter.hasNext()) {
                Map.Entry lEntry = lIter.next();
                Map.Entry rEntry = rIter.next();
                ColumnInfo lInfo = (ColumnInfo)lEntry.getValue();
                ColumnInfo rInfo = (ColumnInfo)rEntry.getValue();
                String field = (String)lEntry.getKey();
                TypeInfo commonTypeInfo = FunctionRegistry.getCommonClassForUnionAll(lInfo.getType(), rInfo.getType());
                if (commonTypeInfo == null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabref, "Schema of both sides of setop should match: Column " + field + " is of type " + lInfo.getType().getTypeName() + " on first table and type " + rInfo.getType().getTypeName() + " on second table"));
                }
                ColumnInfo setOpColInfo = new ColumnInfo(lInfo);
                setOpColInfo.setType(commonTypeInfo);
                setOpOutRR.put(alias, field, setOpColInfo);
            }
            boolean leftNeedsTypeCast = false;
            boolean rightNeedsTypeCast = false;
            ArrayList<RexNode> leftProjs = new ArrayList<RexNode>();
            ArrayList<RexNode> rightProjs = new ArrayList<RexNode>();
            List leftRowDT = leftRel.getRowType().getFieldList();
            List rightRowDT = rightRel.getRowType().getFieldList();
            for (int i = 0; i < leftRowDT.size(); ++i) {
                RelDataType rightFieldDT;
                RelDataType leftFieldDT = ((RelDataTypeField)leftRowDT.get(i)).getType();
                if (!leftFieldDT.equals(rightFieldDT = ((RelDataTypeField)rightRowDT.get(i)).getType())) {
                    RelDataType unionFieldDT = TypeConverter.convert(setOpOutRR.getColumnInfos().get(i).getType(), this.cluster.getTypeFactory());
                    if (!unionFieldDT.equals(leftFieldDT)) {
                        leftNeedsTypeCast = true;
                    }
                    leftProjs.add(this.cluster.getRexBuilder().ensureType(unionFieldDT, (RexNode)this.cluster.getRexBuilder().makeInputRef(leftFieldDT, i), true));
                    if (!unionFieldDT.equals(rightFieldDT)) {
                        rightNeedsTypeCast = true;
                    }
                    rightProjs.add(this.cluster.getRexBuilder().ensureType(unionFieldDT, (RexNode)this.cluster.getRexBuilder().makeInputRef(rightFieldDT, i), true));
                    continue;
                }
                leftProjs.add(this.cluster.getRexBuilder().ensureType(leftFieldDT, (RexNode)this.cluster.getRexBuilder().makeInputRef(leftFieldDT, i), true));
                rightProjs.add(this.cluster.getRexBuilder().ensureType(rightFieldDT, (RexNode)this.cluster.getRexBuilder().makeInputRef(rightFieldDT, i), true));
            }
            RelNode setOpLeftInput = leftRel;
            RelNode setOpRightInput = rightRel;
            if (leftNeedsTypeCast) {
                setOpLeftInput = HiveProject.create(leftRel, leftProjs, leftRel.getRowType().getFieldNames());
            }
            if (rightNeedsTypeCast) {
                setOpRightInput = HiveProject.create(rightRel, rightProjs, rightRel.getRowType().getFieldNames());
            }
            ImmutableList.Builder bldr = new ImmutableList.Builder();
            bldr.add((Object)setOpLeftInput);
            bldr.add((Object)setOpRightInput);
            Object setOpRel = null;
            switch (opcode) {
                case UNION: {
                    setOpRel = new HiveUnion(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)bldr.build());
                    break;
                }
                case INTERSECT: {
                    setOpRel = new HiveIntersect(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)bldr.build(), false);
                    break;
                }
                case INTERSECTALL: {
                    setOpRel = new HiveIntersect(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)bldr.build(), true);
                    break;
                }
                case EXCEPT: {
                    setOpRel = new HiveExcept(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)bldr.build(), false);
                    break;
                }
                case EXCEPTALL: {
                    setOpRel = new HiveExcept(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)bldr.build(), true);
                    break;
                }
                default: {
                    throw new SemanticException(ErrorMsg.UNSUPPORTED_SET_OPERATOR.getMsg(opcode.toString()));
                }
            }
            this.relToHiveRR.put((RelNode)setOpRel, setOpOutRR);
            this.relToHiveColNameCalcitePosMap.put((RelNode)setOpRel, this.buildHiveToCalciteColumnMap(setOpOutRR, (RelNode)setOpRel));
            return setOpRel;
        }

        private RelNode genJoinRelNode(RelNode leftRel, String leftTableAlias, RelNode rightRel, String rightTableAlias, JoinType hiveJoinType, ASTNode joinCond) throws SemanticException {
            JoinRelType calciteJoinType;
            RowResolver leftRR = this.relToHiveRR.get(leftRel);
            RowResolver rightRR = this.relToHiveRR.get(rightRel);
            RexLiteral calciteJoinCond = null;
            ArrayList<String> namedColumns = null;
            if (joinCond != null) {
                JoinTypeCheckCtx jCtx = new JoinTypeCheckCtx(leftRR, rightRR, hiveJoinType);
                RowResolver input = RowResolver.getCombinedRR(leftRR, rightRR);
                if (joinCond.getType() == 1037 && !hiveJoinType.equals((Object)JoinType.LEFTSEMI)) {
                    namedColumns = new ArrayList<String>();
                    ASTNode and = (ASTNode)ParseDriver.adaptor.create(36, "and");
                    ASTNode equal = null;
                    int count = 0;
                    for (Node child : joinCond.getChildren()) {
                        String columnName = ((ASTNode)child).getText();
                        if (CalcitePlanner.this.unparseTranslator != null && CalcitePlanner.this.unparseTranslator.isEnabled()) {
                            CalcitePlanner.this.unparseTranslator.addIdentifierTranslation((ASTNode)child);
                        }
                        namedColumns.add(columnName);
                        ASTNode left = ASTBuilder.qualifiedName(leftTableAlias, columnName);
                        ASTNode right = ASTBuilder.qualifiedName(rightTableAlias, columnName);
                        equal = (ASTNode)ParseDriver.adaptor.create(18, "=");
                        ParseDriver.adaptor.addChild((Object)equal, (Object)left);
                        ParseDriver.adaptor.addChild((Object)equal, (Object)right);
                        ParseDriver.adaptor.addChild((Object)and, (Object)equal);
                        ++count;
                    }
                    joinCond = count > 1 ? and : equal;
                } else if (CalcitePlanner.this.unparseTranslator != null && CalcitePlanner.this.unparseTranslator.isEnabled()) {
                    CalcitePlanner.this.genAllExprNodeDesc(joinCond, input, jCtx);
                }
                Map<ASTNode, ExprNodeDesc> exprNodes = JoinCondTypeCheckProcFactory.genExprNode(joinCond, jCtx);
                if (jCtx.getError() != null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(jCtx.getErrorSrcNode(), jCtx.getError()));
                }
                ExprNodeDesc joinCondnExprNode = exprNodes.get(joinCond);
                ArrayList<RelNode> inputRels = new ArrayList<RelNode>();
                inputRels.add(leftRel);
                inputRels.add(rightRel);
                calciteJoinCond = RexNodeConverter.convert(this.cluster, joinCondnExprNode, inputRels, this.relToHiveRR, this.relToHiveColNameCalcitePosMap, false);
            } else {
                calciteJoinCond = this.cluster.getRexBuilder().makeLiteral(true);
            }
            boolean leftSemiJoin = false;
            switch (hiveJoinType) {
                case LEFTOUTER: {
                    calciteJoinType = JoinRelType.LEFT;
                    break;
                }
                case RIGHTOUTER: {
                    calciteJoinType = JoinRelType.RIGHT;
                    break;
                }
                case FULLOUTER: {
                    calciteJoinType = JoinRelType.FULL;
                    break;
                }
                case LEFTSEMI: {
                    calciteJoinType = JoinRelType.INNER;
                    leftSemiJoin = true;
                    break;
                }
                default: {
                    calciteJoinType = JoinRelType.INNER;
                }
            }
            HiveRelNode topRel = null;
            RowResolver topRR = null;
            if (leftSemiJoin) {
                ArrayList sysFieldList = new ArrayList();
                ArrayList<RexNode> leftJoinKeys = new ArrayList<RexNode>();
                ArrayList<RexNode> rightJoinKeys = new ArrayList<RexNode>();
                RexNode nonEquiConds = RelOptUtil.splitJoinCondition(sysFieldList, (RelNode)leftRel, (RelNode)rightRel, (RexNode)calciteJoinCond, leftJoinKeys, rightJoinKeys, null, null);
                RelNode[] inputRels = new RelNode[]{leftRel, rightRel};
                ArrayList<Integer> leftKeys = new ArrayList<Integer>();
                ArrayList<Integer> rightKeys = new ArrayList<Integer>();
                RexNode remainingEquiCond = HiveCalciteUtil.projectNonColumnEquiConditions(HiveRelFactories.HIVE_PROJECT_FACTORY, inputRels, leftJoinKeys, rightJoinKeys, 0, leftKeys, rightKeys);
                if (inputRels[0] != leftRel) {
                    nonEquiConds = RexUtil.shift((RexNode)nonEquiConds, (int)leftRel.getRowType().getFieldCount(), (int)(inputRels[0].getRowType().getFieldCount() - leftRel.getRowType().getFieldCount()));
                }
                calciteJoinCond = remainingEquiCond != null ? RexUtil.composeConjunction((RexBuilder)this.cluster.getRexBuilder(), (Iterable)ImmutableList.of((Object)remainingEquiCond, (Object)nonEquiConds), (boolean)false) : nonEquiConds;
                topRel = HiveSemiJoin.getSemiJoin(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), inputRels[0], inputRels[1], (RexNode)calciteJoinCond, ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys));
                if (inputRels[0] != leftRel) {
                    RowResolver newLeftRR = new RowResolver();
                    if (!RowResolver.add(newLeftRR, leftRR)) {
                        CalcitePlanner.this.LOG.warn("Duplicates detected when adding columns to RR: see previous message");
                    }
                    for (int i = leftRel.getRowType().getFieldCount(); i < inputRels[0].getRowType().getFieldCount(); ++i) {
                        ColumnInfo oColInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(i), TypeConverter.convert(((RelDataTypeField)inputRels[0].getRowType().getFieldList().get(i)).getType()), null, false);
                        newLeftRR.put(oColInfo.getTabAlias(), oColInfo.getInternalName(), oColInfo);
                    }
                    RowResolver joinRR = new RowResolver();
                    if (!RowResolver.add(joinRR, newLeftRR)) {
                        CalcitePlanner.this.LOG.warn("Duplicates detected when adding columns to RR: see previous message");
                    }
                    this.relToHiveColNameCalcitePosMap.put(topRel, this.buildHiveToCalciteColumnMap(joinRR, topRel));
                    this.relToHiveRR.put(topRel, joinRR);
                    ArrayList<RexInputRef> topFields = new ArrayList<RexInputRef>();
                    ArrayList<String> topFieldNames = new ArrayList<String>();
                    for (int i = 0; i < leftRel.getRowType().getFieldCount(); ++i) {
                        RelDataTypeField field = (RelDataTypeField)leftRel.getRowType().getFieldList().get(i);
                        topFields.add(leftRel.getCluster().getRexBuilder().makeInputRef(field.getType(), i));
                        topFieldNames.add(field.getName());
                    }
                    topRel = HiveRelFactories.HIVE_PROJECT_FACTORY.createProject((RelNode)topRel, topFields, topFieldNames);
                }
                if (!RowResolver.add(topRR = new RowResolver(), leftRR)) {
                    CalcitePlanner.this.LOG.warn("Duplicates detected when adding columns to RR: see previous message");
                }
            } else {
                topRel = HiveJoin.getJoin(this.cluster, leftRel, rightRel, (RexNode)calciteJoinCond, calciteJoinType);
                topRR = RowResolver.getCombinedRR(leftRR, rightRR);
                if (namedColumns != null) {
                    ArrayList<String> tableAliases = new ArrayList<String>();
                    tableAliases.add(leftTableAlias);
                    tableAliases.add(rightTableAlias);
                    topRR.setNamedJoinInfo(new NamedJoinInfo(tableAliases, namedColumns, hiveJoinType));
                }
            }
            this.relToHiveColNameCalcitePosMap.put(topRel, this.buildHiveToCalciteColumnMap(topRR, topRel));
            this.relToHiveRR.put(topRel, topRR);
            return topRel;
        }

        private RelNode genJoinLogicalPlan(ASTNode joinParseTree, Map<String, RelNode> aliasToRel) throws SemanticException {
            RelNode leftRel = null;
            RelNode rightRel = null;
            JoinType hiveJoinType = null;
            if (joinParseTree.getToken().getType() == 1086) {
                String msg = String.format("UNIQUE JOIN is currently not supported in CBO, turn off cbo to use UNIQUE JOIN.", new Object[0]);
                CalcitePlanner.this.LOG.debug(msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Unique_join);
            }
            switch (joinParseTree.getToken().getType()) {
                case 881: {
                    hiveJoinType = JoinType.LEFTOUTER;
                    break;
                }
                case 977: {
                    hiveJoinType = JoinType.RIGHTOUTER;
                    break;
                }
                case 841: {
                    hiveJoinType = JoinType.FULLOUTER;
                    break;
                }
                case 882: {
                    hiveJoinType = JoinType.LEFTSEMI;
                    break;
                }
                default: {
                    hiveJoinType = JoinType.INNER;
                }
            }
            ASTNode left = (ASTNode)joinParseTree.getChild(0);
            String leftTableAlias = null;
            if (left.getToken().getType() == 1062 || left.getToken().getType() == 1026 || left.getToken().getType() == 953) {
                String tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)left.getChild(0)).toLowerCase();
                leftTableAlias = left.getChildCount() == 1 ? tableName : SemanticAnalyzer.unescapeIdentifier(left.getChild(left.getChildCount() - 1).getText().toLowerCase());
                leftTableAlias = left.getToken().getType() == 953 ? SemanticAnalyzer.unescapeIdentifier(left.getChild(1).getText().toLowerCase()) : leftTableAlias;
                leftRel = aliasToRel.get(leftTableAlias);
            } else if (SemanticAnalyzer.isJoinToken(left)) {
                leftRel = this.genJoinLogicalPlan(left, aliasToRel);
            } else if (left.getToken().getType() == 879) {
                leftRel = this.genLateralViewPlans(left, aliasToRel);
            } else assert (false);
            ASTNode right = (ASTNode)joinParseTree.getChild(1);
            String rightTableAlias = null;
            if (right.getToken().getType() == 1062 || right.getToken().getType() == 1026 || right.getToken().getType() == 953) {
                String tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)right.getChild(0)).toLowerCase();
                rightTableAlias = right.getChildCount() == 1 ? tableName : SemanticAnalyzer.unescapeIdentifier(right.getChild(right.getChildCount() - 1).getText().toLowerCase());
                rightTableAlias = right.getToken().getType() == 953 ? SemanticAnalyzer.unescapeIdentifier(right.getChild(1).getText().toLowerCase()) : rightTableAlias;
                rightRel = aliasToRel.get(rightTableAlias);
            } else if (right.getToken().getType() == 879) {
                rightRel = this.genLateralViewPlans(right, aliasToRel);
            } else assert (false);
            ASTNode joinCond = (ASTNode)joinParseTree.getChild(2);
            return this.genJoinRelNode(leftRel, leftTableAlias, rightRel, rightTableAlias, hiveJoinType, joinCond);
        }

        private RelNode genTableLogicalPlan(String tableAlias, QB qb) throws SemanticException {
            RowResolver rr = new RowResolver();
            HiveRelNode tableRel = null;
            try {
                ColumnInfo colInfo;
                String colName;
                if (qb.getParseInfo().getTabSample(tableAlias) != null || CalcitePlanner.this.getNameToSplitSampleMap().containsKey(tableAlias) || CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP) && CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE)) {
                    String msg = String.format("Table Sample specified for %s. Currently we don't support Table Sample clauses in CBO, turn off cbo for queries on tableSamples.", tableAlias);
                    CalcitePlanner.this.LOG.debug(msg);
                    throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Table_sample_clauses);
                }
                Table tabMetaData = qb.getMetaData().getSrcForAlias(tableAlias);
                StructObjectInspector rowObjectInspector = (StructObjectInspector)tabMetaData.getDeserializer().getObjectInspector();
                List fields = rowObjectInspector.getAllStructFieldRefs();
                ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
                for (int i = 0; i < fields.size(); ++i) {
                    colName = ((StructField)fields.get(i)).getFieldName();
                    colInfo = new ColumnInfo(((StructField)fields.get(i)).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()), tableAlias, false);
                    colInfo.setSkewedCol(SemanticAnalyzer.isSkewedCol(tableAlias, qb, colName));
                    rr.put(tableAlias, colName, colInfo);
                    cInfoLst.add(colInfo);
                }
                ArrayList<ColumnInfo> nonPartitionColumns = new ArrayList<ColumnInfo>(cInfoLst);
                ArrayList<ColumnInfo> partitionColumns = new ArrayList<ColumnInfo>();
                for (FieldSchema part_col : tabMetaData.getPartCols()) {
                    colName = part_col.getName();
                    colInfo = new ColumnInfo(colName, (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)part_col.getType()), tableAlias, true);
                    rr.put(tableAlias, colName, colInfo);
                    cInfoLst.add(colInfo);
                    partitionColumns.add(colInfo);
                }
                TableType tableType = this.obtainTableType(tabMetaData);
                ArrayList<VirtualColumn> virtualCols = new ArrayList<VirtualColumn>();
                if (tableType == TableType.NATIVE) {
                    for (VirtualColumn vc : VirtualColumn.getRegistry((Configuration)CalcitePlanner.this.conf)) {
                        colInfo = new ColumnInfo(vc.getName(), vc.getTypeInfo(), tableAlias, true, vc.getIsHidden());
                        rr.put(tableAlias, vc.getName().toLowerCase(), colInfo);
                        cInfoLst.add(colInfo);
                        virtualCols.add(vc);
                    }
                }
                if (tableType == TableType.DRUID || tableType == TableType.JDBC && tabMetaData.getProperty("hive.sql.table") != null) {
                    List originalColumnNames = ((StandardStructObjectInspector)rowObjectInspector).getOriginalColumnNames();
                    ArrayList<ColumnInfo> cIList = new ArrayList<ColumnInfo>(originalColumnNames.size());
                    for (int i = 0; i < rr.getColumnInfos().size(); ++i) {
                        cIList.add(new ColumnInfo((String)originalColumnNames.get(i), rr.getColumnInfos().get(i).getType(), tableAlias, false));
                    }
                    RelDataType rowType = TypeConverter.getType(this.cluster, cIList);
                    String fullyQualifiedTabName = tabMetaData.getDbName();
                    fullyQualifiedTabName = fullyQualifiedTabName != null && !fullyQualifiedTabName.isEmpty() ? fullyQualifiedTabName + "." + tabMetaData.getTableName() : tabMetaData.getTableName();
                    if (tableType == TableType.DRUID) {
                        String address = HiveConf.getVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
                        String dataSource = tabMetaData.getParameters().get("druid.datasource");
                        HashSet<String> metrics = new HashSet<String>();
                        RexBuilder rexBuilder = this.cluster.getRexBuilder();
                        RelDataTypeFactory dtFactory = rexBuilder.getTypeFactory();
                        ArrayList<RelDataType> druidColTypes = new ArrayList<RelDataType>();
                        ArrayList<String> druidColNames = new ArrayList<String>();
                        for (RelDataTypeField field : rowType.getFieldList()) {
                            if ("__time".equals(field.getName())) {
                                druidColTypes.add(dtFactory.createTypeWithNullability(field.getType(), false));
                            } else {
                                druidColTypes.add(field.getType());
                            }
                            druidColNames.add(field.getName());
                            if (field.getName().equals("__time") || field.getType().getSqlTypeName() == SqlTypeName.VARCHAR) continue;
                            metrics.add(field.getName());
                        }
                        List<Interval> intervals = Arrays.asList(DruidTable.DEFAULT_INTERVAL);
                        rowType = dtFactory.createStructType(druidColTypes, druidColNames);
                        DruidTable druidTable = new DruidTable(new DruidSchema(address, address, false), dataSource, RelDataTypeImpl.proto((RelDataType)rowType), metrics, "__time", intervals, null, null);
                        RelOptHiveTable optTable = new RelOptHiveTable(this.relOptSchema, fullyQualifiedTabName, rowType, tabMetaData, nonPartitionColumns, partitionColumns, virtualCols, CalcitePlanner.this.conf, this.partitionCache, this.colStatsCache, CalcitePlanner.this.noColsMissingStats);
                        HiveTableScan scan = new HiveTableScan(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, null == tableAlias ? tabMetaData.getTableName() : tableAlias, CalcitePlanner.this.getAliasId(tableAlias, qb), HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP), qb.isInsideView() || qb.getAliasInsideView().contains(tableAlias.toLowerCase()));
                        tableRel = DruidQuery.create((RelOptCluster)this.cluster, (RelTraitSet)this.cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), (RelOptTable)optTable, (DruidTable)druidTable, (List)ImmutableList.of((Object)scan), DruidSqlOperatorConverter.getDefaultMap());
                    } else if (tableType == TableType.JDBC) {
                        RelOptHiveTable optTable = new RelOptHiveTable(this.relOptSchema, fullyQualifiedTabName, rowType, tabMetaData, nonPartitionColumns, partitionColumns, virtualCols, CalcitePlanner.this.conf, this.partitionCache, this.colStatsCache, CalcitePlanner.this.noColsMissingStats);
                        HiveTableScan hts = new HiveTableScan(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, null == tableAlias ? tabMetaData.getTableName() : tableAlias, CalcitePlanner.this.getAliasId(tableAlias, qb), HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP), qb.isInsideView() || qb.getAliasInsideView().contains(tableAlias.toLowerCase()));
                        CalcitePlanner.this.LOG.debug("JDBC is running");
                        String dataBaseType = tabMetaData.getProperty("hive.sql.database.type");
                        String url = tabMetaData.getProperty("hive.sql.jdbc.url");
                        String driver = tabMetaData.getProperty("hive.sql.jdbc.driver");
                        String user = tabMetaData.getProperty("hive.sql.dbcp.username");
                        String pswd = tabMetaData.getProperty("hive.sql.dbcp.password");
                        String tableName = tabMetaData.getProperty("hive.sql.table");
                        DataSource ds = JdbcSchema.dataSource((String)url, (String)driver, (String)user, (String)pswd);
                        SqlDialect jdbcDialect = JdbcSchema.createDialect((SqlDialectFactory)SqlDialectFactoryImpl.INSTANCE, (DataSource)ds);
                        JdbcConvention jc = JdbcConvention.of((SqlDialect)jdbcDialect, null, (String)dataBaseType);
                        JdbcSchema schema = new JdbcSchema(ds, jc.dialect, jc, null, null);
                        JdbcTable jt = (JdbcTable)schema.getTable(tableName);
                        if (jt == null) {
                            throw new SemanticException("Table " + tableName + " was not found in the database");
                        }
                        JdbcHiveTableScan jdbcTableRel = new JdbcHiveTableScan(this.cluster, (RelOptTable)optTable, jt, jc, hts);
                        tableRel = new HiveJdbcConverter(this.cluster, jdbcTableRel.getTraitSet().replace((RelTrait)HiveRelNode.CONVENTION), (JdbcRel)jdbcTableRel, jc);
                    }
                } else {
                    RelDataType rowType = this.inferNotNullableColumns(tabMetaData, TypeConverter.getType(this.cluster, rr, null));
                    String fullyQualifiedTabName = tabMetaData.getDbName();
                    fullyQualifiedTabName = fullyQualifiedTabName != null && !fullyQualifiedTabName.isEmpty() ? fullyQualifiedTabName + "." + tabMetaData.getTableName() : tabMetaData.getTableName();
                    RelOptHiveTable optTable = new RelOptHiveTable(this.relOptSchema, fullyQualifiedTabName, rowType, tabMetaData, nonPartitionColumns, partitionColumns, virtualCols, CalcitePlanner.this.conf, this.partitionCache, this.colStatsCache, CalcitePlanner.this.noColsMissingStats);
                    tableRel = new HiveTableScan(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, null == tableAlias ? tabMetaData.getTableName() : tableAlias, CalcitePlanner.this.getAliasId(tableAlias, qb), HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP), qb.isInsideView() || qb.getAliasInsideView().contains(tableAlias.toLowerCase()));
                }
                ImmutableMap<String, Integer> hiveToCalciteColMap = this.buildHiveToCalciteColumnMap(rr, tableRel);
                this.relToHiveRR.put(tableRel, rr);
                this.relToHiveColNameCalcitePosMap.put(tableRel, hiveToCalciteColMap);
            }
            catch (Exception e) {
                if (e instanceof SemanticException) {
                    throw (SemanticException)e;
                }
                throw new RuntimeException(e);
            }
            return tableRel;
        }

        private RelDataType inferNotNullableColumns(Table tabMetaData, RelDataType rowType) throws HiveException {
            int i;
            NotNullConstraint nnc = Hive.get().getReliableNotNullConstraints(tabMetaData.getDbName(), tabMetaData.getTableName());
            PrimaryKeyInfo pkc = Hive.get().getReliablePrimaryKeys(tabMetaData.getDbName(), tabMetaData.getTableName());
            if (nnc.getNotNullConstraints().isEmpty() && pkc.getColNames().isEmpty()) {
                return rowType;
            }
            ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
            for (String nnCol : nnc.getNotNullConstraints().values()) {
                int nnPos = -1;
                for (i = 0; i < rowType.getFieldNames().size(); ++i) {
                    if (!((String)rowType.getFieldNames().get(i)).equals(nnCol)) continue;
                    nnPos = i;
                    break;
                }
                if (nnPos == -1) {
                    CalcitePlanner.this.LOG.error("Column for not null constraint definition " + nnCol + " not found");
                    return rowType;
                }
                builder.set(nnPos);
            }
            for (String pkCol : pkc.getColNames().values()) {
                int pkPos = -1;
                for (i = 0; i < rowType.getFieldNames().size(); ++i) {
                    if (!((String)rowType.getFieldNames().get(i)).equals(pkCol)) continue;
                    pkPos = i;
                    break;
                }
                if (pkPos == -1) {
                    CalcitePlanner.this.LOG.error("Column for not null constraint definition " + pkCol + " not found");
                    return rowType;
                }
                builder.set(pkPos);
            }
            ImmutableBitSet bitSet = builder.build();
            RexBuilder rexBuilder = this.cluster.getRexBuilder();
            RelDataTypeFactory dtFactory = rexBuilder.getTypeFactory();
            LinkedList<RelDataType> fieldTypes = new LinkedList<RelDataType>();
            LinkedList<String> fieldNames = new LinkedList<String>();
            for (RelDataTypeField rdtf : rowType.getFieldList()) {
                if (bitSet.indexOf(rdtf.getIndex()) != -1) {
                    fieldTypes.add(dtFactory.createTypeWithNullability(rdtf.getType(), false));
                } else {
                    fieldTypes.add(rdtf.getType());
                }
                fieldNames.add(rdtf.getName());
            }
            return dtFactory.createStructType(fieldTypes, fieldNames);
        }

        private TableType obtainTableType(Table tabMetaData) {
            if (tabMetaData.getStorageHandler() != null) {
                String storageHandlerStr = tabMetaData.getStorageHandler().toString();
                if (storageHandlerStr.equals("org.apache.hadoop.hive.druid.DruidStorageHandler")) {
                    return TableType.DRUID;
                }
                if (storageHandlerStr.equals("org.apache.hive.storage.jdbc.JdbcStorageHandler")) {
                    return TableType.JDBC;
                }
            }
            return TableType.NATIVE;
        }

        private RelNode genFilterRelNode(ASTNode filterExpr, RelNode srcRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR, boolean useCaching) throws SemanticException {
            ExprNodeDesc filterCondn = CalcitePlanner.this.genExprNodeDesc(filterExpr, this.relToHiveRR.get(srcRel), outerRR, null, useCaching);
            if (filterCondn instanceof ExprNodeConstantDesc && !filterCondn.getTypeString().equals("boolean")) {
                throw new CalciteSemanticException("Filter expression with non-boolean return type.", CalciteSemanticException.UnsupportedFeature.Filter_expression_with_non_boolean_return_type);
            }
            ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
            RexNode convertedFilterExpr = new RexNodeConverter(this.cluster, srcRel.getRowType(), outerNameToPosMap, hiveColNameCalcitePosMap, this.relToHiveRR.get(srcRel), outerRR, 0, true, this.subqueryId).convert(filterCondn);
            RexNode factoredFilterExpr = RexUtil.pullFactors((RexBuilder)this.cluster.getRexBuilder(), (RexNode)convertedFilterExpr);
            HiveFilter filterRel = new HiveFilter(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), srcRel, factoredFilterExpr);
            this.relToHiveColNameCalcitePosMap.put(filterRel, hiveColNameCalcitePosMap);
            this.relToHiveRR.put(filterRel, this.relToHiveRR.get(srcRel));
            this.relToHiveColNameCalcitePosMap.put(filterRel, hiveColNameCalcitePosMap);
            return filterRel;
        }

        private void subqueryRestrictionCheck(QB qb, ASTNode searchCond, RelNode srcRel, boolean forHavingClause, Set<ASTNode> corrScalarQueries, Set<ASTNode> scalarQueriesWithAggNoWinNoGby) throws SemanticException {
            List<ASTNode> subQueriesInOriginalTree = SubQueryUtils.findSubQueries(searchCond);
            ASTNode clonedSearchCond = (ASTNode)SubQueryUtils.adaptor.dupTree((Object)searchCond);
            List<ASTNode> subQueries = SubQueryUtils.findSubQueries(clonedSearchCond);
            for (int i = 0; i < subQueriesInOriginalTree.size(); ++i) {
                int sqIdx = qb.incrNumSubQueryPredicates();
                ASTNode originalSubQueryAST = subQueriesInOriginalTree.get(i);
                ASTNode subQueryAST = subQueries.get(i);
                Boolean orInSubquery = new Boolean(false);
                Integer subqueryCount = new Integer(0);
                ObjectPair subqInfo = new ObjectPair((Object)false, (Object)0);
                ASTNode outerQueryExpr = (ASTNode)subQueryAST.getChild(2);
                if (outerQueryExpr != null && outerQueryExpr.getType() == 1027) {
                    throw new CalciteSubquerySemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(outerQueryExpr, "IN/NOT IN subqueries are not allowed in LHS"));
                }
                QBSubQuery subQuery = SubQueryUtils.buildSubQuery(qb.getId(), sqIdx, subQueryAST, originalSubQueryAST, CalcitePlanner.this.ctx);
                RowResolver inputRR = this.relToHiveRR.get(srcRel);
                String havingInputAlias = null;
                boolean[] subqueryConfig = new boolean[]{false, false};
                subQuery.subqueryRestrictionsCheck(inputRR, forHavingClause, havingInputAlias, subqueryConfig);
                if (subqueryConfig[0]) {
                    corrScalarQueries.add(originalSubQueryAST);
                }
                if (!subqueryConfig[1]) continue;
                scalarQueriesWithAggNoWinNoGby.add(originalSubQueryAST);
            }
        }

        private RelNode genLateralViewPlans(ASTNode lateralView, Map<String, RelNode> aliasToRel) throws SemanticException {
            int i;
            RexBuilder rexBuilder = this.cluster.getRexBuilder();
            RelDataTypeFactory dtFactory = this.cluster.getTypeFactory();
            String inlineFunctionName = GenericUDTFInline.class.getAnnotation(Description.class).name();
            int numChildren = lateralView.getChildCount();
            assert (numChildren == 2);
            ASTNode next = (ASTNode)lateralView.getChild(1);
            RelNode inputRel = null;
            switch (next.getToken().getType()) {
                case 953: 
                case 1026: 
                case 1062: {
                    String inputTableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)next.getChild(0)).toLowerCase();
                    String inputTableAlias = next.getToken().getType() == 953 ? SemanticAnalyzer.unescapeIdentifier(next.getChild(1).getText().toLowerCase()) : (next.getChildCount() == 1 ? inputTableName : SemanticAnalyzer.unescapeIdentifier(next.getChild(next.getChildCount() - 1).getText().toLowerCase()));
                    inputRel = aliasToRel.get(inputTableAlias);
                    break;
                }
                case 879: {
                    inputRel = this.genLateralViewPlans(next, aliasToRel);
                    break;
                }
                default: {
                    throw new SemanticException(ErrorMsg.LATERAL_VIEW_INVALID_CHILD.getMsg(lateralView));
                }
            }
            RowResolver inputRR = this.relToHiveRR.get(inputRel);
            List inputRefs = Lists.transform((List)inputRel.getRowType().getFieldList(), input -> new RexInputRef(input.getIndex(), input.getType()));
            ArrayList<RelDataType> inputRefsTypes = new ArrayList<RelDataType>();
            for (int i2 = 0; i2 < inputRefs.size(); ++i2) {
                inputRefsTypes.add(((RexNode)inputRefs.get(i2)).getType());
            }
            ImmutableMap<String, Integer> inputPosMap = this.relToHiveColNameCalcitePosMap.get(inputRel);
            ASTNode selExprClause = (ASTNode)lateralView.getChild(0).getChild(0);
            ASTNode functionCall = (ASTNode)selExprClause.getChild(0);
            if (functionCall.getChild(0).getText().compareToIgnoreCase(inlineFunctionName) != 0) {
                throw new SemanticException("CBO only supports inline LVJ");
            }
            ASTNode valuesClause = (ASTNode)functionCall.getChild(1);
            ArrayList outputFieldTypes = new ArrayList(inputRefsTypes);
            ArrayList outputFieldNames = new ArrayList(inputRel.getRowType().getFieldNames());
            ExprNodeDesc valuesExpr = CalcitePlanner.this.genExprNodeDesc(valuesClause, inputRR, false);
            RexCall convertedOriginalValuesExpr = (RexCall)new RexNodeConverter(this.cluster, inputRel.getRowType(), inputPosMap, 0, false).convert(valuesExpr);
            RelDataType valuesRowType = ((ArraySqlType)convertedOriginalValuesExpr.getType()).getComponentType();
            ArrayList<RexNode> newStructExprs = new ArrayList<RexNode>();
            for (RexNode structExpr : convertedOriginalValuesExpr.getOperands()) {
                RexCall structCall = (RexCall)structExpr;
                ArrayList exprs = new ArrayList(inputRefs);
                exprs.addAll(structCall.getOperands());
                newStructExprs.add(rexBuilder.makeCall(structCall.op, exprs));
            }
            RexNode convertedFinalValuesExpr = rexBuilder.makeCall(convertedOriginalValuesExpr.op, newStructExprs);
            RelDataType retType = SqlValidatorUtil.deriveJoinRowType((RelDataType)inputRel.getRowType(), (RelDataType)valuesRowType, (JoinRelType)JoinRelType.INNER, (RelDataTypeFactory)dtFactory, null, (List)ImmutableList.of());
            FunctionInfo inlineFunctionInfo = FunctionRegistry.getFunctionInfo(inlineFunctionName);
            SqlOperator calciteOp = SqlFunctionConverter.getCalciteOperator(inlineFunctionName, inlineFunctionInfo.getGenericUDTF(), (ImmutableList<RelDataType>)ImmutableList.copyOf(inputRefsTypes), retType);
            HiveTableFunctionScan htfsRel = HiveTableFunctionScan.create(this.cluster, TraitsUtil.getDefaultTraitSet(this.cluster), (List<RelNode>)ImmutableList.of((Object)inputRel), rexBuilder.makeCall(calciteOp, new RexNode[]{convertedFinalValuesExpr}), null, retType, null);
            RowResolver outputRR = new RowResolver();
            if (!RowResolver.add(outputRR, inputRR)) {
                CalcitePlanner.this.LOG.warn("Duplicates detected when adding columns to RR: see previous message");
            }
            String tableAlias = null;
            ArrayList<String> columnAliases = new ArrayList<String>();
            HashSet<String> uniqueNames = new HashSet<String>();
            block9: for (i = 1; i < ((ArrayList)selExprClause.getChildren()).size(); ++i) {
                ASTNode child = (ASTNode)selExprClause.getChild(i);
                switch (child.getToken().getType()) {
                    case 1034: {
                        tableAlias = BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                        continue block9;
                    }
                    default: {
                        String colAlias = BaseSemanticAnalyzer.unescapeIdentifier(child.getText());
                        if (uniqueNames.contains(colAlias)) {
                            throw new SemanticException(ErrorMsg.COLUMN_ALIAS_ALREADY_EXISTS.getMsg(colAlias));
                        }
                        columnAliases.add(colAlias);
                        uniqueNames.add(colAlias);
                    }
                }
            }
            if (tableAlias == null) {
                throw new SemanticException("Alias should be specified LVJ");
            }
            if (!columnAliases.isEmpty() && columnAliases.size() != valuesRowType.getFieldCount()) {
                throw new SemanticException(ErrorMsg.UDTF_ALIAS_MISMATCH.getMsg());
            }
            if (columnAliases.isEmpty()) {
                for (i = 0; i < valuesRowType.getFieldCount(); ++i) {
                    columnAliases.add(SemanticAnalyzer.getColumnInternalName(i));
                }
            }
            int numInputExprs = inputRR.getColumnInfos().size();
            ListTypeInfo listTypeInfo = (ListTypeInfo)valuesExpr.getTypeInfo();
            StructTypeInfo typeInfos = (StructTypeInfo)listTypeInfo.getListElementTypeInfo();
            int j = 0;
            for (int i3 = 0; i3 < columnAliases.size(); ++i3) {
                String internalColName;
                while (inputRR.getPosition(internalColName = SemanticAnalyzer.getColumnInternalName(j++)) != -1) {
                }
                outputRR.put(tableAlias, (String)columnAliases.get(i3), new ColumnInfo(internalColName, (TypeInfo)typeInfos.getAllStructFieldTypeInfos().get(i3), tableAlias, false));
            }
            this.relToHiveColNameCalcitePosMap.put(htfsRel, this.buildHiveToCalciteColumnMap(outputRR, htfsRel));
            this.relToHiveRR.put(htfsRel, outputRR);
            return htfsRel;
        }

        private boolean genSubQueryRelNode(QB qb, ASTNode node, RelNode srcRel, boolean forHavingClause, Map<ASTNode, RelNode> subQueryToRelNode) throws SemanticException {
            HashSet<ASTNode> corrScalarQueriesWithAgg = new HashSet<ASTNode>();
            HashSet<ASTNode> scalarQueriesWithAggNoWinNoGby = new HashSet<ASTNode>();
            this.subqueryRestrictionCheck(qb, node, srcRel, forHavingClause, corrScalarQueriesWithAgg, scalarQueriesWithAggNoWinNoGby);
            ArrayDeque<ASTNode> stack = new ArrayDeque<ASTNode>();
            stack.push(node);
            boolean isSubQuery = false;
            block3: while (!stack.isEmpty()) {
                ASTNode next = (ASTNode)stack.pop();
                switch (next.getType()) {
                    case 1027: {
                        if (((ArrayList)next.getChildren()).size() == 3 && next.getChild(2).getType() == 1027) {
                            throw new CalciteSemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(next.getChild(2), "SubQuery in LHS expressions are not supported."));
                        }
                        String sbQueryAlias = "sq_" + qb.incrNumSubQueryPredicates();
                        QB qbSQ = new QB(qb.getId(), sbQueryAlias, true);
                        SemanticAnalyzer.Phase1Ctx ctx1 = CalcitePlanner.this.initPhase1Ctx();
                        CalcitePlanner.this.doPhase1((ASTNode)next.getChild(1), qbSQ, ctx1, null);
                        CalcitePlanner.this.getMetaData(qbSQ);
                        ++this.subqueryId;
                        RelNode subQueryRelNode = this.genLogicalPlan(qbSQ, false, this.relToHiveColNameCalcitePosMap.get(srcRel), this.relToHiveRR.get(srcRel));
                        subQueryToRelNode.put(next, subQueryRelNode);
                        if (corrScalarQueriesWithAgg.contains(next)) {
                            this.corrScalarRexSQWithAgg.add(subQueryRelNode);
                        }
                        if (scalarQueriesWithAggNoWinNoGby.contains(next)) {
                            this.scalarAggNoGbyNoWin.add(subQueryRelNode);
                        }
                        isSubQuery = true;
                        continue block3;
                    }
                }
                int childCount = next.getChildCount();
                for (int i = childCount - 1; i >= 0; --i) {
                    stack.push((ASTNode)next.getChild(i));
                }
            }
            return isSubQuery;
        }

        private RelNode genFilterRelNode(QB qb, ASTNode searchCond, RelNode srcRel, Map<String, RelNode> aliasToRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR, boolean forHavingClause) throws SemanticException {
            HashMap<ASTNode, RelNode> subQueryToRelNode = new HashMap<ASTNode, RelNode>();
            boolean isSubQuery = this.genSubQueryRelNode(qb, searchCond, srcRel, forHavingClause, subQueryToRelNode);
            if (isSubQuery) {
                ExprNodeDesc subQueryExpr = CalcitePlanner.this.genExprNodeDesc(searchCond, this.relToHiveRR.get(srcRel), outerRR, subQueryToRelNode, forHavingClause);
                ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
                RexNode convertedFilterLHS = new RexNodeConverter(this.cluster, srcRel.getRowType(), outerNameToPosMap, hiveColNameCalcitePosMap, this.relToHiveRR.get(srcRel), outerRR, 0, true, this.subqueryId).convert(subQueryExpr);
                HiveFilter filterRel = new HiveFilter(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), srcRel, convertedFilterLHS);
                this.relToHiveColNameCalcitePosMap.put(filterRel, this.relToHiveColNameCalcitePosMap.get(srcRel));
                this.relToHiveRR.put(filterRel, this.relToHiveRR.get(srcRel));
                return filterRel;
            }
            return this.genFilterRelNode(searchCond, srcRel, outerNameToPosMap, outerRR, forHavingClause);
        }

        private RelNode projectLeftOuterSide(RelNode srcRel, int numColumns) throws SemanticException {
            RowResolver iRR = this.relToHiveRR.get(srcRel);
            RowResolver oRR = new RowResolver();
            RowResolver.add(oRR, iRR, numColumns);
            ArrayList<RexInputRef> calciteColLst = new ArrayList<RexInputRef>();
            ArrayList<String> oFieldNames = new ArrayList<String>();
            RelDataType iType = srcRel.getRowType();
            for (int i = 0; i < iType.getFieldCount(); ++i) {
                RelDataTypeField fType = (RelDataTypeField)iType.getFieldList().get(i);
                String fName = (String)iType.getFieldNames().get(i);
                calciteColLst.add(this.cluster.getRexBuilder().makeInputRef(fType.getType(), i));
                oFieldNames.add(fName);
            }
            HiveProject selRel = HiveProject.create(srcRel, calciteColLst, oFieldNames);
            this.relToHiveColNameCalcitePosMap.put(selRel, this.buildHiveToCalciteColumnMap(oRR, selRel));
            this.relToHiveRR.put(selRel, oRR);
            return selRel;
        }

        private RelNode genFilterLogicalPlan(QB qb, RelNode srcRel, Map<String, RelNode> aliasToRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR, boolean forHavingClause) throws SemanticException {
            RelNode filterRel = null;
            Iterator<ASTNode> whereClauseIterator = this.getQBParseInfo(qb).getDestToWhereExpr().values().iterator();
            if (whereClauseIterator.hasNext()) {
                filterRel = this.genFilterRelNode(qb, (ASTNode)whereClauseIterator.next().getChild(0), srcRel, aliasToRel, outerNameToPosMap, outerRR, forHavingClause);
            }
            return filterRel;
        }

        private AggregateCall convertGBAgg(AggInfo agg, RelNode input, List<RexNode> gbChildProjLst, RexNodeConverter converter, HashMap<String, Integer> rexNodeToPosMap, Integer childProjLstIndx) throws SemanticException {
            RelDataType aggFnRetType = TypeConverter.convert(agg.m_returnType, this.cluster.getTypeFactory());
            ArrayList<Integer> argList = new ArrayList<Integer>();
            RexNode rexNd = null;
            RelDataTypeFactory dtFactory = this.cluster.getTypeFactory();
            ImmutableList.Builder aggArgRelDTBldr = new ImmutableList.Builder();
            for (ExprNodeDesc expr : agg.m_aggParams) {
                rexNd = converter.convert(expr);
                Integer inputIndx = rexNodeToPosMap.get(rexNd.toString());
                if (inputIndx == null) {
                    gbChildProjLst.add(rexNd);
                    rexNodeToPosMap.put(rexNd.toString(), childProjLstIndx);
                    inputIndx = childProjLstIndx;
                    Integer n = childProjLstIndx;
                    Integer n2 = childProjLstIndx = Integer.valueOf(childProjLstIndx + 1);
                }
                argList.add(inputIndx);
                aggArgRelDTBldr.add((Object)TypeConverter.convert(expr.getTypeInfo(), dtFactory));
            }
            SqlAggFunction aggregation = SqlFunctionConverter.getCalciteAggFn(agg.m_udfName, agg.m_distinct, (ImmutableList<RelDataType>)aggArgRelDTBldr.build(), aggFnRetType);
            return new AggregateCall(aggregation, agg.m_distinct, argList, aggFnRetType, null);
        }

        private RelNode genGBRelNode(List<ExprNodeDesc> gbExprs, List<AggInfo> aggInfoLst, List<Long> groupSets, RelNode srcRel) throws SemanticException {
            Object object;
            ImmutableMap<String, Integer> posMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
            RexNodeConverter converter = new RexNodeConverter(this.cluster, srcRel.getRowType(), posMap, 0, false);
            boolean hasGroupSets = groupSets != null && !groupSets.isEmpty();
            ArrayList gbChildProjLst = Lists.newArrayList();
            HashMap<String, Integer> rexNodeToPosMap = new HashMap<String, Integer>();
            ArrayList groupSetPositions = Lists.newArrayList();
            Integer gbIndx = 0;
            for (ExprNodeDesc key : gbExprs) {
                RexNode rnd = converter.convert(key);
                gbChildProjLst.add(rnd);
                groupSetPositions.add(gbIndx);
                rexNodeToPosMap.put(rnd.toString(), gbIndx);
                Integer n = gbIndx;
                gbIndx = gbIndx + 1;
                object = gbIndx;
            }
            ImmutableBitSet groupSet = ImmutableBitSet.of((Iterable)groupSetPositions);
            ArrayList<ImmutableBitSet> transformedGroupSets = null;
            if (hasGroupSets) {
                HashSet<ImmutableBitSet> setTransformedGroupSets = new HashSet<ImmutableBitSet>(groupSets.size());
                object = groupSets.iterator();
                while (object.hasNext()) {
                    long val = (Long)object.next();
                    setTransformedGroupSets.add(this.convert(val, groupSet.cardinality()));
                }
                transformedGroupSets = new ArrayList<ImmutableBitSet>(setTransformedGroupSets);
                Collections.sort(transformedGroupSets, ImmutableBitSet.COMPARATOR);
            }
            ArrayList aggregateCalls = Lists.newArrayList();
            for (AggInfo agg : aggInfoLst) {
                aggregateCalls.add(this.convertGBAgg(agg, srcRel, gbChildProjLst, converter, rexNodeToPosMap, gbChildProjLst.size()));
            }
            if (hasGroupSets) {
                AggregateCall aggCall = AggregateCall.create((SqlAggFunction)HiveGroupingID.INSTANCE, (boolean)false, (List)new ImmutableList.Builder().build(), (int)-1, (RelDataType)this.cluster.getTypeFactory().createSqlType(SqlTypeName.BIGINT), (String)HiveGroupingID.INSTANCE.getName());
                aggregateCalls.add(aggCall);
            }
            if (gbChildProjLst.isEmpty()) {
                gbChildProjLst.add(this.cluster.getRexBuilder().makeInputRef(srcRel, 0));
            }
            HiveProject gbInputRel = HiveProject.create(srcRel, gbChildProjLst, null);
            HiveAggregate aggregateRel = new HiveAggregate(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), gbInputRel, groupSet, transformedGroupSets, aggregateCalls);
            return aggregateRel;
        }

        private ImmutableBitSet convert(long value, int length) {
            BitSet bits = new BitSet();
            for (int index = length - 1; index >= 0; --index) {
                if (value % 2L != 0L) {
                    bits.set(index);
                }
                value >>>= 1;
            }
            bits.flip(0, length);
            return (ImmutableBitSet)ImmutableBitSet.FROM_BIT_SET.apply((Object)bits);
        }

        private void addAlternateGByKeyMappings(ASTNode gByExpr, ColumnInfo colInfo, RowResolver gByInputRR, RowResolver gByRR) {
            if (gByExpr.getType() == 16 && gByExpr.getChild(0).getType() == 1058) {
                String tab_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getChild(0).getText().toLowerCase());
                String col_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(1).getText().toLowerCase());
                gByRR.put(tab_alias, col_alias, colInfo);
            } else if (gByExpr.getType() == 1058) {
                String col_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getText().toLowerCase());
                String tab_alias = null;
                try {
                    ColumnInfo pColInfo = gByInputRR.get(tab_alias, col_alias);
                    tab_alias = pColInfo == null ? null : pColInfo.getTabAlias();
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
                gByRR.put(tab_alias, col_alias, colInfo);
            }
        }

        private void addToGBExpr(RowResolver groupByOutputRowResolver, RowResolver groupByInputRowResolver, ASTNode grpbyExpr, ExprNodeDesc grpbyExprNDesc, List<ExprNodeDesc> gbExprNDescLst, List<String> outputColumnNames) {
            int i = gbExprNDescLst.size();
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            gbExprNDescLst.add(grpbyExprNDesc);
            ColumnInfo oColInfo = new ColumnInfo(field, grpbyExprNDesc.getTypeInfo(), null, false);
            groupByOutputRowResolver.putExpression(grpbyExpr, oColInfo);
            this.addAlternateGByKeyMappings(grpbyExpr, oColInfo, groupByInputRowResolver, groupByOutputRowResolver);
        }

        private AggInfo getHiveAggInfo(ASTNode aggAst, int aggFnLstArgIndx, RowResolver inputRR) throws SemanticException {
            AggInfo aInfo = null;
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            for (int i = 1; i <= aggFnLstArgIndx; ++i) {
                ASTNode paraExpr = (ASTNode)aggAst.getChild(i);
                ExprNodeDesc paraExprNode = CalcitePlanner.this.genExprNodeDesc(paraExpr, inputRR);
                aggParameters.add(paraExprNode);
            }
            boolean isDistinct = aggAst.getType() == 843;
            PrimitiveTypeInfo udafRetType = null;
            String aggName = SemanticAnalyzer.unescapeIdentifier(aggAst.getChild(0).getText());
            if (FunctionRegistry.isRankingFunction(aggName)) {
                udafRetType = aggName.equalsIgnoreCase("percent_rank") ? TypeInfoFactory.doubleTypeInfo : TypeInfoFactory.intTypeInfo;
            } else {
                try {
                    boolean isAllColumns = aggAst.getType() == 844;
                    GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.COMPLETE, isDistinct);
                    GenericUDAFEvaluator genericUDAFEvaluator = null;
                    if (aggName.toLowerCase().equals("lead") || aggName.toLowerCase().equals("lag")) {
                        ArrayList<ObjectInspector> originalParameterTypeInfos = SemanticAnalyzer.getWritableObjectInspector(aggParameters);
                        genericUDAFEvaluator = FunctionRegistry.getGenericWindowingEvaluator(aggName, originalParameterTypeInfos, isDistinct, isAllColumns);
                        SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                        udafRetType = ((ListTypeInfo)udaf.returnType).getListElementTypeInfo();
                    } else {
                        genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, aggAst, isDistinct, isAllColumns);
                        assert (genericUDAFEvaluator != null);
                        SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                        udafRetType = FunctionRegistry.pivotResult(aggName) ? ((ListTypeInfo)udaf.returnType).getListElementTypeInfo() : udaf.returnType;
                    }
                }
                catch (Exception e) {
                    CalcitePlanner.this.LOG.debug("CBO: Couldn't Obtain UDAF evaluators for " + aggName + ", trying to translate to GenericUDF");
                }
                if (udafRetType == null) {
                    TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR);
                    tcCtx.setAllowStatefulFunctions(true);
                    tcCtx.setAllowDistinctFunctions(false);
                    ExprNodeDesc exp = CalcitePlanner.this.genExprNodeDesc((ASTNode)aggAst.getChild(0), inputRR, tcCtx);
                    udafRetType = exp.getTypeInfo();
                }
            }
            aInfo = new AggInfo(aggParameters, (TypeInfo)udafRetType, aggName, isDistinct);
            return aInfo;
        }

        private RelNode genGBLogicalPlan(QB qb, RelNode srcRel) throws SemanticException {
            boolean cubeRollupGrpSetPresent;
            ASTNode node;
            RelNode gbRel = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String detsClauseName = qbp.getClauseNames().iterator().next();
            ASTNode selExprList = qb.getParseInfo().getSelForClause(detsClauseName);
            SubQueryUtils.checkForTopLevelSubqueries(selExprList);
            if (selExprList.getToken().getType() == 984 && selExprList.getChildCount() == 1 && selExprList.getChild(0).getChildCount() == 1 && (node = (ASTNode)selExprList.getChild(0).getChild(0)).getToken().getType() == 713) {
                srcRel = (RelNode)this.genSelectLogicalPlan(qb, srcRel, srcRel, null, null, true).getKey();
                RowResolver rr = this.relToHiveRR.get(srcRel);
                qbp.setSelExprForClause(detsClauseName, SemanticAnalyzer.genSelectDIAST(rr));
            }
            if (selExprList.getToken().getType() == 984 && !qb.getAllWindowingSpecs().isEmpty()) {
                return null;
            }
            List<ASTNode> grpByAstExprs = CalcitePlanner.this.getGroupByForClause(qbp, detsClauseName);
            HashMap<String, ASTNode> aggregationTrees = qbp.getAggregationExprsForClause(detsClauseName);
            boolean hasGrpByAstExprs = grpByAstExprs != null && !grpByAstExprs.isEmpty();
            boolean hasAggregationTrees = aggregationTrees != null && !aggregationTrees.isEmpty();
            boolean bl = cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
            if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) && qbp.getDistinctFuncExprsForClause(detsClauseName).size() > 1) {
                throw new SemanticException(ErrorMsg.UNSUPPORTED_MULTIPLE_DISTINCTS.getMsg());
            }
            if (cubeRollupGrpSetPresent) {
                if (!HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPSIDEAGGREGATE)) {
                    throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_NOMAPAGGR.getMsg());
                }
                if (CalcitePlanner.this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW)) {
                    CalcitePlanner.this.checkExpressionsForGroupingSet(grpByAstExprs, qb.getParseInfo().getDistinctFuncExprsForClause(detsClauseName), aggregationTrees, this.relToHiveRR.get(srcRel));
                    if (qbp.getDestGroupingSets().size() > CalcitePlanner.this.conf.getIntVar(HiveConf.ConfVars.HIVE_NEW_JOB_GROUPING_SET_CARDINALITY)) {
                        String errorMsg = "The number of rows per input row due to grouping sets is " + qbp.getDestGroupingSets().size();
                        throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_SKEW.getMsg(errorMsg));
                    }
                }
            }
            if (hasGrpByAstExprs || hasAggregationTrees) {
                ArrayList<ExprNodeDesc> gbExprNDescLst = new ArrayList<ExprNodeDesc>();
                ArrayList<String> outputColumnNames = new ArrayList<String>();
                RowResolver groupByInputRowResolver = this.relToHiveRR.get(srcRel);
                RowResolver groupByOutputRowResolver = new RowResolver();
                groupByOutputRowResolver.setIsExprResolver(true);
                if (hasGrpByAstExprs) {
                    for (int i = 0; i < grpByAstExprs.size(); ++i) {
                        ASTNode grpbyExpr = grpByAstExprs.get(i);
                        Map<ASTNode, ExprNodeDesc> astToExprNDescMap = CalcitePlanner.this.genAllExprNodeDesc(grpbyExpr, groupByInputRowResolver);
                        ExprNodeDesc grpbyExprNDesc = astToExprNDescMap.get(grpbyExpr);
                        if (grpbyExprNDesc == null) {
                            throw new CalciteSemanticException("Invalid Column Reference: " + grpbyExpr.dump(), CalciteSemanticException.UnsupportedFeature.Invalid_column_reference);
                        }
                        this.addToGBExpr(groupByOutputRowResolver, groupByInputRowResolver, grpbyExpr, grpbyExprNDesc, gbExprNDescLst, outputColumnNames);
                    }
                }
                int groupingColsSize = gbExprNDescLst.size();
                List groupingSets = null;
                if (cubeRollupGrpSetPresent) {
                    groupingSets = (List)CalcitePlanner.this.getGroupByGroupingSetsForClause(qbp, detsClauseName).getSecond();
                }
                ArrayList<AggInfo> aggregations = new ArrayList<AggInfo>();
                if (hasAggregationTrees) {
                    assert (aggregationTrees != null);
                    for (ASTNode value : aggregationTrees.values()) {
                        String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
                        boolean isDistinct = value.getType() == 843;
                        boolean isAllColumns = value.getType() == 844;
                        ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
                        for (int i = 1; i < value.getChildCount(); ++i) {
                            ASTNode paraExpr = (ASTNode)value.getChild(i);
                            ExprNodeDesc paraExprNode = CalcitePlanner.this.genExprNodeDesc(paraExpr, groupByInputRowResolver);
                            aggParameters.add(paraExprNode);
                        }
                        GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.COMPLETE, isDistinct);
                        GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, value, isDistinct, isAllColumns);
                        assert (genericUDAFEvaluator != null);
                        SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                        AggInfo aInfo = new AggInfo(aggParameters, udaf.returnType, aggName, isDistinct);
                        aggregations.add(aInfo);
                        String field = SemanticAnalyzer.getColumnInternalName(groupingColsSize + aggregations.size() - 1);
                        outputColumnNames.add(field);
                        groupByOutputRowResolver.putExpression(value, new ColumnInfo(field, aInfo.m_returnType, "", false));
                    }
                }
                if (groupingSets != null && !groupingSets.isEmpty()) {
                    String field = SemanticAnalyzer.getColumnInternalName(groupingColsSize + aggregations.size());
                    outputColumnNames.add(field);
                    groupByOutputRowResolver.put(null, VirtualColumn.GROUPINGID.getName(), new ColumnInfo(field, VirtualColumn.GROUPINGID.getTypeInfo(), null, true));
                }
                gbRel = this.genGBRelNode(gbExprNDescLst, aggregations, groupingSets, srcRel);
                this.relToHiveColNameCalcitePosMap.put(gbRel, this.buildHiveToCalciteColumnMap(groupByOutputRowResolver, gbRel));
                this.relToHiveRR.put(gbRel, groupByOutputRowResolver);
            }
            return gbRel;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private RelNode genOBLogicalPlan(QB qb, Pair<RelNode, RowResolver> selPair, boolean outermostOB) throws SemanticException {
            String error;
            String dest;
            RelNode srcRel = (RelNode)selPair.getKey();
            RowResolver selectOutputRR = (RowResolver)selPair.getValue();
            HiveSortLimit sortRel = null;
            HiveSortLimit returnRel = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            ASTNode obAST = qbp.getOrderByForClause(dest = qbp.getClauseNames().iterator().next());
            if (obAST == null) return returnRel;
            Integer limit = qb.getParseInfo().getDestLimit(dest);
            if (limit == null && (error = HiveConf.StrictChecks.checkNoLimit((Configuration)CalcitePlanner.this.conf)) != null) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(obAST, error));
            }
            ArrayList<RexNode> newVCLst = new ArrayList<RexNode>();
            ArrayList fieldCollations = Lists.newArrayList();
            int fieldIndex = 0;
            List obASTExprLst = obAST.getChildren();
            ArrayList<Pair> vcASTTypePairs = new ArrayList<Pair>();
            RowResolver inputRR = this.relToHiveRR.get(srcRel);
            RowResolver outputRR = new RowResolver();
            RexNodeConverter converter = new RexNodeConverter(this.cluster, srcRel.getRowType(), this.relToHiveColNameCalcitePosMap.get(srcRel), 0, false);
            int srcRelRecordSz = srcRel.getRowType().getFieldCount();
            for (int i = 0; i < obASTExprLst.size(); ++i) {
                RelFieldCollation.NullDirection nullOrder;
                boolean isObyByPos;
                ASTNode obASTExpr = (ASTNode)obASTExprLst.get(i);
                ASTNode nullObASTExpr = (ASTNode)obASTExpr.getChild(0);
                ASTNode ref = (ASTNode)nullObASTExpr.getChild(0);
                Map<ASTNode, ExprNodeDesc> astToExprNDescMap = null;
                ExprNodeDesc obExprNDesc = null;
                boolean isBothByPos = HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_GROUPBY_ORDERBY_POSITION_ALIAS);
                boolean bl = isObyByPos = isBothByPos || HiveConf.getBoolVar((Configuration)CalcitePlanner.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORDERBY_POSITION_ALIAS);
                if (ref != null && ref.getToken().getType() == 367) {
                    if (isObyByPos) {
                        int pos = Integer.parseInt(ref.getText());
                        if (pos <= 0) throw new SemanticException(ErrorMsg.INVALID_POSITION_ALIAS_IN_ORDERBY.getMsg("Position alias: " + pos + " does not exist\nThe Select List is indexed from 1 to " + selectOutputRR.getColumnInfos().size()));
                        if (pos > selectOutputRR.getColumnInfos().size()) throw new SemanticException(ErrorMsg.INVALID_POSITION_ALIAS_IN_ORDERBY.getMsg("Position alias: " + pos + " does not exist\nThe Select List is indexed from 1 to " + selectOutputRR.getColumnInfos().size()));
                        fieldIndex = pos - 1;
                    } else {
                        CalcitePlanner.this.LOG.warn("Using constant number " + ref.getText() + " in order by. If you try to use position alias when hive.orderby.position.alias is false, the position alias will be ignored.");
                    }
                } else {
                    if (selectOutputRR != null) {
                        try {
                            astToExprNDescMap = CalcitePlanner.this.genAllExprNodeDesc(ref, selectOutputRR);
                            obExprNDesc = astToExprNDescMap.get(ref);
                        }
                        catch (SemanticException ex) {
                            CalcitePlanner.this.LOG.debug("Can not find column in " + ref.getText() + ". The error msg is " + ex.getMessage());
                        }
                    }
                    if (obExprNDesc == null) {
                        astToExprNDescMap = CalcitePlanner.this.genAllExprNodeDesc(ref, inputRR);
                        obExprNDesc = astToExprNDescMap.get(ref);
                    }
                    if (obExprNDesc == null) {
                        throw new SemanticException("Invalid order by expression: " + obASTExpr.toString());
                    }
                    RexNode rnd = converter.convert(obExprNDesc);
                    if (rnd instanceof RexInputRef) {
                        fieldIndex = ((RexInputRef)rnd).getIndex();
                    } else {
                        fieldIndex = srcRelRecordSz + newVCLst.size();
                        newVCLst.add(rnd);
                        vcASTTypePairs.add(new Pair((Object)ref, (Object)obExprNDesc.getTypeInfo()));
                    }
                }
                RelFieldCollation.Direction order = RelFieldCollation.Direction.DESCENDING;
                if (obASTExpr.getType() == 1063) {
                    order = RelFieldCollation.Direction.ASCENDING;
                }
                if (nullObASTExpr.getType() == 904) {
                    nullOrder = RelFieldCollation.NullDirection.FIRST;
                } else {
                    if (nullObASTExpr.getType() != 905) throw new SemanticException("Unexpected null ordering option: " + nullObASTExpr.getType());
                    nullOrder = RelFieldCollation.NullDirection.LAST;
                }
                fieldCollations.add(new RelFieldCollation(fieldIndex, order, nullOrder));
            }
            RelNode obInputRel = srcRel;
            if (!newVCLst.isEmpty()) {
                List originalInputRefs = Lists.transform((List)srcRel.getRowType().getFieldList(), (Function)new Function<RelDataTypeField, RexNode>(){

                    public RexNode apply(RelDataTypeField input) {
                        return new RexInputRef(input.getIndex(), input.getType());
                    }
                });
                RowResolver obSyntheticProjectRR = new RowResolver();
                if (!RowResolver.add(obSyntheticProjectRR, inputRR)) {
                    throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                }
                int vcolPos = inputRR.getRowSchema().getSignature().size();
                for (Pair astTypePair : vcASTTypePairs) {
                    obSyntheticProjectRR.putExpression((ASTNode)astTypePair.getKey(), new ColumnInfo(SemanticAnalyzer.getColumnInternalName(vcolPos), (TypeInfo)astTypePair.getValue(), null, false));
                    ++vcolPos;
                }
                obInputRel = this.genSelectRelNode((List<RexNode>)CompositeList.of((List)originalInputRefs, newVCLst), obSyntheticProjectRR, srcRel);
                if (outermostOB ? !RowResolver.add(outputRR, inputRR) : !RowResolver.add(outputRR, obSyntheticProjectRR)) {
                    throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                }
            } else if (!RowResolver.add(outputRR, inputRR)) {
                throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
            }
            RelTraitSet traitSet = this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION);
            RelCollation canonizedCollation = (RelCollation)traitSet.canonize((RelTrait)RelCollationImpl.of((List)fieldCollations));
            sortRel = new HiveSortLimit(this.cluster, traitSet, obInputRel, canonizedCollation, null, null);
            ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.buildHiveToCalciteColumnMap(outputRR, sortRel);
            this.relToHiveRR.put(sortRel, outputRR);
            this.relToHiveColNameCalcitePosMap.put(sortRel, hiveColNameCalcitePosMap);
            if (selectOutputRR == null) return sortRel;
            List originalInputRefs = Lists.transform((List)srcRel.getRowType().getFieldList(), (Function)new Function<RelDataTypeField, RexNode>(){

                public RexNode apply(RelDataTypeField input) {
                    return new RexInputRef(input.getIndex(), input.getType());
                }
            });
            ArrayList selectedRefs = Lists.newArrayList();
            int index = 0;
            while (index < selectOutputRR.getColumnInfos().size()) {
                selectedRefs.add(originalInputRefs.get(index));
                ++index;
            }
            return this.genSelectRelNode(selectedRefs, selectOutputRR, sortRel);
        }

        private RelNode genLimitLogicalPlan(QB qb, RelNode srcRel) throws SemanticException {
            Integer fetch;
            HiveSortLimit sortRel = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            AbstractMap.SimpleEntry<Integer, Integer> entry = qbp.getDestToLimit().get(qbp.getClauseNames().iterator().next());
            Integer offset = entry == null ? Integer.valueOf(0) : entry.getKey();
            Integer n = fetch = entry == null ? null : entry.getValue();
            if (fetch != null) {
                RexLiteral offsetRN = this.cluster.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(offset.intValue()));
                RexLiteral fetchRN = this.cluster.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(fetch.intValue()));
                RelTraitSet traitSet = this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION);
                RelCollation canonizedCollation = (RelCollation)traitSet.canonize((RelTrait)RelCollations.EMPTY);
                sortRel = new HiveSortLimit(this.cluster, traitSet, srcRel, canonizedCollation, (RexNode)offsetRN, (RexNode)fetchRN);
                RowResolver outputRR = new RowResolver();
                if (!RowResolver.add(outputRR, this.relToHiveRR.get(srcRel))) {
                    throw new CalciteSemanticException("Duplicates detected when adding columns to RR: see previous message", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                }
                ImmutableMap<String, Integer> hiveColNameCalcitePosMap = this.buildHiveToCalciteColumnMap(outputRR, sortRel);
                this.relToHiveRR.put(sortRel, outputRR);
                this.relToHiveColNameCalcitePosMap.put(sortRel, hiveColNameCalcitePosMap);
            }
            return sortRel;
        }

        private List<RexNode> getPartitionKeys(PTFInvocationSpec.PartitionSpec ps, RexNodeConverter converter, RowResolver inputRR) throws SemanticException {
            ArrayList<RexNode> pKeys = new ArrayList<RexNode>();
            if (ps != null) {
                ArrayList<PTFInvocationSpec.PartitionExpression> pExprs = ps.getExpressions();
                for (PTFInvocationSpec.PartitionExpression pExpr : pExprs) {
                    TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR);
                    tcCtx.setAllowStatefulFunctions(true);
                    ExprNodeDesc exp = CalcitePlanner.this.genExprNodeDesc(pExpr.getExpression(), inputRR, tcCtx);
                    pKeys.add(converter.convert(exp));
                }
            }
            return pKeys;
        }

        private List<RexFieldCollation> getOrderKeys(PTFInvocationSpec.OrderSpec os, RexNodeConverter converter, RowResolver inputRR) throws SemanticException {
            ArrayList<RexFieldCollation> oKeys = new ArrayList<RexFieldCollation>();
            if (os != null) {
                ArrayList<PTFInvocationSpec.OrderExpression> oExprs = os.getExpressions();
                for (PTFInvocationSpec.OrderExpression oExpr : oExprs) {
                    TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR);
                    tcCtx.setAllowStatefulFunctions(true);
                    ExprNodeDesc exp = CalcitePlanner.this.genExprNodeDesc(oExpr.getExpression(), inputRR, tcCtx);
                    RexNode ordExp = converter.convert(exp);
                    HashSet<SqlKind> flags = new HashSet<SqlKind>();
                    if (oExpr.getOrder() == PTFInvocationSpec.Order.DESC) {
                        flags.add(SqlKind.DESCENDING);
                    }
                    if (oExpr.getNullOrder() == PTFInvocationSpec.NullOrder.NULLS_FIRST) {
                        flags.add(SqlKind.NULLS_FIRST);
                    } else if (oExpr.getNullOrder() == PTFInvocationSpec.NullOrder.NULLS_LAST) {
                        flags.add(SqlKind.NULLS_LAST);
                    } else {
                        throw new SemanticException("Unexpected null ordering option: " + (Object)((Object)oExpr.getNullOrder()));
                    }
                    oKeys.add(new RexFieldCollation(ordExp, flags));
                }
            }
            return oKeys;
        }

        private RexWindowBound getBound(WindowingSpec.BoundarySpec bs, RexNodeConverter converter) {
            RexWindowBound rwb = null;
            if (bs != null) {
                SqlParserPos pos = new SqlParserPos(1, 1);
                SqlNumericLiteral amt = bs.getAmt() == 0 ? null : SqlLiteral.createExactNumeric((String)String.valueOf(bs.getAmt()), (SqlParserPos)new SqlParserPos(2, 2));
                RexNode amtLiteral = null;
                SqlCall sc = null;
                if (amt != null) {
                    amtLiteral = this.cluster.getRexBuilder().makeLiteral((Object)new Integer(bs.getAmt()), this.cluster.getTypeFactory().createSqlType(SqlTypeName.INTEGER), true);
                }
                switch (bs.getDirection()) {
                    case PRECEDING: {
                        if (amt == null) {
                            rwb = RexWindowBound.create((SqlNode)SqlWindow.createUnboundedPreceding((SqlParserPos)pos), null);
                            break;
                        }
                        sc = (SqlCall)SqlWindow.createPreceding((SqlNode)amt, (SqlParserPos)pos);
                        rwb = RexWindowBound.create((SqlNode)sc, (RexNode)this.cluster.getRexBuilder().makeCall(sc.getOperator(), new RexNode[]{amtLiteral}));
                        break;
                    }
                    case CURRENT: {
                        rwb = RexWindowBound.create((SqlNode)SqlWindow.createCurrentRow((SqlParserPos)new SqlParserPos(1, 1)), null);
                        break;
                    }
                    case FOLLOWING: {
                        if (amt == null) {
                            rwb = RexWindowBound.create((SqlNode)SqlWindow.createUnboundedFollowing((SqlParserPos)new SqlParserPos(1, 1)), null);
                            break;
                        }
                        sc = (SqlCall)SqlWindow.createFollowing((SqlNode)amt, (SqlParserPos)pos);
                        rwb = RexWindowBound.create((SqlNode)sc, (RexNode)this.cluster.getRexBuilder().makeCall(sc.getOperator(), new RexNode[]{amtLiteral}));
                    }
                }
            }
            return rwb;
        }

        private int getWindowSpecIndx(ASTNode wndAST) {
            int wi = wndAST.getChildCount() - 1;
            if (wi <= 0 || wndAST.getChild(wi).getType() != 1102) {
                wi = -1;
            }
            return wi;
        }

        private Pair<RexNode, TypeInfo> genWindowingProj(QB qb, WindowingSpec.WindowExpressionSpec wExpSpec, RelNode srcRel) throws SemanticException {
            ImmutableList.Builder calciteAggFnArgsTypeBldr;
            ImmutableList.Builder calciteAggFnArgsBldr;
            RexNodeConverter converter;
            RelDataType calciteAggFnRetType;
            AggInfo hiveAggInfo;
            RexNode w = null;
            TypeInfo wHiveRetType = null;
            if (wExpSpec instanceof WindowingSpec.WindowFunctionSpec) {
                WindowingSpec.WindowFunctionSpec wFnSpec = (WindowingSpec.WindowFunctionSpec)wExpSpec;
                ASTNode windowProjAst = wFnSpec.getExpression();
                int wndSpecASTIndx = this.getWindowSpecIndx(windowProjAst);
                hiveAggInfo = this.getHiveAggInfo(windowProjAst, wndSpecASTIndx - 1, this.relToHiveRR.get(srcRel));
                wHiveRetType = hiveAggInfo.m_returnType;
                calciteAggFnRetType = TypeConverter.convert(hiveAggInfo.m_returnType, this.cluster.getTypeFactory());
                ImmutableMap<String, Integer> posMap = this.relToHiveColNameCalcitePosMap.get(srcRel);
                converter = new RexNodeConverter(this.cluster, srcRel.getRowType(), posMap, 0, false);
                calciteAggFnArgsBldr = ImmutableList.builder();
                calciteAggFnArgsTypeBldr = ImmutableList.builder();
                for (int i = 0; i < hiveAggInfo.m_aggParams.size(); ++i) {
                    calciteAggFnArgsBldr.add((Object)converter.convert((ExprNodeDesc)hiveAggInfo.m_aggParams.get(i)));
                    calciteAggFnArgsTypeBldr.add((Object)TypeConverter.convert(((ExprNodeDesc)hiveAggInfo.m_aggParams.get(i)).getTypeInfo(), this.cluster.getTypeFactory()));
                }
            } else {
                throw new RuntimeException("Unsupported window Spec");
            }
            ImmutableList calciteAggFnArgs = calciteAggFnArgsBldr.build();
            ImmutableList calciteAggFnArgsType = calciteAggFnArgsTypeBldr.build();
            SqlAggFunction calciteAggFn = SqlFunctionConverter.getCalciteAggFn(hiveAggInfo.m_udfName, hiveAggInfo.m_distinct, (ImmutableList<RelDataType>)calciteAggFnArgsType, calciteAggFnRetType);
            RowResolver inputRR = this.relToHiveRR.get(srcRel);
            WindowingSpec.WindowSpec wndSpec = ((WindowingSpec.WindowFunctionSpec)wExpSpec).getWindowSpec();
            List<RexNode> partitionKeys = this.getPartitionKeys(wndSpec.getPartition(), converter, inputRR);
            List<RexFieldCollation> orderKeys = this.getOrderKeys(wndSpec.getOrder(), converter, inputRR);
            RexWindowBound upperBound = this.getBound(wndSpec.getWindowFrame().getStart(), converter);
            RexWindowBound lowerBound = this.getBound(wndSpec.getWindowFrame().getEnd(), converter);
            boolean isRows = wndSpec.getWindowFrame().getWindowType() == WindowingSpec.WindowType.ROWS;
            w = this.cluster.getRexBuilder().makeOver(calciteAggFnRetType, calciteAggFn, (List)calciteAggFnArgs, partitionKeys, ImmutableList.copyOf(orderKeys), lowerBound, upperBound, isRows, true, false, hiveAggInfo.m_distinct);
            return new Pair((Object)w, (Object)wHiveRetType);
        }

        private RelNode genSelectForWindowing(QB qb, RelNode srcRel, HashSet<ColumnInfo> newColumns) throws SemanticException {
            WindowingSpec wSpec;
            this.getQBParseInfo(qb);
            WindowingSpec windowingSpec = wSpec = !qb.getAllWindowingSpecs().isEmpty() ? qb.getAllWindowingSpecs().values().iterator().next() : null;
            if (wSpec == null) {
                return null;
            }
            wSpec.validateAndMakeEffective();
            ArrayList<WindowingSpec.WindowExpressionSpec> windowExpressions = wSpec.getWindowExpressions();
            if (windowExpressions == null || windowExpressions.isEmpty()) {
                return null;
            }
            RowResolver inputRR = this.relToHiveRR.get(srcRel);
            ArrayList<RexNode> projsForWindowSelOp = new ArrayList<RexNode>(HiveCalciteUtil.getProjsFromBelowAsInputRef(srcRel));
            RowResolver out_rwsch = new RowResolver();
            if (!RowResolver.add(out_rwsch, inputRR)) {
                CalcitePlanner.this.LOG.warn("Duplicates detected when adding columns to RR: see previous message");
            }
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String selClauseName = qbp.getClauseNames().iterator().next();
            boolean cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
            for (WindowingSpec.WindowExpressionSpec wExprSpec : windowExpressions) {
                if (!qbp.getDestToGroupBy().isEmpty()) {
                    wExprSpec.setExpression(SemanticAnalyzer.rewriteGroupingFunctionAST(CalcitePlanner.this.getGroupByForClause(qbp, selClauseName), wExprSpec.getExpression(), !cubeRollupGrpSetPresent));
                }
                if (out_rwsch.getExpression(wExprSpec.getExpression()) != null) continue;
                Pair<RexNode, TypeInfo> wtp = this.genWindowingProj(qb, wExprSpec, srcRel);
                projsForWindowSelOp.add((RexNode)wtp.getKey());
                ColumnInfo oColInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(projsForWindowSelOp.size()), (TypeInfo)wtp.getValue(), null, false);
                out_rwsch.putExpression(wExprSpec.getExpression(), oColInfo);
                newColumns.add(oColInfo);
            }
            return this.genSelectRelNode(projsForWindowSelOp, out_rwsch, srcRel, windowExpressions);
        }

        private RelNode genSelectRelNode(List<RexNode> calciteColLst, RowResolver out_rwsch, RelNode srcRel) throws CalciteSemanticException {
            return this.genSelectRelNode(calciteColLst, out_rwsch, srcRel, null);
        }

        private RelNode genSelectRelNode(List<RexNode> calciteColLst, RowResolver out_rwsch, RelNode srcRel, List<WindowingSpec.WindowExpressionSpec> windowExpressions) throws CalciteSemanticException {
            HashSet<String> colNamesSet = new HashSet<String>();
            ArrayList<ColumnInfo> cInfoLst = out_rwsch.getRowSchema().getSignature();
            ArrayList<String> columnNames = new ArrayList<String>();
            HashMap<String, String> windowToAlias = null;
            if (windowExpressions != null) {
                windowToAlias = new HashMap<String, String>();
                for (WindowingSpec.WindowExpressionSpec wes : windowExpressions) {
                    windowToAlias.put(wes.getExpression().toStringTree().toLowerCase(), wes.getAlias());
                }
            }
            for (int i = 0; i < calciteColLst.size(); ++i) {
                ColumnInfo cInfo = (ColumnInfo)cInfoLst.get(i);
                String[] qualifiedColNames = out_rwsch.reverseLookup(cInfo.getInternalName());
                String tmpColAlias = qualifiedColNames[1];
                if (tmpColAlias.contains(".") || tmpColAlias.contains(":")) {
                    tmpColAlias = cInfo.getInternalName();
                }
                if (tmpColAlias.startsWith("_c")) {
                    tmpColAlias = "_o_" + tmpColAlias;
                } else if (windowToAlias != null && windowToAlias.containsKey(tmpColAlias)) {
                    tmpColAlias = (String)windowToAlias.get(tmpColAlias);
                }
                int suffix = 1;
                while (colNamesSet.contains(tmpColAlias)) {
                    tmpColAlias = qualifiedColNames[1] + suffix;
                    ++suffix;
                }
                colNamesSet.add(tmpColAlias);
                columnNames.add(tmpColAlias);
            }
            HiveProject selRel = HiveProject.create(srcRel, calciteColLst, columnNames);
            this.relToHiveColNameCalcitePosMap.put(selRel, this.buildHiveToCalciteColumnMap(out_rwsch, selRel));
            this.relToHiveRR.put(selRel, out_rwsch);
            return selRel;
        }

        private void setQueryHints(QB qb) throws SemanticException {
            String selClauseName;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            Tree selExpr0 = qbp.getSelForClause(selClauseName = qbp.getClauseNames().iterator().next()).getChild(0);
            if (selExpr0.getType() != 370) {
                return;
            }
            String hint = CalcitePlanner.this.ctx.getTokenRewriteStream().toString(selExpr0.getTokenStartIndex(), selExpr0.getTokenStopIndex());
            CalcitePlanner.this.LOG.debug("Handling query hints: " + hint);
            ParseDriver pd = new ParseDriver();
            try {
                ASTNode hintNode = pd.parseHint(hint);
                qbp.setHints(hintNode);
            }
            catch (ParseException e) {
                throw new SemanticException("failed to parse query hint: " + e.getMessage(), e);
            }
        }

        private Pair<RelNode, RowResolver> genSelectLogicalPlan(QB qb, RelNode srcRel, RelNode starSrcRel, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR, boolean isAllColRefRewrite) throws SemanticException {
            int startPosn;
            String funcName;
            FunctionInfo fi;
            boolean isInTransform;
            boolean hintPresent;
            RowResolver inputRR;
            HashSet<ColumnInfo> excludedColumns = new HashSet<ColumnInfo>();
            RelNode selForWindow = this.genSelectForWindowing(qb, srcRel, excludedColumns);
            srcRel = selForWindow == null ? srcRel : selForWindow;
            ArrayList<ExprNodeDesc> col_list = new ArrayList<ExprNodeDesc>();
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String selClauseName = qbp.getClauseNames().iterator().next();
            ASTNode selExprList = qbp.getSelForClause(selClauseName);
            SubQueryUtils.checkForTopLevelSubqueries(selExprList);
            boolean cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
            RowResolver out_rwsch = new RowResolver();
            Integer pos = 0;
            RowResolver starRR = inputRR = this.relToHiveRR.get(srcRel);
            if (starSrcRel != null) {
                starRR = this.relToHiveRR.get(starSrcRel);
            }
            boolean selectStar = false;
            int posn = 0;
            boolean bl = hintPresent = selExprList.getChild(0).getType() == 370;
            if (hintPresent) {
                ++posn;
            }
            boolean bl2 = isInTransform = selExprList.getChild(posn).getChild(0).getType() == 1075;
            if (isInTransform) {
                String msg = String.format("SELECT TRANSFORM is currently not supported in CBO, turn off cbo to use TRANSFORM.", new Object[0]);
                CalcitePlanner.this.LOG.debug(msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Select_transform);
            }
            String udtfTableAlias = null;
            GenericUDTF genericUDTF = null;
            String genericUDTFName = null;
            ArrayList<String> udtfColAliases = new ArrayList<String>();
            ASTNode expr = (ASTNode)selExprList.getChild(posn).getChild(0);
            int exprType = expr.getType();
            if ((exprType == 842 || exprType == 844) && (fi = FunctionRegistry.getFunctionInfo(funcName = TypeCheckProcFactory.DefaultExprProcessor.getFunctionText(expr, true))) != null && fi.getGenericUDTF() != null) {
                CalcitePlanner.this.LOG.debug("Find UDTF " + funcName);
                genericUDTF = fi.getGenericUDTF();
                genericUDTFName = funcName;
                if (!fi.isNative()) {
                    CalcitePlanner.this.unparseTranslator.addIdentifierTranslation((ASTNode)expr.getChild(0));
                }
                if (genericUDTF != null && (selectStar = exprType == 844)) {
                    CalcitePlanner.this.genColListRegex(".*", null, (ASTNode)expr.getChild(0), col_list, null, inputRR, starRR, pos, out_rwsch, qb.getAliases(), false);
                }
            }
            if (genericUDTF != null) {
                if (selExprList.getChildCount() > 1) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)selExprList.getChild(1), ErrorMsg.UDTF_MULTIPLE_EXPR.getMsg()));
                }
                ASTNode selExpr = (ASTNode)selExprList.getChild(posn);
                block4: for (int i = 1; i < selExpr.getChildCount(); ++i) {
                    ASTNode selExprChild = (ASTNode)selExpr.getChild(i);
                    switch (selExprChild.getType()) {
                        case 24: {
                            udtfColAliases.add(BaseSemanticAnalyzer.unescapeIdentifier(selExprChild.getText().toLowerCase()));
                            CalcitePlanner.this.unparseTranslator.addIdentifierTranslation(selExprChild);
                            continue block4;
                        }
                        case 1034: {
                            assert (selExprChild.getChildCount() == 1);
                            udtfTableAlias = BaseSemanticAnalyzer.unescapeIdentifier(selExprChild.getChild(0).getText());
                            qb.addAlias(udtfTableAlias);
                            CalcitePlanner.this.unparseTranslator.addIdentifierTranslation((ASTNode)selExprChild.getChild(0));
                            continue block4;
                        }
                        default: {
                            throw new SemanticException("Find invalid token type " + selExprChild.getType() + " in UDTF.");
                        }
                    }
                }
                CalcitePlanner.this.LOG.debug("UDTF table alias is " + udtfTableAlias);
                CalcitePlanner.this.LOG.debug("UDTF col aliases are " + udtfColAliases);
            }
            ASTNode exprList = genericUDTF != null ? expr : selExprList;
            for (int i = startPosn = genericUDTF != null ? posn + 1 : posn; i < exprList.getChildCount(); ++i) {
                ExprNodeDesc exp;
                String recommended;
                String colAlias;
                String tabAlias;
                boolean hasAsClause;
                ASTNode child = (ASTNode)exprList.getChild(i);
                boolean bl3 = hasAsClause = !isInTransform && child.getChildCount() == 2;
                if (genericUDTF == null && child.getChildCount() > 2) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)child.getChild(2), ErrorMsg.INVALID_AS.getMsg()));
                }
                if (genericUDTF != null) {
                    tabAlias = null;
                    colAlias = CalcitePlanner.this.getAutogenColAliasPrfxLbl() + i;
                    expr = child;
                } else {
                    expr = (ASTNode)child.getChild(0);
                    String[] colRef = SemanticAnalyzer.getColAlias(child, CalcitePlanner.this.getAutogenColAliasPrfxLbl(), inputRR, CalcitePlanner.this.autogenColAliasPrfxIncludeFuncName(), i);
                    tabAlias = colRef[0];
                    colAlias = colRef[1];
                    if (hasAsClause) {
                        CalcitePlanner.this.unparseTranslator.addIdentifierTranslation((ASTNode)child.getChild(1));
                    }
                }
                HashMap<ASTNode, RelNode> subQueryToRelNode = new HashMap<ASTNode, RelNode>();
                boolean isSubQuery = this.genSubQueryRelNode(qb, expr, srcRel, false, subQueryToRelNode);
                if (isSubQuery) {
                    ExprNodeDesc subQueryExpr = CalcitePlanner.this.genExprNodeDesc(expr, this.relToHiveRR.get(srcRel), outerRR, subQueryToRelNode, true);
                    col_list.add(subQueryExpr);
                    ColumnInfo colInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), subQueryExpr.getWritableObjectInspector(), tabAlias, false);
                    if (!out_rwsch.putWithCheck(tabAlias, colAlias, null, colInfo)) {
                        throw new CalciteSemanticException("Cannot add column to RR: " + tabAlias + "." + colAlias + " => " + colInfo + " due to duplication, see previous warnings", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                    }
                    pos = pos + 1;
                    continue;
                }
                if (expr.getType() == 713) {
                    pos = CalcitePlanner.this.genColListRegex(".*", expr.getChildCount() == 0 ? null : SemanticAnalyzer.getUnescapedName((ASTNode)expr.getChild(0)).toLowerCase(), expr, col_list, excludedColumns, inputRR, starRR, pos, out_rwsch, qb.getAliases(), true);
                    selectStar = true;
                    continue;
                }
                if (expr.getType() == 1058 && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), CalcitePlanner.this.conf)) {
                    pos = CalcitePlanner.this.genColListRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), null, expr, col_list, excludedColumns, inputRR, starRR, pos, out_rwsch, qb.getAliases(), true);
                    continue;
                }
                if (expr.getType() == 16 && expr.getChild(0).getType() == 1058 && inputRR.hasTableAlias(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase())) && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), CalcitePlanner.this.conf)) {
                    pos = CalcitePlanner.this.genColListRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase()), expr, col_list, excludedColumns, inputRR, starRR, pos, out_rwsch, qb.getAliases(), true);
                    continue;
                }
                if (ParseUtils.containsTokenOfType(expr, 843) && !(srcRel instanceof HiveAggregate)) {
                    throw new CalciteSemanticException("Distinct without an aggregation.", CalciteSemanticException.UnsupportedFeature.Distinct_without_an_aggreggation);
                }
                TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR);
                tcCtx.setAllowStatefulFunctions(true);
                if (!qbp.getDestToGroupBy().isEmpty()) {
                    expr = SemanticAnalyzer.rewriteGroupingFunctionAST(CalcitePlanner.this.getGroupByForClause(qbp, selClauseName), expr, !cubeRollupGrpSetPresent);
                }
                if ((recommended = CalcitePlanner.this.recommendName(exp = CalcitePlanner.this.genExprNodeDesc(expr, inputRR, tcCtx), colAlias)) != null && out_rwsch.get(null, recommended) == null) {
                    colAlias = recommended;
                }
                col_list.add(exp);
                ColumnInfo colInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), exp.getWritableObjectInspector(), tabAlias, false);
                colInfo.setSkewedCol(exp instanceof ExprNodeColumnDesc ? ((ExprNodeColumnDesc)exp).isSkewedCol() : false);
                if (!out_rwsch.putWithCheck(tabAlias, colAlias, null, colInfo)) {
                    throw new CalciteSemanticException("Cannot add column to RR: " + tabAlias + "." + colAlias + " => " + colInfo + " due to duplication, see previous warnings", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                }
                pos = pos + 1;
            }
            selectStar = selectStar && exprList.getChildCount() == posn + 1;
            ArrayList<RexNode> calciteColLst = new ArrayList<RexNode>();
            RexNodeConverter rexNodeConv = new RexNodeConverter(this.cluster, srcRel.getRowType(), outerNameToPosMap, this.buildHiveColNameToInputPosMap(col_list, inputRR), this.relToHiveRR.get(srcRel), outerRR, 0, false, this.subqueryId);
            for (ExprNodeDesc colExpr : col_list) {
                calciteColLst.add(rexNodeConv.convert(colExpr));
            }
            RelNode outputRel = null;
            if (genericUDTF != null) {
                outputRel = this.genUDTFPlan(genericUDTF, genericUDTFName, udtfTableAlias, udtfColAliases, qb, calciteColLst, out_rwsch, srcRel);
            } else {
                String dest = qbp.getClauseNames().iterator().next();
                ASTNode obAST = qbp.getOrderByForClause(dest);
                RowResolver originalRR = null;
                if (!(obAST == null || selForWindow != null && selExprList.getToken().getType() == 984 || isAllColRefRewrite)) {
                    String error;
                    Integer limit = qb.getParseInfo().getDestLimit(dest);
                    if (limit == null && (error = HiveConf.StrictChecks.checkNoLimit((Configuration)CalcitePlanner.this.conf)) != null) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(obAST, error));
                    }
                    List originalInputRefs = Lists.transform((List)srcRel.getRowType().getFieldList(), (Function)new Function<RelDataTypeField, RexNode>(){

                        public RexNode apply(RelDataTypeField input) {
                            return new RexInputRef(input.getIndex(), input.getType());
                        }
                    });
                    originalRR = out_rwsch.duplicate();
                    for (int i = 0; i < inputRR.getColumnInfos().size(); ++i) {
                        ColumnInfo colInfo = new ColumnInfo(inputRR.getColumnInfos().get(i));
                        String internalName = SemanticAnalyzer.getColumnInternalName(out_rwsch.getColumnInfos().size() + i);
                        colInfo.setInternalName(internalName);
                        if (!out_rwsch.putWithCheck(colInfo.getTabAlias(), colInfo.getAlias(), internalName, colInfo)) {
                            CalcitePlanner.this.LOG.trace("Column already present in RR. skipping.");
                            continue;
                        }
                        calciteColLst.add((RexNode)originalInputRefs.get(i));
                    }
                    outputRel = this.genSelectRelNode(calciteColLst, out_rwsch, srcRel);
                    return new Pair((Object)outputRel, (Object)originalRR);
                }
                outputRel = this.genSelectRelNode(calciteColLst, out_rwsch, srcRel);
            }
            if (selForWindow != null && selExprList.getToken().getType() == 984) {
                ImmutableBitSet groupSet = ImmutableBitSet.range((int)outputRel.getRowType().getFieldList().size());
                outputRel = new HiveAggregate(this.cluster, this.cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), outputRel, groupSet, null, new ArrayList<AggregateCall>());
                RowResolver groupByOutputRowResolver = new RowResolver();
                for (int i = 0; i < out_rwsch.getColumnInfos().size(); ++i) {
                    ColumnInfo colInfo = out_rwsch.getColumnInfos().get(i);
                    ColumnInfo newColInfo = new ColumnInfo(colInfo.getInternalName(), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsVirtualCol());
                    groupByOutputRowResolver.put(colInfo.getTabAlias(), colInfo.getAlias(), newColInfo);
                }
                this.relToHiveColNameCalcitePosMap.put(outputRel, this.buildHiveToCalciteColumnMap(groupByOutputRowResolver, outputRel));
                this.relToHiveRR.put(outputRel, groupByOutputRowResolver);
            }
            return new Pair((Object)outputRel, null);
        }

        private RelNode genUDTFPlan(GenericUDTF genericUDTF, String genericUDTFName, String outputTableAlias, ArrayList<String> colAliases, QB qb, List<RexNode> selectColLst, RowResolver selectRR, RelNode input) throws SemanticException {
            int numSuppliedAliases;
            QBParseInfo qbp = qb.getParseInfo();
            if (!qbp.getDestToGroupBy().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_NO_GROUP_BY.getMsg());
            }
            if (!qbp.getDestToDistributeBy().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_NO_DISTRIBUTE_BY.getMsg());
            }
            if (!qbp.getDestToSortBy().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_NO_SORT_BY.getMsg());
            }
            if (!qbp.getDestToClusterBy().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_NO_CLUSTER_BY.getMsg());
            }
            if (!qbp.getAliasToLateralViews().isEmpty()) {
                throw new SemanticException(ErrorMsg.UDTF_LATERAL_VIEW.getMsg());
            }
            CalcitePlanner.this.LOG.debug("Table alias: " + outputTableAlias + " Col aliases: " + colAliases);
            ArrayList<ColumnInfo> inputCols = selectRR.getColumnInfos();
            ArrayList<String> colNames = new ArrayList<String>();
            ObjectInspector[] colOIs = new ObjectInspector[inputCols.size()];
            for (int i = 0; i < inputCols.size(); ++i) {
                colNames.add(inputCols.get(i).getInternalName());
                colOIs[i] = inputCols.get(i).getObjectInspector();
            }
            StandardStructObjectInspector rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(colNames, Arrays.asList(colOIs));
            StructObjectInspector outputOI = genericUDTF.initialize((StructObjectInspector)rowOI);
            int numUdtfCols = outputOI.getAllStructFieldRefs().size();
            if (colAliases.isEmpty()) {
                for (StructField field : outputOI.getAllStructFieldRefs()) {
                    colAliases.add(field.getFieldName());
                }
            }
            if (numUdtfCols != (numSuppliedAliases = colAliases.size())) {
                throw new SemanticException(ErrorMsg.UDTF_ALIAS_MISMATCH.getMsg("expected " + numUdtfCols + " aliases but got " + numSuppliedAliases));
            }
            ArrayList<ColumnInfo> udtfCols = new ArrayList<ColumnInfo>();
            Iterator<String> colAliasesIter = colAliases.iterator();
            for (StructField sf : outputOI.getAllStructFieldRefs()) {
                String colAlias = colAliasesIter.next();
                assert (colAlias != null);
                ColumnInfo col = new ColumnInfo(sf.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)sf.getFieldObjectInspector()), outputTableAlias, false);
                udtfCols.add(col);
            }
            RowResolver out_rwsch = new RowResolver();
            for (int i = 0; i < udtfCols.size(); ++i) {
                out_rwsch.put(outputTableAlias, colAliases.get(i), (ColumnInfo)udtfCols.get(i));
            }
            RelTraitSet traitSet = TraitsUtil.getDefaultTraitSet(this.cluster);
            RelDataType retType = TypeConverter.getType(this.cluster, out_rwsch, null);
            ImmutableList.Builder argTypeBldr = ImmutableList.builder();
            RexBuilder rexBuilder = this.cluster.getRexBuilder();
            RelDataTypeFactory dtFactory = rexBuilder.getTypeFactory();
            RowSchema rs = selectRR.getRowSchema();
            for (ColumnInfo ci : rs.getSignature()) {
                argTypeBldr.add((Object)TypeConverter.convert(ci.getType(), dtFactory));
            }
            SqlOperator calciteOp = SqlFunctionConverter.getCalciteOperator(genericUDTFName, genericUDTF, (ImmutableList<RelDataType>)argTypeBldr.build(), retType);
            ArrayList<RelNode> list = new ArrayList<RelNode>();
            list.add(input);
            RexNode rexNode = this.cluster.getRexBuilder().makeCall(calciteOp, selectColLst);
            HiveTableFunctionScan udtf = HiveTableFunctionScan.create(this.cluster, traitSet, list, rexNode, null, retType, null);
            this.relToHiveColNameCalcitePosMap.put(udtf, this.buildHiveToCalciteColumnMap(out_rwsch, udtf));
            this.relToHiveRR.put(udtf, out_rwsch);
            return udtf;
        }

        private RelNode genLogicalPlan(QBExpr qbexpr) throws SemanticException {
            switch (qbexpr.getOpcode()) {
                case NULLOP: {
                    return this.genLogicalPlan(qbexpr.getQB(), false, null, null);
                }
                case UNION: 
                case INTERSECT: 
                case INTERSECTALL: 
                case EXCEPT: 
                case EXCEPTALL: {
                    RelNode qbexpr1Ops = this.genLogicalPlan(qbexpr.getQBExpr1());
                    RelNode qbexpr2Ops = this.genLogicalPlan(qbexpr.getQBExpr2());
                    return this.genSetOpLogicalPlan(qbexpr.getOpcode(), qbexpr.getAlias(), qbexpr.getQBExpr1().getAlias(), qbexpr1Ops, qbexpr.getQBExpr2().getAlias(), qbexpr2Ops);
                }
            }
            return null;
        }

        private RelNode genLogicalPlan(QB qb, boolean outerMostQB, ImmutableMap<String, Integer> outerNameToPosMap, RowResolver outerRR) throws SemanticException {
            RelNode srcRel = null;
            RelNode filterRel = null;
            RelNode gbRel = null;
            RelNode gbHavingRel = null;
            RelNode selectRel = null;
            RelNode obRel = null;
            RelNode limitRel = null;
            HashMap<String, RelNode> aliasToRel = new HashMap<String, RelNode>();
            String reason = CalcitePlanner.canHandleQbForCbo(CalcitePlanner.this.queryProperties, CalcitePlanner.this.conf, false, CalcitePlanner.this.LOG.isDebugEnabled(), qb);
            if (reason != null) {
                String msg = "CBO can not handle Sub Query";
                if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                    CalcitePlanner.this.LOG.debug(msg + " because it: " + reason);
                }
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Subquery);
            }
            for (String subqAlias : qb.getSubqAliases()) {
                QBExpr qbexpr = qb.getSubqForAlias(subqAlias);
                RelNode relNode = this.genLogicalPlan(qbexpr);
                aliasToRel.put(subqAlias, relNode);
                if (!qb.getViewToTabSchema().containsKey(subqAlias)) continue;
                if (relNode instanceof HiveProject) {
                    if (this.viewProjectToTableSchema == null) {
                        this.viewProjectToTableSchema = new LinkedHashMap<HiveProject, Table>();
                    }
                    this.viewProjectToTableSchema.put((HiveProject)relNode, qb.getViewToTabSchema().get(subqAlias));
                    continue;
                }
                throw new SemanticException("View " + subqAlias + " is corresponding to " + relNode.toString() + ", rather than a HiveProject.");
            }
            for (String tableAlias : qb.getTabAliases()) {
                RelNode op = this.genTableLogicalPlan(tableAlias, qb);
                aliasToRel.put(tableAlias, op);
            }
            if (aliasToRel.isEmpty()) {
                qb.getMetaData().setSrcForAlias("_dummy_table", CalcitePlanner.this.getDummyTable());
                qb.addAlias("_dummy_table");
                qb.setTabAlias("_dummy_table", "_dummy_table");
                RelNode op = this.genTableLogicalPlan("_dummy_table", qb);
                aliasToRel.put("_dummy_table", op);
            }
            this.setQueryHints(qb);
            if (qb.getParseInfo().getJoinExpr() != null) {
                srcRel = this.genJoinLogicalPlan(qb.getParseInfo().getJoinExpr(), aliasToRel);
            } else {
                Map.Entry uniqueAliasToRel = aliasToRel.entrySet().iterator().next();
                srcRel = (RelNode)uniqueAliasToRel.getValue();
                List lateralViews = this.getQBParseInfo(qb).getAliasToLateralViews().get(uniqueAliasToRel.getKey());
                if (lateralViews != null) {
                    srcRel = this.genLateralViewPlans((ASTNode)Iterables.getLast((Iterable)lateralViews), aliasToRel);
                }
            }
            filterRel = this.genFilterLogicalPlan(qb, srcRel, aliasToRel, outerNameToPosMap, outerRR, false);
            RelNode starSrcRel = srcRel = filterRel == null ? srcRel : filterRel;
            gbRel = this.genGBLogicalPlan(qb, srcRel);
            srcRel = gbRel == null ? srcRel : gbRel;
            gbHavingRel = this.genGBHavingLogicalPlan(qb, srcRel, aliasToRel);
            srcRel = gbHavingRel == null ? srcRel : gbHavingRel;
            Pair<RelNode, RowResolver> selPair = this.genSelectLogicalPlan(qb, srcRel, starSrcRel, outerNameToPosMap, outerRR, false);
            selectRel = (RelNode)selPair.getKey();
            srcRel = selectRel == null ? srcRel : selectRel;
            obRel = this.genOBLogicalPlan(qb, selPair, outerMostQB);
            srcRel = obRel == null ? srcRel : obRel;
            limitRel = this.genLimitLogicalPlan(qb, srcRel);
            RelNode relNode = srcRel = limitRel == null ? srcRel : limitRel;
            if (qb.getParseInfo().getAlias() != null) {
                RowResolver rr = this.relToHiveRR.get(srcRel);
                RowResolver newRR = new RowResolver();
                String alias = qb.getParseInfo().getAlias();
                for (ColumnInfo colInfo : rr.getColumnInfos()) {
                    String name = colInfo.getInternalName();
                    String[] tmp = rr.reverseLookup(name);
                    if ("".equals(tmp[0]) || tmp[1] == null) {
                        tmp[1] = colInfo.getInternalName();
                    }
                    ColumnInfo newCi = new ColumnInfo(colInfo);
                    newCi.setTabAlias(alias);
                    newRR.put(alias, tmp[1], newCi);
                }
                this.relToHiveRR.put(srcRel, newRR);
                this.relToHiveColNameCalcitePosMap.put(srcRel, this.buildHiveToCalciteColumnMap(newRR, srcRel));
            }
            if (CalcitePlanner.this.LOG.isDebugEnabled()) {
                CalcitePlanner.this.LOG.debug("Created Plan for Query Block " + qb.getId());
            }
            CalcitePlanner.this.setQB(qb);
            return srcRel;
        }

        private RelNode genGBHavingLogicalPlan(QB qb, RelNode srcRel, Map<String, RelNode> aliasToRel) throws SemanticException {
            RelNode gbFilter = null;
            QBParseInfo qbp = this.getQBParseInfo(qb);
            String destClauseName = qbp.getClauseNames().iterator().next();
            ASTNode havingClause = qbp.getHavingForClause(qbp.getClauseNames().iterator().next());
            if (havingClause != null) {
                if (!(srcRel instanceof HiveAggregate)) {
                    throw new CalciteSemanticException("Having clause without any group-by.", CalciteSemanticException.UnsupportedFeature.Having_clause_without_any_groupby);
                }
                ASTNode targetNode = (ASTNode)havingClause.getChild(0);
                this.validateNoHavingReferenceToAlias(qb, targetNode);
                if (!qbp.getDestToGroupBy().isEmpty()) {
                    boolean cubeRollupGrpSetPresent = !qbp.getDestRollups().isEmpty() || !qbp.getDestGroupingSets().isEmpty() || !qbp.getDestCubes().isEmpty();
                    targetNode = SemanticAnalyzer.rewriteGroupingFunctionAST(CalcitePlanner.this.getGroupByForClause(qbp, destClauseName), targetNode, !cubeRollupGrpSetPresent);
                }
                gbFilter = this.genFilterRelNode(qb, targetNode, srcRel, aliasToRel, null, null, true);
            }
            return gbFilter;
        }

        private void validateNoHavingReferenceToAlias(QB qb, ASTNode havingExpr) throws CalciteSemanticException {
            QBParseInfo qbPI = qb.getParseInfo();
            Map<ASTNode, String> exprToAlias = qbPI.getAllExprToColumnAlias();
            Set<String> aggExprs = qbPI.getDestToAggregationExprs().values().iterator().next().keySet();
            for (Map.Entry<ASTNode, String> selExpr : exprToAlias.entrySet()) {
                ASTNode selAST = selExpr.getKey();
                if (!aggExprs.contains(selAST.toStringTree().toLowerCase())) continue;
                final String aliasToCheck = selExpr.getValue();
                final HashSet aliasReferences = new HashSet();
                TreeVisitorAction action = new TreeVisitorAction(){

                    public Object pre(Object t) {
                        Object c;
                        if (ParseDriver.adaptor.getType(t) == 1058 && (c = ParseDriver.adaptor.getChild(t, 0)) != null && ParseDriver.adaptor.getType(c) == 24 && ParseDriver.adaptor.getText(c).equals(aliasToCheck)) {
                            aliasReferences.add(t);
                        }
                        return t;
                    }

                    public Object post(Object t) {
                        return t;
                    }
                };
                new TreeVisitor(ParseDriver.adaptor).visit((Object)havingExpr, action);
                if (aliasReferences.size() <= 0) continue;
                String havingClause = CalcitePlanner.this.ctx.getTokenRewriteStream().toString(havingExpr.getTokenStartIndex(), havingExpr.getTokenStopIndex());
                String msg = String.format("Encountered Select alias '%s' in having clause '%s' This non standard behavior is not supported with cbo on. Turn off cbo for these queries.", aliasToCheck, havingClause);
                CalcitePlanner.this.LOG.debug(msg);
                throw new CalciteSemanticException(msg, CalciteSemanticException.UnsupportedFeature.Select_alias_in_having_clause);
            }
        }

        private ImmutableMap<String, Integer> buildHiveToCalciteColumnMap(RowResolver rr, RelNode rNode) {
            ImmutableMap.Builder b = new ImmutableMap.Builder();
            for (ColumnInfo ci : rr.getRowSchema().getSignature()) {
                b.put((Object)ci.getInternalName(), (Object)rr.getPosition(ci.getInternalName()));
            }
            return b.build();
        }

        private ImmutableMap<String, Integer> buildHiveColNameToInputPosMap(List<ExprNodeDesc> col_list, RowResolver inputRR) {
            HashMap<Integer, ExprNodeDesc> hashCodeTocolumnDescMap = new HashMap<Integer, ExprNodeDesc>();
            ExprNodeDescUtils.getExprNodeColumnDesc(col_list, hashCodeTocolumnDescMap);
            ImmutableMap.Builder hiveColNameToInputPosMapBuilder = new ImmutableMap.Builder();
            for (ExprNodeDesc exprDesc : hashCodeTocolumnDescMap.values()) {
                String exprNodecolName = ((ExprNodeColumnDesc)exprDesc).getColumn();
                hiveColNameToInputPosMapBuilder.put((Object)exprNodecolName, (Object)inputRR.getPosition(exprNodecolName));
            }
            return hiveColNameToInputPosMapBuilder.build();
        }

        private QBParseInfo getQBParseInfo(QB qb) throws CalciteSemanticException {
            return qb.getParseInfo();
        }

        private List<String> getTabAliases(RowResolver inputRR) {
            ArrayList<String> tabAliases = new ArrayList<String>();
            for (ColumnInfo ci : inputRR.getColumnInfos()) {
                tabAliases.add(ci.getTabAlias());
            }
            return tabAliases;
        }

        private class AggInfo {
            private final List<ExprNodeDesc> m_aggParams;
            private final TypeInfo m_returnType;
            private final String m_udfName;
            private final boolean m_distinct;

            private AggInfo(List<ExprNodeDesc> aggParams, TypeInfo returnType, String udfName, boolean isDistinct) {
                this.m_aggParams = aggParams;
                this.m_returnType = returnType;
                this.m_udfName = udfName;
                this.m_distinct = isDistinct;
            }
        }
    }

    private static enum ExtendedCBOProfile {
        JOIN_REORDERING,
        WINDOWING_POSTPROCESSING;

    }

    private static class ExceptionHelper {
        private static final Field CAUSE_FIELD = ExceptionHelper.getField(Throwable.class, "cause");
        private static final Field TARGET_FIELD = ExceptionHelper.getField(InvocationTargetException.class, "target");
        private static final Field MESSAGE_FIELD = ExceptionHelper.getField(Throwable.class, "detailMessage");

        private ExceptionHelper() {
        }

        private static Field getField(Class<?> clazz, String name) {
            try {
                Field f = clazz.getDeclaredField(name);
                f.setAccessible(true);
                return f;
            }
            catch (Throwable t) {
                return null;
            }
        }

        public static boolean resetCause(Throwable target, Throwable newCause) {
            try {
                Field field;
                if (MESSAGE_FIELD == null) {
                    return false;
                }
                Field field2 = field = target instanceof InvocationTargetException ? TARGET_FIELD : CAUSE_FIELD;
                if (field == null) {
                    return false;
                }
                Throwable oldCause = target.getCause();
                String oldMsg = target.getMessage();
                field.set(target, newCause);
                if (oldMsg != null && oldMsg.equals(oldCause.toString())) {
                    MESSAGE_FIELD.set(target, newCause == null ? null : newCause.toString());
                }
            }
            catch (Throwable se) {
                return false;
            }
            return true;
        }
    }

    public static class ASTSearcher {
        private final LinkedList<ASTNode> searchQueue = new LinkedList();

        public ASTNode simpleBreadthFirstSearch(ASTNode ast, int ... tokens) {
            this.searchQueue.clear();
            this.searchQueue.add(ast);
            for (int i = 0; i < tokens.length; ++i) {
                boolean found = false;
                int token = tokens[i];
                while (!this.searchQueue.isEmpty() && !found) {
                    ASTNode next = this.searchQueue.poll();
                    boolean bl = found = next.getType() == token;
                    if (found) {
                        if (i == tokens.length - 1) {
                            return next;
                        }
                        this.searchQueue.clear();
                    }
                    for (int j = 0; j < next.getChildCount(); ++j) {
                        this.searchQueue.add((ASTNode)next.getChild(j));
                    }
                }
                if (found) continue;
                return null;
            }
            return null;
        }

        public ASTNode depthFirstSearch(ASTNode ast, int token) {
            this.searchQueue.clear();
            this.searchQueue.add(ast);
            while (!this.searchQueue.isEmpty()) {
                ASTNode next = this.searchQueue.poll();
                if (next.getType() == token) {
                    return next;
                }
                for (int j = 0; j < next.getChildCount(); ++j) {
                    this.searchQueue.add((ASTNode)next.getChild(j));
                }
            }
            return null;
        }

        public ASTNode simpleBreadthFirstSearchAny(ASTNode ast, int ... tokens) {
            this.searchQueue.clear();
            this.searchQueue.add(ast);
            while (!this.searchQueue.isEmpty()) {
                int i;
                ASTNode next = this.searchQueue.poll();
                for (i = 0; i < tokens.length; ++i) {
                    if (next.getType() != tokens[i]) continue;
                    return next;
                }
                for (i = 0; i < next.getChildCount(); ++i) {
                    this.searchQueue.add((ASTNode)next.getChild(i));
                }
            }
            return null;
        }

        public void reset() {
            this.searchQueue.clear();
        }
    }

    static class PreCboCtx
    extends SemanticAnalyzer.PlannerContext {
        private ASTNode nodeOfInterest;
        private Type type = Type.NONE;

        PreCboCtx() {
        }

        private void set(Type type, ASTNode ast) {
            if (this.type != Type.NONE) {
                BaseSemanticAnalyzer.STATIC_LOG.warn("Setting " + (Object)((Object)type) + " when already " + (Object)((Object)this.type) + "; node " + ast.dump() + " vs old node " + this.nodeOfInterest.dump());
                this.type = Type.UNEXPECTED;
                return;
            }
            this.type = type;
            this.nodeOfInterest = ast;
        }

        @Override
        void setCTASToken(ASTNode child) {
            this.set(Type.CTAS, child);
        }

        @Override
        void setViewToken(ASTNode child) {
            this.set(Type.VIEW, child);
        }

        @Override
        void setInsertToken(ASTNode ast, boolean isTmpFileDest) {
            if (!isTmpFileDest) {
                this.set(Type.INSERT, ast);
            }
        }

        @Override
        void setMultiInsertToken(ASTNode child) {
            this.set(Type.MULTI_INSERT, child);
        }

        @Override
        void resetToken() {
            this.type = Type.NONE;
            this.nodeOfInterest = null;
        }

        static enum Type {
            NONE,
            INSERT,
            MULTI_INSERT,
            CTAS,
            VIEW,
            UNEXPECTED;

        }
    }
}

