/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.optimizer;

import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.DepthFirstWalker;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.optimizer.AllExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.optimizer.PlanTransformListener;

public class ProjectionPatcher
implements PlanTransformListener {
    @Override
    public void transformed(OperatorPlan fp, OperatorPlan tp) throws FrontendException {
        ProjectionFinder pf = new ProjectionFinder(tp);
        pf.visit();
    }

    public static class ProjectionFinder
    extends AllExpressionVisitor {
        public ProjectionFinder(OperatorPlan plan) throws FrontendException {
            super(plan, new DependencyOrderWalker(plan));
        }

        @Override
        protected LogicalExpressionVisitor getVisitor(LogicalExpressionPlan expr) throws FrontendException {
            return new ProjectionRewriter((OperatorPlan)expr, this.currentOp);
        }
    }

    private static class ProjectionRewriter
    extends LogicalExpressionVisitor {
        ProjectionRewriter(OperatorPlan p, LogicalRelationalOperator cop) throws FrontendException {
            super(p, new DepthFirstWalker(p));
        }

        @Override
        public void visit(ProjectExpression p) throws FrontendException {
            if (p.isRangeOrStarProject()) {
                return;
            }
            long myUid = p.getFieldSchema().uid;
            LogicalRelationalOperator pred = p.findReferent();
            if (p.getAttachedRelationalOp() instanceof LOGenerate && p.getPlan().getSuccessors(p) == null) {
                return;
            }
            int match = -1;
            LogicalSchema schema = pred.getSchema();
            if (schema == null) {
                return;
            }
            List<LogicalSchema.LogicalFieldSchema> fields = schema.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                if (fields.get((int)i).uid != myUid) continue;
                match = i;
                break;
            }
            if (match == -1) {
                throw new FrontendException("Couldn't find matching uid " + match + " for project " + p, 2229);
            }
            p.setColNum(match);
        }
    }
}

