/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.List;
import org.apache.pig.SortColInfo;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.LogicalToPhysicalTranslatorException;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LogicalPlan;

public class MapSideMergeValidator {
    public boolean validateMapSideMerge(List<Operator> preds, OperatorPlan lp) throws LogicalToPhysicalTranslatorException {
        int errCode = 1103;
        String errMsg = "Merge join/Cogroup only supports Filter, Foreach, Ascending Sort, or Load as its predecessors. Found : ";
        if (preds != null) {
            for (Operator lo : preds) {
                if (!(lo instanceof LOFilter || lo instanceof LOGenerate || lo instanceof LOInnerLoad || lo instanceof LOLoad || lo instanceof LOSplitOutput || lo instanceof LOSplit || lo instanceof LOJoin && ((LOJoin)lo).getJoinType() == LOJoin.JOINTYPE.REPLICATED || this.isAcceptableSortOp(lo) || this.isAcceptableForEachOp(lo))) {
                    throw new LogicalToPhysicalTranslatorException(errMsg, errCode);
                }
                if (lo instanceof LOSort) continue;
                this.validateMapSideMerge(lp.getPredecessors(lo), lp);
            }
        }
        return true;
    }

    private boolean isAcceptableForEachOp(Operator lo) throws LogicalToPhysicalTranslatorException {
        if (lo instanceof LOForEach) {
            LogicalPlan innerPlan = ((LOForEach)lo).getInnerPlan();
            return this.validateMapSideMerge(innerPlan.getSinks(), innerPlan);
        }
        return false;
    }

    private boolean isAcceptableSortOp(Operator op) throws LogicalToPhysicalTranslatorException {
        if (!(op instanceof LOSort)) {
            return false;
        }
        LOSort sort = (LOSort)op;
        try {
            for (SortColInfo colInfo : sort.getSortInfo().getSortColInfoList()) {
                if (colInfo.getSortOrder() == SortColInfo.Order.ASCENDING) continue;
                return false;
            }
        }
        catch (FrontendException e) {
            throw new LogicalToPhysicalTranslatorException(e);
        }
        return true;
    }
}

