/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.impl.ActiveCompactionImpl;
import org.apache.accumulo.core.client.impl.ActiveScanImpl;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.impl.ServerClient;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.ConfigurationType;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.LoggerFactory;

public class InstanceOperationsImpl
implements InstanceOperations {
    private final ClientContext context;

    public InstanceOperationsImpl(ClientContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        this.context = context;
    }

    @Override
    public void setProperty(final String property, final String value) throws AccumuloException, AccumuloSecurityException, IllegalArgumentException {
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"property is null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value is null");
        MasterClient.executeVoid(this.context, new ClientExec<MasterClientService.Client>(){

            @Override
            public void execute(MasterClientService.Client client) throws Exception {
                client.setSystemProperty(Tracer.traceInfo(), InstanceOperationsImpl.this.context.rpcCreds(), property, value);
            }
        });
        this.checkLocalityGroups(property);
    }

    @Override
    public void removeProperty(final String property) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"property is null");
        MasterClient.executeVoid(this.context, new ClientExec<MasterClientService.Client>(){

            @Override
            public void execute(MasterClientService.Client client) throws Exception {
                client.removeSystemProperty(Tracer.traceInfo(), InstanceOperationsImpl.this.context.rpcCreds(), property);
            }
        });
        this.checkLocalityGroups(property);
    }

    void checkLocalityGroups(String propChanged) throws AccumuloSecurityException, AccumuloException {
        if (LocalityGroupUtil.isLocalityGroupProperty(propChanged)) {
            try {
                LocalityGroupUtil.checkLocalityGroups(this.getSystemConfiguration().entrySet());
            }
            catch (RuntimeException | LocalityGroupUtil.LocalityGroupConfigurationError e) {
                LoggerFactory.getLogger(this.getClass()).warn("Changing '" + propChanged + "' resulted in bad locality group config. This may be a transient situation since the config spreads over multiple properties. Setting properties in a different order may help. Even though this warning was displayed, the property was updated. Please check your config to ensure consistency.", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, String> getSystemConfiguration() throws AccumuloException, AccumuloSecurityException {
        return ServerClient.execute(this.context, new ClientExecReturn<Map<String, String>, ClientService.Client>(){

            @Override
            public Map<String, String> execute(ClientService.Client client) throws Exception {
                return client.getConfiguration(Tracer.traceInfo(), InstanceOperationsImpl.this.context.rpcCreds(), ConfigurationType.CURRENT);
            }
        });
    }

    @Override
    public Map<String, String> getSiteConfiguration() throws AccumuloException, AccumuloSecurityException {
        return ServerClient.execute(this.context, new ClientExecReturn<Map<String, String>, ClientService.Client>(){

            @Override
            public Map<String, String> execute(ClientService.Client client) throws Exception {
                return client.getConfiguration(Tracer.traceInfo(), InstanceOperationsImpl.this.context.rpcCreds(), ConfigurationType.SITE);
            }
        });
    }

    @Override
    public List<String> getTabletServers() {
        Instance instance = this.context.getInstance();
        ZooCache cache = new ZooCacheFactory().getZooCache(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut());
        String path = ZooUtil.getRoot(instance) + "/tservers";
        ArrayList<String> results = new ArrayList<String>();
        for (String candidate : cache.getChildren(path)) {
            List children = cache.getChildren(path + "/" + candidate);
            if (children == null || children.size() <= 0) continue;
            ArrayList copy = new ArrayList(children);
            Collections.sort(copy);
            byte[] data = cache.get(path + "/" + candidate + "/" + (String)copy.get(0));
            if (data == null || "master".equals(new String(data, StandardCharsets.UTF_8))) continue;
            results.add(candidate);
        }
        return results;
    }

    @Override
    public List<org.apache.accumulo.core.client.admin.ActiveScan> getActiveScans(String tserver) throws AccumuloException, AccumuloSecurityException {
        HostAndPort parsedTserver = HostAndPort.fromString(tserver);
        TabletClientService.Client client = null;
        try {
            client = ThriftUtil.getTServerClient(parsedTserver, this.context);
            ArrayList<ActiveScanImpl> as = new ArrayList<ActiveScanImpl>();
            for (ActiveScan activeScan : client.getActiveScans(Tracer.traceInfo(), this.context.rpcCreds())) {
                try {
                    as.add(new ActiveScanImpl(this.context.getInstance(), activeScan));
                }
                catch (TableNotFoundException e) {
                    throw new AccumuloException(e);
                }
            }
            ArrayList<ActiveScanImpl> arrayList = as;
            return arrayList;
        }
        catch (TTransportException e) {
            throw new AccumuloException(e);
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (TException e) {
            throw new AccumuloException(e);
        }
        finally {
            if (client != null) {
                ThriftUtil.returnClient(client);
            }
        }
    }

    @Override
    public boolean testClassLoad(final String className, final String asTypeName) throws AccumuloException, AccumuloSecurityException {
        return ServerClient.execute(this.context, new ClientExecReturn<Boolean, ClientService.Client>(){

            @Override
            public Boolean execute(ClientService.Client client) throws Exception {
                return client.checkClass(Tracer.traceInfo(), InstanceOperationsImpl.this.context.rpcCreds(), className, asTypeName);
            }
        });
    }

    @Override
    public List<org.apache.accumulo.core.client.admin.ActiveCompaction> getActiveCompactions(String tserver) throws AccumuloException, AccumuloSecurityException {
        HostAndPort parsedTserver = HostAndPort.fromString(tserver);
        TabletClientService.Client client = null;
        try {
            client = ThriftUtil.getTServerClient(parsedTserver, this.context);
            ArrayList<ActiveCompactionImpl> as = new ArrayList<ActiveCompactionImpl>();
            for (ActiveCompaction activeCompaction : client.getActiveCompactions(Tracer.traceInfo(), this.context.rpcCreds())) {
                as.add(new ActiveCompactionImpl(this.context.getInstance(), activeCompaction));
            }
            ArrayList<ActiveCompactionImpl> arrayList = as;
            return arrayList;
        }
        catch (TTransportException e) {
            throw new AccumuloException(e);
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (TException e) {
            throw new AccumuloException(e);
        }
        finally {
            if (client != null) {
                ThriftUtil.returnClient(client);
            }
        }
    }

    @Override
    public void ping(String tserver) throws AccumuloException {
        try (TTransport transport = null;){
            transport = ThriftUtil.createTransport(AddressUtil.parseAddress(tserver, false), this.context);
            TabletClientService.Client client = ThriftUtil.createClient(new TabletClientService.Client.Factory(), transport);
            client.getTabletServerStatus(Tracer.traceInfo(), this.context.rpcCreds());
        }
    }

    @Override
    public void waitForBalance() throws AccumuloException {
        try {
            MasterClient.executeVoid(this.context, new ClientExec<MasterClientService.Client>(){

                @Override
                public void execute(MasterClientService.Client client) throws Exception {
                    client.waitForBalance(Tracer.traceInfo());
                }
            });
        }
        catch (AccumuloSecurityException ex) {
            throw new RuntimeException("Unexpected exception thrown", ex);
        }
    }

    public static String lookupInstanceName(ZooCache zooCache, UUID instanceId) {
        Preconditions.checkArgument((zooCache != null ? 1 : 0) != 0, (Object)"zooCache is null");
        Preconditions.checkArgument((instanceId != null ? 1 : 0) != 0, (Object)"instanceId is null");
        for (String name : zooCache.getChildren("/accumulo/instances")) {
            String instanceNamePath = "/accumulo/instances/" + name;
            byte[] bytes = zooCache.get(instanceNamePath);
            UUID iid = UUID.fromString(new String(bytes, StandardCharsets.UTF_8));
            if (!iid.equals(instanceId)) continue;
            return name;
        }
        return null;
    }
}

