/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapred;

import java.io.IOException;
import org.apache.accumulo.core.client.mapreduce.lib.impl.ConfiguratorBase;
import org.apache.accumulo.core.client.mapreduce.lib.impl.FileOutputConfigurator;
import org.apache.accumulo.core.client.rfile.RFile;
import org.apache.accumulo.core.client.rfile.RFileWriter;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class AccumuloFileOutputFormat
extends FileOutputFormat<Key, Value> {
    private static final Class<?> CLASS = AccumuloFileOutputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    @Deprecated
    protected static AccumuloConfiguration getAccumuloConfiguration(JobConf job) {
        return FileOutputConfigurator.getAccumuloConfiguration(CLASS, (Configuration)job);
    }

    public static void setCompressionType(JobConf job, String compressionType) {
        FileOutputConfigurator.setCompressionType(CLASS, (Configuration)job, compressionType);
    }

    public static void setDataBlockSize(JobConf job, long dataBlockSize) {
        FileOutputConfigurator.setDataBlockSize(CLASS, (Configuration)job, dataBlockSize);
    }

    public static void setFileBlockSize(JobConf job, long fileBlockSize) {
        FileOutputConfigurator.setFileBlockSize(CLASS, (Configuration)job, fileBlockSize);
    }

    public static void setIndexBlockSize(JobConf job, long indexBlockSize) {
        FileOutputConfigurator.setIndexBlockSize(CLASS, (Configuration)job, indexBlockSize);
    }

    public static void setReplication(JobConf job, int replication) {
        FileOutputConfigurator.setReplication(CLASS, (Configuration)job, replication);
    }

    public static void setSampler(JobConf job, SamplerConfiguration samplerConfig) {
        FileOutputConfigurator.setSampler(CLASS, (Configuration)job, samplerConfig);
    }

    public RecordWriter<Key, Value> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        JobConf conf = job;
        AccumuloConfiguration acuConf = FileOutputConfigurator.getAccumuloConfiguration(CLASS, (Configuration)job);
        String extension = acuConf.get(Property.TABLE_FILE_TYPE);
        final Path file = new Path(AccumuloFileOutputFormat.getWorkOutputPath((JobConf)job), AccumuloFileOutputFormat.getUniqueName((JobConf)job, (String)"part") + "." + extension);
        int visCacheSize = ConfiguratorBase.getVisibilityCacheSize((Configuration)conf);
        return new RecordWriter<Key, Value>((Configuration)conf, acuConf, visCacheSize){
            RFileWriter out = null;
            final /* synthetic */ Configuration val$conf;
            final /* synthetic */ AccumuloConfiguration val$acuConf;
            final /* synthetic */ int val$visCacheSize;
            {
                this.val$conf = configuration;
                this.val$acuConf = accumuloConfiguration;
                this.val$visCacheSize = n;
            }

            public void close(Reporter reporter) throws IOException {
                if (this.out != null) {
                    this.out.close();
                }
            }

            public void write(Key key, Value value) throws IOException {
                if (this.out == null) {
                    this.out = RFile.newWriter().to(file.toString()).withFileSystem(file.getFileSystem(this.val$conf)).withTableProperties(this.val$acuConf).withVisibilityCacheSize(this.val$visCacheSize).build();
                    this.out.startDefaultLocalityGroup();
                }
                this.out.append(key, value);
            }
        };
    }
}

