/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class RowDeletingIterator
implements SortedKeyValueIterator<Key, Value> {
    public static final Value DELETE_ROW_VALUE = new Value("DEL_ROW".getBytes(StandardCharsets.UTF_8));
    private SortedKeyValueIterator<Key, Value> source;
    private boolean propogateDeletes;
    private ByteSequence currentRow;
    private boolean currentRowDeleted;
    private long deleteTS;
    private boolean dropEmptyColFams;
    private static final ByteSequence EMPTY = new ArrayByteSequence(new byte[0]);

    private RowDeletingIterator(SortedKeyValueIterator<Key, Value> source, boolean propogateDeletes2) {
        this.source = source;
        this.propogateDeletes = propogateDeletes2;
    }

    public RowDeletingIterator() {
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new RowDeletingIterator(this.source.deepCopy(env), this.propogateDeletes);
    }

    @Override
    public Key getTopKey() {
        return this.source.getTopKey();
    }

    @Override
    public Value getTopValue() {
        return this.source.getTopValue();
    }

    @Override
    public boolean hasTop() {
        return this.source.hasTop();
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.source = source;
        this.propogateDeletes = env.getIteratorScope() == IteratorUtil.IteratorScope.majc && !env.isFullMajorCompaction() || env.getIteratorScope() == IteratorUtil.IteratorScope.minc;
    }

    @Override
    public void next() throws IOException {
        this.source.next();
        this.consumeDeleted();
        this.consumeEmptyColFams();
    }

    private void consumeEmptyColFams() throws IOException {
        while (this.dropEmptyColFams && this.source.hasTop() && this.source.getTopKey().getColumnFamilyData().length() == 0) {
            this.source.next();
            this.consumeDeleted();
        }
    }

    private boolean isDeleteMarker(Key key, Value val) {
        return key.getColumnFamilyData().length() == 0 && key.getColumnQualifierData().length() == 0 && key.getColumnVisibilityData().length() == 0 && val.equals(DELETE_ROW_VALUE);
    }

    private void consumeDeleted() throws IOException {
        while (this.source.hasTop()) {
            if (this.currentRowDeleted) {
                while (this.source.hasTop() && this.currentRow.equals(this.source.getTopKey().getRowData()) && this.source.getTopKey().getTimestamp() <= this.deleteTS) {
                    this.source.next();
                }
                if (this.source.hasTop() && !this.currentRow.equals(this.source.getTopKey().getRowData())) {
                    this.currentRowDeleted = false;
                }
            }
            if (this.currentRowDeleted || !this.source.hasTop() || !this.isDeleteMarker(this.source.getTopKey(), this.source.getTopValue())) break;
            this.currentRow = this.source.getTopKey().getRowData();
            this.currentRowDeleted = true;
            this.deleteTS = this.source.getTopKey().getTimestamp();
            if (!this.propogateDeletes) continue;
            break;
        }
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        if (inclusive && !columnFamilies.contains(EMPTY)) {
            columnFamilies = new HashSet<ByteSequence>(columnFamilies);
            columnFamilies.add(EMPTY);
            this.dropEmptyColFams = true;
        } else if (!inclusive && columnFamilies.contains(EMPTY)) {
            columnFamilies = new HashSet<ByteSequence>(columnFamilies);
            columnFamilies.remove(EMPTY);
            this.dropEmptyColFams = true;
        } else {
            this.dropEmptyColFams = false;
        }
        this.currentRowDeleted = false;
        if (range.getStartKey() != null) {
            Range newRange = new Range(new Key(range.getStartKey().getRow()), true, range.getEndKey(), range.isEndKeyInclusive());
            this.source.seek(newRange, columnFamilies, inclusive);
            this.consumeDeleted();
            this.consumeEmptyColFams();
            if (this.source.hasTop() && range.beforeStartKey(this.source.getTopKey())) {
                this.source.seek(range, columnFamilies, inclusive);
                this.consumeDeleted();
                this.consumeEmptyColFams();
            }
        } else {
            this.source.seek(range, columnFamilies, inclusive);
            this.consumeDeleted();
            this.consumeEmptyColFams();
        }
    }
}

