/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.format;

import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.core.util.format.FormatterConfig;
import org.apache.accumulo.core.util.interpret.ScanInterpreter;
import org.apache.hadoop.io.Text;

public class HexFormatter
implements Formatter,
ScanInterpreter {
    private char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private Iterator<Map.Entry<Key, Value>> iter;
    private FormatterConfig config;

    private void toHex(StringBuilder sb, byte[] bin) {
        for (int i = 0; i < bin.length; ++i) {
            if (i > 0 && i % 2 == 0) {
                sb.append('-');
            }
            sb.append(this.chars[0xF & bin[i] >>> 4]);
            sb.append(this.chars[0xF & bin[i]]);
        }
    }

    private int fromChar(char b) {
        if (b >= '0' && b <= '9') {
            return b - 48;
        }
        if (b >= 'a' && b <= 'f') {
            return b - 97 + 10;
        }
        throw new IllegalArgumentException("Bad char " + b);
    }

    private byte[] toBinary(String hex) {
        hex = hex.replace("-", "");
        byte[] bin = new byte[hex.length() / 2 + hex.length() % 2];
        int j = 0;
        int i = 0;
        while (i < bin.length) {
            bin[i] = (byte)(this.fromChar(hex.charAt(j++)) << 4);
            if (j >= hex.length()) break;
            int n = i++;
            bin[n] = (byte)(bin[n] | (byte)this.fromChar(hex.charAt(j++)));
        }
        return bin;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public String next() {
        Map.Entry<Key, Value> entry = this.iter.next();
        StringBuilder sb = new StringBuilder();
        this.toHex(sb, entry.getKey().getRowData().toArray());
        sb.append("  ");
        this.toHex(sb, entry.getKey().getColumnFamilyData().toArray());
        sb.append("  ");
        this.toHex(sb, entry.getKey().getColumnQualifierData().toArray());
        sb.append(" [");
        sb.append(entry.getKey().getColumnVisibilityData().toString());
        sb.append("] ");
        if (this.config.willPrintTimestamps()) {
            sb.append(Long.toString(entry.getKey().getTimestamp()));
            sb.append("  ");
        }
        this.toHex(sb, entry.getValue().get());
        return sb.toString();
    }

    @Override
    public void remove() {
        this.iter.remove();
    }

    @Override
    public void initialize(Iterable<Map.Entry<Key, Value>> scanner, FormatterConfig config) {
        this.iter = scanner.iterator();
        this.config = new FormatterConfig(config);
    }

    @Override
    public Text interpretRow(Text row) {
        return new Text(this.toBinary(row.toString()));
    }

    @Override
    public Text interpretBeginRow(Text row) {
        return this.interpretRow(row);
    }

    @Override
    public Text interpretEndRow(Text row) {
        return this.interpretRow(row);
    }

    @Override
    public Text interpretColumnFamily(Text cf) {
        return this.interpretRow(cf);
    }

    @Override
    public Text interpretColumnQualifier(Text cq) {
        return this.interpretRow(cq);
    }
}

