/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.ResourceNotFoundException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FairSchedulerConfiguration
extends Configuration {
    public static final Logger LOG = LoggerFactory.getLogger((String)FairSchedulerConfiguration.class.getName());
    @Deprecated
    public static final String RM_SCHEDULER_INCREMENT_ALLOCATION_MB = "yarn.scheduler.increment-allocation-mb";
    @Deprecated
    public static final int DEFAULT_RM_SCHEDULER_INCREMENT_ALLOCATION_MB = 1024;
    @Deprecated
    public static final String RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES = "yarn.scheduler.increment-allocation-vcores";
    @Deprecated
    public static final int DEFAULT_RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES = 1;
    public static final String RM_SCHEDULER_RESERVATION_THRESHOLD_INCREMENT_MULTIPLE = "yarn.scheduler.reservation-threshold.increment-multiple";
    public static final float DEFAULT_RM_SCHEDULER_RESERVATION_THRESHOLD_INCREMENT_MULTIPLE = 2.0f;
    private static final String CONF_PREFIX = "yarn.scheduler.fair.";
    public static final String MIGRATION_MODE = "yarn.scheduler.fair.migration.mode";
    public static final String NO_TERMINAL_RULE_CHECK = "yarn.scheduler.fair.no-terminal-rule.check";
    public static final String ALLOCATION_FILE = "yarn.scheduler.fair.allocation.file";
    protected static final String DEFAULT_ALLOCATION_FILE = "fair-scheduler.xml";
    public static final String ALLOW_UNDECLARED_POOLS = "yarn.scheduler.fair.allow-undeclared-pools";
    public static final boolean DEFAULT_ALLOW_UNDECLARED_POOLS = true;
    public static final String USER_AS_DEFAULT_QUEUE = "yarn.scheduler.fair.user-as-default-queue";
    public static final boolean DEFAULT_USER_AS_DEFAULT_QUEUE = true;
    protected static final float DEFAULT_LOCALITY_THRESHOLD = -1.0f;
    public static final String LOCALITY_THRESHOLD_NODE = "yarn.scheduler.fair.locality.threshold.node";
    public static final float DEFAULT_LOCALITY_THRESHOLD_NODE = -1.0f;
    public static final String LOCALITY_THRESHOLD_RACK = "yarn.scheduler.fair.locality.threshold.rack";
    public static final float DEFAULT_LOCALITY_THRESHOLD_RACK = -1.0f;
    @Deprecated
    protected static final String LOCALITY_DELAY_NODE_MS = "yarn.scheduler.fair.locality-delay-node-ms";
    @Deprecated
    protected static final long DEFAULT_LOCALITY_DELAY_NODE_MS = -1L;
    @Deprecated
    protected static final String LOCALITY_DELAY_RACK_MS = "yarn.scheduler.fair.locality-delay-rack-ms";
    @Deprecated
    protected static final long DEFAULT_LOCALITY_DELAY_RACK_MS = -1L;
    @Deprecated
    public static final String CONTINUOUS_SCHEDULING_ENABLED = "yarn.scheduler.fair.continuous-scheduling-enabled";
    @Deprecated
    public static final boolean DEFAULT_CONTINUOUS_SCHEDULING_ENABLED = false;
    @Deprecated
    public static final String CONTINUOUS_SCHEDULING_SLEEP_MS = "yarn.scheduler.fair.continuous-scheduling-sleep-ms";
    @Deprecated
    public static final int DEFAULT_CONTINUOUS_SCHEDULING_SLEEP_MS = 5;
    public static final String PREEMPTION = "yarn.scheduler.fair.preemption";
    public static final boolean DEFAULT_PREEMPTION = false;
    protected static final String AM_PREEMPTION_PREFIX = "yarn.scheduler.fair.am.preemption.";
    protected static final boolean DEFAULT_AM_PREEMPTION = true;
    protected static final String PREEMPTION_THRESHOLD = "yarn.scheduler.fair.preemption.cluster-utilization-threshold";
    protected static final float DEFAULT_PREEMPTION_THRESHOLD = 0.8f;
    public static final String WAIT_TIME_BEFORE_KILL = "yarn.scheduler.fair.waitTimeBeforeKill";
    public static final int DEFAULT_WAIT_TIME_BEFORE_KILL = 15000;
    static final String INCREMENT_ALLOCATION = ".increment-allocation";
    public static final String WAIT_TIME_BEFORE_NEXT_STARVATION_CHECK_MS = "yarn.scheduler.fair.waitTimeBeforeNextStarvationCheck";
    public static final long DEFAULT_WAIT_TIME_BEFORE_NEXT_STARVATION_CHECK_MS = 10000L;
    public static final String ASSIGN_MULTIPLE = "yarn.scheduler.fair.assignmultiple";
    public static final boolean DEFAULT_ASSIGN_MULTIPLE = false;
    public static final String SIZE_BASED_WEIGHT = "yarn.scheduler.fair.sizebasedweight";
    public static final boolean DEFAULT_SIZE_BASED_WEIGHT = false;
    public static final String DYNAMIC_MAX_ASSIGN = "yarn.scheduler.fair.dynamic.max.assign";
    private static final boolean DEFAULT_DYNAMIC_MAX_ASSIGN = true;
    public static final String MAX_ASSIGN = "yarn.scheduler.fair.max.assign";
    public static final int DEFAULT_MAX_ASSIGN = -1;
    public static final String UPDATE_INTERVAL_MS = "yarn.scheduler.fair.update-interval-ms";
    public static final int DEFAULT_UPDATE_INTERVAL_MS = 500;
    public static final String RESERVABLE_NODES = "yarn.scheduler.fair.reservable-nodes";
    public static final float RESERVABLE_NODES_DEFAULT = 0.05f;
    private static final String INVALID_RESOURCE_DEFINITION_PREFIX = "Error reading resource config--invalid resource definition: ";
    private static final String RESOURCE_PERCENTAGE_PATTERN = "^(-?(\\d+)(\\.\\d*)?)\\s*%\\s*";
    private static final String RESOURCE_VALUE_PATTERN = "^(-?\\d+)(\\.\\d*)?\\s*";
    private static final String RESOURCES_WITH_SPACES_PATTERN = "-?\\d+(?:\\.\\d*)?\\s*[a-z]+\\s*";

    public FairSchedulerConfiguration() {
    }

    public FairSchedulerConfiguration(Configuration conf) {
        super(conf);
    }

    public Resource getMinimumAllocation() {
        int mem = this.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int cpu = this.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        return Resources.createResource((int)mem, (int)cpu);
    }

    public Resource getMaximumAllocation() {
        int mem = this.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        int cpu = this.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        return Resources.createResource((int)mem, (int)cpu);
    }

    public Resource getIncrementAllocation() {
        Long memory = null;
        Integer vCores = null;
        HashMap<String, Long> others = new HashMap<String, Long>();
        ResourceInformation[] resourceTypes = ResourceUtils.getResourceTypesArray();
        for (int i = 0; i < resourceTypes.length; ++i) {
            String name = resourceTypes[i].getName();
            String propertyKey = this.getAllocationIncrementPropKey(name);
            String propValue = this.get(propertyKey);
            if (propValue == null) continue;
            Matcher matcher = ResourceUtils.RESOURCE_REQUEST_VALUE_PATTERN.matcher(propValue);
            if (matcher.matches()) {
                long value = Long.parseLong(matcher.group(1));
                String unit = matcher.group(2);
                long valueInDefaultUnits = this.getValueInDefaultUnits(value, unit, name);
                others.put(name, valueInDefaultUnits);
                continue;
            }
            throw new IllegalArgumentException("Property " + propertyKey + " is not in \"value [unit]\" format: " + propValue);
        }
        if (others.containsKey(ResourceInformation.MEMORY_MB.getName())) {
            memory = (Long)others.get(ResourceInformation.MEMORY_MB.getName());
            if (this.get(RM_SCHEDULER_INCREMENT_ALLOCATION_MB) != null) {
                String overridingKey = this.getAllocationIncrementPropKey(ResourceInformation.MEMORY_MB.getName());
                LOG.warn("Configuration " + overridingKey + "=" + this.get(overridingKey) + " is overriding the " + RM_SCHEDULER_INCREMENT_ALLOCATION_MB + "=" + this.get(RM_SCHEDULER_INCREMENT_ALLOCATION_MB) + " property");
            }
            others.remove(ResourceInformation.MEMORY_MB.getName());
        } else {
            memory = this.getLong(RM_SCHEDULER_INCREMENT_ALLOCATION_MB, 1024L);
        }
        if (others.containsKey(ResourceInformation.VCORES.getName())) {
            vCores = ((Long)others.get(ResourceInformation.VCORES.getName())).intValue();
            if (this.get(RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES) != null) {
                String overridingKey = this.getAllocationIncrementPropKey(ResourceInformation.VCORES.getName());
                LOG.warn("Configuration " + overridingKey + "=" + this.get(overridingKey) + " is overriding the " + RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES + "=" + this.get(RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES) + " property");
            }
            others.remove(ResourceInformation.VCORES.getName());
        } else {
            vCores = this.getInt(RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES, 1);
        }
        return Resource.newInstance((long)memory, (int)vCores, others);
    }

    private long getValueInDefaultUnits(long value, String unit, String resourceName) {
        return unit.isEmpty() ? value : UnitsConversionUtil.convert((String)unit, (String)ResourceUtils.getDefaultUnit((String)resourceName), (long)value);
    }

    private String getAllocationIncrementPropKey(String resourceName) {
        return "yarn.resource-types." + resourceName + INCREMENT_ALLOCATION;
    }

    public float getReservationThresholdIncrementMultiple() {
        return this.getFloat(RM_SCHEDULER_RESERVATION_THRESHOLD_INCREMENT_MULTIPLE, 2.0f);
    }

    public float getLocalityThresholdNode() {
        return this.getFloat(LOCALITY_THRESHOLD_NODE, -1.0f);
    }

    public float getLocalityThresholdRack() {
        return this.getFloat(LOCALITY_THRESHOLD_RACK, -1.0f);
    }

    @Deprecated
    public boolean isContinuousSchedulingEnabled() {
        return this.getBoolean(CONTINUOUS_SCHEDULING_ENABLED, false);
    }

    @Deprecated
    public int getContinuousSchedulingSleepMs() {
        return this.getInt(CONTINUOUS_SCHEDULING_SLEEP_MS, 5);
    }

    @Deprecated
    public long getLocalityDelayNodeMs() {
        return this.getLong(LOCALITY_DELAY_NODE_MS, -1L);
    }

    @Deprecated
    public long getLocalityDelayRackMs() {
        return this.getLong(LOCALITY_DELAY_RACK_MS, -1L);
    }

    public boolean getPreemptionEnabled() {
        return this.getBoolean(PREEMPTION, false);
    }

    public boolean getAMPreemptionEnabled(String queueName) {
        return this.getBoolean(AM_PREEMPTION_PREFIX + queueName, true);
    }

    public float getPreemptionUtilizationThreshold() {
        return this.getFloat(PREEMPTION_THRESHOLD, 0.8f);
    }

    public boolean getAssignMultiple() {
        return this.getBoolean(ASSIGN_MULTIPLE, false);
    }

    public boolean isMaxAssignDynamic() {
        return this.getBoolean(DYNAMIC_MAX_ASSIGN, true);
    }

    public int getMaxAssign() {
        return this.getInt(MAX_ASSIGN, -1);
    }

    public boolean getSizeBasedWeight() {
        return this.getBoolean(SIZE_BASED_WEIGHT, false);
    }

    public long getWaitTimeBeforeNextStarvationCheck() {
        return this.getLong(WAIT_TIME_BEFORE_NEXT_STARVATION_CHECK_MS, 10000L);
    }

    public int getWaitTimeBeforeKill() {
        return this.getInt(WAIT_TIME_BEFORE_KILL, 15000);
    }

    public boolean getUsePortForNodeName() {
        return this.getBoolean("yarn.scheduler.include-port-in-node-name", false);
    }

    public float getReservableNodes() {
        return this.getFloat(RESERVABLE_NODES, 0.05f);
    }

    public static ConfigurableResource parseResourceConfigValue(String value) throws AllocationConfigurationException {
        return FairSchedulerConfiguration.parseResourceConfigValue(value, Long.MAX_VALUE);
    }

    public static ConfigurableResource parseResourceConfigValue(String value, long missing) throws AllocationConfigurationException {
        ConfigurableResource configurableResource;
        if (value.trim().isEmpty()) {
            throw new AllocationConfigurationException("Error reading resource config--the resource string is empty.");
        }
        try {
            configurableResource = value.contains("=") ? FairSchedulerConfiguration.parseNewStyleResource(value, missing) : (value.contains("%") ? FairSchedulerConfiguration.parseOldStyleResourceAsPercentage(value) : FairSchedulerConfiguration.parseOldStyleResource(value));
        }
        catch (RuntimeException ex) {
            throw new AllocationConfigurationException("Error reading resource config", ex);
        }
        return configurableResource;
    }

    private static ConfigurableResource parseNewStyleResource(String value, long missing) throws AllocationConfigurationException {
        String[] resources;
        boolean asPercent = value.contains("%");
        ConfigurableResource configurableResource = asPercent ? new ConfigurableResource() : new ConfigurableResource(missing);
        for (String resource : resources = value.split(",")) {
            String[] parts = resource.split("=");
            if (parts.length != 2) {
                throw FairSchedulerConfiguration.createConfigException(value, "Every resource must be of the form: name=value.");
            }
            String resourceName = parts[0].trim();
            String resourceValue = parts[1].trim();
            try {
                if (asPercent) {
                    double percentage = FairSchedulerConfiguration.parseNewStyleResourceAsPercentage(value, resourceName, resourceValue);
                    configurableResource.setPercentage(resourceName, percentage);
                    continue;
                }
                long parsedValue = FairSchedulerConfiguration.parseNewStyleResourceAsAbsoluteValue(value, resourceValue, resourceName);
                configurableResource.setValue(resourceName, parsedValue);
            }
            catch (ResourceNotFoundException ex) {
                throw FairSchedulerConfiguration.createConfigException(value, "The resource name, \"" + resourceName + "\" was not recognized. Please check the value of " + "yarn.resource-types" + " in the Resource Manager's configuration files.", ex);
            }
        }
        return configurableResource;
    }

    private static double parseNewStyleResourceAsPercentage(String value, String resource, String resourceValue) throws AllocationConfigurationException {
        try {
            return FairSchedulerConfiguration.findPercentage(resourceValue, resource);
        }
        catch (AllocationConfigurationException ex) {
            throw FairSchedulerConfiguration.createConfigException(value, "The resource values must all be percentages. \"" + resourceValue + "\" is either not a non-negative number or does not include the '%' symbol.", ex);
        }
    }

    private static long parseNewStyleResourceAsAbsoluteValue(String value, String resourceValue, String resourceName) throws AllocationConfigurationException {
        long parsedValue;
        try {
            parsedValue = Long.parseLong(resourceValue);
        }
        catch (NumberFormatException e) {
            throw FairSchedulerConfiguration.createConfigException(value, "The resource values must all be integers. \"" + resourceValue + "\" is not an integer.", e);
        }
        if (parsedValue < 0L) {
            throw new AllocationConfigurationException("Invalid value of " + resourceName + ": " + parsedValue + ", value should not be negative!");
        }
        return parsedValue;
    }

    private static ConfigurableResource parseOldStyleResourceAsPercentage(String value) throws AllocationConfigurationException {
        return new ConfigurableResource(FairSchedulerConfiguration.getResourcePercentage(StringUtils.toLowerCase((String)value)));
    }

    private static ConfigurableResource parseOldStyleResource(String input) throws AllocationConfigurationException {
        String lowerCaseInput = StringUtils.toLowerCase((String)input);
        String[] resources = lowerCaseInput.split(",");
        if (resources.length != 2 && (resources = FairSchedulerConfiguration.findOldStyleResourcesInSpaceSeparatedInput(lowerCaseInput)).length != 2) {
            throw new AllocationConfigurationException("Cannot parse resource values from input: " + input);
        }
        int memory = FairSchedulerConfiguration.parseOldStyleResourceMemory(resources);
        int vcores = FairSchedulerConfiguration.parseOldStyleResourceVcores(resources);
        return new ConfigurableResource(BuilderUtils.newResource((long)memory, (int)vcores));
    }

    private static String[] findOldStyleResourcesInSpaceSeparatedInput(String input) {
        Pattern pattern = Pattern.compile(RESOURCES_WITH_SPACES_PATTERN);
        Matcher matcher = pattern.matcher(input);
        ArrayList resources = Lists.newArrayList();
        while (matcher.find()) {
            resources.add(matcher.group(0));
        }
        return resources.toArray(new String[0]);
    }

    private static int parseOldStyleResourceMemory(String[] resources) throws AllocationConfigurationException {
        int memory = FairSchedulerConfiguration.findResource(resources, "mb");
        if (memory < 0) {
            throw new AllocationConfigurationException("Invalid value of memory: " + memory + ", value should not be negative!");
        }
        return memory;
    }

    private static int parseOldStyleResourceVcores(String[] resources) throws AllocationConfigurationException {
        int vcores = FairSchedulerConfiguration.findResource(resources, "vcores");
        if (vcores < 0) {
            throw new AllocationConfigurationException("Invalid value of vcores: " + vcores + ", value should not be negative!");
        }
        return vcores;
    }

    private static double[] getResourcePercentage(String val) throws AllocationConfigurationException {
        int numberOfKnownResourceTypes = ResourceUtils.getNumberOfCountableResourceTypes();
        double[] resourcePercentage = new double[numberOfKnownResourceTypes];
        String[] values = val.split(",");
        if (values.length == 1) {
            double percentage = FairSchedulerConfiguration.findPercentage(values, "");
            for (int i = 0; i < numberOfKnownResourceTypes; ++i) {
                resourcePercentage[i] = percentage;
            }
        } else {
            resourcePercentage[0] = FairSchedulerConfiguration.findPercentage(values, "memory");
            resourcePercentage[1] = FairSchedulerConfiguration.findPercentage(values, "cpu");
        }
        return resourcePercentage;
    }

    private static double findPercentage(String resourceValue, String resource) throws AllocationConfigurationException {
        return FairSchedulerConfiguration.findPercentageInternal(resource, resourceValue, false);
    }

    private static double findPercentage(String[] resourceValues, String resource) throws AllocationConfigurationException {
        String resourceValue = FairSchedulerConfiguration.findResourceFromValues(resourceValues, resource);
        return FairSchedulerConfiguration.findPercentageInternal(resource, resourceValue, true);
    }

    private static double findPercentageInternal(String resource, String resourceValue, boolean includeResourceInPattern) throws AllocationConfigurationException {
        Pattern pattern = includeResourceInPattern ? Pattern.compile(RESOURCE_PERCENTAGE_PATTERN + resource) : Pattern.compile(RESOURCE_PERCENTAGE_PATTERN);
        Matcher matcher = pattern.matcher(resourceValue);
        if (!matcher.matches()) {
            if (resource.equals("")) {
                throw new AllocationConfigurationException("Invalid percentage: " + resourceValue);
            }
            throw new AllocationConfigurationException("Invalid percentage of " + resource + ": " + resourceValue);
        }
        double percentage = Double.parseDouble(matcher.group(1)) / 100.0;
        if (percentage < 0.0) {
            throw new AllocationConfigurationException("Invalid percentage: " + resourceValue + ", percentage should not be negative!");
        }
        return percentage;
    }

    private static AllocationConfigurationException createConfigException(String value, String message) {
        return FairSchedulerConfiguration.createConfigException(value, message, null);
    }

    private static AllocationConfigurationException createConfigException(String value, String message, Throwable t) {
        String msg = INVALID_RESOURCE_DEFINITION_PREFIX + value + ". " + message;
        if (t != null) {
            return new AllocationConfigurationException(msg, t);
        }
        return new AllocationConfigurationException(msg);
    }

    public long getUpdateInterval() {
        return this.getLong(UPDATE_INTERVAL_MS, 500L);
    }

    private static int findResource(String[] resourceValues, String resource) throws AllocationConfigurationException {
        String resourceValue = FairSchedulerConfiguration.findResourceFromValues(resourceValues, resource);
        Pattern pattern = Pattern.compile(RESOURCE_VALUE_PATTERN + resource);
        Matcher matcher = pattern.matcher(resourceValue);
        if (!matcher.find()) {
            throw new AllocationConfigurationException("Invalid value of " + (resource.equals("mb") ? "memory" : resource) + ": " + resourceValue);
        }
        return Integer.parseInt(matcher.group(1));
    }

    private static String findResourceFromValues(String[] resourceValues, String resource) throws AllocationConfigurationException {
        for (String resourceValue : resourceValues) {
            if (!resourceValue.contains(resource)) continue;
            return resourceValue.trim();
        }
        throw new AllocationConfigurationException("Missing resource: " + resource);
    }
}

