/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryComponentComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.LongComparator;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestComparators {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestComparators.class);

    @Test
    public void testCellFieldsCompare() throws Exception {
        byte[] r0 = Bytes.toBytes((String)"row0");
        byte[] r1 = Bytes.toBytes((String)"row1");
        byte[] r2 = Bytes.toBytes((String)"row2");
        byte[] f = Bytes.toBytes((String)"cf1");
        byte[] q1 = Bytes.toBytes((String)"qual1");
        byte[] q2 = Bytes.toBytes((String)"qual2");
        byte[] q3 = Bytes.toBytes((String)"r");
        long l1 = 1234L;
        byte[] v1 = Bytes.toBytes((long)l1);
        long l2 = 2000L;
        byte[] v2 = Bytes.toBytes((long)l2);
        KeyValue kv = new KeyValue(r1, f, q1, v1);
        ByteBuffer buffer = ByteBuffer.wrap(kv.getBuffer());
        ByteBufferKeyValue bbCell = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        BinaryComparator comparable = new BinaryComparator(r1);
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareRow((Cell)bbCell, (ByteArrayComparable)comparable));
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareRow((Cell)kv, (ByteArrayComparable)comparable));
        kv = new KeyValue(r0, f, q1, v1);
        buffer = ByteBuffer.wrap(kv.getBuffer());
        bbCell = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        Assert.assertTrue((PrivateCellUtil.compareRow((Cell)bbCell, (ByteArrayComparable)comparable) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareRow((Cell)kv, (ByteArrayComparable)comparable) > 0 ? 1 : 0) != 0);
        kv = new KeyValue(r2, f, q1, v1);
        buffer = ByteBuffer.wrap(kv.getBuffer());
        bbCell = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        Assert.assertTrue((PrivateCellUtil.compareRow((Cell)bbCell, (ByteArrayComparable)comparable) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareRow((Cell)kv, (ByteArrayComparable)comparable) < 0 ? 1 : 0) != 0);
        comparable = new BinaryPrefixComparator(Bytes.toBytes((String)"qual"));
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareQualifier((Cell)bbCell, (ByteArrayComparable)comparable));
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareQualifier((Cell)kv, (ByteArrayComparable)comparable));
        kv = new KeyValue(r2, f, q2, v1);
        buffer = ByteBuffer.wrap(kv.getBuffer());
        bbCell = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareQualifier((Cell)bbCell, (ByteArrayComparable)comparable));
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareQualifier((Cell)kv, (ByteArrayComparable)comparable));
        kv = new KeyValue(r2, f, q3, v1);
        buffer = ByteBuffer.wrap(kv.getBuffer());
        bbCell = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        Assert.assertTrue((PrivateCellUtil.compareQualifier((Cell)bbCell, (ByteArrayComparable)comparable) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareQualifier((Cell)kv, (ByteArrayComparable)comparable) < 0 ? 1 : 0) != 0);
        comparable = new LongComparator(l1);
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareValue((Cell)bbCell, (ByteArrayComparable)comparable));
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareValue((Cell)kv, (ByteArrayComparable)comparable));
        kv = new KeyValue(r1, f, q1, v2);
        buffer = ByteBuffer.wrap(kv.getBuffer());
        bbCell = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        Assert.assertTrue((PrivateCellUtil.compareValue((Cell)bbCell, (ByteArrayComparable)comparable) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareValue((Cell)kv, (ByteArrayComparable)comparable) < 0 ? 1 : 0) != 0);
        comparable = new SubstringComparator("cf");
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareFamily((Cell)bbCell, (ByteArrayComparable)comparable));
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareFamily((Cell)kv, (ByteArrayComparable)comparable));
        kv = new KeyValue(r1, f, q1, v2);
        Assert.assertTrue((boolean)PrivateCellUtil.qualifierStartsWith((Cell)kv, (byte[])Bytes.toBytes((String)"q")));
        Assert.assertTrue((boolean)PrivateCellUtil.qualifierStartsWith((Cell)kv, (byte[])q1));
        Assert.assertFalse((boolean)PrivateCellUtil.qualifierStartsWith((Cell)kv, (byte[])q2));
        Assert.assertFalse((boolean)PrivateCellUtil.qualifierStartsWith((Cell)kv, (byte[])Bytes.toBytes((String)"longerthanthequalifier")));
        byte[] val = Bytes.toBytes((String)"abcd");
        kv = new KeyValue(r0, f, q1, val);
        buffer = ByteBuffer.wrap(kv.getBuffer());
        bbCell = new ByteBufferKeyValue(buffer, 0, buffer.remaining());
        byte[] component = Bytes.toBytes((String)"o");
        comparable = new BinaryComponentComparator(component, 1);
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareRow((Cell)bbCell, (ByteArrayComparable)comparable));
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareRow((Cell)kv, (ByteArrayComparable)comparable));
        component = Bytes.toBytes((String)"c");
        comparable = new BinaryComponentComparator(component, 2);
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareValue((Cell)bbCell, (ByteArrayComparable)comparable));
        Assert.assertEquals((long)0L, (long)PrivateCellUtil.compareValue((Cell)kv, (ByteArrayComparable)comparable));
        component = Bytes.toBytes((String)"z");
        comparable = new BinaryComponentComparator(component, 1);
        Assert.assertTrue((PrivateCellUtil.compareRow((Cell)bbCell, (ByteArrayComparable)comparable) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareRow((Cell)kv, (ByteArrayComparable)comparable) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareValue((Cell)bbCell, (ByteArrayComparable)comparable) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareValue((Cell)kv, (ByteArrayComparable)comparable) > 0 ? 1 : 0) != 0);
        component = Bytes.toBytes((String)"a");
        comparable = new BinaryComponentComparator(component, 1);
        Assert.assertTrue((PrivateCellUtil.compareRow((Cell)bbCell, (ByteArrayComparable)comparable) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareRow((Cell)kv, (ByteArrayComparable)comparable) < 0 ? 1 : 0) != 0);
        comparable = new BinaryComponentComparator(component, 2);
        Assert.assertTrue((PrivateCellUtil.compareValue((Cell)bbCell, (ByteArrayComparable)comparable) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareValue((Cell)kv, (ByteArrayComparable)comparable) < 0 ? 1 : 0) != 0);
    }
}

