/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.hiverc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRCOutputFormat
extends FileOutputFormat<NullWritable, Writable> {
    private static final Logger LOG = LoggerFactory.getLogger(RCFileOutputFormat.class);
    public static String COMPRESSION_CODEC_CONF = "rcfile.output.compression.codec";
    public static String DEFAULT_EXTENSION = ".rc";
    public static String EXTENSION_OVERRIDE_CONF = "rcfile.output.filename.extension";

    public static void setColumnNumber(Configuration conf, int columnNum) {
        assert (columnNum > 0);
        conf.setInt(RCFile.COLUMN_NUMBER_CONF_STR, columnNum);
    }

    public static int getColumnNumber(Configuration conf) {
        return conf.getInt(RCFile.COLUMN_NUMBER_CONF_STR, 0);
    }

    protected RCFile.Writer createRCFileWriter(TaskAttemptContext job, Text columnMetadata) throws IOException {
        Configuration conf = job.getConfiguration();
        String codecOverride = conf.get(COMPRESSION_CODEC_CONF);
        if (codecOverride != null) {
            conf.setBoolean("mapred.output.compress", true);
            conf.set("mapred.output.compression.codec", codecOverride);
        }
        CompressionCodec codec = null;
        if (HiveRCOutputFormat.getCompressOutput((JobContext)job)) {
            Class codecClass = HiveRCOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
        }
        SequenceFile.Metadata metadata = null;
        String ext = conf.get(EXTENSION_OVERRIDE_CONF, DEFAULT_EXTENSION);
        Path file = this.getDefaultWorkFile(job, ext.equalsIgnoreCase("none") ? null : ext);
        LOG.info("writing to rcfile " + file.toString());
        return new RCFile.Writer(file.getFileSystem(conf), conf, file, (Progressable)job, metadata, codec);
    }

    public RecordWriter<NullWritable, Writable> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
        return new Writer(this, job, null);
    }

    protected static class Writer
    extends RecordWriter<NullWritable, Writable> {
        private final RCFile.Writer rcfile;

        protected Writer(HiveRCOutputFormat outputFormat, TaskAttemptContext job, Text columnMetadata) throws IOException {
            this.rcfile = outputFormat.createRCFileWriter(job, columnMetadata);
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.rcfile.close();
        }

        public void write(NullWritable key, Writable value) throws IOException, InterruptedException {
            this.rcfile.append(value);
        }
    }
}

