/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.metrics.MetricsSystemHelper;
import org.apache.accumulo.tserver.metrics.TabletServerScanMetricsKeys;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableStat;

public class Metrics2TabletServerScanMetrics
implements Metrics,
MetricsSource,
TabletServerScanMetricsKeys {
    public static final String NAME = "TabletServer,sub=Scans";
    public static final String DESCRIPTION = "TabletServer Scan Metrics";
    public static final String CONTEXT = "tserver";
    public static final String RECORD = "Scans";
    private final MetricsSystem system;
    private final MetricsRegistry registry;
    private final MutableStat scans;
    private final MutableStat resultsPerScan;
    private final MutableStat yields;

    Metrics2TabletServerScanMetrics(MetricsSystem system) {
        this.system = system;
        this.registry = new MetricsRegistry(Interns.info((String)NAME, (String)DESCRIPTION));
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, MetricsSystemHelper.getProcessName());
        this.scans = this.registry.newStat("scan", RECORD, "Ops", "Count", true);
        this.resultsPerScan = this.registry.newStat("result", "Results per scan", "Ops", "Count", true);
        this.yields = this.registry.newStat("yield", "Yields", "Ops", "Count", true);
    }

    public void add(String name, long value) {
        if ("scan".equals(name)) {
            this.scans.add(value);
        } else if ("result".equals(name)) {
            this.resultsPerScan.add(value);
        } else if ("yield".equals(name)) {
            this.yields.add(value);
        } else {
            throw new RuntimeException("Could not find metric to update for name " + name);
        }
    }

    public void register() {
        this.system.register(NAME, DESCRIPTION, (Object)this);
    }

    public boolean isEnabled() {
        return true;
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(RECORD).setContext(CONTEXT);
        this.registry.snapshot(builder, all);
    }
}

