/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.accumulo.server.metrics.AbstractMetricsImpl;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.metrics.TabletServerMBean;
import org.apache.accumulo.tserver.metrics.TabletServerMetricsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerMBeanImpl
extends AbstractMetricsImpl
implements TabletServerMBean {
    private static final Logger log = LoggerFactory.getLogger(TabletServerMBeanImpl.class);
    private static final String METRICS_PREFIX = "tserver";
    private ObjectName OBJECT_NAME = null;
    private final TabletServerMetricsUtil util;

    TabletServerMBeanImpl(TabletServer server) {
        this.util = new TabletServerMetricsUtil(server);
        try {
            this.OBJECT_NAME = new ObjectName("accumulo.server.metrics:service=TServerInfo,name=TabletServerMBean,instance=" + Thread.currentThread().getName());
        }
        catch (MalformedObjectNameException e) {
            log.error("Exception setting MBean object name", (Throwable)e);
        }
    }

    public void register() throws Exception {
        StandardMBean mbean = new StandardMBean(this, TabletServerMBean.class, false);
        this.register(mbean);
    }

    @Override
    public long getEntries() {
        if (this.isEnabled()) {
            return this.util.getEntries();
        }
        return 0L;
    }

    @Override
    public long getEntriesInMemory() {
        if (this.isEnabled()) {
            return this.util.getEntriesInMemory();
        }
        return 0L;
    }

    @Override
    public double getIngest() {
        if (this.isEnabled()) {
            return this.util.getIngest();
        }
        return 0.0;
    }

    @Override
    public int getMajorCompactions() {
        if (this.isEnabled()) {
            return this.util.getMajorCompactions();
        }
        return 0;
    }

    @Override
    public int getMajorCompactionsQueued() {
        if (this.isEnabled()) {
            return this.util.getMajorCompactionsQueued();
        }
        return 0;
    }

    @Override
    public int getMinorCompactions() {
        if (this.isEnabled()) {
            return this.util.getMinorCompactions();
        }
        return 0;
    }

    @Override
    public int getMinorCompactionsQueued() {
        if (this.isEnabled()) {
            return this.util.getMinorCompactionsQueued();
        }
        return 0;
    }

    @Override
    public int getOnlineCount() {
        if (this.isEnabled()) {
            return this.util.getOnlineCount();
        }
        return 0;
    }

    @Override
    public int getOpeningCount() {
        if (this.isEnabled()) {
            return this.util.getOpeningCount();
        }
        return 0;
    }

    @Override
    public long getQueries() {
        if (this.isEnabled()) {
            return this.util.getQueries();
        }
        return 0L;
    }

    @Override
    public int getUnopenedCount() {
        if (this.isEnabled()) {
            return this.util.getUnopenedCount();
        }
        return 0;
    }

    @Override
    public String getName() {
        if (this.isEnabled()) {
            return this.util.getName();
        }
        return "";
    }

    @Override
    public long getTotalMinorCompactions() {
        if (this.isEnabled()) {
            return this.util.getTotalMinorCompactions();
        }
        return 0L;
    }

    @Override
    public double getHoldTime() {
        if (this.isEnabled()) {
            return this.util.getHoldTime();
        }
        return 0.0;
    }

    @Override
    public double getAverageFilesPerTablet() {
        if (this.isEnabled()) {
            return this.util.getAverageFilesPerTablet();
        }
        return 0.0;
    }

    protected ObjectName getObjectName() {
        return this.OBJECT_NAME;
    }

    protected String getMetricsPrefix() {
        return METRICS_PREFIX;
    }
}

