/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.io.IOException;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.trace.ProbabilitySampler;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.htrace.Sampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinorCompactionTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MinorCompactionTask.class);
    private final Tablet tablet;
    private long queued;
    private CommitSession commitSession;
    private DataFileValue stats;
    private FileRef mergeFile;
    private long flushId;
    private MinorCompactionReason mincReason;
    private double tracePercent;

    MinorCompactionTask(Tablet tablet, FileRef mergeFile, CommitSession commitSession, long flushId, MinorCompactionReason mincReason, double tracePercent) {
        this.tablet = tablet;
        this.queued = System.currentTimeMillis();
        tablet.minorCompactionWaitingToStart();
        this.commitSession = commitSession;
        this.mergeFile = mergeFile;
        this.flushId = flushId;
        this.mincReason = mincReason;
        this.tracePercent = tracePercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.tablet.minorCompactionStarted();
        ProbabilitySampler sampler = new ProbabilitySampler(this.tracePercent);
        Span minorCompaction = Trace.on((String)"minorCompaction", (Sampler)sampler);
        try {
            Span span = Trace.start((String)"waitForCommits");
            Tablet tablet = this.tablet;
            synchronized (tablet) {
                this.commitSession.waitForCommitsToFinish();
            }
            span.stop();
            span = Trace.start((String)"start");
            FileRef newMapfileLocation = null;
            FileRef tmpFileRef = null;
            while (true) {
                try {
                    if (newMapfileLocation == null) {
                        newMapfileLocation = this.tablet.getNextMapFilename(this.mergeFile == null ? "F" : "M");
                        tmpFileRef = new FileRef(newMapfileLocation.path() + "_tmp");
                    }
                    this.tablet.getTabletServer().minorCompactionStarted(this.commitSession, this.commitSession.getWALogSeq() + 1L, newMapfileLocation.path().toString());
                }
                catch (IOException e) {
                    if (newMapfileLocation == null) {
                        log.warn("Failed to create new file for minor compaction {}", (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    log.warn("Failed to write to write ahead log {}", (Object)e.getMessage(), (Object)e);
                    continue;
                }
                break;
            }
            span.stop();
            span = Trace.start((String)"compact");
            this.stats = this.tablet.minorCompact(this.tablet.getTabletServer().getFileSystem(), this.tablet.getTabletMemory().getMinCMemTable(), tmpFileRef, newMapfileLocation, this.mergeFile, true, this.queued, this.commitSession, this.flushId, this.mincReason);
            span.stop();
            minorCompaction.data("extent", this.tablet.getExtent().toString());
            minorCompaction.data("numEntries", Long.toString(this.stats.getNumEntries()));
            minorCompaction.data("size", Long.toString(this.stats.getSize()));
            minorCompaction.stop();
            if (this.tablet.needsSplit(this.tablet.getSplitComputations())) {
                this.tablet.getTabletServer().executeSplit(this.tablet);
            } else {
                this.tablet.initiateMajorCompaction(MajorCompactionReason.NORMAL);
            }
        }
        catch (Throwable t) {
            log.error("Unknown error during minor compaction for extent: " + this.tablet.getExtent(), t);
            throw new RuntimeException(t);
        }
        finally {
            this.tablet.minorCompactionComplete();
            minorCompaction.stop();
        }
    }
}

