/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.text.ParseException;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.TouchCommands;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFsShellTouch {
    static final Logger LOG = LoggerFactory.getLogger(TestFsShellTouch.class);
    static FsShell shell;
    static LocalFileSystem lfs;
    static Path testRootDir;

    @BeforeClass
    public static void setup() throws Exception {
        Configuration conf = new Configuration();
        shell = new FsShell(conf);
        lfs = FileSystem.getLocal((Configuration)conf);
        testRootDir = lfs.makeQualified(new Path(GenericTestUtils.getTempPath("testFsShell")));
        lfs.mkdirs(testRootDir);
        lfs.setWorkingDirectory(testRootDir);
    }

    @Before
    public void prepFiles() throws Exception {
        lfs.setVerifyChecksum(true);
        lfs.setWriteChecksum(true);
    }

    private int shellRun(String ... args) throws Exception {
        int exitCode = shell.run(args);
        LOG.info("exit " + exitCode + " - " + StringUtils.join((CharSequence)" ", (String[])args));
        return exitCode;
    }

    @Test
    public void testTouchz() throws Exception {
        String newFileName = "newFile";
        Path newFile = new Path("newFile");
        lfs.delete(newFile, true);
        Assert.assertThat((Object)lfs.exists(newFile), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((String)"Expected successful touchz on a new file", (Object)this.shellRun("-touchz", "newFile"), (Matcher)CoreMatchers.is((Object)0));
        this.shellRun("-ls", "newFile");
        Assert.assertThat((String)"Expected successful touchz on an existing zero-length file", (Object)this.shellRun("-touchz", "newFile"), (Matcher)CoreMatchers.is((Object)0));
        String noDirName = "noDir";
        Path noDir = new Path("noDir");
        lfs.delete(noDir, true);
        Assert.assertThat((Object)lfs.exists(noDir), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((String)"Expected failed touchz in a non-existent directory", (Object)this.shellRun("-touchz", "noDir/foo"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)0)));
    }

    @Test
    public void testTouch() throws Exception {
        String newFileName = "newFile2";
        Path newFile = new Path("newFile2");
        lfs.delete(newFile, true);
        Assert.assertThat((Object)lfs.exists(newFile), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((String)"Expected successful touch on a non-existent file with -c option", (Object)this.shellRun("-touch", "-c", "newFile2"), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lfs.exists(newFile), (Matcher)CoreMatchers.is((Object)false));
        String strTime = this.formatTimestamp(System.currentTimeMillis());
        Date dateObj = this.parseTimestamp(strTime);
        Assert.assertThat((String)"Expected successful touch on a new file with a specified timestamp", (Object)this.shellRun("-touch", "-t", strTime, "newFile2"), (Matcher)CoreMatchers.is((Object)0));
        FileStatus new_status = lfs.getFileStatus(newFile);
        Assert.assertThat((Object)new_status.getAccessTime(), (Matcher)CoreMatchers.is((Object)dateObj.getTime()));
        Assert.assertThat((Object)new_status.getModificationTime(), (Matcher)CoreMatchers.is((Object)dateObj.getTime()));
        FileStatus fstatus = lfs.getFileStatus(newFile);
        String strTime2 = this.formatTimestamp(System.currentTimeMillis());
        Date dateObj2 = this.parseTimestamp(strTime2);
        Assert.assertThat((String)"Expected successful touch with a specified access time", (Object)this.shellRun("-touch", "-a", "-t", strTime2, "newFile2"), (Matcher)CoreMatchers.is((Object)0));
        FileStatus new_status2 = lfs.getFileStatus(newFile);
        Assert.assertThat((Object)new_status2.getAccessTime(), (Matcher)CoreMatchers.is((Object)dateObj2.getTime()));
        Assert.assertThat((Object)new_status2.getModificationTime(), (Matcher)CoreMatchers.is((Object)fstatus.getModificationTime()));
        fstatus = lfs.getFileStatus(newFile);
        strTime2 = this.formatTimestamp(System.currentTimeMillis());
        dateObj2 = this.parseTimestamp(strTime2);
        Assert.assertThat((String)"Expected successful touch with a specified modification time", (Object)this.shellRun("-touch", "-m", "-t", strTime2, "newFile2"), (Matcher)CoreMatchers.is((Object)0));
        new_status2 = lfs.getFileStatus(newFile);
        Assert.assertThat((Object)new_status2.getAccessTime(), (Matcher)CoreMatchers.is((Object)fstatus.getAccessTime()));
        Assert.assertThat((Object)new_status2.getModificationTime(), (Matcher)CoreMatchers.is((Object)dateObj2.getTime()));
        strTime2 = this.formatTimestamp(System.currentTimeMillis());
        dateObj2 = this.parseTimestamp(strTime2);
        Assert.assertThat((String)"Expected successful touch with a specified timestamp", (Object)this.shellRun("-touch", "-t", strTime2, "newFile2"), (Matcher)CoreMatchers.is((Object)0));
        new_status2 = lfs.getFileStatus(newFile);
        Assert.assertThat((Object)new_status2.getAccessTime(), (Matcher)CoreMatchers.is((Object)dateObj2.getTime()));
        Assert.assertThat((Object)new_status2.getModificationTime(), (Matcher)CoreMatchers.is((Object)dateObj2.getTime()));
        strTime2 = this.formatTimestamp(System.currentTimeMillis());
        dateObj2 = this.parseTimestamp(strTime2);
        Assert.assertThat((String)"Expected successful touch with a specified timestamp", (Object)this.shellRun("-touch", "-a", "-m", "-t", strTime2, "newFile2"), (Matcher)CoreMatchers.is((Object)0));
        new_status2 = lfs.getFileStatus(newFile);
        Assert.assertThat((Object)new_status2.getAccessTime(), (Matcher)CoreMatchers.is((Object)dateObj2.getTime()));
        Assert.assertThat((Object)new_status2.getModificationTime(), (Matcher)CoreMatchers.is((Object)dateObj2.getTime()));
        Assert.assertThat((String)"Expected failed touch with a missing timestamp", (Object)this.shellRun("-touch", "-t", "newFile2"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)0)));
        strTime2 = this.formatTimestamp(System.currentTimeMillis());
        dateObj2 = this.parseTimestamp(strTime2);
        Assert.assertThat((String)"Expected successful touch on a non-existent file with -c option", (Object)this.shellRun("-touch", "-c", "-t", strTime2, "newFile2"), (Matcher)CoreMatchers.is((Object)0));
        FileStatus fileStatus = lfs.getFileStatus(newFile);
        Assert.assertThat((Object)fileStatus.getAccessTime(), (Matcher)CoreMatchers.is((Object)dateObj2.getTime()));
        Assert.assertThat((Object)fileStatus.getModificationTime(), (Matcher)CoreMatchers.is((Object)dateObj2.getTime()));
    }

    private String formatTimestamp(long timeInMillis) {
        return new TouchCommands.Touch().getDateFormat().format(new Date(timeInMillis));
    }

    private Date parseTimestamp(String tstamp) throws ParseException {
        return new TouchCommands.Touch().getDateFormat().parse(tstamp);
    }
}

