/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsAnnotations;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeFloat;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.lib.MutableRates;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMetricsAnnotations {
    @Test
    public void testFields() {
        MyMetrics metrics = new MyMetrics();
        MetricsSource source = MetricsAnnotations.makeSource((Object)metrics);
        metrics.c1.incr();
        metrics.c2.incr();
        metrics.g1.incr();
        metrics.g2.incr();
        metrics.g3.incr();
        metrics.g4.incr();
        metrics.r1.add(1L);
        metrics.s1.add(1L);
        metrics.rs1.add("rs1", 1L);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics(source);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter(Interns.info((String)"C1", (String)"C1"), 1);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter(Interns.info((String)"Counter2", (String)"Counter2 desc"), 1L);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"G1", (String)"G1"), 1);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"G2", (String)"G2"), 1);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"G3", (String)"g3 desc"), 1L);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"G4", (String)"g4 desc"), 1.0f);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter(Interns.info((String)"R1NumOps", (String)"Number of ops for r1"), 1L);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"R1AvgTime", (String)"Average time for r1"), 1.0);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter(Interns.info((String)"S1NumOps", (String)"Number of ops for s1"), 1L);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"S1AvgTime", (String)"Average time for s1"), 1.0);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter(Interns.info((String)"Rs1NumOps", (String)"Number of ops for rs1"), 1L);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"Rs1AvgTime", (String)"Average time for rs1"), 1.0);
    }

    @Test(expected=MetricsException.class)
    public void testBadFields() {
        MetricsAnnotations.makeSource((Object)new BadMetrics());
    }

    @Test
    public void testMethods() {
        MyMetrics2 metrics = new MyMetrics2();
        MetricsSource source = MetricsAnnotations.makeSource((Object)metrics);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics(source);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"G1", (String)"G1"), 1);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"G2", (String)"G2"), 2L);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"G3", (String)"G3"), 3.0f);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"G4", (String)"G4"), 4.0);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter(Interns.info((String)"C1", (String)"C1"), 1);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter(Interns.info((String)"C2", (String)"C2"), 2L);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).tag(Interns.info((String)"T1", (String)"T1"), "t1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadMethodWithArgs() {
        MetricsAnnotations.makeSource((Object)new BadMetrics2());
    }

    @Test(expected=MetricsException.class)
    public void testBadMethodReturnType() {
        MetricsAnnotations.makeSource((Object)new BadMetrics3());
    }

    @Test
    public void testClasses() {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics(MetricsAnnotations.makeSource((Object)new MyMetrics3()));
        MetricsCollector collector = rb.parent();
        ((MetricsCollector)Mockito.verify((Object)collector)).addRecord(Interns.info((String)"MyMetrics3", (String)"My metrics"));
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).add(Interns.tag((MetricsInfo)MsInfo.Context, (String)"foo"));
    }

    @Test
    public void testHybrid() {
        HybridMetrics metrics = new HybridMetrics();
        MetricsSource source = MetricsAnnotations.makeSource((Object)metrics);
        Assert.assertSame((Object)metrics, (Object)source);
        metrics.C0.incr();
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics(source);
        MetricsCollector collector = rb.parent();
        ((MetricsCollector)Mockito.verify((Object)collector)).addRecord("foo");
        ((MetricsCollector)Mockito.verify((Object)collector)).addRecord("bar");
        ((MetricsCollector)Mockito.verify((Object)collector)).addRecord(Interns.info((String)"HybridMetrics", (String)"HybridMetrics"));
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).setContext("foocontext");
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter(Interns.info((String)"C1", (String)"C1 desc"), 1);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).setContext("barcontext");
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"G1", (String)"G1 desc"), 1);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).add(Interns.tag((MetricsInfo)MsInfo.Context, (String)"hybrid"));
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter(Interns.info((String)"C0", (String)"C0 desc"), 1);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge(Interns.info((String)"G0", (String)"G0"), 0);
    }

    @Test(expected=MetricsException.class)
    public void testBadHybrid() {
        MetricsAnnotations.makeSource((Object)new BadHybridMetrics());
    }

    @Test(expected=MetricsException.class)
    public void testEmptyMetrics() {
        MetricsAnnotations.makeSource((Object)new EmptyMetrics());
    }

    static class EmptyMetrics {
        int foo;

        EmptyMetrics() {
        }
    }

    @Metrics(context="hybrid")
    static class BadHybridMetrics
    implements MetricsSource {
        @Metric
        MutableCounterInt c1;

        BadHybridMetrics() {
        }

        public void getMetrics(MetricsCollector collector, boolean all) {
            collector.addRecord("foo");
        }
    }

    static class HybridMetrics
    implements MetricsSource {
        final MetricsRegistry registry = new MetricsRegistry("HybridMetrics").setContext("hybrid");
        @Metric(value={"C0 desc"})
        MutableCounterInt C0;

        HybridMetrics() {
        }

        @Metric
        int getG0() {
            return 0;
        }

        public void getMetrics(MetricsCollector collector, boolean all) {
            collector.addRecord("foo").setContext("foocontext").addCounter(Interns.info((String)"C1", (String)"C1 desc"), 1).endRecord().addRecord("bar").setContext("barcontext").addGauge(Interns.info((String)"G1", (String)"G1 desc"), 1);
            this.registry.snapshot(collector.addRecord(this.registry.info()), all);
        }
    }

    @Metrics(about="My metrics", context="foo")
    static class MyMetrics3 {
        MyMetrics3() {
        }

        @Metric
        int getG1() {
            return 1;
        }
    }

    static class BadMetrics3 {
        BadMetrics3() {
        }

        @Metric
        boolean foo() {
            return true;
        }
    }

    static class BadMetrics2 {
        BadMetrics2() {
        }

        @Metric
        int foo(int i) {
            return i;
        }
    }

    static class MyMetrics2 {
        MyMetrics2() {
        }

        @Metric
        int getG1() {
            return 1;
        }

        @Metric
        long getG2() {
            return 2L;
        }

        @Metric
        float getG3() {
            return 3.0f;
        }

        @Metric
        double getG4() {
            return 4.0;
        }

        @Metric(type=Metric.Type.COUNTER)
        int getC1() {
            return 1;
        }

        @Metric(type=Metric.Type.COUNTER)
        long getC2() {
            return 2L;
        }

        @Metric(type=Metric.Type.TAG)
        String getT1() {
            return "t1";
        }
    }

    static class BadMetrics {
        @Metric
        Integer i0;

        BadMetrics() {
        }
    }

    static class MyMetrics {
        @Metric
        MutableCounterInt c1;
        @Metric(value={"Counter2", "Counter2 desc"})
        MutableCounterLong c2;
        @Metric
        MutableGaugeInt g1;
        @Metric
        MutableGaugeInt g2;
        @Metric(value={"g3 desc"})
        MutableGaugeLong g3;
        @Metric(value={"g4 desc"})
        MutableGaugeFloat g4;
        @Metric
        MutableRate r1;
        @Metric
        MutableStat s1;
        @Metric
        MutableRates rs1;

        MyMetrics() {
        }
    }
}

