/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.org.roaringbitmap;

import org.apache.pig.org.roaringbitmap.ArrayContainer;
import org.apache.pig.org.roaringbitmap.ContainerBatchIterator;
import org.apache.pig.org.roaringbitmap.Util;

public class ArrayBatchIterator
implements ContainerBatchIterator {
    private int index = 0;
    private final ArrayContainer array;

    public ArrayBatchIterator(ArrayContainer array) {
        this.array = array;
    }

    @Override
    public int next(int key, int[] buffer) {
        int consumed = 0;
        short[] data = this.array.content;
        while (consumed < buffer.length && this.index < this.array.getCardinality()) {
            buffer[consumed++] = key + Util.toIntUnsigned(data[this.index++]);
        }
        return consumed;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.array.getCardinality();
    }
}

