/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Closeable;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.logging.Logger;

public class CloseFuture
implements Closeable {
    private final Logger log;
    private final Promise<Void> promise = Promise.promise();
    private boolean closed;
    private Map<Closeable, CloseFuture> weakHooks;
    private Map<Closeable, CloseFuture> hooks;

    public CloseFuture() {
        this(null);
    }

    public CloseFuture(Logger log) {
        this.log = log;
    }

    public synchronized void add(Closeable hook) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (hook instanceof CloseFuture) {
            CloseFuture fut = (CloseFuture)hook;
            fut.future().onComplete(ar -> this.remove(fut));
            if (this.weakHooks == null) {
                this.weakHooks = new WeakHashMap<Closeable, CloseFuture>();
            }
            this.weakHooks.put(hook, this);
        } else {
            if (this.hooks == null) {
                this.hooks = new HashMap<Closeable, CloseFuture>();
            }
            this.hooks.put(hook, this);
        }
    }

    public synchronized boolean remove(Closeable hook) {
        if (hook instanceof CloseFuture) {
            if (this.weakHooks != null) {
                return this.weakHooks.remove(hook) != null;
            }
        } else if (this.hooks != null) {
            return this.hooks.remove(hook) != null;
        }
        return false;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public Future<Void> future() {
        return this.promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> close() {
        boolean close;
        ArrayList<ArrayList<Closeable>> toClose = new ArrayList<ArrayList<Closeable>>();
        CloseFuture closeFuture = this;
        synchronized (closeFuture) {
            boolean bl = close = !this.closed;
            if (this.weakHooks != null) {
                toClose.add(new ArrayList<Closeable>(this.weakHooks.keySet()));
            }
            if (this.hooks != null) {
                toClose.add(new ArrayList<Closeable>(this.hooks.keySet()));
            }
            this.closed = true;
            this.weakHooks = null;
            this.hooks = null;
        }
        if (close) {
            int num = toClose.stream().mapToInt(List::size).sum();
            if (num > 0) {
                AtomicInteger count = new AtomicInteger();
                for (List list : toClose) {
                    for (Closeable hook : list) {
                        Promise<Void> closePromise = Promise.promise();
                        closePromise.future().onComplete(ar -> {
                            if (count.incrementAndGet() == num) {
                                this.promise.complete();
                            }
                        });
                        try {
                            hook.close(closePromise);
                        }
                        catch (Throwable t) {
                            if (this.log != null) {
                                this.log.warn("Failed to run close hook", t);
                            }
                            closePromise.tryFail(t);
                        }
                    }
                }
            } else {
                this.promise.complete();
            }
        }
        return this.promise.future();
    }

    @Override
    public void close(Promise<Void> completionHandler) {
        this.close().onComplete(completionHandler);
    }

    protected void finalize() {
        this.close();
    }
}

