/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.session;

import io.trino.spi.resourcegroups.ResourceGroupId;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class SessionConfigurationContext {
    private final String user;
    private final Optional<String> source;
    private final Set<String> clientTags;
    private final Optional<String> queryType;
    private final ResourceGroupId resourceGroupId;

    public SessionConfigurationContext(String user, Optional<String> source, Set<String> clientTags, Optional<String> queryType, ResourceGroupId resourceGroupId) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.clientTags = Set.copyOf((Collection)Objects.requireNonNull(clientTags, "clientTags is null"));
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.resourceGroupId = Objects.requireNonNull(resourceGroupId, "resourceGroupId");
    }

    public String getUser() {
        return this.user;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public Optional<String> getQueryType() {
        return this.queryType;
    }

    public ResourceGroupId getResourceGroupId() {
        return this.resourceGroupId;
    }
}

